/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DebugLevelSource;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class WorldGenSettings {
    public static final Codec<WorldGenSettings> f_64600_ = RecordCodecBuilder.create(p_64626_ -> p_64626_.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(WorldGenSettings::m_64619_), (App)Codec.BOOL.fieldOf("generate_features").orElse((Object)true).stable().forGetter(WorldGenSettings::m_64657_), (App)Codec.BOOL.fieldOf("bonus_chest").orElse((Object)false).stable().forGetter(WorldGenSettings::m_64660_), (App)RegistryCodecs.m_206318_(Registry.f_122820_, Lifecycle.stable(), LevelStem.f_63970_).xmap(LevelStem::m_204525_, Function.identity()).fieldOf("dimensions").forGetter(WorldGenSettings::m_204655_), (App)Codec.STRING.optionalFieldOf("legacy_custom_options").stable().forGetter(p_158959_ -> p_158959_.f_64606_)).apply((Applicative)p_64626_, p_64626_.stable(WorldGenSettings::new))).comapFlatMap(WorldGenSettings::m_64674_, Function.identity());
    private static final Logger f_64601_ = LogUtils.getLogger();
    private final long f_64602_;
    private final boolean f_64603_;
    private final boolean f_64604_;
    private final Registry<LevelStem> f_64605_;
    private final Optional<String> f_64606_;

    private DataResult<WorldGenSettings> m_64674_() {
        LevelStem $$0 = this.f_64605_.m_6246_(LevelStem.f_63971_);
        if ($$0 == null) {
            return DataResult.error((String)"Overworld settings missing");
        }
        if (this.m_64675_()) {
            return DataResult.success((Object)this, (Lifecycle)Lifecycle.stable());
        }
        return DataResult.success((Object)this);
    }

    private boolean m_64675_() {
        return LevelStem.m_204522_(this.f_64602_, this.f_64605_);
    }

    public WorldGenSettings(long p_204633_, boolean p_204634_, boolean p_204635_, Registry<LevelStem> p_204636_) {
        this(p_204633_, p_204634_, p_204635_, p_204636_, Optional.empty());
        LevelStem $$4 = p_204636_.m_6246_(LevelStem.f_63971_);
        if ($$4 == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
    }

    private WorldGenSettings(long p_204638_, boolean p_204639_, boolean p_204640_, Registry<LevelStem> p_204641_, Optional<String> p_204642_) {
        this.f_64602_ = p_204638_;
        this.f_64603_ = p_204639_;
        this.f_64604_ = p_204640_;
        this.f_64605_ = p_204641_;
        this.f_64606_ = p_204642_;
    }

    public static WorldGenSettings m_64645_(RegistryAccess p_64646_) {
        int $$1 = "North Carolina".hashCode();
        return new WorldGenSettings($$1, true, true, WorldGenSettings.m_204649_(p_64646_.m_175515_(Registry.f_122818_), DimensionType.m_204490_(p_64646_, $$1), WorldGenSettings.m_190027_(p_64646_, $$1)));
    }

    public static WorldGenSettings m_190050_(RegistryAccess p_190051_) {
        long $$1 = new Random().nextLong();
        return new WorldGenSettings($$1, true, false, WorldGenSettings.m_204649_(p_190051_.m_175515_(Registry.f_122818_), DimensionType.m_204490_(p_190051_, $$1), WorldGenSettings.m_190027_(p_190051_, $$1)));
    }

    public static NoiseBasedChunkGenerator m_190027_(RegistryAccess p_190028_, long p_190029_) {
        return WorldGenSettings.m_190039_(p_190028_, p_190029_, true);
    }

    public static NoiseBasedChunkGenerator m_190039_(RegistryAccess p_190040_, long p_190041_, boolean p_190042_) {
        return WorldGenSettings.m_190034_(p_190040_, p_190041_, NoiseGeneratorSettings.f_64432_, p_190042_);
    }

    public static NoiseBasedChunkGenerator m_190030_(RegistryAccess p_190031_, long p_190032_, ResourceKey<NoiseGeneratorSettings> p_190033_) {
        return WorldGenSettings.m_190034_(p_190031_, p_190032_, p_190033_, true);
    }

    public static NoiseBasedChunkGenerator m_190034_(RegistryAccess p_190035_, long p_190036_, ResourceKey<NoiseGeneratorSettings> p_190037_, boolean p_190038_) {
        Registry<Biome> $$4 = p_190035_.m_175515_(Registry.f_122885_);
        Registry<StructureSet> $$5 = p_190035_.m_175515_(Registry.f_211073_);
        Registry<NoiseGeneratorSettings> $$6 = p_190035_.m_175515_(Registry.f_122878_);
        Registry<NormalNoise.NoiseParameters> $$7 = p_190035_.m_175515_(Registry.f_194568_);
        return new NoiseBasedChunkGenerator($$5, $$7, (BiomeSource)MultiNoiseBiomeSource.Preset.f_187087_.m_187104_($$4, p_190038_), p_190036_, $$6.m_203538_(p_190037_));
    }

    public long m_64619_() {
        return this.f_64602_;
    }

    public boolean m_64657_() {
        return this.f_64603_;
    }

    public boolean m_64660_() {
        return this.f_64604_;
    }

    public static Registry<LevelStem> m_204649_(Registry<DimensionType> p_204650_, Registry<LevelStem> p_204651_, ChunkGenerator p_204652_) {
        LevelStem $$3 = p_204651_.m_6246_(LevelStem.f_63971_);
        Holder<DimensionType> $$4 = $$3 == null ? p_204650_.m_203538_(DimensionType.f_63845_) : $$3.m_204521_();
        return WorldGenSettings.m_204645_(p_204651_, $$4, p_204652_);
    }

    public static Registry<LevelStem> m_204645_(Registry<LevelStem> p_204646_, Holder<DimensionType> p_204647_, ChunkGenerator p_204648_) {
        MappedRegistry<LevelStem> $$3 = new MappedRegistry<LevelStem>(Registry.f_122820_, Lifecycle.experimental(), null);
        ((WritableRegistry)$$3).m_203505_(LevelStem.f_63971_, new LevelStem(p_204647_, p_204648_), Lifecycle.stable());
        for (Map.Entry<ResourceKey<LevelStem>, LevelStem> $$4 : p_204646_.m_6579_()) {
            ResourceKey<LevelStem> $$5 = $$4.getKey();
            if ($$5 == LevelStem.f_63971_) continue;
            ((WritableRegistry)$$3).m_203505_($$5, $$4.getValue(), p_204646_.m_6228_($$4.getValue()));
        }
        return $$3;
    }

    public Registry<LevelStem> m_204655_() {
        return this.f_64605_;
    }

    public ChunkGenerator m_64666_() {
        LevelStem $$0 = this.f_64605_.m_6246_(LevelStem.f_63971_);
        if ($$0 == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
        return $$0.m_63990_();
    }

    public ImmutableSet<ResourceKey<Level>> m_64667_() {
        return (ImmutableSet)this.m_204655_().m_6579_().stream().map(Map.Entry::getKey).map(WorldGenSettings::m_190048_).collect(ImmutableSet.toImmutableSet());
    }

    public static ResourceKey<Level> m_190048_(ResourceKey<LevelStem> p_190049_) {
        return ResourceKey.m_135785_(Registry.f_122819_, p_190049_.m_135782_());
    }

    public static ResourceKey<LevelStem> m_190052_(ResourceKey<Level> p_190053_) {
        return ResourceKey.m_135785_(Registry.f_122820_, p_190053_.m_135782_());
    }

    public boolean m_64668_() {
        return this.m_64666_() instanceof DebugLevelSource;
    }

    public boolean m_64669_() {
        return this.m_64666_() instanceof FlatLevelSource;
    }

    public boolean m_64670_() {
        return this.f_64606_.isPresent();
    }

    public WorldGenSettings m_64671_() {
        return new WorldGenSettings(this.f_64602_, this.f_64603_, true, this.f_64605_, this.f_64606_);
    }

    public WorldGenSettings m_64672_() {
        return new WorldGenSettings(this.f_64602_, !this.f_64603_, this.f_64604_, this.f_64605_);
    }

    public WorldGenSettings m_64673_() {
        return new WorldGenSettings(this.f_64602_, this.f_64603_, !this.f_64604_, this.f_64605_);
    }

    public static WorldGenSettings m_209716_(RegistryAccess p_209717_, DedicatedServerProperties.WorldGenProperties p_209718_) {
        long $$2 = WorldGenSettings.m_202192_(p_209718_.f_207542_()).orElse(new Random().nextLong());
        Registry<DimensionType> $$3 = p_209717_.m_175515_(Registry.f_122818_);
        Registry<Biome> $$4 = p_209717_.m_175515_(Registry.f_122885_);
        Registry<StructureSet> $$5 = p_209717_.m_175515_(Registry.f_211073_);
        Registry<LevelStem> $$6 = DimensionType.m_204490_(p_209717_, $$2);
        switch (p_209718_.f_207545_()) {
            case "flat": {
                Dynamic $$7 = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)p_209718_.f_207543_());
                return new WorldGenSettings($$2, p_209718_.f_207544_(), false, WorldGenSettings.m_204649_($$3, $$6, new FlatLevelSource($$5, FlatLevelGeneratorSettings.f_70347_.parse($$7).resultOrPartial(arg_0 -> ((Logger)f_64601_).error(arg_0)).orElseGet(() -> FlatLevelGeneratorSettings.m_211734_($$4, $$5)))));
            }
            case "debug_all_block_states": {
                return new WorldGenSettings($$2, p_209718_.f_207544_(), false, WorldGenSettings.m_204649_($$3, $$6, new DebugLevelSource($$5, $$4)));
            }
            case "amplified": {
                return new WorldGenSettings($$2, p_209718_.f_207544_(), false, WorldGenSettings.m_204649_($$3, $$6, WorldGenSettings.m_190030_(p_209717_, $$2, NoiseGeneratorSettings.f_64433_)));
            }
            case "largebiomes": {
                return new WorldGenSettings($$2, p_209718_.f_207544_(), false, WorldGenSettings.m_204649_($$3, $$6, WorldGenSettings.m_190030_(p_209717_, $$2, NoiseGeneratorSettings.f_188869_)));
            }
        }
        return new WorldGenSettings($$2, p_209718_.f_207544_(), false, WorldGenSettings.m_204649_($$3, $$6, WorldGenSettings.m_190027_(p_209717_, $$2)));
    }

    public WorldGenSettings m_64654_(boolean p_64655_, OptionalLong p_64656_) {
        WorldGenSettings $$10;
        Registry<LevelStem> $$8;
        long $$2 = p_64656_.orElse(this.f_64602_);
        if (p_64656_.isPresent()) {
            MappedRegistry<LevelStem> $$3 = new MappedRegistry<LevelStem>(Registry.f_122820_, Lifecycle.experimental(), null);
            long $$4 = p_64656_.getAsLong();
            for (Map.Entry<ResourceKey<LevelStem>, LevelStem> $$5 : this.f_64605_.m_6579_()) {
                ResourceKey<LevelStem> $$6 = $$5.getKey();
                ((WritableRegistry)$$3).m_203505_($$6, new LevelStem($$5.getValue().m_204521_(), $$5.getValue().m_63990_().m_6819_($$4)), this.f_64605_.m_6228_($$5.getValue()));
            }
            MappedRegistry<LevelStem> $$7 = $$3;
        } else {
            $$8 = this.f_64605_;
        }
        if (this.m_64668_()) {
            WorldGenSettings $$9 = new WorldGenSettings($$2, false, false, $$8);
        } else {
            $$10 = new WorldGenSettings($$2, this.m_64657_(), this.m_64660_() && !p_64655_, $$8);
        }
        return $$10;
    }

    public static OptionalLong m_202192_(String p_202193_) {
        if (StringUtils.isEmpty((CharSequence)(p_202193_ = p_202193_.trim()))) {
            return OptionalLong.empty();
        }
        try {
            return OptionalLong.of(Long.parseLong(p_202193_));
        }
        catch (NumberFormatException $$1) {
            return OptionalLong.of(p_202193_.hashCode());
        }
    }
}

