/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.yaml.file;

import com.mohistmc.yaml.ConfigurationSection;
import com.mohistmc.yaml.DumperOptions;
import com.mohistmc.yaml.nodes.Node;
import com.mohistmc.yaml.representer.Representer;
import com.mohistmc.yaml.representer.SafeRepresenter;
import com.mohistmc.yaml.serialization.ConfigurationSerializable;
import com.mohistmc.yaml.serialization.ConfigurationSerialization;
import java.util.LinkedHashMap;
import org.jetbrains.annotations.NotNull;

public class YamlRepresenter
extends Representer {
    public YamlRepresenter(@NotNull DumperOptions options) {
        super(options);
        this.multiRepresenters.put(ConfigurationSection.class, new RepresentConfigurationSection());
        this.multiRepresenters.put(ConfigurationSerializable.class, new RepresentConfigurationSerializable());
        this.multiRepresenters.remove(Enum.class);
    }

    private class RepresentConfigurationSection
    extends SafeRepresenter.RepresentMap {
        private RepresentConfigurationSection() {
            super(YamlRepresenter.this);
        }

        @Override
        @NotNull
        public Node representData(@NotNull Object data) {
            return super.representData(((ConfigurationSection)data).getValues(false));
        }
    }

    private class RepresentConfigurationSerializable
    extends SafeRepresenter.RepresentMap {
        private RepresentConfigurationSerializable() {
            super(YamlRepresenter.this);
        }

        @Override
        @NotNull
        public Node representData(@NotNull Object data) {
            ConfigurationSerializable serializable = (ConfigurationSerializable)data;
            LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
            values.put("==", ConfigurationSerialization.getAlias(serializable.getClass()));
            values.putAll(serializable.serialize());
            return super.representData(values);
        }
    }
}

