/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraftforge.fml.loading.moddiscovery.AbstractJarFileLocator;
import net.minecraftforge.forgespi.locating.IModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractJarFileDependencyLocator
extends AbstractJarFileLocator {
    private static final Logger LOGGER = LogManager.getLogger();

    protected Optional<InputStream> loadResourceFromModFile(IModFile modFile, Path path) {
        try {
            return Optional.of(Files.newInputStream(modFile.findResource(new String[]{path.toString()}), new OpenOption[0]));
        }
        catch (FileNotFoundException e) {
            LOGGER.debug("Failed to load resource {} from {}, it does not contain dependency information.", (Object)path, (Object)modFile.getFileName());
            return Optional.empty();
        }
        catch (Exception e) {
            LOGGER.error("Failed to load resource {} from mod {}, cause {}", (Object)path, (Object)modFile.getFileName(), (Object)e);
            return Optional.empty();
        }
    }

    protected Optional<IModFile> loadModFileFrom(IModFile file, Path path) {
        try {
            Path pathInModFile = file.findResource(new String[]{path.toString()});
            return this.createMod(pathInModFile);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load mod file {} from {}", (Object)path, (Object)file.getFileName());
            return Optional.empty();
        }
    }

    protected String identifyMod(IModFile modFile) {
        return modFile.getFileName();
    }
}

