/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.api;

import com.mohistmc.MohistMC;
import com.mohistmc.org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class ItemAPI {
    public static Logger LOGGER = LogManager.getLogger((String)"ItemAPI");

    public static ItemStack doItem(Material material, int menge, String name, ArrayList<String> lore) {
        ItemStack item = new ItemStack(material, menge);
        ItemMeta meta = item.getItemMeta();
        meta.setLore(lore);
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        return item;
    }

    public static net.minecraft.world.item.ItemStack toNMSItem(Material material) {
        ItemStack itemStackcb = new ItemStack(material);
        return CraftItemStack.asNMSCopy(itemStackcb);
    }

    public static net.minecraft.world.item.ItemStack toNMSItem(ItemStack itemStack) {
        return CraftItemStack.asNMSCopy(itemStack);
    }

    public static ItemStack getBukkit(Material material) {
        return new ItemStack(material);
    }

    public static CompoundTag getNbt(ItemStack itemStack) {
        return ItemAPI.toNMSItem(itemStack).m_41783_() == null ? null : ItemAPI.toNMSItem(itemStack).m_41783_();
    }

    public static String getNBTAsString(ItemStack itemStack) {
        return ItemAPI.toNMSItem(itemStack).m_41783_() == null ? "null" : ItemAPI.toNMSItem(itemStack).m_41783_().m_7916_();
    }

    public static String getNbtAsString(CompoundTag compoundTag) {
        return compoundTag == null ? "null" : compoundTag.m_7916_();
    }

    public static ItemStack getBukkitByBase64(String base64) {
        ItemStack itemStack;
        BukkitObjectInputStream dataInput = new BukkitObjectInputStream(new ByteArrayInputStream(Base64Coder.decodeLines((String)base64)));
        try {
            itemStack = (ItemStack)dataInput.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    dataInput.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException e) {
                LOGGER.error("Unable to decode class type.");
                return ItemAPI.getBukkit(Material.AIR);
            }
        }
        dataInput.close();
        return itemStack;
    }

    public static String getBase64byBukkit(ItemStack stack) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream(outputStream);
            dataOutput.writeObject(stack);
            dataOutput.close();
            return Base64Coder.encodeLines((byte[])outputStream.toByteArray());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String serializeNBT(ItemStack itemStack) {
        return ItemAPI.getNbt(itemStack) == null ? null : ItemAPI.serializeNbt(ItemAPI.getNbt(itemStack));
    }

    public static ItemStack deserializeNBT(String serializeNBT) {
        if (serializeNBT != null && !serializeNBT.isEmpty()) {
            return CraftItemStack.asBukkitCopy(new net.minecraft.world.item.ItemStack(ItemAPI.deserializeNbt(serializeNBT)));
        }
        return new ItemStack(Material.AIR);
    }

    public static String serializeNbt(CompoundTag nbtTagCompound) {
        try {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            NbtIo.m_128947_((CompoundTag)nbtTagCompound, (OutputStream)buf);
            return Base64Coder.encodeLines((byte[])buf.toByteArray());
        }
        catch (IOException ignored) {
            return null;
        }
    }

    public static CompoundTag deserializeNbt(String serializeNBT) {
        if (serializeNBT != null) {
            ByteArrayInputStream buf = new ByteArrayInputStream(Base64Coder.decodeLines((String)serializeNBT));
            try {
                return NbtIo.m_128939_((InputStream)buf);
            }
            catch (IOException e) {
                MohistMC.LOGGER.error("Reading nbt ", (Throwable)e);
            }
        }
        return null;
    }

    public static void name(ItemStack itemStack, String name) {
        ItemMeta im = itemStack.getItemMeta();
        im.setDisplayName(name.replace("&", "\u00a7"));
        itemStack.setItemMeta(im);
    }

    public static void lore(ItemStack itemStack, List<String> lore) {
        ItemMeta im = itemStack.getItemMeta();
        im.setLore(lore);
        itemStack.setItemMeta(im);
    }
}

