/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.eventhandler.dispatcher;

import com.mohistmc.bukkit.block.MohistBlockSnapshot;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.bukkit.Bukkit;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class BlockEventDispatcher {
    @SubscribeEvent(receiveCanceled=true)
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        LevelAccessor level = event.getWorld();
        BlockPos pos = event.getPos();
        Player player = event.getPlayer();
        net.minecraft.world.level.block.state.BlockState state = event.getState();
        CraftBlock bblock = CraftBlock.at(level, pos);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!(player instanceof FakePlayer) && level instanceof ServerLevel) {
                boolean isSwordNoBreak;
                ServerLevel serverLevel = (ServerLevel)level;
                boolean bl = isSwordNoBreak = !serverPlayer.m_21205_().m_41720_().m_6777_(state, (Level)serverLevel, pos, (Player)serverPlayer);
                if (level.m_7702_(pos) == null && !isSwordNoBreak) {
                    ClientboundBlockUpdatePacket packet = new ClientboundBlockUpdatePacket(pos, Blocks.f_50016_.m_49966_());
                    serverPlayer.f_8906_.m_141995_((Packet)packet);
                }
                BlockBreakEvent bukkitEvent = new BlockBreakEvent((org.bukkit.block.Block)bblock, serverPlayer.getBukkitEntity());
                bukkitEvent.setCancelled(isSwordNoBreak);
                event.setCanceled(isSwordNoBreak);
                net.minecraft.world.level.block.state.BlockState nmsData = serverLevel.m_8055_(pos);
                Block nmsBlock = nmsData.m_60734_();
                if (nmsBlock != null && !bukkitEvent.isCancelled() && !event.isCanceled() && !serverPlayer.m_7500_() && serverPlayer.m_36298_(nmsBlock.m_49966_())) {
                    bukkitEvent.setExpToDrop(event.getExpToDrop());
                }
                serverLevel.getCraftServer().getPluginManager().callEvent(bukkitEvent);
                if (bukkitEvent.isCancelled()) {
                    if (isSwordNoBreak) {
                        bukkitEvent.setCancelled(true);
                        event.setCanceled(true);
                    }
                    serverPlayer.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)serverLevel, pos));
                    for (Direction dir : Direction.values()) {
                        serverPlayer.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)level, pos.m_142300_(dir)));
                    }
                    BlockEntity tileentity = serverLevel.m_7702_(pos);
                    if (tileentity != null) {
                        serverPlayer.f_8906_.m_141995_(tileentity.m_183216_());
                    }
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (!(entity instanceof FakePlayer)) {
                CraftPlayer player = serverPlayer.getBukkitEntity();
                Direction direction = event.getPlaceEventDirection();
                if (direction != null) {
                    EquipmentSlot bukkitHand;
                    ItemStack bukkitStack;
                    InteractionHand hand = event.getPlaceEventHand();
                    MohistBlockSnapshot placedBlock = MohistBlockSnapshot.fromBlockSnapshot(event.getBlockSnapshot(), true);
                    CraftBlock againstBlock = CraftBlock.at(event.getWorld(), event.getPos().m_142300_(direction.m_122424_()));
                    if (hand == InteractionHand.MAIN_HAND) {
                        bukkitStack = player.getInventory().getItemInMainHand();
                        bukkitHand = EquipmentSlot.HAND;
                    } else {
                        bukkitStack = player.getInventory().getItemInOffHand();
                        bukkitHand = EquipmentSlot.OFF_HAND;
                    }
                    BlockPlaceEvent placeEvent = new BlockPlaceEvent(placedBlock, placedBlock.getState(), againstBlock, bukkitStack, player, !event.isCanceled(), bukkitHand);
                    placeEvent.setCancelled(event.isCanceled());
                    Bukkit.getPluginManager().callEvent(placeEvent);
                    event.setCanceled(placeEvent.isCancelled() || !placeEvent.canBuild());
                }
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onMultiPlace(BlockEvent.EntityMultiPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (!(entity instanceof FakePlayer)) {
                CraftPlayer player = serverPlayer.getBukkitEntity();
                Direction direction = event.getPlaceEventDirection();
                if (direction != null) {
                    InteractionHand hand = event.getPlaceEventHand();
                    ArrayList<BlockState> placedBlocks = new ArrayList<BlockState>(event.getReplacedBlockSnapshots().size());
                    for (BlockSnapshot snapshot : event.getReplacedBlockSnapshots()) {
                        placedBlocks.add(MohistBlockSnapshot.fromBlockSnapshot(snapshot, true).getState());
                    }
                    CraftBlock againstBlock = CraftBlock.at(event.getWorld(), event.getPos().m_142300_(direction.m_122424_()));
                    ItemStack bukkitStack = hand == InteractionHand.MAIN_HAND ? player.getInventory().getItemInMainHand() : player.getInventory().getItemInOffHand();
                    BlockMultiPlaceEvent placeEvent = new BlockMultiPlaceEvent(placedBlocks, againstBlock, bukkitStack, player, !event.isCanceled());
                    placeEvent.setCancelled(event.isCanceled());
                    Bukkit.getPluginManager().callEvent(placeEvent);
                    event.setCanceled(placeEvent.isCancelled() || !placeEvent.canBuild());
                }
            }
        }
    }
}

