/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.forge;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.mohistmc.MohistMC;
import com.mohistmc.api.ServerAPI;
import com.mohistmc.bukkit.potion.MohistPotionEffect;
import com.mohistmc.dynamicenum.MohistDynamEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.StatType;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.decoration.Motive;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.TrappedChestBlockEntity;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.bukkit.Art;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_18_R2.CraftParticle;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftChest;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftSign;
import org.bukkit.craftbukkit.v1_18_R2.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_18_R2.potion.CraftPotionUtil;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftSpawnCategory;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.entity.Villager;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class ForgeInjectBukkit {
    public static BiMap<ResourceKey<LevelStem>, World.Environment> environment = HashBiMap.create((Map)ImmutableMap.builder().put((Object)LevelStem.f_63971_, (Object)World.Environment.NORMAL).put((Object)LevelStem.f_63972_, (Object)World.Environment.NETHER).put((Object)LevelStem.f_63973_, (Object)World.Environment.THE_END).build());
    public static BiMap<World.Environment, ResourceKey<LevelStem>> environment0 = HashBiMap.create((Map)ImmutableMap.builder().put((Object)World.Environment.NORMAL, (Object)LevelStem.f_63971_).put((Object)World.Environment.NETHER, (Object)LevelStem.f_63972_).put((Object)World.Environment.THE_END, (Object)LevelStem.f_63973_).build());
    public static Map<Villager.Profession, ResourceLocation> profession = new HashMap<Villager.Profession, ResourceLocation>();
    public static Map<Attribute, ResourceLocation> attributemap = new HashMap<Attribute, ResourceLocation>();
    public static Map<StatType<?>, Statistic> statisticMap = new HashMap();
    public static Map<net.minecraft.world.level.biome.Biome, Biome> biomeBiomeMap = new HashMap<net.minecraft.world.level.biome.Biome, Biome>();

    public static void init() {
        ForgeInjectBukkit.addEnumMaterialInItems();
        ForgeInjectBukkit.addEnumMaterialsInBlocks();
        ForgeInjectBukkit.addEnumBiome();
        ForgeInjectBukkit.addEnumEnchantment();
        ForgeInjectBukkit.addEnumEffectAndPotion();
        ForgeInjectBukkit.addEnumEntity();
        ForgeInjectBukkit.addEnumVillagerProfession();
        ForgeInjectBukkit.addEnumArt();
        ForgeInjectBukkit.addEnumParticle();
        ForgeInjectBukkit.addStatistic();
        ForgeInjectBukkit.addEndDragonPhase();
        ForgeInjectBukkit.loadSpawnCategory();
    }

    public static void addEnumMaterialInItems() {
        IForgeRegistry<Item> registry = ForgeRegistries.ITEMS;
        for (Item item : registry) {
            ResourceLocation resourceLocation = registry.getKey(item);
            if (!ForgeInjectBukkit.isMods(resourceLocation)) continue;
            String materialName = ForgeInjectBukkit.normalizeName(resourceLocation.toString());
            int id = Item.m_41393_((Item)item);
            Material material = Material.addMaterial(materialName, id, item.m_41459_(), false, true, resourceLocation);
            CraftMagicNumbers.ITEM_MATERIAL.put(item, material);
            CraftMagicNumbers.MATERIAL_ITEM.put(material, item);
            MohistMC.LOGGER.debug("Save-ITEM: " + material.name() + " - " + material.key);
        }
    }

    public static void addEnumMaterialsInBlocks() {
        IForgeRegistry<Block> registry = ForgeRegistries.BLOCKS;
        for (Block block : registry) {
            Item item;
            int id;
            String materialName;
            Material material;
            ResourceLocation resourceLocation = registry.getKey(block);
            if (!ForgeInjectBukkit.isMods(resourceLocation) || (material = Material.addMaterial(materialName = ForgeInjectBukkit.normalizeName(resourceLocation.toString()), id = Item.m_41393_((Item)block.m_5456_()), (item = Item.m_41445_((int)id)).m_41459_(), true, false, resourceLocation)) == null) continue;
            CraftMagicNumbers.BLOCK_MATERIAL.put(block, material);
            CraftMagicNumbers.MATERIAL_BLOCK.put(material, block);
            if (block.m_49966_().m_204336_(BlockTags.f_13068_)) {
                CraftBlockStates.register(material, CraftSign.class, CraftSign::new, SignBlockEntity::new);
            } else if (block instanceof SignBlock) {
                SignBlock signBlock = (SignBlock)block;
                blockEntity = signBlock.m_142194_(BlockPos.f_121853_, block.m_49966_());
                if (blockEntity instanceof SignBlockEntity) {
                    CraftBlockStates.register(material, CraftSign.class, CraftSign::new, SignBlockEntity::new);
                }
            } else if (block instanceof ChestBlock) {
                ChestBlock chestBlock = (ChestBlock)block;
                blockEntity = chestBlock.m_142194_(BlockPos.f_121853_, block.m_49966_());
                if (blockEntity instanceof TrappedChestBlockEntity) {
                    CraftBlockStates.register(material, CraftChest.class, CraftChest::new, TrappedChestBlockEntity::new);
                } else if (blockEntity instanceof ChestBlockEntity) {
                    CraftBlockStates.register(material, CraftChest.class, CraftChest::new, ChestBlockEntity::new);
                }
            }
            MohistMC.LOGGER.debug("Save-BLOCK:" + material.name() + " - " + material.key);
        }
    }

    public static void addEnumEnchantment() {
        for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
            org.bukkit.enchantments.Enchantment.registerEnchantment(new CraftEnchantment(enchantment));
        }
        org.bukkit.enchantments.Enchantment.stopAcceptingRegistrations();
    }

    public static void addEnumEffectAndPotion() {
        for (MobEffect effect : ForgeRegistries.MOB_EFFECTS) {
            try {
                String name = ForgeInjectBukkit.normalizeName(effect.getRegistryName().toString());
                MohistPotionEffect pet = new MohistPotionEffect(effect, name);
                PotionEffectType.registerPotionEffectType(pet);
                MohistMC.LOGGER.debug("Registered {} as potion {}", (Object)effect.getRegistryName(), (Object)effect);
            }
            catch (Exception e) {
                MohistMC.LOGGER.error("Failed to register potion type {}: {}", (Object)effect.getRegistryName(), (Object)e);
            }
        }
        PotionEffectType.stopAcceptingRegistrations();
        IForgeRegistry<Potion> registry = ForgeRegistries.POTIONS;
        for (Potion potion : ForgeRegistries.POTIONS) {
            ResourceLocation resourceLocation = registry.getKey(potion);
            if (CraftPotionUtil.toBukkit(resourceLocation.toString()).getType() != PotionType.UNCRAFTABLE || potion == Potions.f_43598_) continue;
            String name = ForgeInjectBukkit.normalizeName(resourceLocation.toString());
            MobEffectInstance effectInstance = potion.m_43488_().isEmpty() ? null : (MobEffectInstance)potion.m_43488_().get(0);
            PotionType potionType = (PotionType)((Object)MohistDynamEnum.addEnum(PotionType.class, (String)name, Arrays.asList(PotionEffectType.class, Boolean.TYPE, Boolean.TYPE), Arrays.asList(effectInstance == null ? null : PotionEffectType.getById(MobEffect.m_19459_((MobEffect)effectInstance.m_19544_())), false, false)));
            if (potionType == null) continue;
            MohistMC.LOGGER.debug("Save-PotionType:" + name + " - " + potionType.name());
        }
    }

    public static void addEnumParticle() {
        IForgeRegistry<ParticleType<?>> registry = ForgeRegistries.PARTICLE_TYPES;
        for (ParticleType particleType : ForgeRegistries.PARTICLE_TYPES) {
            Particle particle;
            ResourceLocation resourceLocation = registry.getKey(particleType);
            String name = ForgeInjectBukkit.normalizeName(resourceLocation.toString());
            if (resourceLocation.m_135827_().equals("minecraft") || (particle = (Particle)((Object)MohistDynamEnum.addEnum(Particle.class, (String)name))) == null) continue;
            CraftParticle.putParticles(particle, resourceLocation);
            MohistMC.LOGGER.debug("Save-ParticleType:" + name + " - " + particle.name());
        }
    }

    public static void addEnumBiome() {
        ArrayList<String> map = new ArrayList<String>();
        IForgeRegistry<net.minecraft.world.level.biome.Biome> registry = ForgeRegistries.BIOMES;
        for (net.minecraft.world.level.biome.Biome biome : registry) {
            ResourceLocation resourceLocation = registry.getKey(biome);
            String biomeName = ForgeInjectBukkit.normalizeName(resourceLocation.toString());
            if (!ForgeInjectBukkit.isMods(resourceLocation) || map.contains(biomeName)) continue;
            map.add(biomeName);
            Biome biomeCB = (Biome)MohistDynamEnum.addEnum(Biome.class, (String)biomeName);
            biomeBiomeMap.put(biome, biomeCB);
            MohistMC.LOGGER.debug("Save-BIOME:" + biomeCB.name() + " - " + biomeName);
        }
        map.clear();
    }

    public static void addEnumEnvironment(Registry<LevelStem> registry) {
        int i = World.Environment.values().length;
        for (Map.Entry entry : registry.m_6579_()) {
            ResourceKey key = (ResourceKey)entry.getKey();
            World.Environment environment1 = (World.Environment)((Object)environment.get((Object)key));
            if (environment1 != null) continue;
            String name = ForgeInjectBukkit.normalizeName(key.m_135782_().toString());
            int id = i - 1;
            environment1 = (World.Environment)((Object)MohistDynamEnum.addEnum(World.Environment.class, (String)name, List.of(Integer.TYPE), List.of(Integer.valueOf(id))));
            environment.put((Object)key, (Object)environment1);
            environment0.put((Object)environment1, (Object)key);
            MohistMC.LOGGER.debug("Registered forge DimensionType as environment {}", (Object)environment1);
            ++i;
        }
    }

    public static WorldType addEnumWorldType(String name) {
        WorldType worldType = (WorldType)((Object)MohistDynamEnum.addEnum(WorldType.class, (String)name, List.of(String.class), List.of(name)));
        Map BY_NAME = (Map)ObfuscationReflectionHelper.getPrivateValue(WorldType.class, null, (String)"BY_NAME");
        BY_NAME.put(name.toUpperCase(), worldType);
        return worldType;
    }

    public static void addEnumEntity() {
        IForgeRegistry<net.minecraft.world.entity.EntityType<?>> registry = ForgeRegistries.ENTITIES;
        for (net.minecraft.world.entity.EntityType entityType : registry) {
            ResourceLocation resourceLocation = registry.getKey(entityType);
            NamespacedKey key = CraftNamespacedKey.fromMinecraft(resourceLocation);
            String entityType2 = ForgeInjectBukkit.normalizeName(resourceLocation.toString());
            if (ForgeInjectBukkit.isMods(resourceLocation)) {
                int typeId = entityType2.hashCode();
                EntityType bukkitType = (EntityType)MohistDynamEnum.addEnum(EntityType.class, (String)entityType2, List.of(String.class, Class.class, Integer.TYPE, Boolean.TYPE), List.of(entityType2.toLowerCase(), Entity.class, Integer.valueOf(typeId), Boolean.valueOf(false)));
                if (bukkitType == null) continue;
                bukkitType.key = key;
                EntityType.NAME_MAP.put(entityType2.toLowerCase(), bukkitType);
                EntityType.ID_MAP.put((short)typeId, bukkitType);
                ServerAPI.entityTypeMap.put(entityType, entityType2);
                continue;
            }
            ServerAPI.entityTypeMap.put(entityType, ForgeInjectBukkit.normalizeName(resourceLocation.m_135815_().toString()));
        }
    }

    public static void addEnumVillagerProfession() {
        IForgeRegistry<VillagerProfession> registry = ForgeRegistries.PROFESSIONS;
        for (VillagerProfession villagerProfession : registry) {
            ResourceLocation resourceLocation = registry.getKey(villagerProfession);
            if (!ForgeInjectBukkit.isMods(resourceLocation)) continue;
            String name = ForgeInjectBukkit.normalizeName(resourceLocation.toString());
            Villager.Profession vp = (Villager.Profession)MohistDynamEnum.addEnum(Villager.Profession.class, (String)name);
            profession.put(vp, resourceLocation);
            MohistMC.LOGGER.debug("Registered forge VillagerProfession as Profession {}", (Object)vp.name());
        }
    }

    public static void addEnumAttribute() {
        IForgeRegistry<net.minecraft.world.entity.ai.attributes.Attribute> registry = ForgeRegistries.ATTRIBUTES;
        for (net.minecraft.world.entity.ai.attributes.Attribute attribute : registry) {
            ResourceLocation resourceLocation = registry.getKey(attribute);
            String name = ForgeInjectBukkit.normalizeName(resourceLocation.m_135815_());
            if (!ForgeInjectBukkit.isMods(resourceLocation)) continue;
            Attribute ab = (Attribute)MohistDynamEnum.addEnum(Attribute.class, (String)name, List.of(String.class), List.of());
            attributemap.put(ab, resourceLocation);
            MohistMC.LOGGER.debug("Registered forge Attribute as Attribute(Bukkit) {}", (Object)ab.name());
        }
    }

    public static void addStatistic() {
        IForgeRegistry<StatType<?>> registry = ForgeRegistries.STAT_TYPES;
        for (StatType statType : registry) {
            ResourceLocation resourceLocation = registry.getKey(statType);
            String name = ForgeInjectBukkit.normalizeName(resourceLocation.m_135815_());
            if (!ForgeInjectBukkit.isMods(resourceLocation)) continue;
            Statistic statistic = (Statistic)MohistDynamEnum.addEnum(Statistic.class, (String)name);
            statisticMap.put(statType, statistic);
            MohistMC.LOGGER.debug("Registered forge StatType as Statistic(Bukkit) {}", (Object)statistic.name());
        }
    }

    public static void addEndDragonPhase() {
        int max = EnderDragonPhase.m_31406_();
        for (int id = EnderDragon.Phase.values().length; id < max; ++id) {
            String name = "MOD_PHASE_" + id;
            EnderDragon.Phase newPhase = (EnderDragon.Phase)((Object)MohistDynamEnum.addEnum(EnderDragon.Phase.class, (String)name));
            MohistMC.LOGGER.debug("Registered {} as ender dragon phase {}", (Object)name, (Object)newPhase);
        }
    }

    private static void loadSpawnCategory() {
        for (MobCategory category : MobCategory.values()) {
            try {
                CraftSpawnCategory.toBukkit(category);
            }
            catch (Exception e) {
                String name = category.name();
                SpawnCategory spawnCategory = (SpawnCategory)((Object)MohistDynamEnum.addEnum(SpawnCategory.class, (String)name));
                MohistMC.LOGGER.debug("Registered forge MobCategory as SpawnCategory(Bukkit) {}", (Object)spawnCategory);
            }
        }
    }

    public static void addEnumArt() {
        int i = Art.values().length;
        for (Motive entry : ForgeRegistries.PAINTING_TYPES) {
            int width = entry.m_31896_();
            int height = entry.m_31901_();
            ResourceLocation resourceLocation = ForgeRegistries.PAINTING_TYPES.getKey(entry);
            if (resourceLocation.m_135827_().equals("minecraft")) continue;
            String name = ForgeInjectBukkit.normalizeName(resourceLocation.toString());
            String lookupName = resourceLocation.m_135815_().toLowerCase(Locale.ROOT);
            int id = i - 1;
            Art art = (Art)MohistDynamEnum.addEnum(Art.class, (String)name, List.of(Integer.TYPE, Integer.TYPE, Integer.TYPE), List.of(Integer.valueOf(id), Integer.valueOf(width), Integer.valueOf(height)));
            Art.BY_NAME.put(lookupName, art);
            Art.BY_ID.put(id, art);
            MohistMC.LOGGER.debug("Registered forge PaintingType as Art {}", (Object)art);
            ++i;
        }
    }

    public static String normalizeName(String name) {
        return name.toUpperCase(Locale.ENGLISH).replaceAll("(:|\\s)", "_").replaceAll("\\W", "");
    }

    public static boolean isMods(ResourceLocation resourceLocation) {
        return !resourceLocation.m_135827_().equals("minecraft");
    }
}

