/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.CompositeModelState;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MultiLayerModel
implements IModelGeometry<MultiLayerModel> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ImmutableList<Pair<RenderType, UnbakedModel>> models;
    private final boolean convertRenderTypes;

    public MultiLayerModel(Map<RenderType, UnbakedModel> models) {
        this((ImmutableList<Pair<RenderType, UnbakedModel>>)((ImmutableList)models.entrySet().stream().map(kv -> Pair.of((Object)((RenderType)kv.getKey()), (Object)((UnbakedModel)kv.getValue()))).collect(ImmutableList.toImmutableList())), true);
    }

    public MultiLayerModel(ImmutableList<Pair<RenderType, UnbakedModel>> models, boolean convertRenderTypes) {
        this.models = models;
        this.convertRenderTypes = convertRenderTypes;
    }

    @Override
    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet materials = Sets.newHashSet();
        materials.add(owner.resolveTexture("particle"));
        for (Pair m : this.models) {
            materials.addAll(((UnbakedModel)m.getSecond()).m_5500_(modelGetter, missingTextureErrors));
        }
        return materials;
    }

    private static ImmutableList<Pair<RenderType, BakedModel>> buildModels(List<Pair<RenderType, UnbakedModel>> models, ModelState modelTransform, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ResourceLocation modelLocation) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Pair<RenderType, UnbakedModel> entry : models) {
            builder.add((Object)Pair.of((Object)((RenderType)entry.getFirst()), (Object)((UnbakedModel)entry.getSecond()).m_7611_(bakery, spriteGetter, modelTransform, modelLocation)));
        }
        return builder.build();
    }

    @Override
    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        return new MultiLayerBakedModel(owner.useSmoothLighting(), owner.isShadedInGui(), owner.isSideLit(), spriteGetter.apply(owner.resolveTexture("particle")), overrides, this.convertRenderTypes, (List<Pair<RenderType, BakedModel>>)MultiLayerModel.buildModels(this.models, modelTransform, bakery, spriteGetter, modelLocation), PerspectiveMapWrapper.getTransforms(new CompositeModelState(owner.getCombinedTransform(), modelTransform)));
    }

    private static final class MultiLayerBakedModel
    implements IDynamicBakedModel {
        private final ImmutableMap<RenderType, BakedModel> models;
        private final ImmutableMap<ItemTransforms.TransformType, Transformation> cameraTransforms;
        protected final boolean ambientOcclusion;
        protected final boolean gui3d;
        protected final boolean isSideLit;
        protected final TextureAtlasSprite particle;
        protected final ItemOverrides overrides;
        private final List<BakedQuad> missing = ImmutableList.of();
        private final boolean convertRenderTypes;
        private final List<Pair<BakedModel, RenderType>> itemLayers;
        public static final BiMap<RenderType, RenderType> ITEM_RENDER_TYPE_MAPPING = HashBiMap.create();

        public MultiLayerBakedModel(boolean ambientOcclusion, boolean isGui3d, boolean isSideLit, TextureAtlasSprite particle, ItemOverrides overrides, boolean convertRenderTypes, List<Pair<RenderType, BakedModel>> models, ImmutableMap<ItemTransforms.TransformType, Transformation> cameraTransforms) {
            this.isSideLit = isSideLit;
            this.cameraTransforms = cameraTransforms;
            this.ambientOcclusion = ambientOcclusion;
            this.gui3d = isGui3d;
            this.particle = particle;
            this.overrides = overrides;
            this.convertRenderTypes = convertRenderTypes;
            this.models = ImmutableMap.copyOf(models.stream().collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)));
            this.itemLayers = models.stream().map(kv -> {
                RenderType rt = (RenderType)kv.getFirst();
                if (convertRenderTypes) {
                    rt = (RenderType)ITEM_RENDER_TYPE_MAPPING.getOrDefault((Object)rt, (Object)rt);
                }
                return Pair.of((Object)((BakedModel)kv.getSecond()), (Object)rt);
            }).collect(Collectors.toList());
        }

        @Override
        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
            RenderType layer = MinecraftForgeClient.getRenderType();
            if (layer == null) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (BakedModel model : this.models.values()) {
                    builder.addAll((Iterable)model.getQuads(state, side, rand, extraData));
                }
                return builder.build();
            }
            if (state == null && this.convertRenderTypes) {
                layer = (RenderType)ITEM_RENDER_TYPE_MAPPING.inverse().getOrDefault((Object)layer, (Object)layer);
            }
            if (this.models.containsKey((Object)layer)) {
                return ((BakedModel)this.models.get((Object)layer)).getQuads(state, side, rand, extraData);
            }
            return this.missing;
        }

        public boolean m_7541_() {
            return this.ambientOcclusion;
        }

        public boolean useAmbientOcclusion(BlockState state) {
            return this.ambientOcclusion;
        }

        public boolean m_7539_() {
            return this.gui3d;
        }

        public boolean m_7547_() {
            return this.isSideLit;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return this.particle;
        }

        public boolean doesHandlePerspectives() {
            return true;
        }

        public BakedModel handlePerspective(ItemTransforms.TransformType cameraTransformType, PoseStack poseStack) {
            return PerspectiveMapWrapper.handlePerspective((BakedModel)this, this.cameraTransforms, cameraTransformType, poseStack);
        }

        public ItemOverrides m_7343_() {
            return ItemOverrides.f_111734_;
        }

        public boolean isLayered() {
            return true;
        }

        public List<Pair<BakedModel, RenderType>> getLayerModels(ItemStack itemStack, boolean fabulous) {
            return this.itemLayers;
        }

        static {
            ITEM_RENDER_TYPE_MAPPING.put((Object)RenderType.m_110451_(), (Object)ForgeRenderTypes.ITEM_LAYERED_SOLID.get());
            ITEM_RENDER_TYPE_MAPPING.put((Object)RenderType.m_110463_(), (Object)ForgeRenderTypes.ITEM_LAYERED_CUTOUT.get());
            ITEM_RENDER_TYPE_MAPPING.put((Object)RenderType.m_110457_(), (Object)ForgeRenderTypes.ITEM_LAYERED_CUTOUT_MIPPED.get());
            ITEM_RENDER_TYPE_MAPPING.put((Object)RenderType.m_110466_(), (Object)ForgeRenderTypes.ITEM_LAYERED_TRANSLUCENT.get());
        }
    }

    public static final class Loader
    implements IModelLoader<MultiLayerModel> {
        public static final ImmutableBiMap<String, RenderType> BLOCK_LAYERS = ImmutableBiMap.builder().put((Object)"solid", (Object)RenderType.m_110451_()).put((Object)"cutout", (Object)RenderType.m_110463_()).put((Object)"cutout_mipped", (Object)RenderType.m_110457_()).put((Object)"translucent", (Object)RenderType.m_110466_()).put((Object)"tripwire", (Object)RenderType.m_110503_()).build();
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public void m_6213_(ResourceManager resourceManager) {
        }

        @Override
        public MultiLayerModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            ImmutableList.Builder builder = ImmutableList.builder();
            JsonObject layersObject = GsonHelper.m_13930_((JsonObject)modelContents, (String)"layers");
            for (Map.Entry layer : BLOCK_LAYERS.entrySet()) {
                String layerName = (String)layer.getKey();
                if (!layersObject.has(layerName)) continue;
                builder.add((Object)Pair.of((Object)((RenderType)layer.getValue()), (Object)((UnbakedModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)layersObject, (String)layerName), BlockModel.class))));
            }
            boolean convertRenderTypes = GsonHelper.m_13855_((JsonObject)modelContents, (String)"convert_render_types", (boolean)true);
            return new MultiLayerModel((ImmutableList<Pair<RenderType, UnbakedModel>>)builder.build(), convertRenderTypes);
        }
    }
}

