/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Random;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.VertexBufferConsumer;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;
import net.minecraftforge.client.model.pipeline.VertexLighterSmoothAo;
import net.minecraftforge.common.ForgeConfig;

public class ForgeBlockModelRenderer
extends ModelBlockRenderer {
    private final ThreadLocal<VertexLighterFlat> lighterFlat;
    private final ThreadLocal<VertexLighterSmoothAo> lighterSmooth;
    private final ThreadLocal<VertexBufferConsumer> consumerFlat = ThreadLocal.withInitial(VertexBufferConsumer::new);
    private final ThreadLocal<VertexBufferConsumer> consumerSmooth = ThreadLocal.withInitial(VertexBufferConsumer::new);

    public ForgeBlockModelRenderer(BlockColors colors) {
        super(colors);
        this.lighterFlat = ThreadLocal.withInitial(() -> new VertexLighterFlat(colors));
        this.lighterSmooth = ThreadLocal.withInitial(() -> new VertexLighterSmoothAo(colors));
    }

    public boolean tesselateWithoutAO(BlockAndTintGetter level, BakedModel model, BlockState state, BlockPos pos, PoseStack poseStack, VertexConsumer buffer, boolean checkSides, Random rand, long seed, int packedOverlay, IModelData modelData) {
        if (((Boolean)ForgeConfig.CLIENT.experimentalForgeLightPipelineEnabled.get()).booleanValue()) {
            VertexBufferConsumer consumer = this.consumerFlat.get();
            consumer.setBuffer(buffer);
            consumer.setPackedOverlay(packedOverlay);
            VertexLighterFlat lighter = this.lighterFlat.get();
            lighter.setParent(consumer);
            lighter.setTransform(poseStack.m_85850_());
            return ForgeBlockModelRenderer.render(lighter, level, model, state, pos, poseStack, checkSides, rand, seed, modelData);
        }
        return super.tesselateWithoutAO(level, model, state, pos, poseStack, buffer, checkSides, rand, seed, packedOverlay, modelData);
    }

    public boolean tesselateWithAO(BlockAndTintGetter level, BakedModel model, BlockState state, BlockPos pos, PoseStack poseStack, VertexConsumer buffer, boolean checkSides, Random rand, long seed, int packedOverlay, IModelData modelData) {
        if (((Boolean)ForgeConfig.CLIENT.experimentalForgeLightPipelineEnabled.get()).booleanValue()) {
            VertexBufferConsumer consumer = this.consumerSmooth.get();
            consumer.setBuffer(buffer);
            consumer.setPackedOverlay(packedOverlay);
            VertexLighterSmoothAo lighter = this.lighterSmooth.get();
            lighter.setParent(consumer);
            lighter.setTransform(poseStack.m_85850_());
            return ForgeBlockModelRenderer.render(lighter, level, model, state, pos, poseStack, checkSides, rand, seed, modelData);
        }
        return super.tesselateWithAO(level, model, state, pos, poseStack, buffer, checkSides, rand, seed, packedOverlay, modelData);
    }

    public static boolean render(VertexLighterFlat lighter, BlockAndTintGetter level, BakedModel model, BlockState state, BlockPos pos, PoseStack poseStack, boolean checkSides, Random rand, long seed, IModelData modelData) {
        lighter.setWorld(level);
        lighter.setState(state);
        lighter.setBlockPos(pos);
        boolean empty = true;
        rand.setSeed(seed);
        List quads = model.getQuads(state, null, rand, modelData);
        if (!quads.isEmpty()) {
            lighter.updateBlockInfo();
            empty = false;
            for (BakedQuad quad : quads) {
                quad.pipe((IVertexConsumer)lighter);
            }
        }
        for (Direction side : Direction.values()) {
            rand.setSeed(seed);
            quads = model.getQuads(state, side, rand, modelData);
            if (quads.isEmpty() || checkSides && !Block.m_152444_((BlockState)state, (BlockGetter)level, (BlockPos)pos, (Direction)side, (BlockPos)pos.m_142300_(side))) continue;
            if (empty) {
                lighter.updateBlockInfo();
            }
            empty = false;
            for (BakedQuad quad : quads) {
                quad.pipe((IVertexConsumer)lighter);
            }
        }
        lighter.resetBlockInfo();
        return !empty;
    }
}

