/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.collect.Maps;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;
import net.minecraftforge.registries.ObjectHolderRef;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

public class ObjectHolderRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<Consumer<Predicate<ResourceLocation>>> objectHolders = new HashSet<Consumer<Predicate<ResourceLocation>>>();
    private static final Type OBJECT_HOLDER = Type.getType(ObjectHolder.class);
    private static final Type MOD = Type.getType(Mod.class);

    public static synchronized void addHandler(Consumer<Predicate<ResourceLocation>> ref) {
        objectHolders.add(ref);
    }

    public static synchronized boolean removeHandler(Consumer<Predicate<ResourceLocation>> ref) {
        return objectHolders.remove(ref);
    }

    public static void findObjectHolders() {
        LOGGER.debug(ForgeRegistry.REGISTRIES, "Processing ObjectHolder annotations");
        List annotations = ModList.get().getAllScanData().stream().map(ModFileScanData::getAnnotations).flatMap(Collection::stream).filter(a -> OBJECT_HOLDER.equals((Object)a.annotationType()) || MOD.equals((Object)a.annotationType())).collect(Collectors.toList());
        HashMap classModIds = Maps.newHashMap();
        HashMap classCache = Maps.newHashMap();
        annotations.stream().filter(a -> MOD.equals((Object)a.annotationType())).forEach(data -> classModIds.put(data.clazz(), (String)data.annotationData().get("value")));
        annotations.stream().filter(a -> OBJECT_HOLDER.equals((Object)a.annotationType())).filter(a -> a.targetType() == ElementType.TYPE).forEach(data -> ObjectHolderRegistry.scanTarget(classModIds, classCache, data.clazz(), null, (String)data.annotationData().get("value"), true, data.clazz().getClassName().startsWith("net.minecraft.")));
        annotations.stream().filter(a -> OBJECT_HOLDER.equals((Object)a.annotationType())).filter(a -> a.targetType() == ElementType.FIELD).forEach(data -> ObjectHolderRegistry.scanTarget(classModIds, classCache, data.clazz(), data.memberName(), (String)data.annotationData().get("value"), false, false));
        LOGGER.debug(ForgeRegistry.REGISTRIES, "Found {} ObjectHolder annotations", (Object)objectHolders.size());
    }

    private static void scanTarget(Map<Type, String> classModIds, Map<Type, Class<?>> classCache, Type type, @Nullable String annotationTarget, String value, boolean isClass, boolean extractFromValue) {
        Class<?> clazz;
        if (classCache.containsKey(type)) {
            clazz = classCache.get(type);
        } else {
            try {
                clazz = Class.forName(type.getClassName(), extractFromValue, ObjectHolderRegistry.class.getClassLoader());
                classCache.put(type, clazz);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (isClass) {
            ObjectHolderRegistry.scanClassForFields(classModIds, type, (String)value, clazz, extractFromValue);
        } else {
            if (((String)value).indexOf(58) == -1) {
                String prefix = classModIds.get(type);
                if (prefix == null) {
                    LOGGER.warn(ForgeRegistry.REGISTRIES, "Found an unqualified ObjectHolder annotation ({}) without a modid context at {}.{}, ignoring", value, (Object)type, (Object)annotationTarget);
                    throw new IllegalStateException("Unqualified reference to ObjectHolder");
                }
                value = prefix + ":" + (String)value;
            }
            try {
                Field f = clazz.getDeclaredField(annotationTarget);
                ObjectHolderRef ref = new ObjectHolderRef(f, (String)value, extractFromValue);
                if (ref.isValid()) {
                    ObjectHolderRegistry.addHandler(ref);
                }
            }
            catch (NoSuchFieldException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static void scanClassForFields(Map<Type, String> classModIds, Type targetClass, String value, Class<?> clazz, boolean extractFromExistingValues) {
        classModIds.put(targetClass, value);
        int flags = 4105;
        for (Field f : clazz.getFields()) {
            ObjectHolderRef ref;
            if ((f.getModifiers() & 0x1009) != 4105 || f.isAnnotationPresent(ObjectHolder.class) || !(ref = new ObjectHolderRef(f, value + ":" + f.getName().toLowerCase(Locale.ENGLISH), extractFromExistingValues)).isValid()) continue;
            ObjectHolderRegistry.addHandler(ref);
        }
    }

    public static void applyObjectHolders() {
        LOGGER.debug(ForgeRegistry.REGISTRIES, "Applying holder lookups");
        ObjectHolderRegistry.applyObjectHolders(key -> true);
        LOGGER.debug(ForgeRegistry.REGISTRIES, "Holder lookups applied");
    }

    public static void applyObjectHolders(Predicate<ResourceLocation> filter) {
        RuntimeException aggregate = new RuntimeException("Failed to apply some object holders, see suppressed exceptions for details");
        objectHolders.forEach(objectHolder -> {
            try {
                objectHolder.accept(filter);
            }
            catch (Exception e) {
                aggregate.addSuppressed(e);
            }
        });
        if (aggregate.getSuppressed().length > 0) {
            LOGGER.error("", (Throwable)aggregate);
            throw aggregate;
        }
    }
}

