/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.mohistmc.MohistMC;
import com.mohistmc.forge.ForgeInjectBukkit;
import com.mohistmc.org.yaml.snakeyaml.Yaml;
import com.mohistmc.org.yaml.snakeyaml.constructor.BaseConstructor;
import com.mohistmc.org.yaml.snakeyaml.constructor.SafeConstructor;
import com.mohistmc.org.yaml.snakeyaml.error.MarkedYAMLException;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Lifecycle;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import jline.console.ConsoleReader;
import net.minecraft.advancements.Advancement;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ConsoleInput;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.bossevents.CustomBossEvent;
import net.minecraft.server.bossevents.CustomBossEvents;
import net.minecraft.server.commands.ReloadCommand;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.ServerOpListEntry;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.UserBanListEntry;
import net.minecraft.server.players.UserWhiteListEntry;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.npc.CatSpawner;
import net.minecraft.world.entity.npc.WanderingTraderSpawner;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.RepairItemRecipe;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.PatrolSpawner;
import net.minecraft.world.level.levelgen.PhantomSpawner;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PlayerDataStorage;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import org.apache.commons.lang3.Validate;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Fluid;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.StructureType;
import org.bukkit.Tag;
import org.bukkit.UnsafeValues;
import org.bukkit.Warning;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.WorldCreator;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.conversations.Conversable;
import org.bukkit.craftbukkit.Main;
import org.bukkit.craftbukkit.v1_18_R2.CraftIpBanList;
import org.bukkit.craftbukkit.v1_18_R2.CraftLootTable;
import org.bukkit.craftbukkit.v1_18_R2.CraftOfflinePlayer;
import org.bukkit.craftbukkit.v1_18_R2.CraftProfileBanList;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_18_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_18_R2.boss.CraftBossBar;
import org.bukkit.craftbukkit.v1_18_R2.boss.CraftKeyedBossbar;
import org.bukkit.craftbukkit.v1_18_R2.command.BukkitCommandWrapper;
import org.bukkit.craftbukkit.v1_18_R2.command.CraftCommandMap;
import org.bukkit.craftbukkit.v1_18_R2.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_18_R2.generator.CraftWorldInfo;
import org.bukkit.craftbukkit.v1_18_R2.generator.CustomWorldChunkManager;
import org.bukkit.craftbukkit.v1_18_R2.generator.OldCraftChunkData;
import org.bukkit.craftbukkit.v1_18_R2.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftBlastingRecipe;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftCampfireRecipe;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftFurnaceRecipe;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMerchantCustom;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftShapedRecipe;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftShapelessRecipe;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftSmithingRecipe;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftSmokingRecipe;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftStonecuttingRecipe;
import org.bukkit.craftbukkit.v1_18_R2.inventory.RecipeIterator;
import org.bukkit.craftbukkit.v1_18_R2.inventory.util.CraftInventoryCreator;
import org.bukkit.craftbukkit.v1_18_R2.map.CraftMapView;
import org.bukkit.craftbukkit.v1_18_R2.metadata.EntityMetadataStore;
import org.bukkit.craftbukkit.v1_18_R2.metadata.PlayerMetadataStore;
import org.bukkit.craftbukkit.v1_18_R2.metadata.WorldMetadataStore;
import org.bukkit.craftbukkit.v1_18_R2.potion.CraftPotionBrewer;
import org.bukkit.craftbukkit.v1_18_R2.profile.CraftPlayerProfile;
import org.bukkit.craftbukkit.v1_18_R2.scheduler.CraftScheduler;
import org.bukkit.craftbukkit.v1_18_R2.scoreboard.CraftScoreboardManager;
import org.bukkit.craftbukkit.v1_18_R2.structure.CraftStructureManager;
import org.bukkit.craftbukkit.v1_18_R2.tag.CraftBlockTag;
import org.bukkit.craftbukkit.v1_18_R2.tag.CraftEntityTag;
import org.bukkit.craftbukkit.v1_18_R2.tag.CraftFluidTag;
import org.bukkit.craftbukkit.v1_18_R2.tag.CraftItemTag;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftIconCache;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftSpawnCategory;
import org.bukkit.craftbukkit.v1_18_R2.util.DatFileFilter;
import org.bukkit.craftbukkit.v1_18_R2.util.Versioning;
import org.bukkit.craftbukkit.v1_18_R2.util.permissions.CraftDefaultPermissions;
import org.bukkit.entity.Entity;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerChatTabCompleteEvent;
import org.bukkit.event.server.BroadcastMessageEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.event.server.TabCompleteEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.help.HelpMap;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.ComplexRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingRecipe;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.inventory.StonecuttingRecipe;
import org.bukkit.loot.LootTable;
import org.bukkit.map.MapView;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.plugin.SimpleServicesManager;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.potion.Potion;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.scheduler.BukkitWorker;
import org.bukkit.structure.StructureManager;
import org.bukkit.util.StringUtil;
import org.bukkit.util.permissions.DefaultPermissions;
import org.spigotmc.SpigotConfig;

public final class CraftServer
implements Server {
    private final String serverName = "Mohist";
    public static String serverVersion;
    private final String bukkitVersion = Versioning.getBukkitVersion();
    private final Logger logger = Logger.getLogger("Minecraft");
    private final ServicesManager servicesManager = new SimpleServicesManager();
    private final CraftScheduler scheduler = new CraftScheduler();
    private final CraftCommandMap commandMap = new CraftCommandMap(this);
    private final SimpleHelpMap helpMap = new SimpleHelpMap(this);
    private final StandardMessenger messenger = new StandardMessenger();
    private final SimplePluginManager pluginManager = new SimplePluginManager(this, this.commandMap);
    private final StructureManager structureManager;
    protected final DedicatedServer console;
    protected final DedicatedPlayerList playerList;
    private final Map<String, World> worlds = new LinkedHashMap<String, World>();
    private YamlConfiguration configuration;
    private YamlConfiguration commandsConfiguration;
    private final Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
    private final Map<UUID, OfflinePlayer> offlinePlayers = new MapMaker().weakValues().makeMap();
    private final EntityMetadataStore entityMetadata = new EntityMetadataStore();
    private final PlayerMetadataStore playerMetadata = new PlayerMetadataStore();
    private final WorldMetadataStore worldMetadata = new WorldMetadataStore();
    private final Object2IntOpenHashMap<SpawnCategory> spawnCategoryLimit = new Object2IntOpenHashMap();
    private File container;
    private Warning.WarningState warningState = Warning.WarningState.DEFAULT;
    public String minimumAPI;
    public CraftScoreboardManager scoreboardManager;
    public boolean playerCommandState;
    private boolean printSaveWarning;
    private CraftIconCache icon;
    private boolean overrideAllCommandCommandBlocks = false;
    public boolean ignoreVanillaPermissions = false;
    private final List<CraftPlayer> playerView;
    public int reloadCount;
    private final Server.Spigot spigot = new Server.Spigot(){};

    public CraftServer(DedicatedServer console, PlayerList playerList) {
        this.console = console;
        this.playerList = (DedicatedPlayerList)playerList;
        this.playerView = Collections.unmodifiableList(Lists.transform((List)playerList.f_11196_, (Function)new Function<ServerPlayer, CraftPlayer>(){

            public CraftPlayer apply(ServerPlayer player) {
                return player.getBukkitEntity();
            }
        }));
        serverVersion = MohistMC.class.getPackage().getImplementationVersion() != null ? MohistMC.class.getPackage().getImplementationVersion() : "unknown";
        this.structureManager = new CraftStructureManager(console.m_129909_());
        this.scoreboardManager = new CraftScoreboardManager((MinecraftServer)console, (Scoreboard)new ServerScoreboard((MinecraftServer)console));
        Bukkit.setServer(this);
        Enchantments.f_44977_.getClass();
        Potion.setPotionBrewer(new CraftPotionBrewer());
        MobEffects.f_19610_.getClass();
        ForgeInjectBukkit.init();
        if (!Main.useConsole) {
            this.getLogger().info("Console input is disabled due to --noconsole command argument");
        }
        this.configuration = YamlConfiguration.loadConfiguration(this.getConfigFile());
        this.configuration.options().copyDefaults(true);
        this.configuration.setDefaults(YamlConfiguration.loadConfiguration(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("configurations/bukkit.yml"), Charsets.UTF_8)));
        ConfigurationSection legacyAlias = null;
        if (!this.configuration.isString("aliases")) {
            legacyAlias = this.configuration.getConfigurationSection("aliases");
            this.configuration.set("aliases", "now-in-commands.yml");
        }
        this.saveConfig();
        if (this.getCommandsConfigFile().isFile()) {
            legacyAlias = null;
        }
        this.commandsConfiguration = YamlConfiguration.loadConfiguration(this.getCommandsConfigFile());
        this.commandsConfiguration.options().copyDefaults(true);
        this.commandsConfiguration.setDefaults(YamlConfiguration.loadConfiguration(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("configurations/commands.yml"), Charsets.UTF_8)));
        this.saveCommandsConfig();
        if (legacyAlias != null) {
            ConfigurationSection aliases = this.commandsConfiguration.createSection("aliases");
            for (String key : legacyAlias.getKeys(false)) {
                ArrayList<CallSite> commands = new ArrayList<CallSite>();
                if (legacyAlias.isList(key)) {
                    for (String command : legacyAlias.getStringList(key)) {
                        commands.add((CallSite)((Object)(command + " $1-")));
                    }
                } else {
                    commands.add((CallSite)((Object)(legacyAlias.getString(key) + " $1-")));
                }
                aliases.set(key, commands);
            }
        }
        this.saveCommandsConfig();
        this.overrideAllCommandCommandBlocks = this.commandsConfiguration.getStringList("command-block-overrides").contains("*");
        this.ignoreVanillaPermissions = this.commandsConfiguration.getBoolean("ignore-vanilla-permissions");
        this.pluginManager.useTimings(this.configuration.getBoolean("settings.plugin-profiling"));
        this.overrideSpawnLimits();
        console.autosavePeriod = this.configuration.getInt("ticks-per.autosave");
        this.warningState = Warning.WarningState.value(this.configuration.getString("settings.deprecated-verbose"));
        TicketType.PLUGIN.f_9452_ = this.configuration.getInt("chunk-gc.period-in-ticks");
        this.minimumAPI = this.configuration.getString("settings.minimum-api");
        this.loadIcon();
    }

    public boolean getCommandBlockOverride(String command) {
        return this.overrideAllCommandCommandBlocks || this.commandsConfiguration.getStringList("command-block-overrides").contains(command);
    }

    private File getConfigFile() {
        return (File)DedicatedServer.options.valueOf("bukkit-settings");
    }

    private File getCommandsConfigFile() {
        return (File)DedicatedServer.options.valueOf("commands-settings");
    }

    private void overrideSpawnLimits() {
        for (SpawnCategory spawnCategory : SpawnCategory.values()) {
            if (!CraftSpawnCategory.isValidForLimits(spawnCategory)) continue;
            this.spawnCategoryLimit.put((Object)spawnCategory, this.configuration.getInt(CraftSpawnCategory.getConfigNameSpawnLimit(spawnCategory)));
        }
    }

    private void saveConfig() {
        try {
            this.configuration.save(this.getConfigFile());
        }
        catch (IOException ex) {
            Logger.getLogger(CraftServer.class.getName()).log(Level.SEVERE, "Could not save " + this.getConfigFile(), ex);
        }
    }

    private void saveCommandsConfig() {
        try {
            this.commandsConfiguration.save(this.getCommandsConfigFile());
        }
        catch (IOException ex) {
            Logger.getLogger(CraftServer.class.getName()).log(Level.SEVERE, "Could not save " + this.getCommandsConfigFile(), ex);
        }
    }

    public void loadPlugins() {
        this.pluginManager.registerInterface(JavaPluginLoader.class);
        File pluginFolder = (File)DedicatedServer.options.valueOf("plugins");
        if (pluginFolder.exists()) {
            Plugin[] plugins;
            for (Plugin plugin : plugins = this.pluginManager.loadPlugins(pluginFolder)) {
                try {
                    String message = String.format("Loading %s", plugin.getDescription().getFullName());
                    plugin.getLogger().info(message);
                    plugin.onLoad();
                }
                catch (Throwable ex) {
                    Logger.getLogger(CraftServer.class.getName()).log(Level.SEVERE, ex.getMessage() + " initializing " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
                }
            }
        } else {
            pluginFolder.mkdir();
        }
    }

    public void enablePlugins(PluginLoadOrder type) {
        Plugin[] plugins;
        if (type == PluginLoadOrder.STARTUP) {
            this.helpMap.clear();
            this.helpMap.initializeGeneralTopics();
        }
        for (Plugin plugin : plugins = this.pluginManager.getPlugins()) {
            if (plugin.isEnabled() || plugin.getDescription().getLoad() != type) continue;
            this.enablePlugin(plugin);
        }
        if (type == PluginLoadOrder.POSTWORLD) {
            this.commandMap.setFallbackCommands();
            this.setVanillaCommands();
            this.commandMap.registerServerAliases();
            DefaultPermissions.registerCorePermissions();
            CraftDefaultPermissions.registerCorePermissions();
            this.loadCustomPermissions();
            this.helpMap.initializeCommands();
            this.syncCommands();
        }
    }

    public void disablePlugins() {
        this.pluginManager.disablePlugins();
    }

    private void setVanillaCommands() {
        Commands dispatcher = this.console.vanillaCommandDispatcher;
        for (CommandNode cmd : dispatcher.m_82094_().getRoot().getChildren()) {
            this.commandMap.register("minecraft", new VanillaCommandWrapper(dispatcher, (CommandNode<CommandSourceStack>)cmd));
        }
    }

    public void syncCommands() {
        Commands dispatcher = this.console.f_129740_.f_206585_().f_206847_ = new Commands();
        for (Map.Entry<String, Command> entry : this.commandMap.getKnownCommands().entrySet()) {
            String label = entry.getKey();
            Command command = entry.getValue();
            if (command instanceof VanillaCommandWrapper) {
                LiteralCommandNode node = (LiteralCommandNode)((VanillaCommandWrapper)command).vanillaCommand;
                if (!node.getLiteral().equals(label)) {
                    LiteralCommandNode clone = new LiteralCommandNode(label, node.getCommand(), node.getRequirement(), node.getRedirect(), node.getRedirectModifier(), node.isFork());
                    for (CommandNode child : node.getChildren()) {
                        clone.addChild(child);
                    }
                    node = clone;
                }
                dispatcher.m_82094_().getRoot().addChild((CommandNode)node);
                continue;
            }
            new BukkitCommandWrapper(this, entry.getValue()).register((CommandDispatcher<CommandSourceStack>)dispatcher.m_82094_(), label);
        }
        for (ServerPlayer player : this.getHandle().f_11196_) {
            dispatcher.m_82095_(player);
        }
    }

    private void enablePlugin(Plugin plugin) {
        try {
            List<Permission> perms = plugin.getDescription().getPermissions();
            for (Permission perm : perms) {
                try {
                    this.pluginManager.addPermission(perm, false);
                }
                catch (IllegalArgumentException ex) {
                    this.getLogger().log(Level.WARNING, "Plugin " + plugin.getDescription().getFullName() + " tried to register permission '" + perm.getName() + "' but it's already registered", ex);
                }
            }
            this.pluginManager.dirtyPermissibles();
            this.pluginManager.enablePlugin(plugin);
        }
        catch (Throwable ex) {
            Logger.getLogger(CraftServer.class.getName()).log(Level.SEVERE, ex.getMessage() + " loading " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
        }
    }

    @Override
    public String getName() {
        return "Mohist";
    }

    @Override
    public String getVersion() {
        return serverVersion + " (MC: " + this.console.m_7630_() + ")";
    }

    @Override
    public String getBukkitVersion() {
        return this.bukkitVersion;
    }

    public List<CraftPlayer> getOnlinePlayers() {
        return this.playerView;
    }

    @Override
    @Deprecated
    public org.bukkit.entity.Player getPlayer(String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null", (Object[])new Object[0]);
        org.bukkit.entity.Player found = this.getPlayerExact(name);
        if (found != null) {
            return found;
        }
        String lowerName = name.toLowerCase(Locale.ENGLISH);
        int delta = Integer.MAX_VALUE;
        for (org.bukkit.entity.Player player : this.getOnlinePlayers()) {
            if (!player.getName().toLowerCase(Locale.ENGLISH).startsWith(lowerName)) continue;
            int curDelta = Math.abs(player.getName().length() - lowerName.length());
            if (curDelta < delta) {
                found = player;
                delta = curDelta;
            }
            if (curDelta != 0) continue;
            break;
        }
        return found;
    }

    @Override
    @Deprecated
    public org.bukkit.entity.Player getPlayerExact(String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null", (Object[])new Object[0]);
        ServerPlayer player = this.playerList.m_11255_(name);
        return player != null ? player.getBukkitEntity() : null;
    }

    @Override
    public org.bukkit.entity.Player getPlayer(UUID id) {
        ServerPlayer player = this.playerList.m_11259_(id);
        if (player != null) {
            return player.getBukkitEntity();
        }
        return null;
    }

    @Override
    public int broadcastMessage(String message) {
        return this.broadcast(message, "bukkit.broadcast.user");
    }

    @Override
    @Deprecated
    public List<org.bukkit.entity.Player> matchPlayer(String partialName) {
        Validate.notNull((Object)partialName, (String)"PartialName cannot be null", (Object[])new Object[0]);
        ArrayList<org.bukkit.entity.Player> matchedPlayers = new ArrayList<org.bukkit.entity.Player>();
        for (org.bukkit.entity.Player iterPlayer : this.getOnlinePlayers()) {
            String iterPlayerName = iterPlayer.getName();
            if (partialName.equalsIgnoreCase(iterPlayerName)) {
                matchedPlayers.clear();
                matchedPlayers.add(iterPlayer);
                break;
            }
            if (!iterPlayerName.toLowerCase(Locale.ENGLISH).contains(partialName.toLowerCase(Locale.ENGLISH))) continue;
            matchedPlayers.add(iterPlayer);
        }
        return matchedPlayers;
    }

    @Override
    public int getMaxPlayers() {
        return this.playerList.m_11310_();
    }

    @Override
    public int getPort() {
        return this.getServer().m_7010_();
    }

    @Override
    public int getViewDistance() {
        return this.getProperties().f_139714_;
    }

    @Override
    public int getSimulationDistance() {
        return this.getProperties().f_183715_;
    }

    @Override
    public String getIp() {
        return this.getServer().m_130009_();
    }

    @Override
    public String getWorldType() {
        return this.getProperties().f_139798_.getProperty("level-type");
    }

    @Override
    public boolean getGenerateStructures() {
        return this.getProperties().m_180927_((RegistryAccess)this.getServer().m_206579_()).m_64657_();
    }

    @Override
    public int getMaxWorldSize() {
        return this.getProperties().f_139719_;
    }

    @Override
    public boolean getAllowEnd() {
        return this.configuration.getBoolean("settings.allow-end");
    }

    @Override
    public boolean getAllowNether() {
        return this.getServer().m_7079_();
    }

    public boolean getWarnOnOverload() {
        return this.configuration.getBoolean("settings.warn-on-overload");
    }

    public boolean getQueryPlugins() {
        return this.configuration.getBoolean("settings.query-plugins");
    }

    @Override
    public String getResourcePack() {
        return this.getServer().m_129795_();
    }

    @Override
    public String getResourcePackHash() {
        return this.getServer().m_129796_().toUpperCase(Locale.ROOT);
    }

    @Override
    public String getResourcePackPrompt() {
        return CraftChatMessage.fromComponent(this.getServer().m_141958_());
    }

    @Override
    public boolean isResourcePackRequired() {
        return this.getServer().m_142205_();
    }

    @Override
    public boolean hasWhitelist() {
        return (Boolean)this.getProperties().f_139726_.get();
    }

    private DedicatedServerProperties getProperties() {
        return this.console.m_7913_();
    }

    @Override
    public String getUpdateFolder() {
        return this.configuration.getString("settings.update-folder", "update");
    }

    @Override
    public File getUpdateFolderFile() {
        return new File((File)DedicatedServer.options.valueOf("plugins"), this.configuration.getString("settings.update-folder", "update"));
    }

    @Override
    public long getConnectionThrottle() {
        return this.configuration.getInt("settings.connection-throttle");
    }

    @Override
    @Deprecated
    public int getTicksPerAnimalSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.ANIMAL);
    }

    @Override
    @Deprecated
    public int getTicksPerMonsterSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.MONSTER);
    }

    @Override
    @Deprecated
    public int getTicksPerWaterSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_ANIMAL);
    }

    @Override
    @Deprecated
    public int getTicksPerWaterAmbientSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_AMBIENT);
    }

    @Override
    @Deprecated
    public int getTicksPerWaterUndergroundCreatureSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_UNDERGROUND_CREATURE);
    }

    @Override
    @Deprecated
    public int getTicksPerAmbientSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.AMBIENT);
    }

    @Override
    public int getTicksPerSpawns(SpawnCategory spawnCategory) {
        Validate.notNull((Object)((Object)spawnCategory), (String)"SpawnCategory cannot be null", (Object[])new Object[0]);
        Validate.isTrue((boolean)CraftSpawnCategory.isValidForLimits(spawnCategory), (String)("SpawnCategory." + spawnCategory + " are not supported."), (Object[])new Object[0]);
        return this.configuration.getInt(CraftSpawnCategory.getConfigNameTicksPerSpawn(spawnCategory));
    }

    @Override
    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    @Override
    public CraftScheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Override
    public List<World> getWorlds() {
        return new ArrayList<World>(this.worlds.values());
    }

    public Set<String> getWorldsByName() {
        return new HashSet<String>(this.worlds.keySet());
    }

    public DedicatedPlayerList getHandle() {
        return this.playerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchServerCommand(CommandSender sender, ConsoleInput serverCommand) {
        Conversable conversable2;
        if (sender instanceof Conversable && (conversable2 = (Conversable)((Object)sender)).isConversing()) {
            conversable2.acceptConversationInput(serverCommand.f_135928_);
            return true;
        }
        try {
            this.playerCommandState = true;
            boolean conversable2 = this.dispatchCommand(sender, serverCommand.f_135928_);
            return conversable2;
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Unexpected exception while parsing console command \"" + serverCommand.f_135928_ + "\"", ex);
            boolean bl = false;
            return bl;
        }
        finally {
            this.playerCommandState = false;
        }
    }

    @Override
    public boolean dispatchCommand(CommandSender sender, String commandLine) {
        Validate.notNull((Object)sender, (String)"Sender cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)commandLine, (String)"CommandLine cannot be null", (Object[])new Object[0]);
        if (this.commandMap.dispatch(sender, commandLine)) {
            return true;
        }
        if (sender instanceof org.bukkit.entity.Player) {
            sender.sendMessage("Unknown command. Type \"/help\" for help.");
        } else {
            sender.sendMessage("Unknown command. Type \"help\" for help.");
        }
        return false;
    }

    @Override
    public void reload() {
        ++this.reloadCount;
        this.configuration = YamlConfiguration.loadConfiguration(this.getConfigFile());
        this.commandsConfiguration = YamlConfiguration.loadConfiguration(this.getCommandsConfigFile());
        this.console.f_139604_ = new DedicatedServerSettings(Paths.get("server.properties", new String[0]));
        DedicatedServerProperties config = this.console.f_139604_.m_139777_();
        this.console.m_129997_(config.f_139733_);
        this.console.m_129999_(config.f_139734_);
        this.console.m_129989_(config.f_139736_);
        this.overrideSpawnLimits();
        this.warningState = Warning.WarningState.value(this.configuration.getString("settings.deprecated-verbose"));
        TicketType.PLUGIN.f_9452_ = this.configuration.getInt("chunk-gc.period-in-ticks");
        this.minimumAPI = this.configuration.getString("settings.minimum-api");
        this.printSaveWarning = false;
        this.console.autosavePeriod = this.configuration.getInt("ticks-per.autosave");
        this.loadIcon();
        try {
            this.playerList.m_11299_().m_11399_();
        }
        catch (IOException ex) {
            this.logger.log(Level.WARNING, "Failed to load banned-ips.json, " + ex.getMessage());
        }
        try {
            this.playerList.m_11295_().m_11399_();
        }
        catch (IOException ex) {
            this.logger.log(Level.WARNING, "Failed to load banned-players.json, " + ex.getMessage());
        }
        SpigotConfig.init((File)DedicatedServer.options.valueOf("spigot-settings"));
        for (ServerLevel world : this.console.m_129785_()) {
            world.m_142572_().m_129910_().m_6166_(config.f_139739_);
            world.m_46703_(config.f_139705_, config.f_139731_);
            for (SpawnCategory spawnCategory : SpawnCategory.values()) {
                if (!CraftSpawnCategory.isValidForLimits(spawnCategory)) continue;
                long ticksPerCategorySpawn = this.getTicksPerSpawns(spawnCategory);
                if (ticksPerCategorySpawn < 0L) {
                    world.ticksPerSpawnCategory.put((Object)spawnCategory, CraftSpawnCategory.getDefaultTicksPerSpawn(spawnCategory));
                    continue;
                }
                world.ticksPerSpawnCategory.put((Object)spawnCategory, ticksPerCategorySpawn);
            }
            world.spigotConfig.init();
        }
        this.pluginManager.clearPlugins();
        this.commandMap.clearCommands();
        this.reloadData();
        SpigotConfig.registerCommands();
        this.overrideAllCommandCommandBlocks = this.commandsConfiguration.getStringList("command-block-overrides").contains("*");
        this.ignoreVanillaPermissions = this.commandsConfiguration.getBoolean("ignore-vanilla-permissions");
        for (int pollCount = 0; pollCount < 50 && this.getScheduler().getActiveWorkers().size() > 0; ++pollCount) {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException world) {
                // empty catch block
            }
        }
        List<BukkitWorker> overdueWorkers = this.getScheduler().getActiveWorkers();
        for (BukkitWorker worker : overdueWorkers) {
            Plugin plugin = worker.getOwner();
            this.getLogger().log(Level.SEVERE, String.format("Nag author(s): '%s' of '%s' about the following: %s", plugin.getDescription().getAuthors(), plugin.getDescription().getFullName(), "This plugin is not properly shutting down its async tasks when it is being reloaded.  This may cause conflicts with the newly loaded version of the plugin"));
        }
        this.loadPlugins();
        this.enablePlugins(PluginLoadOrder.STARTUP);
        this.enablePlugins(PluginLoadOrder.POSTWORLD);
        this.getPluginManager().callEvent(new ServerLoadEvent(ServerLoadEvent.LoadType.RELOAD));
    }

    @Override
    public void reloadData() {
        ReloadCommand.reload((MinecraftServer)this.console);
    }

    private void loadIcon() {
        this.icon = new CraftIconCache(null);
        try {
            File file = new File(new File("."), "server-icon.png");
            if (file.isFile()) {
                this.icon = CraftServer.loadServerIcon0(file);
            }
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Couldn't load server icon", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCustomPermissions() {
        Map perms;
        FileInputStream stream;
        File file = new File(this.configuration.getString("settings.permissions-file"));
        try {
            stream = new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            try {
                file.createNewFile();
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }
        try {
            perms = (Map)this.yaml.load((InputStream)stream);
        }
        catch (MarkedYAMLException ex) {
            this.getLogger().log(Level.WARNING, "Server permissions file " + file + " is not valid YAML: " + ex.toString());
            return;
        }
        catch (Throwable ex) {
            this.getLogger().log(Level.WARNING, "Server permissions file " + file + " is not valid YAML.", ex);
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        if (perms == null) {
            this.getLogger().log(Level.INFO, "Server permissions file " + file + " is empty, ignoring it");
            return;
        }
        List<Permission> permsList = Permission.loadPermissions(perms, "Permission node '%s' in " + file + " is invalid", Permission.DEFAULT_PERMISSION);
        for (Permission perm : permsList) {
            try {
                this.pluginManager.addPermission(perm);
            }
            catch (IllegalArgumentException ex) {
                this.getLogger().log(Level.SEVERE, "Permission in " + file + " was already defined", ex);
            }
        }
    }

    public String toString() {
        return "CraftServer{serverName=Mohist,serverVersion=" + serverVersion + ",minecraftVersion=" + this.console.m_7630_() + "}";
    }

    public World createWorld(String name, World.Environment environment) {
        return WorldCreator.name(name).environment(environment).createWorld();
    }

    public World createWorld(String name, World.Environment environment, long seed) {
        return WorldCreator.name(name).environment(environment).seed(seed).createWorld();
    }

    public World createWorld(String name, World.Environment environment, org.bukkit.generator.ChunkGenerator generator) {
        return WorldCreator.name(name).environment(environment).generator(generator).createWorld();
    }

    public World createWorld(String name, World.Environment environment, long seed, org.bukkit.generator.ChunkGenerator generator) {
        return WorldCreator.name(name).environment(environment).seed(seed).generator(generator).createWorld();
    }

    @Override
    public World createWorld(WorldCreator creator) {
        String levelName;
        ChunkGenerator chunkgenerator;
        Holder holder;
        LevelStorageSource.LevelStorageAccess worldSession;
        Preconditions.checkState((!this.console.f_129762_.isEmpty() ? 1 : 0) != 0, (Object)"Cannot create additional worlds on STARTUP");
        Validate.notNull((Object)creator, (String)"Creator may not be null", (Object[])new Object[0]);
        String name = creator.name();
        org.bukkit.generator.ChunkGenerator generator = creator.generator();
        BiomeProvider biomeProvider = creator.biomeProvider();
        File folder = new File(this.getWorldContainer(), name);
        World world = this.getWorld(name);
        if (world != null) {
            return world;
        }
        if (folder.exists() && !folder.isDirectory()) {
            throw new IllegalArgumentException("File exists with the name '" + name + "' and isn't a folder");
        }
        if (generator == null) {
            generator = this.getGenerator(name);
        }
        if (biomeProvider == null) {
            biomeProvider = this.getBiomeProvider(name);
        }
        ResourceKey actualDimension = (ResourceKey)ForgeInjectBukkit.environment0.get((Object)creator.environment());
        try {
            worldSession = LevelStorageSource.m_78242_((Path)this.getWorldContainer().toPath()).createAccess(name, actualDimension);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (worldSession == null) {
            return null;
        }
        boolean hardcore = creator.hardcore();
        PrimaryLevelData worlddata = (PrimaryLevelData)worldSession.m_211747_(DedicatedServer.registryreadops, DedicatedServer.datapackconfiguration, this.console.f_129746_.m_211816_());
        if (worlddata == null) {
            DedicatedServerProperties.WorldGenProperties properties = new DedicatedServerProperties.WorldGenProperties(Objects.toString(creator.seed()), GsonHelper.m_13864_((String)(creator.generatorSettings().isEmpty() ? "{}" : creator.generatorSettings())), creator.generateStructures(), creator.type().name().toLowerCase(Locale.ROOT));
            WorldGenSettings generatorsettings = WorldGenSettings.m_209716_((RegistryAccess)this.console.m_206579_(), (DedicatedServerProperties.WorldGenProperties)properties);
            LevelSettings worldSettings = new LevelSettings(name, GameType.m_46393_((int)this.getDefaultGameMode().getValue()), hardcore, Difficulty.EASY, false, new GameRules(), DedicatedServer.datapackconfiguration);
            worlddata = new PrimaryLevelData(worldSettings, generatorsettings, Lifecycle.stable());
        }
        worlddata.checkName(name);
        worlddata.m_7955_(this.console.m_130001_(), this.console.m_183471_().m_184597_());
        if (DedicatedServer.options.has("forceUpgrade")) {
            net.minecraft.server.Main.m_195488_((LevelStorageSource.LevelStorageAccess)worldSession, (DataFixer)DataFixers.m_14512_(), (boolean)DedicatedServer.options.has("eraseCache"), () -> true, (WorldGenSettings)worlddata.m_5961_());
        }
        long j = BiomeManager.m_47877_((long)creator.seed());
        ImmutableList list = ImmutableList.of((Object)new PhantomSpawner(), (Object)new PatrolSpawner(), (Object)new CatSpawner(), (Object)new VillageSiege(), (Object)new WanderingTraderSpawner((ServerLevelData)worlddata));
        Registry iregistry = worlddata.m_5961_().m_204655_();
        LevelStem worlddimension = (LevelStem)iregistry.m_6246_(actualDimension);
        if (worlddimension == null) {
            holder = this.console.f_129746_.m_175515_(Registry.f_122818_).m_203538_(DimensionType.f_63845_);
            chunkgenerator = WorldGenSettings.m_190027_((RegistryAccess)this.console.f_129746_, (long)new Random().nextLong());
        } else {
            holder = worlddimension.m_204521_();
            chunkgenerator = worlddimension.m_63990_();
        }
        CraftWorldInfo worldInfo = new CraftWorldInfo((ServerLevelData)worlddata, worldSession, creator.environment(), (DimensionType)holder.m_203334_());
        if (biomeProvider == null && generator != null) {
            biomeProvider = generator.getDefaultBiomeProvider(worldInfo);
        }
        if (biomeProvider != null) {
            CustomWorldChunkManager worldChunkManager = new CustomWorldChunkManager(worldInfo, biomeProvider, (Registry<Biome>)this.console.f_129746_.m_206191_(Registry.f_122885_));
            if (chunkgenerator instanceof NoiseBasedChunkGenerator) {
                NoiseBasedChunkGenerator cga = (NoiseBasedChunkGenerator)chunkgenerator;
                chunkgenerator = new NoiseBasedChunkGenerator(cga.f_207955_, cga.f_188604_, (BiomeSource)worldChunkManager, cga.f_212255_, cga.f_64318_);
            }
        }
        ResourceKey worldKey = name.equals((levelName = this.getServer().m_7913_().f_139741_) + "_nether") ? net.minecraft.world.level.Level.f_46429_ : (name.equals(levelName + "_the_end") ? net.minecraft.world.level.Level.f_46430_ : ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(name.toLowerCase(Locale.ENGLISH))));
        ServerLevel internal = new ServerLevel((MinecraftServer)this.console, this.console.f_129738_, worldSession, (ServerLevelData)worlddata, worldKey, holder, this.getServer().f_129756_.m_9620_(11), chunkgenerator, worlddata.m_5961_().m_64668_(), j, (List)(creator.environment() == World.Environment.NORMAL ? list : ImmutableList.of()), true);
        ServerLevel.setGeneratorAndEnv((org.bukkit.generator.ChunkGenerator)generator, (World.Environment)creator.environment());
        if (!this.worlds.containsKey(name.toLowerCase(Locale.ENGLISH))) {
            return null;
        }
        this.console.initWorld(internal, (ServerLevelData)worlddata, (WorldData)worlddata, worlddata.m_5961_());
        internal.m_46703_(true, true);
        this.console.f_129762_.put(internal.m_46472_(), internal);
        this.getServer().prepareLevels(internal.m_7726_().f_8325_.f_140144_, internal);
        internal.f_143244_.m_157506_();
        this.pluginManager.callEvent(new WorldLoadEvent(internal.getWorld()));
        return internal.getWorld();
    }

    @Override
    public boolean unloadWorld(String name, boolean save) {
        return this.unloadWorld(this.getWorld(name), save);
    }

    @Override
    public boolean unloadWorld(World world, boolean save) {
        if (world == null) {
            return false;
        }
        ServerLevel handle = ((CraftWorld)world).getHandle();
        if (!this.console.f_129762_.containsKey(handle.m_46472_())) {
            return false;
        }
        if (handle.m_46472_() == net.minecraft.world.level.Level.f_46428_) {
            return false;
        }
        if (handle.m_6907_().size() > 0) {
            return false;
        }
        WorldUnloadEvent e = new WorldUnloadEvent(handle.getWorld());
        this.pluginManager.callEvent(e);
        if (e.isCancelled()) {
            return false;
        }
        try {
            if (save) {
                handle.m_8643_(null, true, true);
            }
            handle.m_7726_().close(save);
            handle.f_143244_.close(save);
            handle.convertable.close();
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, null, ex);
        }
        this.worlds.remove(world.getName().toLowerCase(Locale.ENGLISH));
        this.console.f_129762_.remove(handle.m_46472_());
        return true;
    }

    public DedicatedServer getServer() {
        return this.console;
    }

    @Override
    public World getWorld(String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null", (Object[])new Object[0]);
        return this.worlds.get(name.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public World getWorld(UUID uid) {
        for (World world : this.worlds.values()) {
            if (!world.getUID().equals(uid)) continue;
            return world;
        }
        return null;
    }

    public void addWorld(World world) {
        if (this.getWorld(world.getUID()) != null) {
            return;
        }
        this.worlds.put(world.getName().toLowerCase(Locale.ENGLISH), world);
    }

    @Override
    public WorldBorder createWorldBorder() {
        return new CraftWorldBorder(new net.minecraft.world.level.border.WorldBorder());
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public ConsoleReader getReader() {
        return this.console.reader;
    }

    @Override
    public PluginCommand getPluginCommand(String name) {
        Command command = this.commandMap.getCommand(name);
        if (command instanceof PluginCommand) {
            return (PluginCommand)command;
        }
        return null;
    }

    @Override
    public void savePlayers() {
        this.checkSaveState();
        this.playerList.m_11302_();
    }

    @Override
    public boolean addRecipe(org.bukkit.inventory.Recipe recipe) {
        CraftRecipe toAdd;
        if (recipe instanceof CraftRecipe) {
            toAdd = (CraftRecipe)recipe;
        } else if (recipe instanceof ShapedRecipe) {
            toAdd = CraftShapedRecipe.fromBukkitRecipe((ShapedRecipe)recipe);
        } else if (recipe instanceof ShapelessRecipe) {
            toAdd = CraftShapelessRecipe.fromBukkitRecipe((ShapelessRecipe)recipe);
        } else if (recipe instanceof FurnaceRecipe) {
            toAdd = CraftFurnaceRecipe.fromBukkitRecipe((FurnaceRecipe)recipe);
        } else if (recipe instanceof BlastingRecipe) {
            toAdd = CraftBlastingRecipe.fromBukkitRecipe((BlastingRecipe)recipe);
        } else if (recipe instanceof CampfireRecipe) {
            toAdd = CraftCampfireRecipe.fromBukkitRecipe((CampfireRecipe)recipe);
        } else if (recipe instanceof SmokingRecipe) {
            toAdd = CraftSmokingRecipe.fromBukkitRecipe((SmokingRecipe)recipe);
        } else if (recipe instanceof StonecuttingRecipe) {
            toAdd = CraftStonecuttingRecipe.fromBukkitRecipe((StonecuttingRecipe)recipe);
        } else if (recipe instanceof SmithingRecipe) {
            toAdd = CraftSmithingRecipe.fromBukkitRecipe((SmithingRecipe)recipe);
        } else {
            if (recipe instanceof ComplexRecipe) {
                throw new UnsupportedOperationException("Cannot add custom complex recipe");
            }
            return false;
        }
        toAdd.addToCraftingManager();
        return true;
    }

    @Override
    public List<org.bukkit.inventory.Recipe> getRecipesFor(org.bukkit.inventory.ItemStack result) {
        Validate.notNull((Object)result, (String)"Result cannot be null", (Object[])new Object[0]);
        ArrayList<org.bukkit.inventory.Recipe> results = new ArrayList<org.bukkit.inventory.Recipe>();
        Iterator<org.bukkit.inventory.Recipe> iter = this.recipeIterator();
        while (iter.hasNext()) {
            org.bukkit.inventory.Recipe recipe = iter.next();
            org.bukkit.inventory.ItemStack stack = recipe.getResult();
            if (stack.getType() != result.getType() || result.getDurability() != -1 && result.getDurability() != stack.getDurability()) continue;
            results.add(recipe);
        }
        return results;
    }

    @Override
    public org.bukkit.inventory.Recipe getRecipe(NamespacedKey recipeKey) {
        Preconditions.checkArgument((recipeKey != null ? 1 : 0) != 0, (Object)"recipeKey == null");
        return this.getServer().m_129894_().m_44043_(CraftNamespacedKey.toMinecraft(recipeKey)).map(Recipe::toBukkitRecipe).orElse(null);
    }

    @Override
    public org.bukkit.inventory.Recipe getCraftingRecipe(org.bukkit.inventory.ItemStack[] craftingMatrix, World world) {
        AbstractContainerMenu container = new AbstractContainerMenu(null, -1){

            public InventoryView getBukkitView() {
                return null;
            }

            public boolean m_6875_(Player p_38874_) {
                return false;
            }
        };
        CraftingContainer inventoryCrafting = new CraftingContainer(container, 3, 3);
        return this.getNMSRecipe(craftingMatrix, inventoryCrafting, (CraftWorld)world).map(Recipe::toBukkitRecipe).orElse(null);
    }

    @Override
    public org.bukkit.inventory.ItemStack craftItem(org.bukkit.inventory.ItemStack[] craftingMatrix, World world, org.bukkit.entity.Player player) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"world must not be null");
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"player must not be null");
        CraftWorld craftWorld = (CraftWorld)world;
        CraftPlayer craftPlayer = (CraftPlayer)player;
        CraftingMenu container = new CraftingMenu(-1, craftPlayer.getHandle().m_150109_());
        CraftingContainer inventoryCrafting = container.f_39348_;
        ResultContainer craftResult = container.f_39349_;
        Optional<CraftingRecipe> recipe = this.getNMSRecipe(craftingMatrix, inventoryCrafting, craftWorld);
        ItemStack itemstack = ItemStack.f_41583_;
        if (recipe.isPresent()) {
            CraftingRecipe recipeCrafting = recipe.get();
            if (craftResult.m_40135_((net.minecraft.world.level.Level)craftWorld.getHandle(), craftPlayer.getHandle(), (Recipe)recipeCrafting)) {
                itemstack = recipeCrafting.m_5874_((Container)inventoryCrafting);
            }
        }
        ItemStack result = CraftEventFactory.callPreCraftEvent((Container)inventoryCrafting, (Container)craftResult, itemstack, container.getBukkitView(), recipe.orElse(null) instanceof RepairItemRecipe);
        for (int i = 0; i < craftingMatrix.length; ++i) {
            Item remaining = ((ItemStack)inventoryCrafting.getContents().get(i)).m_41720_().m_41469_();
            craftingMatrix[i] = remaining != null ? CraftItemStack.asBukkitCopy(remaining.m_7968_()) : null;
        }
        return CraftItemStack.asBukkitCopy(result);
    }

    private Optional<CraftingRecipe> getNMSRecipe(org.bukkit.inventory.ItemStack[] craftingMatrix, CraftingContainer inventoryCrafting, CraftWorld world) {
        Preconditions.checkArgument((craftingMatrix != null ? 1 : 0) != 0, (Object)"craftingMatrix must not be null");
        Preconditions.checkArgument((craftingMatrix.length == 9 ? 1 : 0) != 0, (Object)"craftingMatrix must be an array of length 9");
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"world must not be null");
        for (int i = 0; i < craftingMatrix.length; ++i) {
            inventoryCrafting.m_6836_(i, CraftItemStack.asNMSCopy(craftingMatrix[i]));
        }
        return this.getServer().m_129894_().m_44015_(RecipeType.f_44107_, (Container)inventoryCrafting, (net.minecraft.world.level.Level)world.getHandle());
    }

    @Override
    public Iterator<org.bukkit.inventory.Recipe> recipeIterator() {
        return new RecipeIterator();
    }

    @Override
    public void clearRecipes() {
        this.console.m_129894_().clearRecipes();
    }

    @Override
    public void resetRecipes() {
        this.reloadData();
    }

    @Override
    public boolean removeRecipe(NamespacedKey recipeKey) {
        Preconditions.checkArgument((recipeKey != null ? 1 : 0) != 0, (Object)"recipeKey == null");
        ResourceLocation mcKey = CraftNamespacedKey.toMinecraft(recipeKey);
        return this.getServer().m_129894_().removeRecipe(mcKey);
    }

    @Override
    public Map<String, String[]> getCommandAliases() {
        ConfigurationSection section = this.commandsConfiguration.getConfigurationSection("aliases");
        LinkedHashMap<String, String[]> result = new LinkedHashMap<String, String[]>();
        if (section != null) {
            for (String key : section.getKeys(false)) {
                ImmutableList commands = section.isList(key) ? section.getStringList(key) : ImmutableList.of((Object)section.getString(key));
                result.put(key, commands.toArray(new String[commands.size()]));
            }
        }
        return result;
    }

    public void removeBukkitSpawnRadius() {
        this.configuration.set("settings.spawn-radius", null);
        this.saveConfig();
    }

    public int getBukkitSpawnRadius() {
        return this.configuration.getInt("settings.spawn-radius", -1);
    }

    @Override
    public String getShutdownMessage() {
        return this.configuration.getString("settings.shutdown-message");
    }

    @Override
    public int getSpawnRadius() {
        return this.getServer().m_6396_();
    }

    @Override
    public void setSpawnRadius(int value) {
        this.configuration.set("settings.spawn-radius", value);
        this.saveConfig();
    }

    @Override
    public boolean getHideOnlinePlayers() {
        return this.console.m_183306_();
    }

    @Override
    public boolean getOnlineMode() {
        return this.console.m_129797_();
    }

    @Override
    public boolean getAllowFlight() {
        return this.console.m_129915_();
    }

    @Override
    public boolean isHardcore() {
        return this.console.m_7035_();
    }

    public org.bukkit.generator.ChunkGenerator getGenerator(String world) {
        String name;
        ConfigurationSection section = this.configuration.getConfigurationSection("worlds");
        org.bukkit.generator.ChunkGenerator result = null;
        if (section != null && (section = section.getConfigurationSection(world)) != null && (name = section.getString("generator")) != null && !name.equals("")) {
            String[] split = name.split(":", 2);
            String id = split.length > 1 ? split[1] : null;
            Plugin plugin = this.pluginManager.getPlugin(split[0]);
            if (plugin == null) {
                this.getLogger().severe("Could not set generator for default world '" + world + "': Plugin '" + split[0] + "' does not exist");
            } else if (!plugin.isEnabled()) {
                this.getLogger().severe("Could not set generator for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName() + "' is not enabled yet (is it load:STARTUP?)");
            } else {
                try {
                    result = plugin.getDefaultWorldGenerator(world, id);
                    if (result == null) {
                        this.getLogger().severe("Could not set generator for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName() + "' lacks a default world generator");
                    }
                }
                catch (Throwable t) {
                    plugin.getLogger().log(Level.SEVERE, "Could not set generator for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName(), t);
                }
            }
        }
        return result;
    }

    public BiomeProvider getBiomeProvider(String world) {
        String name;
        ConfigurationSection section = this.configuration.getConfigurationSection("worlds");
        BiomeProvider result = null;
        if (section != null && (section = section.getConfigurationSection(world)) != null && (name = section.getString("biome-provider")) != null && !name.equals("")) {
            String[] split = name.split(":", 2);
            String id = split.length > 1 ? split[1] : null;
            Plugin plugin = this.pluginManager.getPlugin(split[0]);
            if (plugin == null) {
                this.getLogger().severe("Could not set biome provider for default world '" + world + "': Plugin '" + split[0] + "' does not exist");
            } else if (!plugin.isEnabled()) {
                this.getLogger().severe("Could not set biome provider for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName() + "' is not enabled yet (is it load:STARTUP?)");
            } else {
                try {
                    result = plugin.getDefaultBiomeProvider(world, id);
                    if (result == null) {
                        this.getLogger().severe("Could not set biome provider for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName() + "' lacks a default world biome provider");
                    }
                }
                catch (Throwable t) {
                    plugin.getLogger().log(Level.SEVERE, "Could not set biome provider for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName(), t);
                }
            }
        }
        return result;
    }

    @Override
    @Deprecated
    public CraftMapView getMap(int id) {
        MapItemSavedData worldmap = this.console.m_129880_(net.minecraft.world.level.Level.f_46428_).m_7489_("map_" + id);
        if (worldmap == null) {
            return null;
        }
        return worldmap.mapView;
    }

    @Override
    public CraftMapView createMap(World world) {
        Validate.notNull((Object)world, (String)"World cannot be null", (Object[])new Object[0]);
        ServerLevel minecraftWorld = ((CraftWorld)world).getHandle();
        int newId = MapItem.m_151120_((net.minecraft.world.level.Level)minecraftWorld, (int)minecraftWorld.m_6106_().m_6789_(), (int)minecraftWorld.m_6106_().m_6526_(), (int)3, (boolean)false, (boolean)false, (ResourceKey)minecraftWorld.m_46472_());
        return minecraftWorld.m_7489_((String)MapItem.m_42848_((int)newId)).mapView;
    }

    @Override
    public org.bukkit.inventory.ItemStack createExplorerMap(World world, Location location, StructureType structureType) {
        return this.createExplorerMap(world, location, structureType, 100, true);
    }

    @Override
    public org.bukkit.inventory.ItemStack createExplorerMap(World world, Location location, StructureType structureType, int radius, boolean findUnexplored) {
        Validate.notNull((Object)world, (String)"World cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)structureType, (String)"StructureType cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)structureType.getMapIcon()), (String)("Cannot create explorer maps for StructureType " + structureType.getName()), (Object[])new Object[0]);
        ServerLevel worldServer = ((CraftWorld)world).getHandle();
        Location structureLocation = world.locateNearestStructure(location, structureType, radius, findUnexplored);
        BlockPos structurePosition = new BlockPos(structureLocation.getBlockX(), structureLocation.getBlockY(), structureLocation.getBlockZ());
        ItemStack stack = MapItem.m_42886_((net.minecraft.world.level.Level)worldServer, (int)structurePosition.m_123341_(), (int)structurePosition.m_123343_(), (byte)MapView.Scale.NORMAL.getValue(), (boolean)true, (boolean)true);
        MapItem.m_42850_((ServerLevel)worldServer, (ItemStack)stack);
        MapItem.m_42853_((ItemStack)stack, (net.minecraft.world.level.Level)worldServer);
        MapItemSavedData.m_77925_((ItemStack)stack, (BlockPos)structurePosition, (String)"+", (MapDecoration.Type)MapDecoration.Type.m_77854_((byte)structureType.getMapIcon().getValue()));
        return CraftItemStack.asBukkitCopy(stack);
    }

    @Override
    public void shutdown() {
        this.console.m_7570_(false);
    }

    @Override
    public int broadcast(String message, String permission) {
        HashSet<CommandSender> recipients = new HashSet<CommandSender>();
        for (Permissible permissible : this.getPluginManager().getPermissionSubscriptions(permission)) {
            if (!(permissible instanceof CommandSender) || !permissible.hasPermission(permission)) continue;
            recipients.add((CommandSender)permissible);
        }
        BroadcastMessageEvent broadcastMessageEvent = new BroadcastMessageEvent(!Bukkit.isPrimaryThread(), message, recipients);
        this.getPluginManager().callEvent(broadcastMessageEvent);
        if (broadcastMessageEvent.isCancelled()) {
            return 0;
        }
        message = broadcastMessageEvent.getMessage();
        for (CommandSender recipient : recipients) {
            recipient.sendMessage(message);
        }
        return recipients.size();
    }

    @Override
    @Deprecated
    public OfflinePlayer getOfflinePlayer(String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)name, (String)"Name cannot be empty", (Object[])new Object[0]);
        OfflinePlayer result = this.getPlayerExact(name);
        if (result == null) {
            GameProfile profile = this.console.m_129927_().m_10996_(name).orElse(null);
            result = profile == null ? this.getOfflinePlayer(new GameProfile(UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(Charsets.UTF_8)), name)) : this.getOfflinePlayer(profile);
        } else {
            this.offlinePlayers.remove(result.getUniqueId());
        }
        return result;
    }

    @Override
    public OfflinePlayer getOfflinePlayer(UUID id) {
        Validate.notNull((Object)id, (String)"UUID cannot be null", (Object[])new Object[0]);
        OfflinePlayer result = this.getPlayer(id);
        if (result == null) {
            result = this.offlinePlayers.get(id);
            if (result == null) {
                result = new CraftOfflinePlayer(this, new GameProfile(id, null));
                this.offlinePlayers.put(id, result);
            }
        } else {
            this.offlinePlayers.remove(id);
        }
        return result;
    }

    @Override
    public PlayerProfile createPlayerProfile(UUID uniqueId, String name) {
        return new CraftPlayerProfile(uniqueId, name);
    }

    @Override
    public PlayerProfile createPlayerProfile(UUID uniqueId) {
        return new CraftPlayerProfile(uniqueId, null);
    }

    @Override
    public PlayerProfile createPlayerProfile(String name) {
        return new CraftPlayerProfile(null, name);
    }

    public OfflinePlayer getOfflinePlayer(GameProfile profile) {
        CraftOfflinePlayer player = new CraftOfflinePlayer(this, profile);
        this.offlinePlayers.put(profile.getId(), player);
        return player;
    }

    @Override
    public Set<String> getIPBans() {
        return this.playerList.m_11299_().m_11395_().stream().map(StoredUserEntry::m_11373_).collect(Collectors.toSet());
    }

    @Override
    public void banIP(String address) {
        Validate.notNull((Object)address, (String)"Address cannot be null.", (Object[])new Object[0]);
        this.getBanList(BanList.Type.IP).addBan(address, null, null, null);
    }

    @Override
    public void unbanIP(String address) {
        Validate.notNull((Object)address, (String)"Address cannot be null.", (Object[])new Object[0]);
        this.getBanList(BanList.Type.IP).pardon(address);
    }

    @Override
    public Set<OfflinePlayer> getBannedPlayers() {
        HashSet<OfflinePlayer> result = new HashSet<OfflinePlayer>();
        for (UserBanListEntry entry : this.playerList.m_11295_().m_11395_()) {
            result.add(this.getOfflinePlayer((GameProfile)entry.m_11373_()));
        }
        return result;
    }

    @Override
    public BanList getBanList(BanList.Type type) {
        Validate.notNull((Object)((Object)type), (String)"Type cannot be null", (Object[])new Object[0]);
        switch (type) {
            case IP: {
                return new CraftIpBanList(this.playerList.m_11299_());
            }
        }
        return new CraftProfileBanList(this.playerList.m_11295_());
    }

    @Override
    public void setWhitelist(boolean value) {
        this.playerList.m_6628_(value);
        this.console.m_139688_(value);
    }

    @Override
    public boolean isWhitelistEnforced() {
        return this.console.m_129902_();
    }

    @Override
    public void setWhitelistEnforced(boolean value) {
        this.console.m_130004_(value);
    }

    @Override
    public Set<OfflinePlayer> getWhitelistedPlayers() {
        LinkedHashSet<OfflinePlayer> result = new LinkedHashSet<OfflinePlayer>();
        for (UserWhiteListEntry entry : this.playerList.m_11305_().m_11395_()) {
            result.add(this.getOfflinePlayer((GameProfile)entry.m_11373_()));
        }
        return result;
    }

    @Override
    public Set<OfflinePlayer> getOperators() {
        HashSet<OfflinePlayer> result = new HashSet<OfflinePlayer>();
        for (ServerOpListEntry entry : this.playerList.m_11307_().m_11395_()) {
            result.add(this.getOfflinePlayer((GameProfile)entry.m_11373_()));
        }
        return result;
    }

    @Override
    public void reloadWhitelist() {
        this.playerList.m_7542_();
    }

    @Override
    public GameMode getDefaultGameMode() {
        return GameMode.getByValue(this.console.m_129880_((ResourceKey)net.minecraft.world.level.Level.f_46428_).f_8549_.m_5464_().m_46392_());
    }

    @Override
    public void setDefaultGameMode(GameMode mode) {
        Validate.notNull((Object)((Object)mode), (String)"Mode cannot be null", (Object[])new Object[0]);
        for (World world : this.getWorlds()) {
            ((CraftWorld)world).getHandle().f_8549_.m_5458_(GameType.m_46393_((int)mode.getValue()));
        }
    }

    @Override
    public ConsoleCommandSender getConsoleSender() {
        return this.console.console;
    }

    public EntityMetadataStore getEntityMetadata() {
        return this.entityMetadata;
    }

    public PlayerMetadataStore getPlayerMetadata() {
        return this.playerMetadata;
    }

    public WorldMetadataStore getWorldMetadata() {
        return this.worldMetadata;
    }

    @Override
    public File getWorldContainer() {
        return this.getServer().f_129744_.m_197394_(net.minecraft.world.level.Level.f_46428_).getParent().toFile();
    }

    @Override
    public OfflinePlayer[] getOfflinePlayers() {
        PlayerDataStorage storage = this.console.f_129745_;
        String[] files = storage.getPlayerDataFolder().list(new DatFileFilter());
        HashSet<OfflinePlayer> players = new HashSet<OfflinePlayer>();
        for (String file : files) {
            try {
                players.add(this.getOfflinePlayer(UUID.fromString(file.substring(0, file.length() - 4))));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        players.addAll(this.getOnlinePlayers());
        return players.toArray(new OfflinePlayer[players.size()]);
    }

    @Override
    public Messenger getMessenger() {
        return this.messenger;
    }

    @Override
    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage(this.getMessenger(), source, channel, message);
        for (org.bukkit.entity.Player player : this.getOnlinePlayers()) {
            player.sendPluginMessage(source, channel, message);
        }
    }

    @Override
    public Set<String> getListeningPluginChannels() {
        HashSet<String> result = new HashSet<String>();
        for (org.bukkit.entity.Player player : this.getOnlinePlayers()) {
            result.addAll(player.getListeningPluginChannels());
        }
        return result;
    }

    @Override
    public Inventory createInventory(InventoryHolder owner, InventoryType type) {
        Validate.isTrue((boolean)type.isCreatable(), (String)"Cannot open an inventory of type ", (Object[])new Object[]{type});
        return CraftInventoryCreator.INSTANCE.createInventory(owner, type);
    }

    @Override
    public Inventory createInventory(InventoryHolder owner, InventoryType type, String title) {
        Validate.isTrue((boolean)type.isCreatable(), (String)"Cannot open an inventory of type ", (Object[])new Object[]{type});
        return CraftInventoryCreator.INSTANCE.createInventory(owner, type, title);
    }

    @Override
    public Inventory createInventory(InventoryHolder owner, int size) throws IllegalArgumentException {
        Validate.isTrue((9 <= size && size <= 54 && size % 9 == 0 ? 1 : 0) != 0, (String)("Size for custom inventory must be a multiple of 9 between 9 and 54 slots (got " + size + ")"), (Object[])new Object[0]);
        return CraftInventoryCreator.INSTANCE.createInventory(owner, size);
    }

    @Override
    public Inventory createInventory(InventoryHolder owner, int size, String title) throws IllegalArgumentException {
        Validate.isTrue((9 <= size && size <= 54 && size % 9 == 0 ? 1 : 0) != 0, (String)("Size for custom inventory must be a multiple of 9 between 9 and 54 slots (got " + size + ")"), (Object[])new Object[0]);
        return CraftInventoryCreator.INSTANCE.createInventory(owner, size, title);
    }

    @Override
    public Merchant createMerchant(String title) {
        return new CraftMerchantCustom(title == null ? InventoryType.MERCHANT.getDefaultTitle() : title);
    }

    @Override
    public HelpMap getHelpMap() {
        return this.helpMap;
    }

    public SimpleCommandMap getCommandMap() {
        return this.commandMap;
    }

    @Override
    @Deprecated
    public int getMonsterSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.MONSTER);
    }

    @Override
    @Deprecated
    public int getAnimalSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.ANIMAL);
    }

    @Override
    @Deprecated
    public int getWaterAnimalSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_ANIMAL);
    }

    @Override
    @Deprecated
    public int getWaterAmbientSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_AMBIENT);
    }

    @Override
    @Deprecated
    public int getWaterUndergroundCreatureSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_UNDERGROUND_CREATURE);
    }

    @Override
    @Deprecated
    public int getAmbientSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.AMBIENT);
    }

    @Override
    public int getSpawnLimit(SpawnCategory spawnCategory) {
        return this.spawnCategoryLimit.getOrDefault((Object)spawnCategory, -1);
    }

    @Override
    @Deprecated
    public boolean isPrimaryThread() {
        return Thread.currentThread().equals(this.console.f_129725_);
    }

    @Override
    public String getMotd() {
        return this.console.m_129916_();
    }

    @Override
    public Warning.WarningState getWarningState() {
        return this.warningState;
    }

    public List<String> tabComplete(CommandSender sender, String message, ServerLevel world, Vec3 pos, boolean forceCommand) {
        if (!(sender instanceof org.bukkit.entity.Player)) {
            return ImmutableList.of();
        }
        org.bukkit.entity.Player player = (org.bukkit.entity.Player)sender;
        List<String> offers = message.startsWith("/") || forceCommand ? this.tabCompleteCommand(player, message, world, pos) : this.tabCompleteChat(player, message);
        TabCompleteEvent tabEvent = new TabCompleteEvent(player, message, offers);
        this.getPluginManager().callEvent(tabEvent);
        return tabEvent.isCancelled() ? Collections.EMPTY_LIST : tabEvent.getCompletions();
    }

    public List<String> tabCompleteCommand(org.bukkit.entity.Player player, String message, ServerLevel world, Vec3 pos) {
        List<String> completions = null;
        try {
            if (message.startsWith("/")) {
                message = message.substring(1);
            }
            completions = pos == null ? this.getCommandMap().tabComplete(player, message) : this.getCommandMap().tabComplete(player, message, new Location(world.getWorld(), pos.f_82479_, pos.f_82480_, pos.f_82481_));
        }
        catch (CommandException ex) {
            player.sendMessage(ChatColor.RED + "An internal error occurred while attempting to tab-complete this command");
            this.getLogger().log(Level.SEVERE, "Exception when " + player.getName() + " attempted to tab complete " + message, ex);
        }
        return completions == null ? ImmutableList.of() : completions;
    }

    public List<String> tabCompleteChat(org.bukkit.entity.Player player, String message) {
        ArrayList<String> completions = new ArrayList<String>();
        PlayerChatTabCompleteEvent event = new PlayerChatTabCompleteEvent(player, message, completions);
        String token = event.getLastToken();
        for (org.bukkit.entity.Player p : this.getOnlinePlayers()) {
            if (!player.canSee(p) || !StringUtil.startsWithIgnoreCase(p.getName(), token)) continue;
            completions.add(p.getName());
        }
        this.pluginManager.callEvent(event);
        Iterator it = completions.iterator();
        while (it.hasNext()) {
            Object current = it.next();
            if (current instanceof String) continue;
            it.remove();
        }
        Collections.sort(completions, String.CASE_INSENSITIVE_ORDER);
        return completions;
    }

    @Override
    public CraftItemFactory getItemFactory() {
        return CraftItemFactory.instance();
    }

    @Override
    public CraftScoreboardManager getScoreboardManager() {
        return this.scoreboardManager;
    }

    public void checkSaveState() {
        if (this.playerCommandState || this.printSaveWarning || this.console.autosavePeriod <= 0) {
            return;
        }
        this.printSaveWarning = true;
        this.getLogger().log(Level.WARNING, "A manual (plugin-induced) save has been detected while server is configured to auto-save. This may affect performance.", this.warningState == Warning.WarningState.ON ? new Throwable() : null);
    }

    @Override
    public CraftIconCache getServerIcon() {
        return this.icon;
    }

    @Override
    public CraftIconCache loadServerIcon(File file) throws Exception {
        Validate.notNull((Object)file, (String)"File cannot be null", (Object[])new Object[0]);
        if (!file.isFile()) {
            throw new IllegalArgumentException(file + " is not a file");
        }
        return CraftServer.loadServerIcon0(file);
    }

    static CraftIconCache loadServerIcon0(File file) throws Exception {
        return CraftServer.loadServerIcon0(ImageIO.read(file));
    }

    @Override
    public CraftIconCache loadServerIcon(BufferedImage image) throws Exception {
        Validate.notNull((Object)image, (String)"Image cannot be null", (Object[])new Object[0]);
        return CraftServer.loadServerIcon0(image);
    }

    static CraftIconCache loadServerIcon0(BufferedImage image) throws Exception {
        ByteBuf bytebuf = Unpooled.buffer();
        Validate.isTrue((image.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
        Validate.isTrue((image.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
        ImageIO.write((RenderedImage)image, "PNG", (OutputStream)new ByteBufOutputStream(bytebuf));
        ByteBuffer bytebuffer = Base64.getEncoder().encode(bytebuf.nioBuffer());
        return new CraftIconCache("data:image/png;base64," + StandardCharsets.UTF_8.decode(bytebuffer));
    }

    @Override
    public void setIdleTimeout(int threshold) {
        this.console.m_7196_(threshold);
    }

    @Override
    public int getIdleTimeout() {
        return this.console.m_129924_();
    }

    @Override
    public ChunkGenerator.ChunkData createChunkData(World world) {
        Validate.notNull((Object)world, (String)"World cannot be null", (Object[])new Object[0]);
        ServerLevel handle = ((CraftWorld)world).getHandle();
        return new OldCraftChunkData(world.getMinHeight(), world.getMaxHeight(), (Registry<Biome>)handle.m_5962_().m_175515_(Registry.f_122885_));
    }

    @Override
    public BossBar createBossBar(String title, BarColor color, BarStyle style, BarFlag ... flags) {
        return new CraftBossBar(title, color, style, flags);
    }

    @Override
    public KeyedBossBar createBossBar(NamespacedKey key, String title, BarColor barColor, BarStyle barStyle, BarFlag ... barFlags) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key");
        CustomBossEvent bossBattleCustom = this.getServer().m_129901_().m_136299_(CraftNamespacedKey.toMinecraft(key), CraftChatMessage.fromString(title, true)[0]);
        CraftKeyedBossbar craftKeyedBossbar = new CraftKeyedBossbar(bossBattleCustom);
        craftKeyedBossbar.setColor(barColor);
        craftKeyedBossbar.setStyle(barStyle);
        for (BarFlag flag : barFlags) {
            craftKeyedBossbar.addFlag(flag);
        }
        return craftKeyedBossbar;
    }

    @Override
    public Iterator<KeyedBossBar> getBossBars() {
        return Iterators.unmodifiableIterator((Iterator)Iterators.transform(this.getServer().m_129901_().m_136304_().iterator(), (Function)new Function<CustomBossEvent, KeyedBossBar>(){

            public KeyedBossBar apply(CustomBossEvent bossBattleCustom) {
                return bossBattleCustom.getBukkitEntity();
            }
        }));
    }

    @Override
    public KeyedBossBar getBossBar(NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key");
        CustomBossEvent bossBattleCustom = this.getServer().m_129901_().m_136297_(CraftNamespacedKey.toMinecraft(key));
        return bossBattleCustom == null ? null : bossBattleCustom.getBukkitEntity();
    }

    @Override
    public boolean removeBossBar(NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key");
        CustomBossEvents bossBattleCustomData = this.getServer().m_129901_();
        CustomBossEvent bossBattleCustom = bossBattleCustomData.m_136297_(CraftNamespacedKey.toMinecraft(key));
        if (bossBattleCustom != null) {
            bossBattleCustomData.m_136302_(bossBattleCustom);
            return true;
        }
        return false;
    }

    @Override
    public Entity getEntity(UUID uuid) {
        Validate.notNull((Object)uuid, (String)"UUID cannot be null", (Object[])new Object[0]);
        for (ServerLevel world : this.getServer().m_129785_()) {
            net.minecraft.world.entity.Entity entity = world.m_8791_(uuid);
            if (entity == null) continue;
            return entity.getBukkitEntity();
        }
        return null;
    }

    @Override
    public org.bukkit.advancement.Advancement getAdvancement(NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key");
        Advancement advancement = this.console.m_129889_().m_136041_(CraftNamespacedKey.toMinecraft(key));
        return advancement == null ? null : advancement.bukkit;
    }

    @Override
    public Iterator<org.bukkit.advancement.Advancement> advancementIterator() {
        return Iterators.unmodifiableIterator((Iterator)Iterators.transform(this.console.m_129889_().m_136028_().iterator(), (Function)new Function<Advancement, org.bukkit.advancement.Advancement>(){

            public org.bukkit.advancement.Advancement apply(Advancement advancement) {
                return advancement.bukkit;
            }
        }));
    }

    @Override
    public BlockData createBlockData(Material material) {
        Validate.isTrue((material != null ? 1 : 0) != 0, (String)"Must provide material", (Object[])new Object[0]);
        return this.createBlockData(material, (String)null);
    }

    @Override
    public BlockData createBlockData(Material material, Consumer<BlockData> consumer) {
        BlockData data = this.createBlockData(material);
        if (consumer != null) {
            consumer.accept(data);
        }
        return data;
    }

    @Override
    public BlockData createBlockData(String data) throws IllegalArgumentException {
        Validate.isTrue((data != null ? 1 : 0) != 0, (String)"Must provide data", (Object[])new Object[0]);
        return this.createBlockData(null, data);
    }

    @Override
    public BlockData createBlockData(Material material, String data) {
        Validate.isTrue((material != null || data != null ? 1 : 0) != 0, (String)"Must provide one of material or data", (Object[])new Object[0]);
        return CraftBlockData.newData(material, data);
    }

    @Override
    public <T extends Keyed> Tag<T> getTag(String registry, NamespacedKey tag, Class<T> clazz) {
        Validate.notNull((Object)registry, (String)"registry cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)tag, (String)"NamespacedKey cannot be null", (Object[])new Object[0]);
        Validate.notNull(clazz, (String)"Class cannot be null", (Object[])new Object[0]);
        ResourceLocation key = CraftNamespacedKey.toMinecraft(tag);
        switch (registry) {
            case "blocks": {
                Preconditions.checkArgument((clazz == Material.class ? 1 : 0) != 0, (Object)"Block namespace must have material type");
                TagKey blockTagKey = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)key);
                if (!Registry.f_122824_.m_203658_(blockTagKey)) break;
                return new CraftBlockTag((Registry<Block>)Registry.f_122824_, (TagKey<Block>)blockTagKey);
            }
            case "items": {
                Preconditions.checkArgument((clazz == Material.class ? 1 : 0) != 0, (Object)"Item namespace must have material type");
                TagKey itemTagKey = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)key);
                if (!Registry.f_122827_.m_203658_(itemTagKey)) break;
                return new CraftItemTag((Registry<Item>)Registry.f_122827_, (TagKey<Item>)itemTagKey);
            }
            case "fluids": {
                Preconditions.checkArgument((clazz == Fluid.class ? 1 : 0) != 0, (Object)"Fluid namespace must have fluid type");
                TagKey fluidTagKey = TagKey.m_203882_((ResourceKey)Registry.f_122899_, (ResourceLocation)key);
                if (!Registry.f_122822_.m_203658_(fluidTagKey)) break;
                return new CraftFluidTag((Registry<net.minecraft.world.level.material.Fluid>)Registry.f_122822_, (TagKey<net.minecraft.world.level.material.Fluid>)fluidTagKey);
            }
            case "entity_types": {
                Preconditions.checkArgument((clazz == org.bukkit.entity.EntityType.class ? 1 : 0) != 0, (Object)"Entity type namespace must have entity type");
                TagKey entityTagKey = TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)key);
                if (!Registry.f_122826_.m_203658_(entityTagKey)) break;
                return new CraftEntityTag((Registry<EntityType<?>>)Registry.f_122826_, (TagKey<EntityType<?>>)entityTagKey);
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return null;
    }

    @Override
    public <T extends Keyed> Iterable<Tag<T>> getTags(String registry, Class<T> clazz) {
        Validate.notNull((Object)registry, (String)"registry cannot be null", (Object[])new Object[0]);
        Validate.notNull(clazz, (String)"Class cannot be null", (Object[])new Object[0]);
        switch (registry) {
            case "blocks": {
                Preconditions.checkArgument((clazz == Material.class ? 1 : 0) != 0, (Object)"Block namespace must have material type");
                DefaultedRegistry blockTags = Registry.f_122824_;
                return (Iterable)blockTags.m_203612_().map(arg_0 -> CraftServer.lambda$getTags$1((Registry)blockTags, arg_0)).collect(ImmutableList.toImmutableList());
            }
            case "items": {
                Preconditions.checkArgument((clazz == Material.class ? 1 : 0) != 0, (Object)"Item namespace must have material type");
                DefaultedRegistry itemTags = Registry.f_122827_;
                return (Iterable)itemTags.m_203612_().map(arg_0 -> CraftServer.lambda$getTags$2((Registry)itemTags, arg_0)).collect(ImmutableList.toImmutableList());
            }
            case "fluids": {
                Preconditions.checkArgument((clazz == Material.class ? 1 : 0) != 0, (Object)"Fluid namespace must have fluid type");
                DefaultedRegistry fluidTags = Registry.f_122822_;
                return (Iterable)fluidTags.m_203612_().map(arg_0 -> CraftServer.lambda$getTags$3((Registry)fluidTags, arg_0)).collect(ImmutableList.toImmutableList());
            }
            case "entity_types": {
                Preconditions.checkArgument((clazz == org.bukkit.entity.EntityType.class ? 1 : 0) != 0, (Object)"Entity type namespace must have entity type");
                DefaultedRegistry entityTags = Registry.f_122826_;
                return (Iterable)entityTags.m_203612_().map(arg_0 -> CraftServer.lambda$getTags$4((Registry)entityTags, arg_0)).collect(ImmutableList.toImmutableList());
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public LootTable getLootTable(NamespacedKey key) {
        Validate.notNull((Object)key, (String)"NamespacedKey cannot be null", (Object[])new Object[0]);
        LootTables registry = this.getServer().m_129898_();
        return new CraftLootTable(key, registry.m_79217_(CraftNamespacedKey.toMinecraft(key)));
    }

    @Override
    public List<Entity> selectEntities(CommandSender sender, String selector) {
        List nms;
        Preconditions.checkArgument((selector != null ? 1 : 0) != 0, (Object)"Selector cannot be null");
        Preconditions.checkArgument((sender != null ? 1 : 0) != 0, (Object)"Sender cannot be null");
        EntityArgument arg = EntityArgument.m_91460_();
        try {
            StringReader reader = new StringReader(selector);
            nms = arg.parse(reader, true).m_121160_(VanillaCommandWrapper.getListener(sender));
            Preconditions.checkArgument((!reader.canRead() ? 1 : 0) != 0, (Object)("Spurious trailing data in selector: " + selector));
        }
        catch (CommandSyntaxException ex) {
            throw new IllegalArgumentException("Could not parse selector: " + selector, ex);
        }
        return new ArrayList<Entity>(Lists.transform((List)nms, entity -> entity.getBukkitEntity()));
    }

    @Override
    public StructureManager getStructureManager() {
        return this.structureManager;
    }

    @Override
    @Deprecated
    public UnsafeValues getUnsafe() {
        return CraftMagicNumbers.INSTANCE;
    }

    @Override
    public Server.Spigot spigot() {
        return this.spigot;
    }

    private static /* synthetic */ Tag lambda$getTags$4(Registry entityTags, Pair pair) {
        return new CraftEntityTag((Registry<EntityType<?>>)entityTags, (TagKey<EntityType<?>>)((TagKey)pair.getFirst()));
    }

    private static /* synthetic */ Tag lambda$getTags$3(Registry fluidTags, Pair pair) {
        return new CraftFluidTag((Registry<net.minecraft.world.level.material.Fluid>)fluidTags, (TagKey<net.minecraft.world.level.material.Fluid>)((TagKey)pair.getFirst()));
    }

    private static /* synthetic */ Tag lambda$getTags$2(Registry itemTags, Pair pair) {
        return new CraftItemTag((Registry<Item>)itemTags, (TagKey<Item>)((TagKey)pair.getFirst()));
    }

    private static /* synthetic */ Tag lambda$getTags$1(Registry blockTags, Pair pair) {
        return new CraftBlockTag((Registry<Block>)blockTags, (TagKey<Block>)((TagKey)pair.getFirst()));
    }

    static {
        ConfigurationSerialization.registerClass(CraftOfflinePlayer.class);
        ConfigurationSerialization.registerClass(CraftPlayerProfile.class);
        CraftItemFactory.instance();
    }
}

