/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2;

import com.google.common.base.Preconditions;
import net.minecraft.core.BlockPos;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;

public class CraftWorldBorder
implements WorldBorder {
    private final World world;
    private final net.minecraft.world.level.border.WorldBorder handle;

    public CraftWorldBorder(CraftWorld world) {
        this.world = world;
        this.handle = world.getHandle().m_6857_();
    }

    public CraftWorldBorder(net.minecraft.world.level.border.WorldBorder handle) {
        this.world = null;
        this.handle = handle;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public void reset() {
        this.setSize(6.0E7);
        this.setDamageAmount(0.2);
        this.setDamageBuffer(5.0);
        this.setWarningDistance(5);
        this.setWarningTime(15);
        this.setCenter(0.0, 0.0);
    }

    @Override
    public double getSize() {
        return this.handle.m_61959_();
    }

    @Override
    public void setSize(double newSize) {
        this.setSize(newSize, 0L);
    }

    @Override
    public void setSize(double newSize, long time) {
        newSize = Math.min(6.0E7, Math.max(1.0, newSize));
        if ((time = Math.min(9223372036854775L, Math.max(0L, time))) > 0L) {
            this.handle.m_61919_(this.handle.m_61959_(), newSize, time * 1000L);
        } else {
            this.handle.m_61917_(newSize);
        }
    }

    @Override
    public Location getCenter() {
        double x = this.handle.m_6347_();
        double z = this.handle.m_6345_();
        return new Location(this.world, x, 0.0, z);
    }

    @Override
    public void setCenter(double x, double z) {
        x = Math.min(3.0E7, Math.max(-3.0E7, x));
        z = Math.min(3.0E7, Math.max(-3.0E7, z));
        this.handle.m_61949_(x, z);
    }

    @Override
    public void setCenter(Location location) {
        this.setCenter(location.getX(), location.getZ());
    }

    @Override
    public double getDamageBuffer() {
        return this.handle.m_61964_();
    }

    @Override
    public void setDamageBuffer(double blocks) {
        this.handle.m_61939_(blocks);
    }

    @Override
    public double getDamageAmount() {
        return this.handle.m_61965_();
    }

    @Override
    public void setDamageAmount(double damage) {
        this.handle.m_61947_(damage);
    }

    @Override
    public int getWarningTime() {
        return this.handle.m_61967_();
    }

    @Override
    public void setWarningTime(int time) {
        this.handle.m_61944_(time);
    }

    @Override
    public int getWarningDistance() {
        return this.handle.m_61968_();
    }

    @Override
    public void setWarningDistance(int distance) {
        this.handle.m_61952_(distance);
    }

    @Override
    public boolean isInside(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location");
        return (this.world == null || location.getWorld().equals(this.world)) && this.handle.m_61937_(new BlockPos(location.getX(), location.getY(), location.getZ()));
    }

    public net.minecraft.world.level.border.WorldBorder getHandle() {
        return this.handle;
    }

    public boolean isVirtual() {
        return this.world == null;
    }
}

