/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.block;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import org.bukkit.World;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlockEntityState;

public class CraftCreatureSpawner
extends CraftBlockEntityState<SpawnerBlockEntity>
implements CreatureSpawner {
    public CraftCreatureSpawner(World world, SpawnerBlockEntity te) {
        super(world, te);
    }

    @Override
    public org.bukkit.entity.EntityType getSpawnedType() {
        Optional type = EntityType.m_20637_((CompoundTag)((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45444_.m_186567_());
        return type.isEmpty() ? org.bukkit.entity.EntityType.PIG : org.bukkit.entity.EntityType.fromName(EntityType.m_20613_((EntityType)((EntityType)type.get())).m_135815_());
    }

    @Override
    public void setSpawnedType(org.bukkit.entity.EntityType entityType) {
        if (entityType == null || entityType.getName() == null) {
            throw new IllegalArgumentException("Can't spawn EntityType " + entityType + " from mobspawners!");
        }
        ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().m_45462_((EntityType)EntityType.m_20632_((String)entityType.getName()).get());
    }

    @Override
    public String getCreatureTypeName() {
        Optional type = EntityType.m_20637_((CompoundTag)((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45444_.m_186567_());
        return type.isEmpty() ? "" : EntityType.m_20613_((EntityType)((EntityType)type.get())).m_135815_();
    }

    @Override
    public void setCreatureTypeByName(String creatureType) {
        org.bukkit.entity.EntityType type = org.bukkit.entity.EntityType.fromName(creatureType);
        if (type == null) {
            return;
        }
        this.setSpawnedType(type);
    }

    @Override
    public int getDelay() {
        return ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45442_;
    }

    @Override
    public void setDelay(int delay) {
        ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45442_ = delay;
    }

    @Override
    public int getMinSpawnDelay() {
        return ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45447_;
    }

    @Override
    public void setMinSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay <= this.getMaxSpawnDelay() ? 1 : 0) != 0, (Object)"Minimum Spawn Delay must be less than or equal to Maximum Spawn Delay");
        ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45447_ = spawnDelay;
    }

    @Override
    public int getMaxSpawnDelay() {
        return ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45448_;
    }

    @Override
    public void setMaxSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay > 0 ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than 0.");
        Preconditions.checkArgument((spawnDelay >= this.getMinSpawnDelay() ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than or equal to Minimum Spawn Delay");
        ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45448_ = spawnDelay;
    }

    @Override
    public int getMaxNearbyEntities() {
        return ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45451_;
    }

    @Override
    public void setMaxNearbyEntities(int maxNearbyEntities) {
        ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45451_ = maxNearbyEntities;
    }

    @Override
    public int getSpawnCount() {
        return ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45449_;
    }

    @Override
    public void setSpawnCount(int count) {
        ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45449_ = count;
    }

    @Override
    public int getRequiredPlayerRange() {
        return ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45452_;
    }

    @Override
    public void setRequiredPlayerRange(int requiredPlayerRange) {
        ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45452_ = requiredPlayerRange;
    }

    @Override
    public int getSpawnRange() {
        return ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45453_;
    }

    @Override
    public void setSpawnRange(int spawnRange) {
        ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45453_ = spawnRange;
    }
}

