/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.Util;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundChatPacket;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.ClientboundCustomSoundPacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.network.protocol.game.ClientboundSetHealthPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundSoundEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.network.protocol.game.ClientboundTabListPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.UserWhiteListEntry;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Effect;
import org.bukkit.GameMode;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Note;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Statistic;
import org.bukkit.WeatherType;
import org.bukkit.WorldBorder;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ManuallyAbandonedConversationCanceller;
import org.bukkit.craftbukkit.v1_18_R2.CraftEffect;
import org.bukkit.craftbukkit.v1_18_R2.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_18_R2.CraftOfflinePlayer;
import org.bukkit.craftbukkit.v1_18_R2.CraftParticle;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.CraftSound;
import org.bukkit.craftbukkit.v1_18_R2.CraftStatistic;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_18_R2.advancement.CraftAdvancement;
import org.bukkit.craftbukkit.v1_18_R2.advancement.CraftAdvancementProgress;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftSign;
import org.bukkit.craftbukkit.v1_18_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_18_R2.conversations.ConversationTracker;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R2.map.CraftMapView;
import org.bukkit.craftbukkit.v1_18_R2.map.RenderData;
import org.bukkit.craftbukkit.v1_18_R2.profile.CraftPlayerProfile;
import org.bukkit.craftbukkit.v1_18_R2.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerHideEntityEvent;
import org.bukkit.event.player.PlayerRegisterChannelEvent;
import org.bukkit.event.player.PlayerShowEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerUnregisterChannelEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapView;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.scoreboard.Scoreboard;

@DelegateDeserialization(value=CraftOfflinePlayer.class)
public class CraftPlayer
extends CraftHumanEntity
implements org.bukkit.entity.Player {
    private long firstPlayed = 0L;
    private long lastPlayed = 0L;
    private boolean hasPlayedBefore = false;
    private final ConversationTracker conversationTracker = new ConversationTracker();
    private final Set<String> channels = new HashSet<String>();
    private final Map<UUID, Set<WeakReference<Plugin>>> hiddenEntities = new HashMap<UUID, Set<WeakReference<Plugin>>>();
    private static final WeakHashMap<Plugin, WeakReference<Plugin>> pluginWeakReferences = new WeakHashMap();
    private int hash = 0;
    private double health = 20.0;
    private boolean scaledHealth = false;
    private double healthScale = 20.0;
    private CraftWorldBorder clientWorldBorder = null;
    private BorderChangeListener clientWorldBorderListener = this.createWorldBorderListener();
    private Component playerListHeader;
    private Component playerListFooter;
    private final Player.Spigot spigot = new Player.Spigot(){

        @Override
        public InetSocketAddress getRawAddress() {
            return (InetSocketAddress)CraftPlayer.this.getHandle().f_8906_.f_9742_.getRawAddress();
        }

        @Override
        public boolean getCollidesWithEntities() {
            return CraftPlayer.this.isCollidable();
        }

        @Override
        public void setCollidesWithEntities(boolean collides) {
            CraftPlayer.this.setCollidable(collides);
        }

        @Override
        public void respawn() {
            if (CraftPlayer.this.getHealth() <= 0.0 && CraftPlayer.this.isOnline()) {
                CraftPlayer.this.server.getServer().m_6846_().m_11236_(CraftPlayer.this.getHandle(), false);
            }
        }

        @Override
        public Set<org.bukkit.entity.Player> getHiddenPlayers() {
            HashSet<org.bukkit.entity.Player> ret = new HashSet<org.bukkit.entity.Player>();
            for (UUID u : CraftPlayer.this.hiddenEntities.keySet()) {
                org.bukkit.entity.Player p = CraftPlayer.this.getServer().getPlayer(u);
                if (p == null) continue;
                ret.add(p);
            }
            return Collections.unmodifiableSet(ret);
        }

        @Override
        public void sendMessage(BaseComponent component) {
            this.sendMessage(new BaseComponent[]{component});
        }

        @Override
        public void sendMessage(BaseComponent ... components) {
            if (CraftPlayer.this.getHandle().f_8906_ == null) {
                return;
            }
            ClientboundChatPacket packet = new ClientboundChatPacket(null, ChatType.SYSTEM, Util.f_137441_);
            packet.components = components;
            CraftPlayer.this.getHandle().f_8906_.m_141995_((Packet)packet);
        }

        @Override
        public void sendMessage(UUID sender, BaseComponent component) {
            this.sendMessage(ChatMessageType.CHAT, sender, component);
        }

        @Override
        public void sendMessage(UUID sender, BaseComponent ... components) {
            this.sendMessage(ChatMessageType.CHAT, sender, components);
        }

        @Override
        public void sendMessage(ChatMessageType position, BaseComponent component) {
            this.sendMessage(position, new BaseComponent[]{component});
        }

        @Override
        public void sendMessage(ChatMessageType position, BaseComponent ... components) {
            if (CraftPlayer.this.getHandle().f_8906_ == null) {
                return;
            }
            ClientboundChatPacket packet = new ClientboundChatPacket(null, ChatType.m_130611_((byte)((byte)position.ordinal())), Util.f_137441_);
            packet.components = components;
            CraftPlayer.this.getHandle().f_8906_.m_141995_((Packet)packet);
        }

        @Override
        public void sendMessage(ChatMessageType position, UUID sender, BaseComponent component) {
            this.sendMessage(position, sender, new BaseComponent[]{component});
        }

        @Override
        public void sendMessage(ChatMessageType position, UUID sender, BaseComponent ... components) {
            if (CraftPlayer.this.getHandle().f_8906_ == null) {
                return;
            }
            ClientboundChatPacket packet = new ClientboundChatPacket(null, ChatType.m_130611_((byte)((byte)position.ordinal())), sender == null ? Util.f_137441_ : sender);
            packet.components = components;
            CraftPlayer.this.getHandle().f_8906_.m_141995_((Packet)packet);
        }
    };

    public CraftPlayer(CraftServer server, ServerPlayer entity) {
        super(server, (Player)entity);
        this.firstPlayed = System.currentTimeMillis();
    }

    public GameProfile getProfile() {
        return this.getHandle().m_36316_();
    }

    @Override
    public boolean isOp() {
        return this.server.getHandle().m_11303_(this.getProfile());
    }

    @Override
    public void setOp(boolean value) {
        if (value == this.isOp()) {
            return;
        }
        if (value) {
            this.server.getHandle().m_5749_(this.getProfile());
        } else {
            this.server.getHandle().m_5750_(this.getProfile());
        }
        this.perm.recalculatePermissions();
    }

    @Override
    public boolean isOnline() {
        return this.server.getPlayer(this.getUniqueId()) != null;
    }

    @Override
    public PlayerProfile getPlayerProfile() {
        return new CraftPlayerProfile(this.getProfile());
    }

    @Override
    public InetSocketAddress getAddress() {
        if (this.getHandle().f_8906_ == null) {
            return null;
        }
        SocketAddress addr = this.getHandle().f_8906_.f_9742_.m_129523_();
        if (addr instanceof InetSocketAddress) {
            return (InetSocketAddress)addr;
        }
        return null;
    }

    @Override
    public double getEyeHeight(boolean ignorePose) {
        if (ignorePose) {
            return 1.62;
        }
        return this.getEyeHeight();
    }

    @Override
    public void sendRawMessage(String message) {
        if (this.getHandle().f_8906_ == null) {
            return;
        }
        for (Component component : CraftChatMessage.fromString(message)) {
            this.getHandle().f_8906_.m_141995_((Packet)new ClientboundChatPacket(component, ChatType.SYSTEM, Util.f_137441_));
        }
    }

    @Override
    public void sendRawMessage(UUID sender, String message) {
        if (this.getHandle().f_8906_ == null) {
            return;
        }
        for (Component component : CraftChatMessage.fromString(message)) {
            this.getHandle().f_8906_.m_141995_((Packet)new ClientboundChatPacket(component, ChatType.CHAT, sender == null ? Util.f_137441_ : sender));
        }
    }

    @Override
    public void sendMessage(String message) {
        if (!this.conversationTracker.isConversingModaly()) {
            this.sendRawMessage(message);
        }
    }

    @Override
    public void sendMessage(String[] messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    @Override
    public void sendMessage(UUID sender, String message) {
        if (!this.conversationTracker.isConversingModaly()) {
            this.sendRawMessage(sender, message);
        }
    }

    @Override
    public void sendMessage(UUID sender, String ... messages) {
        for (String message : messages) {
            this.sendMessage(sender, message);
        }
    }

    @Override
    public String getDisplayName() {
        return this.getHandle().displayName;
    }

    @Override
    public void setDisplayName(String name) {
        this.getHandle().displayName = name == null ? this.getName() : name;
    }

    @Override
    public String getPlayerListName() {
        return this.getHandle().m_8957_() == null ? this.getName() : CraftChatMessage.fromComponent(this.getHandle().m_8957_());
    }

    @Override
    public void setPlayerListName(String name) {
        if (name == null) {
            name = this.getName();
        }
        this.getHandle().setTabListDisplayName(name.equals(this.getName()) ? null : CraftChatMessage.fromStringOrNull(name));
        for (ServerPlayer player : this.server.getHandle().f_11196_) {
            if (!player.getBukkitEntity().canSee(this)) continue;
            player.f_8906_.m_141995_((Packet)new ClientboundPlayerInfoPacket(ClientboundPlayerInfoPacket.Action.UPDATE_DISPLAY_NAME, new ServerPlayer[]{this.getHandle()}));
        }
    }

    @Override
    public String getPlayerListHeader() {
        return this.playerListHeader == null ? null : CraftChatMessage.fromComponent(this.playerListHeader);
    }

    @Override
    public String getPlayerListFooter() {
        return this.playerListFooter == null ? null : CraftChatMessage.fromComponent(this.playerListFooter);
    }

    @Override
    public void setPlayerListHeader(String header) {
        this.playerListHeader = CraftChatMessage.fromStringOrNull(header, true);
        this.updatePlayerListHeaderFooter();
    }

    @Override
    public void setPlayerListFooter(String footer) {
        this.playerListFooter = CraftChatMessage.fromStringOrNull(footer, true);
        this.updatePlayerListHeaderFooter();
    }

    @Override
    public void setPlayerListHeaderFooter(String header, String footer) {
        this.playerListHeader = CraftChatMessage.fromStringOrNull(header, true);
        this.playerListFooter = CraftChatMessage.fromStringOrNull(footer, true);
        this.updatePlayerListHeaderFooter();
    }

    private void updatePlayerListHeaderFooter() {
        if (this.getHandle().f_8906_ == null) {
            return;
        }
        ClientboundTabListPacket packet = new ClientboundTabListPacket((Component)(this.playerListHeader == null ? new TextComponent("") : this.playerListHeader), (Component)(this.playerListFooter == null ? new TextComponent("") : this.playerListFooter));
        this.getHandle().f_8906_.m_141995_((Packet)packet);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OfflinePlayer)) {
            return false;
        }
        OfflinePlayer other = (OfflinePlayer)obj;
        if (this.getUniqueId() == null || other.getUniqueId() == null) {
            return false;
        }
        boolean uuidEquals = this.getUniqueId().equals(other.getUniqueId());
        boolean idEquals = true;
        if (other instanceof CraftPlayer) {
            idEquals = this.getEntityId() == ((CraftPlayer)other).getEntityId();
        }
        return uuidEquals && idEquals;
    }

    @Override
    public void kickPlayer(String message) {
        if (this.getHandle().f_8906_ == null) {
            return;
        }
        this.getHandle().f_8906_.disconnect(message == null ? "" : message);
    }

    @Override
    public void setCompassTarget(Location loc) {
        if (this.getHandle().f_8906_ == null) {
            return;
        }
        this.getHandle().f_8906_.m_141995_((Packet)new ClientboundSetDefaultSpawnPositionPacket(new BlockPos(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()), loc.getYaw()));
    }

    @Override
    public Location getCompassTarget() {
        return this.getHandle().compassTarget;
    }

    @Override
    public void chat(String msg) {
        if (this.getHandle().f_8906_ == null) {
            return;
        }
        this.getHandle().f_8906_.chat(msg, false);
    }

    @Override
    public boolean performCommand(String command) {
        return this.server.dispatchCommand(this, command);
    }

    @Override
    public void playNote(Location loc, byte instrument, byte note) {
        if (this.getHandle().f_8906_ == null) {
            return;
        }
        String instrumentName = null;
        switch (instrument) {
            case 0: {
                instrumentName = "harp";
                break;
            }
            case 1: {
                instrumentName = "basedrum";
                break;
            }
            case 2: {
                instrumentName = "snare";
                break;
            }
            case 3: {
                instrumentName = "hat";
                break;
            }
            case 4: {
                instrumentName = "bass";
                break;
            }
            case 5: {
                instrumentName = "flute";
                break;
            }
            case 6: {
                instrumentName = "bell";
                break;
            }
            case 7: {
                instrumentName = "guitar";
                break;
            }
            case 8: {
                instrumentName = "chime";
                break;
            }
            case 9: {
                instrumentName = "xylophone";
            }
        }
        float f = (float)Math.pow(2.0, ((double)note - 12.0) / 12.0);
        this.getHandle().f_8906_.m_141995_((Packet)new ClientboundSoundPacket(CraftSound.getSoundEffect("block.note_block." + instrumentName), SoundSource.RECORDS, (double)loc.getBlockX(), (double)loc.getBlockY(), (double)loc.getBlockZ(), 3.0f, f));
    }

    @Override
    public void playNote(Location loc, Instrument instrument, Note note) {
        if (this.getHandle().f_8906_ == null) {
            return;
        }
        String instrumentName = null;
        switch (instrument.ordinal()) {
            case 0: {
                instrumentName = "harp";
                break;
            }
            case 1: {
                instrumentName = "basedrum";
                break;
            }
            case 2: {
                instrumentName = "snare";
                break;
            }
            case 3: {
                instrumentName = "hat";
                break;
            }
            case 4: {
                instrumentName = "bass";
                break;
            }
            case 5: {
                instrumentName = "flute";
                break;
            }
            case 6: {
                instrumentName = "bell";
                break;
            }
            case 7: {
                instrumentName = "guitar";
                break;
            }
            case 8: {
                instrumentName = "chime";
                break;
            }
            case 9: {
                instrumentName = "xylophone";
                break;
            }
            case 10: {
                instrumentName = "iron_xylophone";
                break;
            }
            case 11: {
                instrumentName = "cow_bell";
                break;
            }
            case 12: {
                instrumentName = "didgeridoo";
                break;
            }
            case 13: {
                instrumentName = "bit";
                break;
            }
            case 14: {
                instrumentName = "banjo";
                break;
            }
            case 15: {
                instrumentName = "pling";
                break;
            }
            case 16: {
                instrumentName = "xylophone";
            }
        }
        float f = (float)Math.pow(2.0, ((double)note.getId() - 12.0) / 12.0);
        this.getHandle().f_8906_.m_141995_((Packet)new ClientboundSoundPacket(CraftSound.getSoundEffect("block.note_block." + instrumentName), SoundSource.RECORDS, (double)loc.getBlockX(), (double)loc.getBlockY(), (double)loc.getBlockZ(), 3.0f, f));
    }

    @Override
    public void playSound(Location loc, Sound sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    @Override
    public void playSound(Location loc, String sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    @Override
    public void playSound(Location loc, Sound sound, SoundCategory category, float volume, float pitch) {
        if (loc == null || sound == null || category == null || this.getHandle().f_8906_ == null) {
            return;
        }
        ClientboundSoundPacket packet = new ClientboundSoundPacket(CraftSound.getSoundEffect(sound), SoundSource.valueOf((String)category.name()), loc.getX(), loc.getY(), loc.getZ(), volume, pitch);
        this.getHandle().f_8906_.m_141995_((Packet)packet);
    }

    @Override
    public void playSound(Location loc, String sound, SoundCategory category, float volume, float pitch) {
        if (loc == null || sound == null || category == null || this.getHandle().f_8906_ == null) {
            return;
        }
        ClientboundCustomSoundPacket packet = new ClientboundCustomSoundPacket(new ResourceLocation(sound), SoundSource.valueOf((String)category.name()), new Vec3(loc.getX(), loc.getY(), loc.getZ()), volume, pitch);
        this.getHandle().f_8906_.m_141995_((Packet)packet);
    }

    @Override
    public void playSound(Entity entity, Sound sound, float volume, float pitch) {
        this.playSound(entity, sound, SoundCategory.MASTER, volume, pitch);
    }

    @Override
    public void playSound(Entity entity, Sound sound, SoundCategory category, float volume, float pitch) {
        CraftEntity craftEntity;
        block3: {
            block2: {
                if (!(entity instanceof CraftEntity)) break block2;
                craftEntity = (CraftEntity)entity;
                if (sound != null && category != null && this.getHandle().f_8906_ != null) break block3;
            }
            return;
        }
        ClientboundSoundEntityPacket packet = new ClientboundSoundEntityPacket(CraftSound.getSoundEffect(sound), SoundSource.valueOf((String)category.name()), craftEntity.getHandle(), volume, pitch);
        this.getHandle().f_8906_.m_141995_((Packet)packet);
    }

    @Override
    public void stopSound(Sound sound) {
        this.stopSound(sound, null);
    }

    @Override
    public void stopSound(String sound) {
        this.stopSound(sound, null);
    }

    @Override
    public void stopSound(Sound sound, SoundCategory category) {
        this.stopSound(sound.getKey().getKey(), category);
    }

    @Override
    public void stopAllSounds() {
        if (this.getHandle().f_8906_ == null) {
            return;
        }
        this.getHandle().f_8906_.m_141995_((Packet)new ClientboundStopSoundPacket(null, null));
    }

    @Override
    public void stopSound(String sound, SoundCategory category) {
        if (this.getHandle().f_8906_ == null) {
            return;
        }
        this.getHandle().f_8906_.m_141995_((Packet)new ClientboundStopSoundPacket(new ResourceLocation(sound), category == null ? SoundSource.MASTER : SoundSource.valueOf((String)category.name())));
    }

    @Override
    public void playEffect(Location loc, Effect effect, int data) {
        if (this.getHandle().f_8906_ == null) {
            return;
        }
        int packetData = effect.getId();
        ClientboundLevelEventPacket packet = new ClientboundLevelEventPacket(packetData, new BlockPos(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()), data, false);
        this.getHandle().f_8906_.m_141995_((Packet)packet);
    }

    @Override
    public <T> void playEffect(Location loc, Effect effect, T data) {
        if (data != null) {
            Validate.isTrue((effect.getData() != null && effect.getData().isAssignableFrom(data.getClass()) ? 1 : 0) != 0, (String)"Wrong kind of data for this effect!", (Object[])new Object[0]);
        } else {
            Validate.isTrue((effect.getData() == null || effect == Effect.ELECTRIC_SPARK ? 1 : 0) != 0, (String)"Wrong kind of data for this effect!", (Object[])new Object[0]);
        }
        int datavalue = CraftEffect.getDataValue(effect, data);
        this.playEffect(loc, effect, datavalue);
    }

    @Override
    public boolean breakBlock(Block block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"Block cannot be null");
        Preconditions.checkArgument((boolean)block.getWorld().equals(this.getWorld()), (Object)"Cannot break blocks across worlds");
        return this.getHandle().f_8941_.m_9280_(new BlockPos(block.getX(), block.getY(), block.getZ()));
    }

    @Override
    public void sendBlockChange(Location loc, Material material, byte data) {
        if (this.getHandle().f_8906_ == null) {
            return;
        }
        ClientboundBlockUpdatePacket packet = new ClientboundBlockUpdatePacket(new BlockPos(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()), CraftMagicNumbers.getBlock(material, data));
        this.getHandle().f_8906_.m_141995_((Packet)packet);
    }

    @Override
    public void sendBlockChange(Location loc, BlockData block) {
        if (this.getHandle().f_8906_ == null) {
            return;
        }
        ClientboundBlockUpdatePacket packet = new ClientboundBlockUpdatePacket(new BlockPos(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()), ((CraftBlockData)block).getState());
        this.getHandle().f_8906_.m_141995_((Packet)packet);
    }

    @Override
    public void sendBlockDamage(Location loc, float progress) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"loc must not be null");
        Preconditions.checkArgument(((double)progress >= 0.0 && (double)progress <= 1.0 ? 1 : 0) != 0, (Object)"progress must be between 0.0 and 1.0 (inclusive)");
        if (this.getHandle().f_8906_ == null) {
            return;
        }
        int stage = (int)(9.0f * progress);
        ClientboundBlockDestructionPacket packet = new ClientboundBlockDestructionPacket(this.getHandle().m_142049_(), new BlockPos(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()), stage);
        this.getHandle().f_8906_.m_141995_((Packet)packet);
    }

    @Override
    public void sendEquipmentChange(LivingEntity entity, EquipmentSlot slot, ItemStack item) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"entity must not be null");
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"slot must not be null");
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"item must not be null");
        if (this.getHandle().f_8906_ == null) {
            return;
        }
        List<Pair> equipment = Arrays.asList(new Pair((Object)CraftEquipmentSlot.getNMS(slot), (Object)CraftItemStack.asNMSCopy(item)));
        this.getHandle().f_8906_.m_141995_((Packet)new ClientboundSetEquipmentPacket(entity.getEntityId(), equipment));
    }

    @Override
    public void sendSignChange(Location loc, String[] lines) {
        this.sendSignChange(loc, lines, DyeColor.BLACK);
    }

    @Override
    public void sendSignChange(Location loc, String[] lines, DyeColor dyeColor) {
        this.sendSignChange(loc, lines, dyeColor, false);
    }

    @Override
    public void sendSignChange(Location loc, String[] lines, DyeColor dyeColor, boolean hasGlowingText) {
        if (this.getHandle().f_8906_ == null) {
            return;
        }
        if (lines == null) {
            lines = new String[4];
        }
        Validate.notNull((Object)loc, (String)"Location can not be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)dyeColor), (String)"DyeColor can not be null", (Object[])new Object[0]);
        if (lines.length < 4) {
            throw new IllegalArgumentException("Must have at least 4 lines");
        }
        Component[] components = CraftSign.sanitizeLines(lines);
        SignBlockEntity sign = new SignBlockEntity(new BlockPos(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()), Blocks.f_50095_.m_49966_());
        sign.m_59739_(net.minecraft.world.item.DyeColor.m_41053_((int)dyeColor.getWoolData()));
        for (int i = 0; i < components.length; ++i) {
            sign.m_59732_(i, components[i]);
        }
        this.getHandle().f_8906_.m_141995_((Packet)sign.m_183216_());
    }

    @Override
    public WorldBorder getWorldBorder() {
        return this.clientWorldBorder;
    }

    @Override
    public void setWorldBorder(WorldBorder border) {
        net.minecraft.world.level.border.WorldBorder newWorldBorder;
        CraftWorldBorder craftBorder = (CraftWorldBorder)border;
        if (border != null && !craftBorder.isVirtual() && !craftBorder.getWorld().equals(this.getWorld())) {
            throw new UnsupportedOperationException("Cannot set player world border to that of another world");
        }
        if (this.clientWorldBorder != null) {
            this.clientWorldBorder.getHandle().m_156096_(this.clientWorldBorderListener);
        }
        if (craftBorder == null || !craftBorder.isVirtual()) {
            this.clientWorldBorder = null;
            newWorldBorder = ((CraftWorldBorder)this.getWorld().getWorldBorder()).getHandle();
        } else {
            this.clientWorldBorder = craftBorder;
            this.clientWorldBorder.getHandle().m_61929_(this.clientWorldBorderListener);
            newWorldBorder = this.clientWorldBorder.getHandle();
        }
        ServerGamePacketListenerImpl connection = this.getHandle().f_8906_;
        connection.m_141995_((Packet)new ClientboundSetBorderSizePacket(newWorldBorder));
        connection.m_141995_((Packet)new ClientboundSetBorderLerpSizePacket(newWorldBorder));
        connection.m_141995_((Packet)new ClientboundSetBorderCenterPacket(newWorldBorder));
        connection.m_141995_((Packet)new ClientboundSetBorderWarningDelayPacket(newWorldBorder));
        connection.m_141995_((Packet)new ClientboundSetBorderWarningDistancePacket(newWorldBorder));
    }

    private BorderChangeListener createWorldBorderListener() {
        return new BorderChangeListener(){

            public void m_6312_(net.minecraft.world.level.border.WorldBorder border, double size) {
                CraftPlayer.this.getHandle().f_8906_.m_141995_((Packet)new ClientboundSetBorderSizePacket(border));
            }

            public void m_6689_(net.minecraft.world.level.border.WorldBorder border, double size, double newSize, long time) {
                CraftPlayer.this.getHandle().f_8906_.m_141995_((Packet)new ClientboundSetBorderLerpSizePacket(border));
            }

            public void m_7721_(net.minecraft.world.level.border.WorldBorder border, double x, double z) {
                CraftPlayer.this.getHandle().f_8906_.m_141995_((Packet)new ClientboundSetBorderCenterPacket(border));
            }

            public void m_5904_(net.minecraft.world.level.border.WorldBorder border, int warningTime) {
                CraftPlayer.this.getHandle().f_8906_.m_141995_((Packet)new ClientboundSetBorderWarningDelayPacket(border));
            }

            public void m_5903_(net.minecraft.world.level.border.WorldBorder border, int warningBlocks) {
                CraftPlayer.this.getHandle().f_8906_.m_141995_((Packet)new ClientboundSetBorderWarningDistancePacket(border));
            }

            public void m_6315_(net.minecraft.world.level.border.WorldBorder border, double damage) {
            }

            public void m_6313_(net.minecraft.world.level.border.WorldBorder border, double blocks) {
            }
        };
    }

    public boolean hasClientWorldBorder() {
        return this.clientWorldBorder != null;
    }

    @Override
    public void sendMap(MapView map) {
        if (this.getHandle().f_8906_ == null) {
            return;
        }
        RenderData data = ((CraftMapView)map).render(this);
        ArrayList<MapDecoration> icons = new ArrayList<MapDecoration>();
        for (MapCursor cursor : data.cursors) {
            if (!cursor.isVisible()) continue;
            icons.add(new MapDecoration(MapDecoration.Type.m_77854_((byte)cursor.getRawType()), cursor.getX(), cursor.getY(), cursor.getDirection(), CraftChatMessage.fromStringOrNull(cursor.getCaption())));
        }
        ClientboundMapItemDataPacket packet = new ClientboundMapItemDataPacket(map.getId(), map.getScale().getValue(), map.isLocked(), icons, new MapItemSavedData.MapPatch(0, 0, 128, 128, data.buffer));
        this.getHandle().f_8906_.m_141995_((Packet)packet);
    }

    @Override
    public void setRotation(float yaw, float pitch) {
        throw new UnsupportedOperationException("Cannot set rotation of players. Consider teleporting instead.");
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"location.world");
        location.checkFinite();
        ServerPlayer entity = this.getHandle();
        if (this.getHealth() == 0.0 || entity.m_146910_()) {
            return false;
        }
        if (entity.f_8906_ == null) {
            return false;
        }
        if (entity.m_20160_()) {
            return false;
        }
        Location from = this.getLocation();
        Location to = location;
        PlayerTeleportEvent event = new PlayerTeleportEvent(this, from, to, cause);
        this.server.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return false;
        }
        entity.m_8127_();
        if (this.isSleeping()) {
            this.wakeup(false);
        }
        from = event.getFrom();
        to = event.getTo();
        ServerLevel fromWorld = ((CraftWorld)from.getWorld()).getHandle();
        ServerLevel toWorld = ((CraftWorld)to.getWorld()).getHandle();
        if (this.getHandle().f_36096_ != this.getHandle().f_36095_) {
            this.getHandle().m_6915_();
        }
        if (fromWorld == toWorld) {
            entity.f_8906_.teleport(to);
        } else {
            this.server.getHandle().respawn(entity, toWorld, true, to);
        }
        return true;
    }

    @Override
    public void setSneaking(boolean sneak) {
        this.getHandle().m_20260_(sneak);
    }

    @Override
    public boolean isSneaking() {
        return this.getHandle().m_6144_();
    }

    @Override
    public boolean isSprinting() {
        return this.getHandle().m_20142_();
    }

    @Override
    public void setSprinting(boolean sprinting) {
        this.getHandle().m_6858_(sprinting);
    }

    @Override
    public void loadData() {
        this.server.getHandle().f_11204_.m_78435_((Player)this.getHandle());
    }

    @Override
    public void saveData() {
        this.server.getHandle().f_11204_.m_78433_((Player)this.getHandle());
    }

    @Override
    @Deprecated
    public void updateInventory() {
        this.getHandle().f_36096_.m_150429_();
    }

    @Override
    public void setSleepingIgnored(boolean isSleeping) {
        this.getHandle().fauxSleeping = isSleeping;
        ((CraftWorld)this.getWorld()).getHandle().m_8878_();
    }

    @Override
    public boolean isSleepingIgnored() {
        return this.getHandle().fauxSleeping;
    }

    @Override
    public Location getBedSpawnLocation() {
        Optional spawnLoc;
        ServerLevel world = this.getHandle().f_8924_.m_129880_(this.getHandle().m_8963_());
        BlockPos bed = this.getHandle().m_8961_();
        if (world != null && bed != null && (spawnLoc = Player.m_36130_((ServerLevel)world, (BlockPos)bed, (float)this.getHandle().m_8962_(), (boolean)this.getHandle().m_8964_(), (boolean)true)).isPresent()) {
            Vec3 vec = (Vec3)spawnLoc.get();
            return new Location(world.getWorld(), vec.f_82479_, vec.f_82480_, vec.f_82481_, this.getHandle().m_8962_(), 0.0f);
        }
        return null;
    }

    @Override
    public void setBedSpawnLocation(Location location) {
        this.setBedSpawnLocation(location, false);
    }

    @Override
    public void setBedSpawnLocation(Location location, boolean override) {
        if (location == null) {
            this.getHandle().m_9158_(null, null, 0.0f, override, false);
        } else {
            this.getHandle().m_9158_(((CraftWorld)location.getWorld()).getHandle().m_46472_(), new BlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ()), location.getYaw(), override, false);
        }
    }

    @Override
    public Location getBedLocation() {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Not sleeping");
        BlockPos bed = this.getHandle().m_8961_();
        return new Location(this.getWorld(), bed.m_123341_(), bed.m_123342_(), bed.m_123343_());
    }

    @Override
    public boolean hasDiscoveredRecipe(NamespacedKey recipe) {
        Preconditions.checkArgument((recipe != null ? 1 : 0) != 0, (Object)"recipe cannot be null");
        return this.getHandle().m_8952_().m_12711_(CraftNamespacedKey.toMinecraft(recipe));
    }

    @Override
    public Set<NamespacedKey> getDiscoveredRecipes() {
        ImmutableSet.Builder bukkitRecipeKeys = ImmutableSet.builder();
        this.getHandle().m_8952_().f_12680_.forEach(key -> bukkitRecipeKeys.add((Object)CraftNamespacedKey.fromMinecraft(key)));
        return bukkitRecipeKeys.build();
    }

    @Override
    public void incrementStatistic(Statistic statistic) {
        CraftStatistic.incrementStatistic(this.getHandle().m_8951_(), statistic);
    }

    @Override
    public void decrementStatistic(Statistic statistic) {
        CraftStatistic.decrementStatistic(this.getHandle().m_8951_(), statistic);
    }

    @Override
    public int getStatistic(Statistic statistic) {
        return CraftStatistic.getStatistic(this.getHandle().m_8951_(), statistic);
    }

    @Override
    public void incrementStatistic(Statistic statistic, int amount) {
        CraftStatistic.incrementStatistic(this.getHandle().m_8951_(), statistic, amount);
    }

    @Override
    public void decrementStatistic(Statistic statistic, int amount) {
        CraftStatistic.decrementStatistic(this.getHandle().m_8951_(), statistic, amount);
    }

    @Override
    public void setStatistic(Statistic statistic, int newValue) {
        CraftStatistic.setStatistic(this.getHandle().m_8951_(), statistic, newValue);
    }

    @Override
    public void incrementStatistic(Statistic statistic, Material material) {
        CraftStatistic.incrementStatistic(this.getHandle().m_8951_(), statistic, material);
    }

    @Override
    public void decrementStatistic(Statistic statistic, Material material) {
        CraftStatistic.decrementStatistic(this.getHandle().m_8951_(), statistic, material);
    }

    @Override
    public int getStatistic(Statistic statistic, Material material) {
        return CraftStatistic.getStatistic(this.getHandle().m_8951_(), statistic, material);
    }

    @Override
    public void incrementStatistic(Statistic statistic, Material material, int amount) {
        CraftStatistic.incrementStatistic(this.getHandle().m_8951_(), statistic, material, amount);
    }

    @Override
    public void decrementStatistic(Statistic statistic, Material material, int amount) {
        CraftStatistic.decrementStatistic(this.getHandle().m_8951_(), statistic, material, amount);
    }

    @Override
    public void setStatistic(Statistic statistic, Material material, int newValue) {
        CraftStatistic.setStatistic(this.getHandle().m_8951_(), statistic, material, newValue);
    }

    @Override
    public void incrementStatistic(Statistic statistic, EntityType entityType) {
        CraftStatistic.incrementStatistic(this.getHandle().m_8951_(), statistic, entityType);
    }

    @Override
    public void decrementStatistic(Statistic statistic, EntityType entityType) {
        CraftStatistic.decrementStatistic(this.getHandle().m_8951_(), statistic, entityType);
    }

    @Override
    public int getStatistic(Statistic statistic, EntityType entityType) {
        return CraftStatistic.getStatistic(this.getHandle().m_8951_(), statistic, entityType);
    }

    @Override
    public void incrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        CraftStatistic.incrementStatistic(this.getHandle().m_8951_(), statistic, entityType, amount);
    }

    @Override
    public void decrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        CraftStatistic.decrementStatistic(this.getHandle().m_8951_(), statistic, entityType, amount);
    }

    @Override
    public void setStatistic(Statistic statistic, EntityType entityType, int newValue) {
        CraftStatistic.setStatistic(this.getHandle().m_8951_(), statistic, entityType, newValue);
    }

    @Override
    public void setPlayerTime(long time, boolean relative) {
        this.getHandle().timeOffset = time;
        this.getHandle().relativeTime = relative;
    }

    @Override
    public long getPlayerTimeOffset() {
        return this.getHandle().timeOffset;
    }

    @Override
    public long getPlayerTime() {
        return this.getHandle().getPlayerTime();
    }

    @Override
    public boolean isPlayerTimeRelative() {
        return this.getHandle().relativeTime;
    }

    @Override
    public void resetPlayerTime() {
        this.setPlayerTime(0L, true);
    }

    @Override
    public void setPlayerWeather(WeatherType type) {
        this.getHandle().setPlayerWeather(type, true);
    }

    @Override
    public WeatherType getPlayerWeather() {
        return this.getHandle().getPlayerWeather();
    }

    @Override
    public void resetPlayerWeather() {
        this.getHandle().resetPlayerWeather();
    }

    @Override
    public boolean isBanned() {
        return this.server.getBanList(BanList.Type.NAME).isBanned(this.getName());
    }

    @Override
    public boolean isWhitelisted() {
        return this.server.getHandle().m_11305_().m_11453_(this.getProfile());
    }

    @Override
    public void setWhitelisted(boolean value) {
        if (value) {
            this.server.getHandle().m_11305_().m_11381_((StoredUserEntry)new UserWhiteListEntry(this.getProfile()));
        } else {
            this.server.getHandle().m_11305_().m_11393_((Object)this.getProfile());
        }
    }

    @Override
    public void setGameMode(GameMode mode) {
        if (this.getHandle().f_8906_ == null) {
            return;
        }
        if (mode == null) {
            throw new IllegalArgumentException("Mode cannot be null");
        }
        this.getHandle().m_143403_(GameType.m_46393_((int)mode.getValue()));
    }

    @Override
    public GameMode getGameMode() {
        return GameMode.getByValue(this.getHandle().f_8941_.m_9290_().m_46392_());
    }

    @Override
    public GameMode getPreviousGameMode() {
        GameType previousGameMode = this.getHandle().f_8941_.m_9293_();
        return previousGameMode == null ? null : GameMode.getByValue(previousGameMode.m_46392_());
    }

    @Override
    public void giveExp(int exp) {
        this.getHandle().m_6756_(exp);
    }

    @Override
    public void giveExpLevels(int levels) {
        this.getHandle().m_6749_(levels);
    }

    @Override
    public float getExp() {
        return this.getHandle().f_36080_;
    }

    @Override
    public void setExp(float exp) {
        Preconditions.checkArgument(((double)exp >= 0.0 && (double)exp <= 1.0 ? 1 : 0) != 0, (String)"Experience progress must be between 0.0 and 1.0 (%s)", (Object)Float.valueOf(exp));
        this.getHandle().f_36080_ = exp;
        this.getHandle().f_8920_ = -1;
    }

    @Override
    public int getLevel() {
        return this.getHandle().f_36078_;
    }

    @Override
    public void setLevel(int level) {
        Preconditions.checkArgument((level >= 0 ? 1 : 0) != 0, (String)"Experience level must not be negative (%s)", (int)level);
        this.getHandle().f_36078_ = level;
        this.getHandle().f_8920_ = -1;
    }

    @Override
    public int getTotalExperience() {
        return this.getHandle().f_36079_;
    }

    @Override
    public void setTotalExperience(int exp) {
        Preconditions.checkArgument((exp >= 0 ? 1 : 0) != 0, (String)"Total experience points must not be negative (%s)", (int)exp);
        this.getHandle().f_36079_ = exp;
    }

    @Override
    public void sendExperienceChange(float progress) {
        this.sendExperienceChange(progress, this.getLevel());
    }

    @Override
    public void sendExperienceChange(float progress, int level) {
        Preconditions.checkArgument(((double)progress >= 0.0 && (double)progress <= 1.0 ? 1 : 0) != 0, (String)"Experience progress must be between 0.0 and 1.0 (%s)", (Object)Float.valueOf(progress));
        Preconditions.checkArgument((level >= 0 ? 1 : 0) != 0, (String)"Experience level must not be negative (%s)", (int)level);
        if (this.getHandle().f_8906_ == null) {
            return;
        }
        ClientboundSetExperiencePacket packet = new ClientboundSetExperiencePacket(progress, this.getTotalExperience(), level);
        this.getHandle().f_8906_.m_141995_((Packet)packet);
    }

    @Nullable
    private static WeakReference<Plugin> getPluginWeakReference(@Nullable Plugin plugin) {
        return plugin == null ? null : pluginWeakReferences.computeIfAbsent(plugin, WeakReference::new);
    }

    @Override
    @Deprecated
    public void hidePlayer(org.bukkit.entity.Player player) {
        this.hideEntity0(null, player);
    }

    @Override
    public void hidePlayer(Plugin plugin, org.bukkit.entity.Player player) {
        this.hideEntity(plugin, player);
    }

    @Override
    public void hideEntity(Plugin plugin, Entity entity) {
        Validate.notNull((Object)plugin, (String)"Plugin cannot be null", (Object[])new Object[0]);
        Validate.isTrue((boolean)plugin.isEnabled(), (String)"Plugin attempted to hide player while disabled", (Object[])new Object[0]);
        this.hideEntity0(plugin, entity);
    }

    private void hideEntity0(@Nullable Plugin plugin, Entity entity) {
        Validate.notNull((Object)entity, (String)"hidden entity cannot be null", (Object[])new Object[0]);
        if (this.getHandle().f_8906_ == null) {
            return;
        }
        if (this.equals(entity)) {
            return;
        }
        Set<WeakReference<Plugin>> hidingPlugins = this.hiddenEntities.get(entity.getUniqueId());
        if (hidingPlugins != null) {
            hidingPlugins.add(CraftPlayer.getPluginWeakReference(plugin));
            return;
        }
        hidingPlugins = new HashSet<WeakReference<Plugin>>();
        hidingPlugins.add(CraftPlayer.getPluginWeakReference(plugin));
        this.hiddenEntities.put(entity.getUniqueId(), hidingPlugins);
        ChunkMap tracker = ((ServerLevel)this.getHandle().f_19853_).m_7726_().f_8325_;
        net.minecraft.world.entity.Entity other = ((CraftEntity)entity).getHandle();
        ChunkMap.TrackedEntity entry = (ChunkMap.TrackedEntity)tracker.f_140150_.get(other.m_142049_());
        if (entry != null) {
            entry.m_140485_(this.getHandle());
        }
        if (other instanceof ServerPlayer) {
            ServerPlayer otherPlayer = (ServerPlayer)other;
            if (otherPlayer.sentListPacket) {
                this.getHandle().f_8906_.m_141995_((Packet)new ClientboundPlayerInfoPacket(ClientboundPlayerInfoPacket.Action.REMOVE_PLAYER, new ServerPlayer[]{otherPlayer}));
            }
        }
        this.server.getPluginManager().callEvent(new PlayerHideEntityEvent((org.bukkit.entity.Player)this, entity));
    }

    @Override
    @Deprecated
    public void showPlayer(org.bukkit.entity.Player player) {
        this.showEntity0(null, player);
    }

    @Override
    public void showPlayer(Plugin plugin, org.bukkit.entity.Player player) {
        this.showEntity(plugin, player);
    }

    @Override
    public void showEntity(Plugin plugin, Entity entity) {
        Validate.notNull((Object)plugin, (String)"Plugin cannot be null", (Object[])new Object[0]);
        this.showEntity0(plugin, entity);
    }

    private void showEntity0(@Nullable Plugin plugin, Entity entity) {
        ChunkMap.TrackedEntity entry;
        Validate.notNull((Object)entity, (String)"shown player cannot be null", (Object[])new Object[0]);
        if (this.getHandle().f_8906_ == null) {
            return;
        }
        if (this.equals(entity)) {
            return;
        }
        Set<WeakReference<Plugin>> hidingPlugins = this.hiddenEntities.get(entity.getUniqueId());
        if (hidingPlugins == null) {
            return;
        }
        hidingPlugins.remove(CraftPlayer.getPluginWeakReference(plugin));
        if (!hidingPlugins.isEmpty()) {
            return;
        }
        this.hiddenEntities.remove(entity.getUniqueId());
        ChunkMap tracker = ((ServerLevel)this.getHandle().f_19853_).m_7726_().f_8325_;
        net.minecraft.world.entity.Entity other = ((CraftEntity)entity).getHandle();
        if (other instanceof ServerPlayer) {
            ServerPlayer otherPlayer = (ServerPlayer)other;
            this.getHandle().f_8906_.m_141995_((Packet)new ClientboundPlayerInfoPacket(ClientboundPlayerInfoPacket.Action.ADD_PLAYER, new ServerPlayer[]{otherPlayer}));
        }
        if ((entry = (ChunkMap.TrackedEntity)tracker.f_140150_.get(other.m_142049_())) != null && !entry.f_140475_.contains(this.getHandle().f_8906_)) {
            entry.m_140497_(this.getHandle());
        }
        this.server.getPluginManager().callEvent(new PlayerShowEntityEvent((org.bukkit.entity.Player)this, entity));
    }

    public void onEntityRemove(net.minecraft.world.entity.Entity entity) {
        this.hiddenEntities.remove(entity.m_142081_());
    }

    @Override
    public boolean canSee(org.bukkit.entity.Player player) {
        return this.canSee((Entity)player);
    }

    @Override
    public boolean canSee(Entity entity) {
        return !this.hiddenEntities.containsKey(entity.getUniqueId());
    }

    @Override
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("name", this.getName());
        return result;
    }

    @Override
    public org.bukkit.entity.Player getPlayer() {
        return this;
    }

    public ServerPlayer getHandle() {
        return (ServerPlayer)this.entity;
    }

    public void setHandle(ServerPlayer entity) {
        super.setHandle((Player)entity);
    }

    @Override
    public String toString() {
        return "CraftPlayer{name=" + this.getName() + "}";
    }

    @Override
    public int hashCode() {
        if (this.hash == 0 || this.hash == 485) {
            this.hash = 485 + (this.getUniqueId() != null ? this.getUniqueId().hashCode() : 0);
        }
        return this.hash;
    }

    @Override
    public long getFirstPlayed() {
        return this.firstPlayed;
    }

    @Override
    public long getLastPlayed() {
        return this.lastPlayed;
    }

    @Override
    public boolean hasPlayedBefore() {
        return this.hasPlayedBefore;
    }

    public void setFirstPlayed(long firstPlayed) {
        this.firstPlayed = firstPlayed;
    }

    public void readExtraData(CompoundTag nbttagcompound) {
        this.hasPlayedBefore = true;
        if (nbttagcompound.m_128441_("bukkit")) {
            CompoundTag data = nbttagcompound.m_128469_("bukkit");
            if (data.m_128441_("firstPlayed")) {
                this.firstPlayed = data.m_128454_("firstPlayed");
                this.lastPlayed = data.m_128454_("lastPlayed");
            }
            if (data.m_128441_("newExp")) {
                ServerPlayer handle = this.getHandle();
                handle.newExp = data.m_128451_("newExp");
                handle.newTotalExp = data.m_128451_("newTotalExp");
                handle.newLevel = data.m_128451_("newLevel");
                handle.expToDrop = data.m_128451_("expToDrop");
                handle.keepLevel = data.m_128471_("keepLevel");
            }
        }
    }

    public void setExtraData(CompoundTag nbttagcompound) {
        if (!nbttagcompound.m_128441_("bukkit")) {
            nbttagcompound.m_128365_("bukkit", (Tag)new CompoundTag());
        }
        CompoundTag data = nbttagcompound.m_128469_("bukkit");
        ServerPlayer handle = this.getHandle();
        data.m_128405_("newExp", handle.newExp);
        data.m_128405_("newTotalExp", handle.newTotalExp);
        data.m_128405_("newLevel", handle.newLevel);
        data.m_128405_("expToDrop", handle.expToDrop);
        data.m_128379_("keepLevel", handle.keepLevel);
        data.m_128356_("firstPlayed", this.getFirstPlayed());
        data.m_128356_("lastPlayed", System.currentTimeMillis());
        data.m_128359_("lastKnownName", handle.m_6302_());
    }

    @Override
    public boolean beginConversation(Conversation conversation) {
        return this.conversationTracker.beginConversation(conversation);
    }

    @Override
    public void abandonConversation(Conversation conversation) {
        this.conversationTracker.abandonConversation(conversation, new ConversationAbandonedEvent(conversation, new ManuallyAbandonedConversationCanceller()));
    }

    @Override
    public void abandonConversation(Conversation conversation, ConversationAbandonedEvent details) {
        this.conversationTracker.abandonConversation(conversation, details);
    }

    @Override
    public void acceptConversationInput(String input) {
        this.conversationTracker.acceptConversationInput(input);
    }

    @Override
    public boolean isConversing() {
        return this.conversationTracker.isConversing();
    }

    @Override
    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage(this.server.getMessenger(), source, channel, message);
        if (this.getHandle().f_8906_ == null) {
            return;
        }
        if (this.channels.contains(channel)) {
            channel = StandardMessenger.validateAndCorrectChannel(channel);
            ClientboundCustomPayloadPacket packet = new ClientboundCustomPayloadPacket(new ResourceLocation(channel), new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])message)));
            this.getHandle().f_8906_.m_141995_((Packet)packet);
        }
    }

    @Override
    public void setTexturePack(String url) {
        this.setResourcePack(url);
    }

    @Override
    public void setResourcePack(String url) {
        this.setResourcePack(url);
    }

    @Override
    public void setResourcePack(String url, byte[] hash, String prompt) {
        this.setResourcePack(url, hash, prompt, false);
    }

    @Override
    public void setResourcePack(String url, byte[] hash, boolean force) {
        this.setResourcePack(url, hash, null, force);
    }

    @Override
    public void setResourcePack(String url, byte[] hash, String prompt, boolean force) {
        if (hash != null) {
            Validate.isTrue((hash.length == 20 ? 1 : 0) != 0, (String)("Resource pack hash should be 20 bytes long but was " + hash.length), (Object[])new Object[0]);
            this.getHandle().m_143408_(url, BaseEncoding.base16().lowerCase().encode(hash), force, CraftChatMessage.fromStringOrNull(prompt, true));
        } else {
            this.getHandle().m_143408_(url, "", force, CraftChatMessage.fromStringOrNull(prompt, true));
        }
    }

    @Override
    public void setResourcePack(String url, byte[] hash) {
        Validate.notNull((Object)url, (String)"Resource pack URL cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)hash, (String)"Resource pack hash cannot be null", (Object[])new Object[0]);
        Validate.isTrue((hash.length == 20 ? 1 : 0) != 0, (String)("Resource pack hash should be 20 bytes long but was " + hash.length), (Object[])new Object[0]);
        this.getHandle().m_143408_(url, BaseEncoding.base16().lowerCase().encode(hash), false, null);
    }

    public void addChannel(String channel) {
        Preconditions.checkState((this.channels.size() < 1024 ? 1 : 0) != 0, (String)"Cannot register channel '%s'. Too many channels registered!", (Object)channel);
        channel = StandardMessenger.validateAndCorrectChannel(channel);
        if (this.channels.add(channel)) {
            this.server.getPluginManager().callEvent(new PlayerRegisterChannelEvent((org.bukkit.entity.Player)this, channel));
        }
    }

    public void removeChannel(String channel) {
        if (this.channels.remove(channel = StandardMessenger.validateAndCorrectChannel(channel))) {
            this.server.getPluginManager().callEvent(new PlayerUnregisterChannelEvent((org.bukkit.entity.Player)this, channel));
        }
    }

    @Override
    public Set<String> getListeningPluginChannels() {
        return ImmutableSet.copyOf(this.channels);
    }

    public void sendSupportedChannels() {
        if (this.getHandle().f_8906_ == null) {
            return;
        }
        Set<String> listening = this.server.getMessenger().getIncomingChannels();
        if (!listening.isEmpty()) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            for (String channel : listening) {
                try {
                    stream.write(channel.getBytes("UTF8"));
                    stream.write(0);
                }
                catch (IOException ex) {
                    Logger.getLogger(CraftPlayer.class.getName()).log(Level.SEVERE, "Could not send Plugin Channel REGISTER to " + this.getName(), ex);
                }
            }
            this.getHandle().f_8906_.m_141995_((Packet)new ClientboundCustomPayloadPacket(new ResourceLocation("register"), new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])stream.toByteArray()))));
        }
    }

    @Override
    public EntityType getType() {
        return EntityType.PLAYER;
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getPlayerMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getPlayerMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    @Override
    public boolean setWindowProperty(InventoryView.Property prop, int value) {
        AbstractContainerMenu container = this.getHandle().f_36096_;
        if (container.getBukkitView().getType() != prop.getType()) {
            return false;
        }
        container.m_7511_(prop.getId(), value);
        return true;
    }

    public void disconnect(String reason) {
        this.conversationTracker.abandonAllConversations();
        this.perm.clearPermissions();
    }

    @Override
    public boolean isFlying() {
        return this.getHandle().m_150110_().f_35935_;
    }

    @Override
    public void setFlying(boolean value) {
        if (!this.getAllowFlight() && value) {
            throw new IllegalArgumentException("Cannot make player fly if getAllowFlight() is false");
        }
        this.getHandle().m_150110_().f_35935_ = value;
        this.getHandle().m_6885_();
    }

    @Override
    public boolean getAllowFlight() {
        return this.getHandle().m_150110_().f_35936_;
    }

    @Override
    public void setAllowFlight(boolean value) {
        if (this.isFlying() && !value) {
            this.getHandle().m_150110_().f_35935_ = false;
        }
        this.getHandle().m_150110_().f_35936_ = value;
        this.getHandle().m_6885_();
    }

    @Override
    public int getNoDamageTicks() {
        if (this.getHandle().f_8921_ > 0) {
            return Math.max(this.getHandle().f_8921_, this.getHandle().f_19802_);
        }
        return this.getHandle().f_19802_;
    }

    @Override
    public void setNoDamageTicks(int ticks) {
        super.setNoDamageTicks(ticks);
        this.getHandle().f_8921_ = ticks;
    }

    @Override
    public void setFlySpeed(float value) {
        this.validateSpeed(value);
        ServerPlayer player = this.getHandle();
        player.m_150110_().f_35939_ = value / 2.0f;
        player.m_6885_();
    }

    @Override
    public void setWalkSpeed(float value) {
        this.validateSpeed(value);
        ServerPlayer player = this.getHandle();
        player.m_150110_().f_35940_ = value / 2.0f;
        player.m_6885_();
        this.getHandle().m_21051_(Attributes.f_22279_).m_22100_((double)player.m_150110_().f_35940_);
    }

    @Override
    public float getFlySpeed() {
        return this.getHandle().m_150110_().f_35939_ * 2.0f;
    }

    @Override
    public float getWalkSpeed() {
        return this.getHandle().m_150110_().f_35940_ * 2.0f;
    }

    private void validateSpeed(float value) {
        if (value < 0.0f) {
            if (value < -1.0f) {
                throw new IllegalArgumentException(value + " is too low");
            }
        } else if (value > 1.0f) {
            throw new IllegalArgumentException(value + " is too high");
        }
    }

    @Override
    public void setMaxHealth(double amount) {
        super.setMaxHealth(amount);
        this.health = Math.min(this.health, this.health);
        this.getHandle().m_9233_();
    }

    @Override
    public void resetMaxHealth() {
        super.resetMaxHealth();
        this.getHandle().m_9233_();
    }

    @Override
    public CraftScoreboard getScoreboard() {
        return this.server.getScoreboardManager().getPlayerBoard(this);
    }

    @Override
    public void setScoreboard(Scoreboard scoreboard) {
        Validate.notNull((Object)scoreboard, (String)"Scoreboard cannot be null", (Object[])new Object[0]);
        ServerGamePacketListenerImpl playerConnection = this.getHandle().f_8906_;
        if (playerConnection == null) {
            throw new IllegalStateException("Cannot set scoreboard yet");
        }
        if (playerConnection.isDisconnected()) {
            throw new IllegalStateException("Cannot set scoreboard for invalid CraftPlayer");
        }
        this.server.getScoreboardManager().setPlayerBoard(this, scoreboard);
    }

    @Override
    public void setHealthScale(double value) {
        Validate.isTrue(((float)value > 0.0f ? 1 : 0) != 0, (String)"Must be greater than 0", (Object[])new Object[0]);
        this.healthScale = value;
        this.scaledHealth = true;
        this.updateScaledHealth();
    }

    @Override
    public double getHealthScale() {
        return this.healthScale;
    }

    @Override
    public void setHealthScaled(boolean scale) {
        this.scaledHealth = scale;
        if (this.scaledHealth != this.scaledHealth) {
            this.updateScaledHealth();
        }
    }

    @Override
    public boolean isHealthScaled() {
        return this.scaledHealth;
    }

    public float getScaledHealth() {
        return (float)(this.isHealthScaled() ? this.getHealth() * this.getHealthScale() / this.getMaxHealth() : this.getHealth());
    }

    @Override
    public double getHealth() {
        return this.health;
    }

    public void setRealHealth(double health) {
        this.health = health;
    }

    public void updateScaledHealth() {
        this.updateScaledHealth(true);
    }

    public void updateScaledHealth(boolean sendHealth) {
        AttributeMap attributemapserver = this.getHandle().m_21204_();
        Collection set = attributemapserver.m_22170_();
        this.injectScaledMaxHealth(set, true);
        if (this.getHandle().f_8906_ != null) {
            this.getHandle().f_8906_.m_141995_((Packet)new ClientboundUpdateAttributesPacket(this.getHandle().m_142049_(), set));
            if (sendHealth) {
                this.sendHealthUpdate();
            }
        }
        this.getHandle().m_20088_().m_135381_(net.minecraft.world.entity.LivingEntity.f_20961_, (Object)Float.valueOf(this.getScaledHealth()));
        this.getHandle().maxHealthCache = this.getMaxHealth();
    }

    public void sendHealthUpdate() {
        this.getHandle().f_8906_.m_141995_((Packet)new ClientboundSetHealthPacket(this.getScaledHealth(), this.getHandle().m_36324_().m_38702_(), this.getHandle().m_36324_().m_38722_()));
    }

    public void injectScaledMaxHealth(Collection<AttributeInstance> collection, boolean force) {
        if (!this.scaledHealth && !force) {
            return;
        }
        for (AttributeInstance genericInstance : collection) {
            if (genericInstance.m_22099_() != Attributes.f_22276_) continue;
            collection.remove(genericInstance);
            break;
        }
        AttributeInstance dummy = new AttributeInstance(Attributes.f_22276_, attribute -> {});
        dummy.m_22100_(this.scaledHealth ? this.healthScale : this.getMaxHealth());
        collection.add(dummy);
    }

    @Override
    public Entity getSpectatorTarget() {
        net.minecraft.world.entity.Entity followed = this.getHandle().m_8954_();
        return followed == this.getHandle() ? null : followed.getBukkitEntity();
    }

    @Override
    public void setSpectatorTarget(Entity entity) {
        Preconditions.checkArgument((this.getGameMode() == GameMode.SPECTATOR ? 1 : 0) != 0, (Object)"Player must be in spectator mode");
        this.getHandle().m_9213_(entity == null ? null : ((CraftEntity)entity).getHandle());
    }

    @Override
    public void sendTitle(String title, String subtitle) {
        this.sendTitle(title, subtitle, 10, 70, 20);
    }

    @Override
    public void sendTitle(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        ClientboundSetTitlesAnimationPacket times = new ClientboundSetTitlesAnimationPacket(fadeIn, stay, fadeOut);
        this.getHandle().f_8906_.m_141995_((Packet)times);
        if (title != null) {
            ClientboundSetTitleTextPacket packetTitle = new ClientboundSetTitleTextPacket(CraftChatMessage.fromStringOrNull(title));
            this.getHandle().f_8906_.m_141995_((Packet)packetTitle);
        }
        if (subtitle != null) {
            ClientboundSetSubtitleTextPacket packetSubtitle = new ClientboundSetSubtitleTextPacket(CraftChatMessage.fromStringOrNull(subtitle));
            this.getHandle().f_8906_.m_141995_((Packet)packetSubtitle);
        }
    }

    @Override
    public void resetTitle() {
        ClientboundClearTitlesPacket packetReset = new ClientboundClearTitlesPacket(true);
        this.getHandle().f_8906_.m_141995_((Packet)packetReset);
    }

    public void restore(CraftPlayer player) {
        this.setDisplayName(player.getDisplayName());
        player.setHandle(this.getHandle());
    }

    @Override
    public void spawnParticle(Particle particle, Location location, int count) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count);
    }

    @Override
    public void spawnParticle(Particle particle, double x, double y, double z, int count) {
        this.spawnParticle(particle, x, y, z, count, null);
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, data);
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, T data) {
        this.spawnParticle(particle, x, y, z, count, 0.0, 0.0, 0.0, data);
    }

    @Override
    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ);
    }

    @Override
    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, null);
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, data);
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, 1.0, data);
    }

    @Override
    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra);
    }

    @Override
    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, extra, null);
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data);
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        if (data != null && !particle.getDataType().isInstance(data)) {
            throw new IllegalArgumentException("data should be " + particle.getDataType() + " got " + data.getClass());
        }
        ClientboundLevelParticlesPacket packetplayoutworldparticles = new ClientboundLevelParticlesPacket(CraftParticle.toNMS(particle, data), true, (double)((float)x), (double)((float)y), (double)((float)z), (float)offsetX, (float)offsetY, (float)offsetZ, (float)extra, count);
        this.getHandle().f_8906_.m_141995_((Packet)packetplayoutworldparticles);
    }

    @Override
    public org.bukkit.advancement.AdvancementProgress getAdvancementProgress(Advancement advancement) {
        Preconditions.checkArgument((advancement != null ? 1 : 0) != 0, (Object)"advancement");
        CraftAdvancement craft = (CraftAdvancement)advancement;
        PlayerAdvancements data = this.getHandle().m_8960_();
        AdvancementProgress progress = data.m_135996_(craft.getHandle());
        return new CraftAdvancementProgress(craft, data, progress);
    }

    @Override
    public int getClientViewDistance() {
        return this.getHandle().clientViewDistance == null ? Bukkit.getViewDistance() : this.getHandle().clientViewDistance;
    }

    @Override
    public int getPing() {
        return this.getHandle().f_8943_;
    }

    @Override
    public String getLocale() {
        return this.getHandle().locale;
    }

    @Override
    public void updateCommands() {
        if (this.getHandle().f_8906_ == null) {
            return;
        }
        this.getHandle().f_8924_.m_129892_().m_82095_(this.getHandle());
    }

    @Override
    public void openBook(ItemStack book) {
        Validate.isTrue((book != null ? 1 : 0) != 0, (String)"book == null", (Object[])new Object[0]);
        Validate.isTrue((book.getType() == Material.WRITTEN_BOOK ? 1 : 0) != 0, (String)"Book must be Material.WRITTEN_BOOK", (Object[])new Object[0]);
        ItemStack hand = this.getInventory().getItemInMainHand();
        this.getInventory().setItemInMainHand(book);
        this.getHandle().m_6986_(CraftItemStack.asNMSCopy(book), InteractionHand.MAIN_HAND);
        this.getInventory().setItemInMainHand(hand);
    }

    @Override
    public void openSign(Sign sign) {
        CraftSign.openSign(sign, this);
    }

    @Override
    public void showDemoScreen() {
        if (this.getHandle().f_8906_ == null) {
            return;
        }
        this.getHandle().f_8906_.m_141995_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132158_, 0.0f));
    }

    @Override
    public boolean isAllowingServerListings() {
        return this.getHandle().m_184128_();
    }

    @Override
    public Player.Spigot spigot() {
        return this.spigot;
    }
}

