/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.generator;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_18_R2.CraftHeightMap;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R2.generator.CraftChunkData;
import org.bukkit.craftbukkit.v1_18_R2.generator.InternalChunkGenerator;
import org.bukkit.craftbukkit.v1_18_R2.generator.OldCraftChunkData;
import org.bukkit.generator.ChunkGenerator;

public class CustomChunkGenerator
extends InternalChunkGenerator {
    private final ChunkGenerator delegate;
    private final org.bukkit.generator.ChunkGenerator generator;
    private final ServerLevel world;
    private final Random random = new Random();
    private boolean newApi;
    private boolean implementBaseHeight = true;

    public CustomChunkGenerator(ServerLevel world, ChunkGenerator delegate, org.bukkit.generator.ChunkGenerator generator) {
        super((Registry<StructureSet>)delegate.f_207955_, delegate.f_207956_, delegate.m_62218_());
        this.world = world;
        this.delegate = delegate;
        this.generator = generator;
    }

    private static WorldgenRandom getSeededRandom() {
        return new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
    }

    public ChunkGenerator m_6819_(long i) {
        return new CustomChunkGenerator(this.world, this.delegate.m_6819_(i), this.generator);
    }

    public BiomeSource m_62218_() {
        return this.delegate.m_62218_();
    }

    public int m_142062_() {
        return this.delegate.m_142062_();
    }

    public int m_6337_() {
        return this.delegate.m_6337_();
    }

    public void m_62199_(RegistryAccess iregistrycustom, StructureFeatureManager structuremanager, ChunkAccess ichunkaccess, StructureManager definedstructuremanager, long i) {
        if (this.generator.shouldGenerateStructures()) {
            super.m_62199_(iregistrycustom, structuremanager, ichunkaccess, definedstructuremanager, i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_183621_(WorldGenRegion regionlimitedworldaccess, StructureFeatureManager structuremanager, ChunkAccess ichunkaccess) {
        ChunkGenerator.ChunkData data;
        int z;
        int x;
        block16: {
            if (this.generator.shouldGenerateSurface()) {
                this.delegate.m_183621_(regionlimitedworldaccess, structuremanager, ichunkaccess);
            }
            CraftChunkData chunkData = new CraftChunkData(this.world.getWorld(), ichunkaccess);
            WorldgenRandom random = CustomChunkGenerator.getSeededRandom();
            x = ichunkaccess.m_7697_().f_45578_;
            z = ichunkaccess.m_7697_().f_45579_;
            random.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
            this.generator.generateSurface(this.world.getWorld(), (Random)random, x, z, chunkData);
            if (this.generator.shouldGenerateBedrock()) {
                random = CustomChunkGenerator.getSeededRandom();
                random.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
            }
            random = CustomChunkGenerator.getSeededRandom();
            random.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
            this.generator.generateBedrock(this.world.getWorld(), (Random)random, x, z, chunkData);
            chunkData.breakLink();
            if (this.newApi) {
                return;
            }
            this.random.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
            CustomBiomeGrid biomegrid = new CustomBiomeGrid(ichunkaccess);
            try {
                if (this.generator.isParallelCapable()) {
                    data = this.generator.generateChunkData(this.world.getWorld(), this.random, x, z, biomegrid);
                    break block16;
                }
                CustomChunkGenerator customChunkGenerator = this;
                synchronized (customChunkGenerator) {
                    data = this.generator.generateChunkData(this.world.getWorld(), this.random, x, z, biomegrid);
                }
            }
            catch (UnsupportedOperationException exception) {
                this.newApi = true;
                return;
            }
        }
        Preconditions.checkArgument((boolean)(data instanceof OldCraftChunkData), (String)"Plugins must use createChunkData(World) rather than implementing ChunkData: %s", (Object)data);
        OldCraftChunkData craftData = (OldCraftChunkData)data;
        LevelChunkSection[] sections = craftData.getRawChunkData();
        LevelChunkSection[] csect = ichunkaccess.m_7103_();
        int scnt = Math.min(csect.length, sections.length);
        for (int sec = 0; sec < scnt; ++sec) {
            if (sections[sec] == null) continue;
            LevelChunkSection section = sections[sec];
            LevelChunkSection oldSection = csect[sec];
            for (int biomeX = 0; biomeX < 4; ++biomeX) {
                for (int biomeY = 0; biomeY < 4; ++biomeY) {
                    for (int biomeZ = 0; biomeZ < 4; ++biomeZ) {
                        section.setBiome(biomeX, biomeY, biomeZ, oldSection.m_204433_(biomeX, biomeY, biomeZ));
                    }
                }
            }
            csect[sec] = section;
        }
        if (craftData.getTiles() != null) {
            for (BlockPos pos : craftData.getTiles()) {
                int tz;
                int ty;
                int tx = pos.m_123341_();
                BlockState block = craftData.getTypeId(tx, ty = pos.m_123342_(), tz = pos.m_123343_());
                if (!block.m_155947_()) continue;
                BlockEntity tile = ((EntityBlock)block.m_60734_()).m_142194_(new BlockPos((x << 4) + tx, ty, (z << 4) + tz), block);
                ichunkaccess.m_142169_(tile);
            }
        }
        for (BlockPos lightPosition : craftData.getLights()) {
            ((ProtoChunk)ichunkaccess).m_63277_(new BlockPos((x << 4) + lightPosition.m_123341_(), lightPosition.m_123342_(), (z << 4) + lightPosition.m_123343_()));
        }
    }

    public void m_183516_(WorldGenRegion regionlimitedworldaccess, long seed, BiomeManager biomemanager, StructureFeatureManager structuremanager, ChunkAccess ichunkaccess, GenerationStep.Carving worldgenstage_features) {
        if (this.generator.shouldGenerateCaves()) {
            this.delegate.m_183516_(regionlimitedworldaccess, seed, biomemanager, structuremanager, ichunkaccess, worldgenstage_features);
        }
        if (worldgenstage_features == GenerationStep.Carving.LIQUID) {
            CraftChunkData chunkData = new CraftChunkData(this.world.getWorld(), ichunkaccess);
            WorldgenRandom random = CustomChunkGenerator.getSeededRandom();
            int x = ichunkaccess.m_7697_().f_45578_;
            int z = ichunkaccess.m_7697_().f_45579_;
            random.m_64690_(seed, 0, 0);
            this.generator.generateCaves(this.world.getWorld(), (Random)random, x, z, chunkData);
            chunkData.breakLink();
        }
    }

    public CompletableFuture<ChunkAccess> m_183489_(Executor executor, Blender blender, StructureFeatureManager structuremanager, ChunkAccess ichunkaccess) {
        CompletableFuture future = null;
        if (this.generator.shouldGenerateNoise()) {
            future = this.delegate.m_183489_(executor, blender, structuremanager, ichunkaccess);
        }
        Function<ChunkAccess, ChunkAccess> function = ichunkaccess1 -> {
            CraftChunkData chunkData = new CraftChunkData(this.world.getWorld(), (ChunkAccess)ichunkaccess1);
            WorldgenRandom random = CustomChunkGenerator.getSeededRandom();
            int x = ichunkaccess1.m_7697_().f_45578_;
            int z = ichunkaccess1.m_7697_().f_45579_;
            random.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
            this.generator.generateNoise(this.world.getWorld(), (Random)random, x, z, chunkData);
            chunkData.breakLink();
            return ichunkaccess1;
        };
        return future == null ? CompletableFuture.supplyAsync(() -> (ChunkAccess)function.apply(ichunkaccess), Util.m_183991_()) : future.thenApply(function);
    }

    public int m_142647_(int i, int j, Heightmap.Types heightmap_type, LevelHeightAccessor levelheightaccessor) {
        if (this.implementBaseHeight) {
            try {
                WorldgenRandom random = CustomChunkGenerator.getSeededRandom();
                int xChunk = i >> 4;
                int zChunk = j >> 4;
                random.setSeed((long)xChunk * 341873128712L + (long)zChunk * 132897987541L);
                return this.generator.getBaseHeight(this.world.getWorld(), (Random)random, i, j, CraftHeightMap.fromNMS(heightmap_type));
            }
            catch (UnsupportedOperationException exception) {
                this.implementBaseHeight = false;
            }
        }
        return this.delegate.m_142647_(i, j, heightmap_type, levelheightaccessor);
    }

    public WeightedRandomList<MobSpawnSettings.SpawnerData> m_203315_(Holder<net.minecraft.world.level.biome.Biome> holder, StructureFeatureManager structuremanager, MobCategory enumcreaturetype, BlockPos blockposition) {
        return this.delegate.m_203315_(holder, structuremanager, enumcreaturetype, blockposition);
    }

    public void m_183372_(WorldGenLevel generatoraccessseed, ChunkAccess ichunkaccess, StructureFeatureManager structuremanager) {
    }

    public void m_207076_(List<String> list, BlockPos blockposition) {
        this.delegate.m_207076_(list, blockposition);
    }

    public void m_6929_(WorldGenRegion regionlimitedworldaccess) {
        if (this.generator.shouldGenerateMobs()) {
            this.delegate.m_6929_(regionlimitedworldaccess);
        }
    }

    public int m_142051_(LevelHeightAccessor levelheightaccessor) {
        return this.delegate.m_142051_(levelheightaccessor);
    }

    public int m_6331_() {
        return this.delegate.m_6331_();
    }

    public NoiseColumn m_141914_(int i, int j, LevelHeightAccessor levelheightaccessor) {
        return this.delegate.m_141914_(i, j, levelheightaccessor);
    }

    public Climate.Sampler m_183403_() {
        return this.delegate.m_183403_();
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return Codec.unit(null);
    }

    @Deprecated
    private class CustomBiomeGrid
    implements ChunkGenerator.BiomeGrid {
        private final ChunkAccess biome;

        public CustomBiomeGrid(ChunkAccess biome) {
            this.biome = biome;
        }

        @Override
        public Biome getBiome(int x, int z) {
            return this.getBiome(x, 0, z);
        }

        @Override
        public void setBiome(int x, int z, Biome bio) {
            for (int y = CustomChunkGenerator.this.world.getWorld().getMinHeight(); y < CustomChunkGenerator.this.world.getWorld().getMaxHeight(); y += 4) {
                this.setBiome(x, y, z, bio);
            }
        }

        @Override
        public Biome getBiome(int x, int y, int z) {
            return CraftBlock.biomeBaseToBiome((Registry<net.minecraft.world.level.biome.Biome>)this.biome.biomeRegistry, (Holder<net.minecraft.world.level.biome.Biome>)this.biome.m_203495_(x >> 2, y >> 2, z >> 2));
        }

        @Override
        public void setBiome(int x, int y, int z, Biome bio) {
            Preconditions.checkArgument((bio != Biome.CUSTOM ? 1 : 0) != 0, (String)"Cannot set the biome to %s", (Object)bio);
            this.biome.setBiome(x >> 2, y >> 2, z >> 2, CraftBlock.biomeToBiomeBase((Registry<net.minecraft.world.level.biome.Biome>)this.biome.biomeRegistry, bio));
        }
    }
}

