/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.inventory;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.apache.commons.lang3.Validate;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBanner;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaBanner;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaItem;
import org.bukkit.inventory.meta.BlockStateMeta;

@DelegateDeserialization(value=CraftMetaItem.SerializableMeta.class)
public class CraftMetaBlockState
extends CraftMetaItem
implements BlockStateMeta {
    static final CraftMetaItem.ItemMetaKey BLOCK_ENTITY_TAG = new CraftMetaItem.ItemMetaKey("BlockEntityTag");
    final Material material;
    CompoundTag blockEntityTag;

    CraftMetaBlockState(CraftMetaItem meta, Material material) {
        super(meta);
        this.material = material;
        if (!(meta instanceof CraftMetaBlockState) || ((CraftMetaBlockState)meta).material != material) {
            this.blockEntityTag = null;
            return;
        }
        CraftMetaBlockState te = (CraftMetaBlockState)meta;
        this.blockEntityTag = te.blockEntityTag;
    }

    CraftMetaBlockState(CompoundTag tag, Material material) {
        super(tag);
        this.material = material;
        this.blockEntityTag = tag.m_128425_(CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT, 10) ? tag.m_128469_(CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT).m_6426_() : null;
    }

    CraftMetaBlockState(Map<String, Object> map) {
        super(map);
        String matName = CraftMetaItem.SerializableMeta.getString(map, "blockMaterial", true);
        Material m = Material.getMaterial(matName);
        this.material = m != null ? m : Material.AIR;
    }

    @Override
    void applyToItem(CompoundTag tag) {
        super.applyToItem(tag);
        if (this.blockEntityTag != null) {
            tag.m_128365_(CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT, (Tag)this.blockEntityTag);
        }
    }

    @Override
    void deserializeInternal(CompoundTag tag, Object context) {
        super.deserializeInternal(tag, context);
        if (tag.m_128425_(CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT, 10)) {
            this.blockEntityTag = tag.m_128469_(CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT);
        }
    }

    @Override
    void serializeInternal(Map<String, Tag> internalTags) {
        if (this.blockEntityTag != null) {
            internalTags.put(CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT, (Tag)this.blockEntityTag);
        }
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        builder.put((Object)"blockMaterial", (Object)this.material.name());
        return builder;
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.blockEntityTag != null) {
            hash = 61 * hash + this.blockEntityTag.hashCode();
        }
        return original != hash ? CraftMetaBlockState.class.hashCode() ^ hash : hash;
    }

    @Override
    public boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaBlockState) {
            CraftMetaBlockState that = (CraftMetaBlockState)meta;
            return Objects.equal((Object)this.blockEntityTag, (Object)that.blockEntityTag);
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaBlockState || this.blockEntityTag == null);
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.blockEntityTag == null;
    }

    @Override
    boolean applicableTo(Material type) {
        switch (type) {
            case FURNACE: 
            case CHEST: 
            case TRAPPED_CHEST: 
            case JUKEBOX: 
            case DISPENSER: 
            case DROPPER: 
            case ACACIA_SIGN: 
            case ACACIA_WALL_SIGN: 
            case BIRCH_SIGN: 
            case BIRCH_WALL_SIGN: 
            case CRIMSON_SIGN: 
            case CRIMSON_WALL_SIGN: 
            case DARK_OAK_SIGN: 
            case DARK_OAK_WALL_SIGN: 
            case JUNGLE_SIGN: 
            case JUNGLE_WALL_SIGN: 
            case OAK_SIGN: 
            case OAK_WALL_SIGN: 
            case SPRUCE_SIGN: 
            case SPRUCE_WALL_SIGN: 
            case WARPED_SIGN: 
            case WARPED_WALL_SIGN: 
            case SPAWNER: 
            case BREWING_STAND: 
            case ENCHANTING_TABLE: 
            case COMMAND_BLOCK: 
            case REPEATING_COMMAND_BLOCK: 
            case CHAIN_COMMAND_BLOCK: 
            case BEACON: 
            case DAYLIGHT_DETECTOR: 
            case HOPPER: 
            case COMPARATOR: 
            case SHIELD: 
            case STRUCTURE_BLOCK: 
            case SHULKER_BOX: 
            case WHITE_SHULKER_BOX: 
            case ORANGE_SHULKER_BOX: 
            case MAGENTA_SHULKER_BOX: 
            case LIGHT_BLUE_SHULKER_BOX: 
            case YELLOW_SHULKER_BOX: 
            case LIME_SHULKER_BOX: 
            case PINK_SHULKER_BOX: 
            case GRAY_SHULKER_BOX: 
            case LIGHT_GRAY_SHULKER_BOX: 
            case CYAN_SHULKER_BOX: 
            case PURPLE_SHULKER_BOX: 
            case BLUE_SHULKER_BOX: 
            case BROWN_SHULKER_BOX: 
            case GREEN_SHULKER_BOX: 
            case RED_SHULKER_BOX: 
            case BLACK_SHULKER_BOX: 
            case ENDER_CHEST: 
            case BARREL: 
            case BELL: 
            case BLAST_FURNACE: 
            case CAMPFIRE: 
            case SOUL_CAMPFIRE: 
            case JIGSAW: 
            case LECTERN: 
            case SMOKER: 
            case BEEHIVE: 
            case BEE_NEST: 
            case SCULK_SENSOR: {
                return true;
            }
        }
        return false;
    }

    @Override
    public CraftMetaBlockState clone() {
        CraftMetaBlockState meta = (CraftMetaBlockState)super.clone();
        if (this.blockEntityTag != null) {
            meta.blockEntityTag = this.blockEntityTag.m_6426_();
        }
        return meta;
    }

    @Override
    public boolean hasBlockState() {
        return this.blockEntityTag != null;
    }

    @Override
    public BlockState getBlockState() {
        Material stateMaterial;
        Material material = stateMaterial = this.material != Material.SHIELD ? this.material : CraftMetaBlockState.shieldToBannerHack(this.blockEntityTag);
        if (this.blockEntityTag != null) {
            switch (this.material) {
                case SHIELD: {
                    this.blockEntityTag.m_128359_("id", "minecraft:banner");
                    break;
                }
                case SHULKER_BOX: 
                case WHITE_SHULKER_BOX: 
                case ORANGE_SHULKER_BOX: 
                case MAGENTA_SHULKER_BOX: 
                case LIGHT_BLUE_SHULKER_BOX: 
                case YELLOW_SHULKER_BOX: 
                case LIME_SHULKER_BOX: 
                case PINK_SHULKER_BOX: 
                case GRAY_SHULKER_BOX: 
                case LIGHT_GRAY_SHULKER_BOX: 
                case CYAN_SHULKER_BOX: 
                case PURPLE_SHULKER_BOX: 
                case BLUE_SHULKER_BOX: 
                case BROWN_SHULKER_BOX: 
                case GREEN_SHULKER_BOX: 
                case RED_SHULKER_BOX: 
                case BLACK_SHULKER_BOX: {
                    this.blockEntityTag.m_128359_("id", "minecraft:shulker_box");
                    break;
                }
                case BEEHIVE: 
                case BEE_NEST: {
                    this.blockEntityTag.m_128359_("id", "minecraft:beehive");
                }
            }
        }
        return CraftBlockStates.getBlockState(stateMaterial, this.blockEntityTag);
    }

    @Override
    public void setBlockState(BlockState blockState) {
        Material stateMaterial = this.material != Material.SHIELD ? this.material : CraftMetaBlockState.shieldToBannerHack(this.blockEntityTag);
        Class<? extends CraftBlockState> blockStateType = CraftBlockStates.getBlockStateType(stateMaterial);
        Validate.isTrue((blockStateType == blockState.getClass() && blockState instanceof CraftBlockEntityState ? 1 : 0) != 0, (String)("Invalid blockState for " + this.material), (Object[])new Object[0]);
        this.blockEntityTag = ((CraftBlockEntityState)blockState).getSnapshotNBT();
        if (this.material == Material.SHIELD) {
            this.blockEntityTag.m_128405_(CraftMetaBanner.BASE.NBT, (int)((CraftBanner)blockState).getBaseColor().getWoolData());
        }
    }

    private static Material shieldToBannerHack(CompoundTag tag) {
        if (tag == null || !tag.m_128425_(CraftMetaBanner.BASE.NBT, 3)) {
            return Material.WHITE_BANNER;
        }
        switch (tag.m_128451_(CraftMetaBanner.BASE.NBT)) {
            case 0: {
                return Material.WHITE_BANNER;
            }
            case 1: {
                return Material.ORANGE_BANNER;
            }
            case 2: {
                return Material.MAGENTA_BANNER;
            }
            case 3: {
                return Material.LIGHT_BLUE_BANNER;
            }
            case 4: {
                return Material.YELLOW_BANNER;
            }
            case 5: {
                return Material.LIME_BANNER;
            }
            case 6: {
                return Material.PINK_BANNER;
            }
            case 7: {
                return Material.GRAY_BANNER;
            }
            case 8: {
                return Material.LIGHT_GRAY_BANNER;
            }
            case 9: {
                return Material.CYAN_BANNER;
            }
            case 10: {
                return Material.PURPLE_BANNER;
            }
            case 11: {
                return Material.BLUE_BANNER;
            }
            case 12: {
                return Material.BROWN_BANNER;
            }
            case 13: {
                return Material.GREEN_BANNER;
            }
            case 14: {
                return Material.RED_BANNER;
            }
            case 15: {
                return Material.BLACK_BANNER;
            }
        }
        throw new IllegalArgumentException("Unknown banner colour");
    }
}

