/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.tools.geoip;

import com.mohistmc.tools.geoip.GeoIP;
import com.mohistmc.tools.geoip.GeoIPException;
import com.mohistmc.tools.geoip.internal.IpAddressMatcher;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.Optional;
import java.util.stream.Stream;

public class GeoIPNonResidentImpl
implements GeoIP {
    @Override
    public Optional<String> getTwoLetterCountryCode(InetAddress inetAddress) {
        return this.getTwoLetterCountryCode(inetAddress.getHostAddress());
    }

    @Override
    public Optional<String> getTwoLetterCountryCode(String ipAddress) {
        Optional<String> optionalCountryCodeFromIpv4 = this.getCountryCodeFromIpv4(ipAddress);
        if (optionalCountryCodeFromIpv4.isPresent()) {
            return optionalCountryCodeFromIpv4;
        }
        return this.getCountryCodeFromIpv6(ipAddress);
    }

    @Override
    public Optional<String> getCountryName(InetAddress inetAddress) {
        return this.getCountryName(inetAddress.getHostAddress());
    }

    @Override
    public Optional<String> getCountryName(String ipAddress) {
        Optional<String> optionalCountryNameFromIpv4 = this.getCountryNameFromIpv4(ipAddress);
        if (optionalCountryNameFromIpv4.isPresent()) {
            return optionalCountryNameFromIpv4;
        }
        return this.getCountryNameFromIpv6(ipAddress);
    }

    private Optional<String> getCountryCodeFromIpv4(String ipAddress) {
        return this.findCountryCodeInCsv("GeoLite2-Country-Blocks-IPv4.csv", ipAddress);
    }

    private Optional<String> getCountryNameFromIpv4(String ipAddress) {
        return this.findCountryNameInCsv("GeoLite2-Country-Blocks-IPv4.csv", ipAddress);
    }

    private Optional<String> getCountryCodeFromIpv6(String ipAddress) {
        return this.findCountryCodeInCsv("GeoLite2-Country-Blocks-IPv6.csv", ipAddress);
    }

    private Optional<String> getCountryNameFromIpv6(String ipAddress) {
        return this.findCountryNameInCsv("GeoLite2-Country-Blocks-IPv6.csv", ipAddress);
    }

    private Optional<String> findCountryCodeInCsv(String filename, String ipAddress) {
        Optional<String> optional;
        block8: {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(filename);
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                optional = ((Stream)reader.lines().parallel()).skip(1L).map(e -> e.split(",")).filter(e -> !e[2].isEmpty() || !e[1].isEmpty()).filter(e -> new IpAddressMatcher(e[0]).matches(ipAddress)).map(this::mapCountryCodeToCountryIsoCode).filter(e -> !e.isEmpty()).findFirst();
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new GeoIPException("Failed to read csv: " + filename, e2);
                }
            }
            is.close();
        }
        return optional;
    }

    private Optional<String> findCountryNameInCsv(String filename, String ipAddress) {
        Optional<String> optional;
        block8: {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(filename);
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                optional = ((Stream)reader.lines().parallel()).skip(1L).map(e -> e.split(",")).filter(e -> !e[2].isEmpty() || !e[1].isEmpty()).filter(e -> new IpAddressMatcher(e[0]).matches(ipAddress)).map(this::mapCountryCodeToCountryName).filter(e -> !e.isEmpty()).findFirst();
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new GeoIPException("Failed to read csv: " + filename, e2);
                }
            }
            is.close();
        }
        return optional;
    }

    private String mapCountryCodeToCountryIsoCode(String[] splittedLine) {
        String registeredCountryGeonameId = splittedLine[2];
        String geonameId = splittedLine[1];
        String countryId = registeredCountryGeonameId.isEmpty() ? geonameId : registeredCountryGeonameId;
        return this.getCountryIsoCodeFromCountryId(countryId);
    }

    private String mapCountryCodeToCountryName(String[] splittedLine) {
        String registeredCountryGeonameId = splittedLine[2];
        String geonameId = splittedLine[1];
        String countryId = registeredCountryGeonameId.isEmpty() ? geonameId : registeredCountryGeonameId;
        return this.getCountryNameFromCountryId(countryId);
    }

    private String getCountryIsoCodeFromCountryId(String countryId) {
        String string;
        block8: {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("GeoLite2-Country-Locations-en.csv");
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                string = ((Stream)reader.lines().parallel()).skip(1L).map(e -> e.split(",")).filter(e -> e[0].equals(countryId)).map(e -> e[4]).findFirst().orElseThrow(() -> new GeoIPException("Country iso code was not found for countryId, countryId: " + countryId));
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new GeoIPException("Failed to read GeoLite2-Country-Locations-en.csv", e2);
                }
            }
            inputStream.close();
        }
        return string;
    }

    private String getCountryNameFromCountryId(String countryId) {
        String string;
        block8: {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("GeoLite2-Country-Locations-en.csv");
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                string = ((Stream)reader.lines().parallel()).skip(1L).map(e -> e.split(",")).filter(e -> e[0].equals(countryId)).map(e -> e[5]).map(this::stripLeadingAndTrailingDoubleQuotes).findFirst().orElseThrow(() -> new GeoIPException("Country name was not found for countryId, countryId: " + countryId));
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new GeoIPException("Failed to read GeoLite2-Country-Locations-en.csv", e2);
                }
            }
            inputStream.close();
        }
        return string;
    }

    private String stripLeadingAndTrailingDoubleQuotes(String maybeQuotedCountryName) {
        String countryName = maybeQuotedCountryName;
        if (countryName.startsWith("\"")) {
            countryName = countryName.substring(1);
        }
        if (countryName.endsWith("\"")) {
            countryName = countryName.substring(0, countryName.length() - 1);
        }
        return countryName;
    }
}

