/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.tools.geoip;

import com.mohistmc.tools.geoip.GeoIP;
import com.mohistmc.tools.geoip.GeoIPNonResidentImpl;
import com.mohistmc.tools.geoip.GeoIPResidentImpl;

public final class GeoIPProvider {
    private GeoIPProvider() {
    }

    public static GeoIP getGeoIP() {
        return GeoIPProvider.getGeoIP(Type.RESIDENT);
    }

    public static GeoIP getGeoIP(Type type) {
        switch (type) {
            case RESIDENT: {
                GeoIPResidentImpl residentGeoIP = new GeoIPResidentImpl();
                residentGeoIP.getTwoLetterCountryCode("127.0.0.1");
                return residentGeoIP;
            }
            case RESIDENT_LAZY: {
                return new GeoIPResidentImpl();
            }
            case NON_RESIDENT: {
                return new GeoIPNonResidentImpl();
            }
        }
        throw new IllegalStateException("Unexpected type: " + type);
    }

    public static enum Type {
        RESIDENT,
        RESIDENT_LAZY,
        NON_RESIDENT;

    }
}

