/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.worldselection;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.client.gui.screens.worldselection.EditGameRulesScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.client.gui.screens.worldselection.WorldGenSettingsComponent;
import net.minecraft.client.gui.screens.worldselection.WorldOpenFlows;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.FolderRepositorySource;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.resource.ResourcePackLoader;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class CreateWorldScreen
extends Screen {
    private static final Logger f_100848_ = LogUtils.getLogger();
    private static final String f_170147_ = "mcworld-";
    private static final Component f_100849_ = Component.m_237115_("selectWorld.gameMode");
    private static final Component f_100850_ = Component.m_237115_("selectWorld.enterSeed");
    private static final Component f_100851_ = Component.m_237115_("selectWorld.seedInfo");
    private static final Component f_100852_ = Component.m_237115_("selectWorld.enterName");
    private static final Component f_100853_ = Component.m_237115_("selectWorld.resultFolder");
    private static final Component f_100854_ = Component.m_237115_("selectWorld.allowCommands.info");
    private static final Component f_232866_ = Component.m_237115_("createWorld.preparing");
    @Nullable
    private final Screen f_100855_;
    private EditBox f_100856_;
    String f_100857_;
    private SelectedGameMode f_100858_ = SelectedGameMode.SURVIVAL;
    @Nullable
    private SelectedGameMode f_100826_;
    private Difficulty f_170145_ = Difficulty.NORMAL;
    private boolean f_100829_;
    private boolean f_100830_;
    public boolean f_100845_;
    protected DataPackConfig f_100846_;
    @Nullable
    private Path f_100831_;
    @Nullable
    private PackRepository f_100832_;
    private boolean f_170146_;
    private Button f_100834_;
    private CycleButton<SelectedGameMode> f_100835_;
    private CycleButton<Difficulty> f_100836_;
    private Button f_100837_;
    private Button f_100838_;
    private Button f_100839_;
    private CycleButton<Boolean> f_100840_;
    private Component f_100841_;
    private Component f_100842_;
    private String f_100843_;
    private GameRules f_100844_ = new GameRules();
    public final WorldGenSettingsComponent f_100847_;

    public static void m_232896_(Minecraft p_232897_, @Nullable Screen p_232898_) {
        CreateWorldScreen.m_232899_(p_232897_, f_232866_);
        PackRepository packrepository = new PackRepository(PackType.SERVER_DATA, new RepositorySource[]{new ServerPacksSource()});
        WorldLoader.InitConfig worldloader$initconfig = CreateWorldScreen.m_232872_(packrepository, new DataPackConfig((List<String>)ImmutableList.of((Object)"vanilla"), (List<String>)ImmutableList.of()));
        CompletableFuture completablefuture = WorldLoader.m_214362_((WorldLoader.InitConfig)worldloader$initconfig, (p_232935_, p_232936_) -> {
            RegistryAccess.Frozen registryaccess$frozen = RegistryAccess.m_206197_().m_203557_();
            WorldGenSettings worldgensettings = WorldPresets.m_226449_((RegistryAccess)registryaccess$frozen);
            return Pair.of((Object)worldgensettings, (Object)registryaccess$frozen);
        }, (p_232881_, p_232882_, p_232883_, p_232884_) -> {
            p_232881_.close();
            return new WorldCreationContext(p_232884_, Lifecycle.stable(), p_232883_, p_232882_);
        }, (Executor)Util.m_183991_(), (Executor)((Object)p_232897_));
        p_232897_.m_18701_(completablefuture::isDone);
        CreateWorldScreen createWorldScreen = new CreateWorldScreen(p_232898_, new DataPackConfig((List<String>)ImmutableList.of((Object)"vanilla"), (List<String>)ImmutableList.of()), new WorldGenSettingsComponent((WorldCreationContext)completablefuture.join(), Optional.of(WorldPresets.f_226437_), OptionalLong.empty()));
        p_232897_.m_91152_(createWorldScreen);
        createWorldScreen.m_100878_(packrepository);
    }

    public static CreateWorldScreen m_205426_(@Nullable Screen p_205427_, WorldStem p_205428_, @Nullable Path p_205429_) {
        WorldData worlddata = p_205428_.f_206895_();
        LevelSettings levelsettings = worlddata.m_5926_();
        WorldGenSettings worldgensettings = worlddata.m_5961_();
        RegistryAccess.Frozen registryaccess$frozen = p_205428_.f_206894_();
        WorldCreationContext worldcreationcontext = new WorldCreationContext(worldgensettings, worlddata.m_5754_(), registryaccess$frozen, p_205428_.f_206893_());
        DataPackConfig datapackconfig = levelsettings.m_46934_();
        CreateWorldScreen createworldscreen = new CreateWorldScreen(p_205427_, datapackconfig, new WorldGenSettingsComponent(worldcreationcontext, WorldPresets.m_226445_((WorldGenSettings)worldgensettings), OptionalLong.of(worldgensettings.m_64619_())));
        createworldscreen.f_100843_ = levelsettings.m_46917_();
        createworldscreen.f_100829_ = levelsettings.m_46932_();
        createworldscreen.f_100830_ = true;
        createworldscreen.f_170145_ = levelsettings.m_46931_();
        createworldscreen.f_100844_.m_46176_(levelsettings.m_46933_(), null);
        if (levelsettings.m_46930_()) {
            createworldscreen.f_100858_ = SelectedGameMode.HARDCORE;
        } else if (levelsettings.m_46929_().m_46409_()) {
            createworldscreen.f_100858_ = SelectedGameMode.SURVIVAL;
        } else if (levelsettings.m_46929_().m_46408_()) {
            createworldscreen.f_100858_ = SelectedGameMode.CREATIVE;
        }
        createworldscreen.f_100831_ = p_205429_;
        return createworldscreen;
    }

    private CreateWorldScreen(@Nullable Screen p_100861_, DataPackConfig p_100862_, WorldGenSettingsComponent p_100863_) {
        super((Component)Component.m_237115_("selectWorld.create"));
        this.f_100855_ = p_100861_;
        this.f_100843_ = I18n.m_118938_("selectWorld.newWorld", new Object[0]);
        this.f_100846_ = p_100862_;
        this.f_100847_ = p_100863_;
    }

    @Override
    public void m_86600_() {
        this.f_100856_.m_94120_();
        this.f_100847_.m_101469_();
    }

    @Override
    protected void m_7856_() {
        this.f_96541_.f_91068_.m_90926_(true);
        this.f_100856_ = new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, 60, 200, 20, (Component)Component.m_237115_("selectWorld.enterName")){

            protected MutableComponent m_5646_() {
                return CommonComponents.m_178398_((Component)super.m_5646_(), (Component)Component.m_237115_("selectWorld.resultFolder")).m_130946_(" ").m_130946_(CreateWorldScreen.this.f_100857_);
            }
        };
        this.f_100856_.m_94144_(this.f_100843_);
        this.f_100856_.m_94151_(p_232916_ -> {
            this.f_100843_ = p_232916_;
            this.f_100834_.f_93623_ = !this.f_100856_.m_94155_().isEmpty();
            this.m_100971_();
        });
        this.m_7787_(this.f_100856_);
        int i = this.f_96543_ / 2 - 155;
        int j = this.f_96543_ / 2 + 5;
        this.f_100835_ = this.m_142416_(CycleButton.m_168894_(SelectedGameMode::m_170207_).m_168961_((Object[])new SelectedGameMode[]{SelectedGameMode.SURVIVAL, SelectedGameMode.HARDCORE, SelectedGameMode.CREATIVE}).m_168948_((Object)this.f_100858_).m_168959_(p_232940_ -> AbstractWidget.m_168799_(p_232940_.m_6035_()).m_7220_(CommonComponents.f_178389_).m_7220_(this.f_100841_).m_130946_(" ").m_7220_(this.f_100842_)).m_168936_(i, 100, 150, 20, f_100849_, (p_232910_, p_232911_) -> this.m_100900_((SelectedGameMode)((Object)p_232911_))));
        this.f_100836_ = this.m_142416_(CycleButton.m_168894_(Difficulty::m_19033_).m_168961_((Object[])Difficulty.values()).m_168948_((Object)this.m_170205_()).m_168936_(j, 100, 150, 20, (Component)Component.m_237115_("options.difficulty"), (p_232907_, p_232908_) -> {
            this.f_170145_ = p_232908_;
        }));
        this.f_100840_ = this.m_142416_(CycleButton.m_168916_((this.f_100829_ && !this.f_100845_ ? 1 : 0) != 0).m_168959_(p_232905_ -> CommonComponents.m_178398_((Component)p_232905_.m_168904_(), (Component)Component.m_237115_("selectWorld.allowCommands.info"))).m_168936_(i, 151, 150, 20, (Component)Component.m_237115_("selectWorld.allowCommands"), (p_232913_, p_232914_) -> {
            this.f_100830_ = true;
            this.f_100829_ = p_232914_;
        }));
        this.f_100839_ = this.m_142416_(new Button(j, 151, 150, 20, (Component)Component.m_237115_("selectWorld.dataPacks"), p_232947_ -> this.m_100975_()));
        this.f_100838_ = this.m_142416_(new Button(i, 185, 150, 20, (Component)Component.m_237115_("selectWorld.gameRules"), p_170188_ -> this.f_96541_.m_91152_((Screen)new EditGameRulesScreen(this.f_100844_.m_46202_(), p_232929_ -> {
            this.f_96541_.m_91152_(this);
            p_232929_.ifPresent(p_232892_ -> {
                this.f_100844_ = p_232892_;
            });
        }))));
        this.f_100847_.m_101429_(this, this.f_96541_, this.f_96547_);
        this.f_100837_ = this.m_142416_(new Button(j, 185, 150, 20, (Component)Component.m_237115_("selectWorld.moreWorldOptions"), p_170158_ -> this.m_170148_()));
        this.f_100834_ = this.m_142416_(new Button(i, this.f_96544_ - 28, 150, 20, (Component)Component.m_237115_("selectWorld.create"), p_232938_ -> this.m_100972_()));
        this.f_100834_.f_93623_ = !this.f_100843_.isEmpty();
        this.m_142416_(new Button(j, this.f_96544_ - 28, 150, 20, CommonComponents.f_130656_, p_232903_ -> this.m_100967_()));
        this.m_170204_();
        this.m_94718_((GuiEventListener)this.f_100856_);
        this.m_100900_(this.f_100858_);
        this.m_100971_();
    }

    private Difficulty m_170205_() {
        return this.f_100858_ == SelectedGameMode.HARDCORE ? Difficulty.HARD : this.f_170145_;
    }

    private void m_100970_() {
        this.f_100841_ = Component.m_237115_("selectWorld.gameMode." + this.f_100858_.f_101028_ + ".line1");
        this.f_100842_ = Component.m_237115_("selectWorld.gameMode." + this.f_100858_.f_101028_ + ".line2");
    }

    private void m_100971_() {
        this.f_100857_ = this.f_100856_.m_94155_().trim();
        if (this.f_100857_.isEmpty()) {
            this.f_100857_ = "World";
        }
        try {
            this.f_100857_ = FileUtil.m_133730_((Path)this.f_96541_.m_91392_().m_78257_(), (String)this.f_100857_, (String)"");
        }
        catch (Exception exception1) {
            this.f_100857_ = "World";
            try {
                this.f_100857_ = FileUtil.m_133730_((Path)this.f_96541_.m_91392_().m_78257_(), (String)this.f_100857_, (String)"");
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not create save folder", exception);
            }
        }
    }

    @Override
    public void m_7861_() {
        this.f_96541_.f_91068_.m_90926_(false);
    }

    private static void m_232899_(Minecraft p_232900_, Component p_232901_) {
        p_232900_.m_91346_((Screen)new GenericDirtMessageScreen(p_232901_));
    }

    private void m_100972_() {
        WorldOpenFlows.m_233126_(this.f_96541_, this, this.f_100847_.m_233087_().f_232988_(), this::m_232867_);
    }

    private void m_232867_() {
        CreateWorldScreen.m_232899_(this.f_96541_, f_232866_);
        Optional<LevelStorageSource.LevelStorageAccess> optional = this.m_232868_();
        if (!optional.isEmpty()) {
            this.m_100976_();
            WorldCreationContext worldcreationcontext = this.f_100847_.m_233066_(this.f_100845_);
            LevelSettings levelsettings = this.m_205447_(worldcreationcontext.f_232987_().m_64668_());
            PrimaryLevelData worlddata = new PrimaryLevelData(levelsettings, worldcreationcontext.f_232987_(), worldcreationcontext.f_232988_());
            this.f_96541_.m_231466_().m_233107_(optional.get(), worldcreationcontext.f_232990_(), worldcreationcontext.f_232989_(), worlddata);
        }
    }

    private LevelSettings m_205447_(boolean p_205448_) {
        String s = this.f_100856_.m_94155_().trim();
        if (p_205448_) {
            GameRules gamerules = new GameRules();
            gamerules.m_46170_(GameRules.f_46140_).m_46246_(false, null);
            return new LevelSettings(s, GameType.SPECTATOR, false, Difficulty.PEACEFUL, true, gamerules, DataPackConfig.f_45842_);
        }
        return new LevelSettings(s, this.f_100858_.f_101029_, this.f_100845_, this.m_170205_(), this.f_100829_ && !this.f_100845_, this.f_100844_, this.f_100846_);
    }

    private void m_170148_() {
        this.m_170196_(!this.f_170146_);
    }

    private void m_100900_(SelectedGameMode p_100901_) {
        if (!this.f_100830_) {
            this.f_100829_ = p_100901_ == SelectedGameMode.CREATIVE;
            this.f_100840_.m_168892_((Object)this.f_100829_);
        }
        if (p_100901_ == SelectedGameMode.HARDCORE) {
            this.f_100845_ = true;
            this.f_100840_.f_93623_ = false;
            this.f_100840_.m_168892_((Object)false);
            this.f_100847_.m_170291_();
            this.f_100836_.m_168892_((Object)Difficulty.HARD);
            this.f_100836_.f_93623_ = false;
        } else {
            this.f_100845_ = false;
            this.f_100840_.f_93623_ = true;
            this.f_100840_.m_168892_((Object)this.f_100829_);
            this.f_100847_.m_170292_();
            this.f_100836_.m_168892_((Object)this.f_170145_);
            this.f_100836_.f_93623_ = true;
        }
        this.f_100858_ = p_100901_;
        this.m_100970_();
    }

    public void m_170204_() {
        this.m_170196_(this.f_170146_);
    }

    private void m_170196_(boolean p_170197_) {
        this.f_170146_ = p_170197_;
        this.f_100835_.f_93624_ = !p_170197_;
        boolean bl = this.f_100836_.f_93624_ = !p_170197_;
        if (this.f_100847_.m_101403_()) {
            this.f_100839_.f_93624_ = false;
            this.f_100835_.f_93623_ = false;
            if (this.f_100826_ == null) {
                this.f_100826_ = this.f_100858_;
            }
            this.m_100900_(SelectedGameMode.DEBUG);
            this.f_100840_.f_93624_ = false;
        } else {
            this.f_100835_.f_93623_ = true;
            if (this.f_100826_ != null) {
                this.m_100900_(this.f_100826_);
            }
            this.f_100840_.f_93624_ = !p_170197_;
            this.f_100839_.f_93624_ = !p_170197_;
        }
        this.f_100847_.m_170287_(p_170197_);
        this.f_100856_.m_94194_(!p_170197_);
        if (p_170197_) {
            this.f_100837_.m_93666_(CommonComponents.f_130655_);
        } else {
            this.f_100837_.m_93666_((Component)Component.m_237115_("selectWorld.moreWorldOptions"));
        }
        this.f_100838_.f_93624_ = !p_170197_;
    }

    @Override
    public boolean m_7933_(int p_100875_, int p_100876_, int p_100877_) {
        if (super.m_7933_(p_100875_, p_100876_, p_100877_)) {
            return true;
        }
        if (p_100875_ != 257 && p_100875_ != 335) {
            return false;
        }
        this.m_100972_();
        return true;
    }

    @Override
    public void m_7379_() {
        if (this.f_170146_) {
            this.m_170196_(false);
        } else {
            this.m_100967_();
        }
    }

    public void m_100967_() {
        this.f_96541_.m_91152_(this.f_100855_);
        this.m_100976_();
    }

    @Override
    public void m_6305_(PoseStack p_100890_, int p_100891_, int p_100892_, float p_100893_) {
        this.m_7333_(p_100890_);
        CreateWorldScreen.m_93215_((PoseStack)p_100890_, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)20, (int)-1);
        if (this.f_170146_) {
            CreateWorldScreen.m_93243_((PoseStack)p_100890_, (Font)this.f_96547_, (Component)f_100850_, (int)(this.f_96543_ / 2 - 100), (int)47, (int)-6250336);
            CreateWorldScreen.m_93243_((PoseStack)p_100890_, (Font)this.f_96547_, (Component)f_100851_, (int)(this.f_96543_ / 2 - 100), (int)85, (int)-6250336);
            this.f_100847_.m_6305_(p_100890_, p_100891_, p_100892_, p_100893_);
        } else {
            CreateWorldScreen.m_93243_((PoseStack)p_100890_, (Font)this.f_96547_, (Component)f_100852_, (int)(this.f_96543_ / 2 - 100), (int)47, (int)-6250336);
            CreateWorldScreen.m_93243_((PoseStack)p_100890_, (Font)this.f_96547_, (Component)Component.m_237119_().m_7220_(f_100853_).m_130946_(" ").m_130946_(this.f_100857_), (int)(this.f_96543_ / 2 - 100), (int)85, (int)-6250336);
            this.f_100856_.m_6305_(p_100890_, p_100891_, p_100892_, p_100893_);
            CreateWorldScreen.m_93243_((PoseStack)p_100890_, (Font)this.f_96547_, (Component)this.f_100841_, (int)(this.f_96543_ / 2 - 150), (int)122, (int)-6250336);
            CreateWorldScreen.m_93243_((PoseStack)p_100890_, (Font)this.f_96547_, (Component)this.f_100842_, (int)(this.f_96543_ / 2 - 150), (int)134, (int)-6250336);
            if (this.f_100840_.f_93624_) {
                CreateWorldScreen.m_93243_((PoseStack)p_100890_, (Font)this.f_96547_, (Component)f_100854_, (int)(this.f_96543_ / 2 - 150), (int)172, (int)-6250336);
            }
        }
        super.m_6305_(p_100890_, p_100891_, p_100892_, p_100893_);
    }

    @Override
    protected <T extends GuiEventListener & NarratableEntry> T m_7787_(T p_100948_) {
        return super.m_7787_(p_100948_);
    }

    @Override
    protected <T extends GuiEventListener & Widget> T m_142416_(T p_170199_) {
        return super.m_142416_(p_170199_);
    }

    @Nullable
    private Path m_100968_() {
        if (this.f_100831_ == null) {
            try {
                this.f_100831_ = Files.createTempDirectory(f_170147_, new FileAttribute[0]);
            }
            catch (IOException ioexception) {
                f_100848_.warn("Failed to create temporary dir", (Throwable)ioexception);
                SystemToast.m_94875_((Minecraft)this.f_96541_, (String)this.f_100857_);
                this.m_100967_();
            }
        }
        return this.f_100831_;
    }

    private void m_100975_() {
        Pair<File, PackRepository> pair = this.m_100871_();
        if (pair != null) {
            this.f_96541_.m_91152_(new PackSelectionScreen(this, (PackRepository)pair.getSecond(), this::m_100878_, (File)pair.getFirst(), (Component)Component.m_237115_("dataPack.title")));
        }
    }

    private void m_100878_(PackRepository p_100879_) {
        ImmutableList list = ImmutableList.copyOf(p_100879_.m_10523_());
        List list1 = (List)p_100879_.m_10514_().stream().filter(arg_0 -> CreateWorldScreen.m_232925_((List)list, arg_0)).collect(ImmutableList.toImmutableList());
        DataPackConfig datapackconfig = new DataPackConfig((List<String>)list, list1);
        if (list.equals(this.f_100846_.m_45850_())) {
            this.f_100846_ = datapackconfig;
        } else {
            this.f_96541_.m_6937_(() -> this.f_96541_.m_91152_((Screen)new GenericDirtMessageScreen((Component)Component.m_237115_("dataPack.validation.working"))));
            WorldLoader.InitConfig worldloader$initconfig = CreateWorldScreen.m_232872_(p_100879_, datapackconfig);
            ((CompletableFuture)WorldLoader.m_214362_((WorldLoader.InitConfig)worldloader$initconfig, (p_232886_, p_232887_) -> {
                WorldCreationContext worldcreationcontext = this.f_100847_.m_233087_();
                RegistryAccess.Frozen registryaccess = worldcreationcontext.f_232989_();
                RegistryAccess.Writable registryaccess$writable = RegistryAccess.m_206197_();
                RegistryOps dynamicops = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)registryaccess);
                RegistryOps dynamicops1 = RegistryOps.m_206813_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess.Writable)registryaccess$writable, (ResourceManager)p_232886_);
                DataResult dataresult = WorldGenSettings.f_64600_.encodeStart((DynamicOps)dynamicops, (Object)worldcreationcontext.f_232987_()).setLifecycle(Lifecycle.stable());
                DataResult dataresult1 = dataresult.flatMap(arg_0 -> CreateWorldScreen.m_232893_((DynamicOps)dynamicops1, arg_0));
                RegistryAccess.Frozen registryaccess$frozen = registryaccess$writable.m_203557_();
                Lifecycle lifecycle = dataresult1.lifecycle().add(registryaccess$frozen.m_211816_());
                WorldGenSettings worldgensettings = (WorldGenSettings)dataresult1.getOrThrow(false, Util.m_137489_("Error parsing worldgen settings after loading data packs: ", arg_0 -> ((Logger)f_100848_).error(arg_0)));
                if (registryaccess$frozen.m_175515_(Registry.f_235726_).m_13562_() == 0) {
                    throw new IllegalStateException("Needs at least one world preset to continue");
                }
                if (registryaccess$frozen.m_175515_(Registry.f_122885_).m_13562_() == 0) {
                    throw new IllegalStateException("Needs at least one biome continue");
                }
                return Pair.of((Object)Pair.of((Object)worldgensettings, (Object)lifecycle), (Object)registryaccess$frozen);
            }, (p_232876_, p_232877_, p_232878_, p_232879_) -> {
                p_232876_.close();
                return new WorldCreationContext((WorldGenSettings)p_232879_.getFirst(), (Lifecycle)p_232879_.getSecond(), p_232878_, p_232877_);
            }, (Executor)Util.m_183991_(), (Executor)((Object)this.f_96541_)).thenAcceptAsync(p_232890_ -> {
                this.f_100846_ = datapackconfig;
                this.f_100847_.m_233042_(p_232890_);
                this.m_232761_();
            }, (Executor)((Object)this.f_96541_))).handle((p_232918_, p_232919_) -> {
                if (p_232919_ != null) {
                    f_100848_.warn("Failed to validate datapack", p_232919_);
                    this.f_96541_.m_6937_(() -> this.f_96541_.m_91152_((Screen)new ConfirmScreen(p_232949_ -> {
                        if (p_232949_) {
                            this.m_100975_();
                        } else {
                            this.f_100846_ = new DataPackConfig((List<String>)ImmutableList.of((Object)"vanilla"), (List<String>)ImmutableList.of());
                            this.f_96541_.m_91152_(this);
                        }
                    }, (Component)Component.m_237115_("dataPack.validation.failed"), CommonComponents.f_237098_, (Component)Component.m_237115_("dataPack.validation.back"), (Component)Component.m_237115_("dataPack.validation.reset"))));
                } else {
                    this.f_96541_.m_6937_(() -> this.f_96541_.m_91152_(this));
                }
                return null;
            });
        }
    }

    private static WorldLoader.InitConfig m_232872_(PackRepository p_232873_, DataPackConfig p_232874_) {
        WorldLoader.PackConfig worldloader$packconfig = new WorldLoader.PackConfig(p_232873_, p_232874_, false);
        return new WorldLoader.InitConfig(worldloader$packconfig, Commands.CommandSelection.INTEGRATED, 2);
    }

    private void m_100976_() {
        if (this.f_100831_ != null) {
            try (Stream<Path> stream = Files.walk(this.f_100831_, new FileVisitOption[0]);){
                stream.sorted(Comparator.reverseOrder()).forEach(p_232942_ -> {
                    try {
                        Files.delete(p_232942_);
                    }
                    catch (IOException ioexception1) {
                        f_100848_.warn("Failed to remove temporary file {}", p_232942_, (Object)ioexception1);
                    }
                });
            }
            catch (IOException ioexception) {
                f_100848_.warn("Failed to list temporary dir {}", (Object)this.f_100831_);
            }
            this.f_100831_ = null;
        }
    }

    private static void m_100912_(Path p_100913_, Path p_100914_, Path p_100915_) {
        try {
            Util.m_137563_(p_100913_, p_100914_, p_100915_);
        }
        catch (IOException ioexception) {
            f_100848_.warn("Failed to copy datapack file from {} to {}", (Object)p_100915_, (Object)p_100914_);
            throw new UncheckedIOException(ioexception);
        }
    }

    private Optional<LevelStorageSource.LevelStorageAccess> m_232868_() {
        LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess;
        block11: {
            levelstoragesource$levelstorageaccess = this.f_96541_.m_91392_().m_78260_(this.f_100857_);
            if (this.f_100831_ != null) break block11;
            return Optional.of(levelstoragesource$levelstorageaccess);
        }
        try {
            Optional<LevelStorageSource.LevelStorageAccess> optional;
            try (Stream<Path> stream = Files.walk(this.f_100831_, new FileVisitOption[0]);){
                Path path = levelstoragesource$levelstorageaccess.m_78283_(LevelResource.f_78180_);
                Files.createDirectories(path, new FileAttribute[0]);
                stream.filter(p_232921_ -> !p_232921_.equals(this.f_100831_)).forEach(p_232945_ -> CreateWorldScreen.m_100912_(this.f_100831_, path, p_232945_));
                optional = Optional.of(levelstoragesource$levelstorageaccess);
            }
            return optional;
        }
        catch (IOException | UncheckedIOException ioexception) {
            try {
                f_100848_.warn("Failed to copy datapacks to world {}", (Object)this.f_100857_, (Object)ioexception);
                levelstoragesource$levelstorageaccess.close();
            }
            catch (IOException | UncheckedIOException ioexception1) {
                f_100848_.warn("Failed to create access for {}", (Object)this.f_100857_, (Object)ioexception1);
            }
        }
        SystemToast.m_94875_((Minecraft)this.f_96541_, (String)this.f_100857_);
        this.m_100967_();
        return Optional.empty();
    }

    @Nullable
    public static Path m_100906_(Path p_100907_, Minecraft p_100908_) {
        MutableObject mutableobject = new MutableObject();
        try (Stream<Path> stream = Files.walk(p_100907_, new FileVisitOption[0]);){
            stream.filter(p_232924_ -> !p_232924_.equals(p_100907_)).forEach(p_232933_ -> {
                Path path = (Path)mutableobject.getValue();
                if (path == null) {
                    try {
                        path = Files.createTempDirectory(f_170147_, new FileAttribute[0]);
                    }
                    catch (IOException ioexception1) {
                        f_100848_.warn("Failed to create temporary dir");
                        throw new UncheckedIOException(ioexception1);
                    }
                    mutableobject.setValue((Object)path);
                }
                CreateWorldScreen.m_100912_(p_100907_, path, p_232933_);
            });
        }
        catch (IOException | UncheckedIOException ioexception) {
            f_100848_.warn("Failed to copy datapacks from world {}", (Object)p_100907_, (Object)ioexception);
            SystemToast.m_94875_((Minecraft)p_100908_, (String)p_100907_.toString());
            return null;
        }
        return (Path)mutableobject.getValue();
    }

    @Nullable
    private Pair<File, PackRepository> m_100871_() {
        Path path = this.m_100968_();
        if (path != null) {
            File file1 = path.toFile();
            if (this.f_100832_ == null) {
                this.f_100832_ = new PackRepository(PackType.SERVER_DATA, new RepositorySource[]{new ServerPacksSource(), new FolderRepositorySource(file1, PackSource.f_10527_)});
                ResourcePackLoader.loadResourcePacks((PackRepository)this.f_100832_, ServerLifecycleHooks::buildPackFinder);
                this.f_100832_.m_10506_();
            }
            this.f_100832_.m_10509_(this.f_100846_.m_45850_());
            return Pair.of((Object)file1, (Object)this.f_100832_);
        }
        return null;
    }

    private static /* synthetic */ DataResult m_232893_(DynamicOps p_232894_, JsonElement p_232895_) {
        return WorldGenSettings.f_64600_.parse(p_232894_, (Object)p_232895_);
    }

    private static /* synthetic */ boolean m_232925_(List p_232926_, String p_232927_) {
        return !p_232926_.contains(p_232927_);
    }

    @OnlyIn(value=Dist.CLIENT)
    static final class SelectedGameMode
    extends Enum<SelectedGameMode> {
        public static final /* enum */ SelectedGameMode SURVIVAL = new SelectedGameMode("survival", GameType.SURVIVAL);
        public static final /* enum */ SelectedGameMode HARDCORE = new SelectedGameMode("hardcore", GameType.SURVIVAL);
        public static final /* enum */ SelectedGameMode CREATIVE = new SelectedGameMode("creative", GameType.CREATIVE);
        public static final /* enum */ SelectedGameMode DEBUG = new SelectedGameMode("spectator", GameType.SPECTATOR);
        final String f_101028_;
        final GameType f_101029_;
        private final Component f_170206_;
        private static final /* synthetic */ SelectedGameMode[] $VALUES;

        public static SelectedGameMode[] values() {
            return (SelectedGameMode[])$VALUES.clone();
        }

        public static SelectedGameMode valueOf(String p_101042_) {
            return Enum.valueOf(SelectedGameMode.class, p_101042_);
        }

        private SelectedGameMode(String p_101035_, GameType p_101036_) {
            this.f_101028_ = p_101035_;
            this.f_101029_ = p_101036_;
            this.f_170206_ = Component.m_237115_("selectWorld.gameMode." + p_101035_);
        }

        public Component m_170207_() {
            return this.f_170206_;
        }

        private static /* synthetic */ SelectedGameMode[] m_170208_() {
            return new SelectedGameMode[]{SURVIVAL, HARDCORE, CREATIVE, DEBUG};
        }

        static {
            $VALUES = SelectedGameMode.m_170208_();
        }
    }
}

