/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.FolderPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraftforge.resource.ResourceCacheManager;
import org.slf4j.Logger;

public class VanillaPackResources
implements PackResources {
    @Nullable
    public static Path f_10312_;
    private static final Logger f_10315_;
    public static Class<?> f_10313_;
    private static final Map<PackType, Path> f_182296_;
    public final PackMetadataSection f_143759_;
    public final Set<String> f_10314_;
    private final ResourceCacheManager cacheManager = new ResourceCacheManager(false, "indexVanillaPackCachesOnThread", (packType, namespace) -> f_182296_.get(packType).resolve((String)namespace));

    private static Path m_182297_(URI p_182298_) throws IOException {
        try {
            return Paths.get(p_182298_);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
        }
        catch (Throwable throwable) {
            f_10315_.warn("Unable to get path for: {}", (Object)p_182298_, (Object)throwable);
        }
        try {
            FileSystems.newFileSystem(p_182298_, Collections.emptyMap());
        }
        catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
            // empty catch block
        }
        return Paths.get(p_182298_);
    }

    public VanillaPackResources(PackMetadataSection p_143761_, String ... p_143762_) {
        this.f_143759_ = p_143761_;
        this.f_10314_ = ImmutableSet.copyOf((Object[])p_143762_);
    }

    @Override
    public InputStream m_5542_(String p_10358_) throws IOException {
        if (!p_10358_.contains("/") && !p_10358_.contains("\\")) {
            Path path;
            if (f_10312_ != null && Files.exists(path = f_10312_.resolve(p_10358_), new LinkOption[0])) {
                return Files.newInputStream(path, new OpenOption[0]);
            }
            return this.m_5539_(p_10358_);
        }
        throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
    }

    @Override
    public InputStream m_8031_(PackType p_10330_, ResourceLocation p_10331_) throws IOException {
        InputStream inputstream = this.m_8033_(p_10330_, p_10331_);
        if (inputstream != null) {
            return inputstream;
        }
        throw new FileNotFoundException(p_10331_.m_135815_());
    }

    @Override
    public Collection<ResourceLocation> m_214146_(PackType p_215346_, String p_215347_, String p_215348_, Predicate<ResourceLocation> p_215349_) {
        HashSet set = Sets.newHashSet();
        if (f_10312_ != null) {
            try {
                VanillaPackResources.m_215357_(set, p_215347_, f_10312_.resolve(p_215346_.m_10305_()), p_215348_, p_215349_);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (p_215346_ == PackType.CLIENT_RESOURCES) {
                Enumeration<URL> enumeration = null;
                try {
                    enumeration = f_10313_.getClassLoader().getResources(p_215346_.m_10305_() + "/");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                while (enumeration != null && enumeration.hasMoreElements()) {
                    try {
                        URI uri = enumeration.nextElement().toURI();
                        if (!"file".equals(uri.getScheme())) continue;
                        VanillaPackResources.m_215357_(set, p_215347_, Paths.get(uri), p_215348_, p_215349_);
                    }
                    catch (IOException | URISyntaxException exception) {}
                }
            }
        }
        try {
            Path path = f_182296_.get(p_215346_);
            if (path != null) {
                if (ResourceCacheManager.shouldUseCache() && this.cacheManager.hasCached(p_215346_, p_215347_)) {
                    set.addAll(this.cacheManager.getResources(p_215346_, p_215347_, path.getFileSystem().getPath(p_215348_, new String[0]), p_215349_));
                } else {
                    VanillaPackResources.m_215357_(set, p_215347_, path, p_215348_, p_215349_);
                }
            } else {
                f_10315_.error("Can't access assets root for type: {}", (Object)p_215346_);
            }
        }
        catch (FileNotFoundException | NoSuchFileException path) {
        }
        catch (IOException ioexception) {
            f_10315_.error("Couldn't get a list of all vanilla resources", (Throwable)ioexception);
        }
        return set;
    }

    private static void m_215357_(Collection<ResourceLocation> p_215358_, String p_215359_, Path p_215360_, String p_215361_, Predicate<ResourceLocation> p_215362_) throws IOException {
        Path path = p_215360_.resolve(p_215359_);
        try (Stream<Path> stream = Files.walk(path.resolve(p_215361_), new FileVisitOption[0]);){
            stream.filter(p_215351_ -> !p_215351_.endsWith(".mcmeta") && Files.isRegularFile(p_215351_, new LinkOption[0])).mapMulti((p_215355_, p_215356_) -> {
                String s = path.relativize((Path)p_215355_).toString().replaceAll("\\\\", "/");
                ResourceLocation resourcelocation = ResourceLocation.m_214293_(p_215359_, s);
                if (resourcelocation == null) {
                    Util.m_143785_(String.format(Locale.ROOT, "Invalid path in datapack: %s:%s, ignoring", p_215359_, s));
                } else {
                    p_215356_.accept(resourcelocation);
                }
            }).filter(p_215362_).forEach(p_215358_::add);
        }
    }

    @Nullable
    protected InputStream m_8033_(PackType p_10359_, ResourceLocation p_10360_) {
        Path path;
        String s = VanillaPackResources.m_10362_(p_10359_, p_10360_);
        if (f_10312_ != null && Files.exists(path = f_10312_.resolve(p_10359_.m_10305_() + "/" + p_10360_.m_135827_() + "/" + p_10360_.m_135815_()), new LinkOption[0])) {
            try {
                return Files.newInputStream(path, new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            URL url = VanillaPackResources.class.getResource(s);
            return VanillaPackResources.m_10335_(s, url) ? this.getExtraInputStream(p_10359_, s) : null;
        }
        catch (IOException ioexception) {
            return VanillaPackResources.class.getResourceAsStream(s);
        }
    }

    private static String m_10362_(PackType p_10363_, ResourceLocation p_10364_) {
        return "/" + p_10363_.m_10305_() + "/" + p_10364_.m_135827_() + "/" + p_10364_.m_135815_();
    }

    private static boolean m_10335_(String p_10336_, @Nullable URL p_10337_) throws IOException {
        return p_10337_ != null && (p_10337_.getProtocol().equals("jar") || FolderPackResources.m_10273_((File)new File(p_10337_.getFile()), (String)p_10336_));
    }

    @Nullable
    protected InputStream m_5539_(String p_10334_) {
        return this.getExtraInputStream(PackType.SERVER_DATA, "/" + p_10334_);
    }

    @Override
    public boolean m_7211_(PackType p_10355_, ResourceLocation p_10356_) {
        Path path;
        String s = VanillaPackResources.m_10362_(p_10355_, p_10356_);
        if (f_10312_ != null && Files.exists(path = f_10312_.resolve(p_10355_.m_10305_() + "/" + p_10356_.m_135827_() + "/" + p_10356_.m_135815_()), new LinkOption[0])) {
            return true;
        }
        try {
            URL url = VanillaPackResources.class.getResource(s);
            return VanillaPackResources.m_10335_(s, url);
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    @Override
    public Set<String> m_5698_(PackType p_10322_) {
        return this.f_10314_;
    }

    @Override
    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> p_10333_) throws IOException {
        try {
            T object;
            block9: {
                block8: {
                    try (InputStream inputstream = this.m_5542_("pack.mcmeta");){
                        T t;
                        if (inputstream == null || (t = AbstractPackResources.m_10214_(p_10333_, inputstream)) == null) break block8;
                        object = t;
                        break block9;
                    }
                }
                return (T)(p_10333_ == PackMetadataSection.f_10366_ ? this.f_143759_ : null);
            }
            return object;
        }
        catch (FileNotFoundException | RuntimeException runtimeexception) {
            return (T)(p_10333_ == PackMetadataSection.f_10366_ ? this.f_143759_ : null);
        }
    }

    @Override
    public String m_8017_() {
        return "Default";
    }

    @Override
    public void close() {
    }

    private InputStream getExtraInputStream(PackType type, String resource) {
        try {
            Path rootDir = f_182296_.get(type);
            if (rootDir != null) {
                return Files.newInputStream(rootDir.resolve(resource), new OpenOption[0]);
            }
            return VanillaPackResources.class.getResourceAsStream(resource);
        }
        catch (IOException e) {
            return VanillaPackResources.class.getResourceAsStream(resource);
        }
    }

    public ResourceProvider m_215363_() {
        return p_215344_ -> Optional.of(new Resource(this.m_8017_(), () -> this.m_8031_(PackType.CLIENT_RESOURCES, p_215344_)));
    }

    public void initForNamespace(String nameSpace) {
        if (ResourceCacheManager.shouldUseCache()) {
            this.cacheManager.index(nameSpace);
        }
    }

    public void init(PackType packType) {
        this.initForNamespace("minecraft");
        this.initForNamespace("realms");
    }

    static {
        f_10315_ = LogUtils.getLogger();
        f_182296_ = (Map)Util.m_137537_(() -> {
            Class<VanillaPackResources> clazz = VanillaPackResources.class;
            synchronized (VanillaPackResources.class) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (PackType packtype : PackType.values()) {
                    String s = "/" + packtype.m_10305_() + "/.mcassetsroot";
                    URL url = VanillaPackResources.class.getResource(s);
                    if (url == null) {
                        f_10315_.error("File {} does not exist in classpath", (Object)s);
                        continue;
                    }
                    try {
                        URI uri = url.toURI();
                        String s1 = uri.getScheme();
                        if (!"jar".equals(s1) && !"file".equals(s1)) {
                            f_10315_.warn("Assets URL '{}' uses unexpected schema", (Object)uri);
                        }
                        Path path = VanillaPackResources.m_182297_(uri);
                        builder.put((Object)packtype, (Object)path.getParent());
                    }
                    catch (Exception exception) {
                        f_10315_.error("Couldn't resolve path to vanilla assets", (Throwable)exception);
                    }
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return builder.build();
            }
        });
    }
}

