/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_19_R1.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityInteractEvent;

public class InteractWithDoor
extends Behavior<LivingEntity> {
    private static final int f_147585_ = 20;
    private static final double f_147586_ = 2.0;
    private static final double f_147587_ = 2.0;
    @Nullable
    private Node f_23288_;
    private int f_23289_;

    public InteractWithDoor() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26377_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26379_, (Object)MemoryStatus.REGISTERED));
    }

    protected boolean m_6114_(ServerLevel p_23292_, LivingEntity p_23293_) {
        Path path = (Path)p_23293_.m_6274_().m_21952_(MemoryModuleType.f_26377_).get();
        if (!path.m_77387_() && !path.m_77392_()) {
            if (!Objects.equals(this.f_23288_, path.m_77401_())) {
                this.f_23289_ = 20;
                return true;
            }
            if (this.f_23289_ > 0) {
                --this.f_23289_;
            }
            return this.f_23289_ == 0;
        }
        return false;
    }

    protected void m_6735_(ServerLevel p_23295_, LivingEntity p_23296_, long p_23297_) {
        DoorBlock doorblock1;
        BlockPos blockpos1;
        BlockState blockstate1;
        Path path = (Path)p_23296_.m_6274_().m_21952_(MemoryModuleType.f_26377_).get();
        this.f_23288_ = path.m_77401_();
        Node node = path.m_77402_();
        Node node1 = path.m_77401_();
        BlockPos blockpos = node.m_77288_();
        BlockState blockstate = p_23295_.m_8055_(blockpos);
        if (blockstate.m_204338_(BlockTags.f_13095_, p_201959_ -> p_201959_.m_60734_() instanceof DoorBlock)) {
            DoorBlock doorblock = (DoorBlock)blockstate.m_60734_();
            if (!doorblock.m_52815_(blockstate)) {
                EntityInteractEvent event = new EntityInteractEvent((org.bukkit.entity.Entity)p_23296_.getBukkitEntity(), (Block)CraftBlock.at((LevelAccessor)p_23296_.f_19853_, (BlockPos)blockpos));
                p_23296_.f_19853_.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                doorblock.m_153165_((Entity)p_23296_, (Level)p_23295_, blockstate, blockpos, true);
            }
            this.m_23325_(p_23295_, p_23296_, blockpos);
        }
        if ((blockstate1 = p_23295_.m_8055_(blockpos1 = node1.m_77288_())).m_204338_(BlockTags.f_13095_, p_201957_ -> p_201957_.m_60734_() instanceof DoorBlock) && !(doorblock1 = (DoorBlock)blockstate1.m_60734_()).m_52815_(blockstate1)) {
            EntityInteractEvent event = new EntityInteractEvent((org.bukkit.entity.Entity)p_23296_.getBukkitEntity(), (Block)CraftBlock.at((LevelAccessor)p_23296_.f_19853_, (BlockPos)blockpos1));
            p_23296_.f_19853_.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            doorblock1.m_153165_((Entity)p_23296_, (Level)p_23295_, blockstate1, blockpos1, true);
            this.m_23325_(p_23295_, p_23296_, blockpos1);
        }
        InteractWithDoor.m_23298_(p_23295_, p_23296_, node, node1);
    }

    public static void m_23298_(ServerLevel p_23299_, LivingEntity p_23300_, @Nullable Node p_23301_, @Nullable Node p_23302_) {
        Brain<?> brain = p_23300_.m_6274_();
        if (brain.m_21874_(MemoryModuleType.f_26379_)) {
            Iterator iterator = ((Set)brain.m_21952_(MemoryModuleType.f_26379_).get()).iterator();
            while (iterator.hasNext()) {
                GlobalPos globalpos = (GlobalPos)iterator.next();
                BlockPos blockpos = globalpos.m_122646_();
                if (p_23301_ != null && p_23301_.m_77288_().equals((Object)blockpos) || p_23302_ != null && p_23302_.m_77288_().equals((Object)blockpos)) continue;
                if (InteractWithDoor.m_23307_(p_23299_, p_23300_, globalpos)) {
                    iterator.remove();
                    continue;
                }
                BlockState blockstate = p_23299_.m_8055_(blockpos);
                if (!blockstate.m_204338_(BlockTags.f_13095_, p_201952_ -> p_201952_.m_60734_() instanceof DoorBlock)) {
                    iterator.remove();
                    continue;
                }
                DoorBlock doorblock = (DoorBlock)blockstate.m_60734_();
                if (!doorblock.m_52815_(blockstate)) {
                    iterator.remove();
                    continue;
                }
                if (InteractWithDoor.m_23303_(p_23299_, p_23300_, blockpos)) {
                    iterator.remove();
                    continue;
                }
                doorblock.m_153165_((Entity)p_23300_, (Level)p_23299_, blockstate, blockpos, false);
                iterator.remove();
            }
        }
    }

    private static boolean m_23303_(ServerLevel p_23304_, LivingEntity p_23305_, BlockPos p_23306_) {
        Brain<?> brain = p_23305_.m_6274_();
        return !brain.m_21874_(MemoryModuleType.f_148204_) ? false : ((List)brain.m_21952_(MemoryModuleType.f_148204_).get()).stream().filter(p_201950_ -> p_201950_.m_6095_() == p_23305_.m_6095_()).filter(p_201955_ -> p_23306_.m_203195_((Position)p_201955_.m_20182_(), 2.0)).anyMatch(p_201947_ -> InteractWithDoor.m_23321_(p_23304_, p_201947_, p_23306_));
    }

    private static boolean m_23321_(ServerLevel p_23322_, LivingEntity p_23323_, BlockPos p_23324_) {
        if (!p_23323_.m_6274_().m_21874_(MemoryModuleType.f_26377_)) {
            return false;
        }
        Path path = (Path)p_23323_.m_6274_().m_21952_(MemoryModuleType.f_26377_).get();
        if (path.m_77392_()) {
            return false;
        }
        Node node = path.m_77402_();
        if (node == null) {
            return false;
        }
        Node node1 = path.m_77401_();
        return p_23324_.equals((Object)node.m_77288_()) || p_23324_.equals((Object)node1.m_77288_());
    }

    private static boolean m_23307_(ServerLevel p_23308_, LivingEntity p_23309_, GlobalPos p_23310_) {
        return p_23310_.m_122640_() != p_23308_.m_46472_() || !p_23310_.m_122646_().m_203195_((Position)p_23309_.m_20182_(), 2.0);
    }

    private void m_23325_(ServerLevel p_23326_, LivingEntity p_23327_, BlockPos p_23328_) {
        Brain<?> brain = p_23327_.m_6274_();
        GlobalPos globalpos = GlobalPos.m_122643_(p_23326_.m_46472_(), (BlockPos)p_23328_);
        if (brain.m_21952_(MemoryModuleType.f_26379_).isPresent()) {
            ((Set)brain.m_21952_(MemoryModuleType.f_26379_).get()).add(globalpos);
        } else {
            brain.m_21879_(MemoryModuleType.f_26379_, (Object)Sets.newHashSet((Object[])new GlobalPos[]{globalpos}));
        }
    }
}

