/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_19_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class StartAttacking<E extends Mob>
extends Behavior<E> {
    private final Predicate<E> f_24190_;
    private final Function<E, Optional<? extends LivingEntity>> f_24191_;

    public StartAttacking(Predicate<E> p_24195_, Function<E, Optional<? extends LivingEntity>> p_24196_) {
        this(p_24195_, p_24196_, 60);
    }

    public StartAttacking(Predicate<E> p_217378_, Function<E, Optional<? extends LivingEntity>> p_217379_, int p_217380_) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26326_, (Object)MemoryStatus.REGISTERED), p_217380_);
        this.f_24190_ = p_217378_;
        this.f_24191_ = p_217379_;
    }

    public StartAttacking(Function<E, Optional<? extends LivingEntity>> p_24193_) {
        this(p_24212_ -> true, p_24193_);
    }

    protected boolean m_6114_(ServerLevel p_24205_, E p_24206_) {
        if (!this.f_24190_.test(p_24206_)) {
            return false;
        }
        Optional<? extends LivingEntity> optional = this.f_24191_.apply(p_24206_);
        return optional.isPresent() ? ((LivingEntity)p_24206_).m_6779_(optional.get()) : false;
    }

    protected void m_6735_(ServerLevel p_24208_, E p_24209_, long p_24210_) {
        this.f_24191_.apply(p_24209_).ifPresent(p_24218_ -> StartAttacking.m_24213_(p_24209_, p_24218_));
    }

    public static <E extends Mob> void m_24213_(E p_24214_, LivingEntity p_24215_) {
        LivingChangeTargetEvent changeTargetEvent = ForgeHooks.onLivingChangeTarget(p_24214_, (LivingEntity)p_24215_, (LivingChangeTargetEvent.ILivingTargetType)LivingChangeTargetEvent.LivingTargetType.BEHAVIOR_TARGET);
        EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(p_24214_, (LivingEntity)p_24215_, (EntityTargetEvent.TargetReason)(p_24215_ instanceof ServerPlayer ? EntityTargetEvent.TargetReason.CLOSEST_PLAYER : EntityTargetEvent.TargetReason.CLOSEST_ENTITY));
        event.setCancelled(changeTargetEvent.isCanceled());
        if (event.isCancelled()) {
            return;
        }
        LivingEntity entityliving = event.getTarget() != null ? ((CraftLivingEntity)event.getTarget()).getHandle() : null;
        changeTargetEvent.setNewTarget(entityliving);
        if (!changeTargetEvent.isCanceled()) {
            p_24214_.m_6274_().m_21879_(MemoryModuleType.f_26372_, (Object)changeTargetEvent.getNewTarget());
            p_24214_.m_6274_().m_21936_(MemoryModuleType.f_26326_);
            ForgeHooks.onLivingSetAttackTarget(p_24214_, (LivingEntity)changeTargetEvent.getNewTarget(), (LivingChangeTargetEvent.ILivingTargetType)LivingChangeTargetEvent.LivingTargetType.BEHAVIOR_TARGET);
        }
    }
}

