/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_19_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PotionSplashEvent;

public class ThrownPotion
extends ThrowableItemProjectile
implements ItemSupplier {
    public static final double f_150190_ = 4.0;
    private static final double f_150191_ = 16.0;
    public static final Predicate<LivingEntity> f_37524_ = LivingEntity::m_6126_;

    public ThrownPotion(EntityType<? extends ThrownPotion> p_37527_, Level p_37528_) {
        super((EntityType<? extends ThrowableItemProjectile>)p_37527_, p_37528_);
    }

    public ThrownPotion(Level p_37535_, LivingEntity p_37536_) {
        super((EntityType<? extends ThrowableItemProjectile>)EntityType.f_20486_, p_37536_, p_37535_);
    }

    public ThrownPotion(Level p_37530_, double p_37531_, double p_37532_, double p_37533_) {
        super((EntityType<? extends ThrowableItemProjectile>)EntityType.f_20486_, p_37531_, p_37532_, p_37533_, p_37530_);
    }

    @Override
    protected Item m_7881_() {
        return Items.f_42736_;
    }

    @Override
    protected float m_7139_() {
        return 0.05f;
    }

    @Override
    protected void m_8060_(BlockHitResult p_37541_) {
        super.m_8060_(p_37541_);
        if (!this.f_19853_.f_46443_) {
            ItemStack itemstack = this.m_7846_();
            Potion potion = PotionUtils.m_43579_((ItemStack)itemstack);
            List list = PotionUtils.m_43547_((ItemStack)itemstack);
            boolean flag = potion == Potions.f_43599_ && list.isEmpty();
            Direction direction = p_37541_.m_82434_();
            BlockPos blockpos = p_37541_.m_82425_();
            BlockPos blockpos1 = blockpos.m_121945_(direction);
            if (flag) {
                this.m_150192_(blockpos1);
                this.m_150192_(blockpos1.m_121945_(direction.m_122424_()));
                for (Direction direction1 : Direction.Plane.HORIZONTAL) {
                    this.m_150192_(blockpos1.m_121945_(direction1));
                }
            }
        }
    }

    @Override
    protected void m_6532_(HitResult p_37543_) {
        super.m_6532_(p_37543_);
        if (!this.f_19853_.f_46443_) {
            boolean flag;
            ItemStack itemstack = this.m_7846_();
            Potion potion = PotionUtils.m_43579_((ItemStack)itemstack);
            List list = PotionUtils.m_43547_((ItemStack)itemstack);
            boolean bl = flag = potion == Potions.f_43599_ && list.isEmpty();
            if (flag) {
                this.m_37552_();
            } else if (this.m_37553_()) {
                this.m_37537_(itemstack, potion);
            } else {
                this.m_37547_(list, p_37543_.m_6662_() == HitResult.Type.ENTITY ? ((EntityHitResult)p_37543_).m_82443_() : null);
            }
            int i = potion.m_43491_() ? 2007 : 2002;
            this.f_19853_.m_46796_(i, this.m_20183_(), PotionUtils.m_43575_((ItemStack)itemstack));
            this.m_146870_();
        }
    }

    private void m_37552_() {
        AABB aabb = this.m_20191_().m_82377_(4.0, 2.0, 4.0);
        List list = this.f_19853_.m_6443_(LivingEntity.class, aabb, f_37524_);
        if (!list.isEmpty()) {
            for (LivingEntity livingentity : list) {
                double d0 = this.m_20280_(livingentity);
                if (!(d0 < 16.0) || !livingentity.m_6126_()) continue;
                livingentity.m_6469_(DamageSource.m_19367_(this, this.m_37282_()), 1.0f);
            }
        }
        for (Axolotl axolotl : this.f_19853_.m_45976_(Axolotl.class, aabb)) {
            axolotl.m_149177_();
        }
    }

    private void m_37547_(List<MobEffectInstance> p_37548_, @Nullable Entity p_37549_) {
        PotionSplashEvent event;
        double d1;
        AABB aabb = this.m_20191_().m_82377_(4.0, 2.0, 4.0);
        List list = this.f_19853_.m_45976_(LivingEntity.class, aabb);
        HashMap<org.bukkit.entity.LivingEntity, Double> affected = new HashMap<org.bukkit.entity.LivingEntity, Double>();
        if (!list.isEmpty()) {
            Entity entity = this.m_150173_();
            for (LivingEntity livingentity : list) {
                double d0;
                if (!livingentity.m_5801_() || !((d0 = this.m_20280_(livingentity)) < 16.0)) continue;
                d1 = 1.0 - Math.sqrt(d0) / 4.0;
                d1 = livingentity == p_37549_ ? 1.0 : 1.0 - Math.sqrt(d0) / 4.0;
                affected.put((org.bukkit.entity.LivingEntity)livingentity.getBukkitEntity(), d1);
            }
        }
        if (!(event = CraftEventFactory.callPotionSplashEvent((ThrownPotion)this, affected)).isCancelled() && list != null && !list.isEmpty()) {
            Entity entity = this.m_150173_();
            for (org.bukkit.entity.LivingEntity victim : event.getAffectedEntities()) {
                if (!(victim instanceof CraftLivingEntity)) continue;
                LivingEntity livingentity = ((CraftLivingEntity)victim).getHandle();
                d1 = event.getIntensity(victim);
                for (MobEffectInstance mobeffectinstance : p_37548_) {
                    int i;
                    MobEffect mobeffect = mobeffectinstance.m_19544_();
                    if (!this.f_19853_.pvpMode && this.m_37282_() instanceof ServerPlayer && livingentity instanceof ServerPlayer && livingentity != this.m_37282_() && ((i = MobEffect.m_19459_(mobeffect)) == 2 || i == 4 || i == 7 || i == 15 || i == 17 || i == 18 || i == 19)) continue;
                    if (mobeffect.m_8093_()) {
                        mobeffect.m_19461_(this, this.m_37282_(), livingentity, mobeffectinstance.m_19564_(), d1);
                        continue;
                    }
                    i = (int)(d1 * (double)mobeffectinstance.m_19557_() + 0.5);
                    if (i <= 20) continue;
                    livingentity.addEffect(new MobEffectInstance(mobeffect, i, mobeffectinstance.m_19564_(), mobeffectinstance.m_19571_(), mobeffectinstance.m_19572_()), entity, EntityPotionEffectEvent.Cause.POTION_SPLASH);
                }
            }
        }
    }

    private void m_37537_(ItemStack p_37538_, Potion p_37539_) {
        LingeringPotionSplashEvent event;
        AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
        Entity entity = this.m_37282_();
        if (entity instanceof LivingEntity) {
            areaeffectcloud.m_19718_((LivingEntity)entity);
        }
        areaeffectcloud.m_19712_(3.0f);
        areaeffectcloud.m_19732_(-0.5f);
        areaeffectcloud.m_19740_(10);
        areaeffectcloud.m_19738_(-areaeffectcloud.m_19743_() / (float)areaeffectcloud.m_19748_());
        areaeffectcloud.m_19722_(p_37539_);
        for (MobEffectInstance mobeffectinstance : PotionUtils.m_43571_((ItemStack)p_37538_)) {
            areaeffectcloud.m_19716_(new MobEffectInstance(mobeffectinstance));
        }
        CompoundTag compoundtag = p_37538_.m_41783_();
        if (compoundtag != null && compoundtag.m_128425_("CustomPotionColor", 99)) {
            areaeffectcloud.m_19714_(compoundtag.m_128451_("CustomPotionColor"));
        }
        if (!(event = CraftEventFactory.callLingeringPotionSplashEvent((ThrownPotion)this, (AreaEffectCloud)areaeffectcloud)).isCancelled() && !areaeffectcloud.m_213877_()) {
            this.f_19853_.m_7967_(areaeffectcloud);
        } else {
            areaeffectcloud.m_146870_();
        }
    }

    private boolean m_37553_() {
        return this.m_7846_().m_150930_(Items.f_42739_);
    }

    private void m_150192_(BlockPos p_150193_) {
        BlockState blockstate = this.f_19853_.m_8055_(p_150193_);
        if (blockstate.m_204336_(BlockTags.f_13076_)) {
            if (!CraftEventFactory.callEntityChangeBlockEvent((Entity)this, (BlockPos)p_150193_, (BlockState)Blocks.f_50016_.m_49966_()).isCancelled()) {
                this.f_19853_.m_7471_(p_150193_, false);
            }
        } else if (AbstractCandleBlock.m_151933_(blockstate)) {
            if (!CraftEventFactory.callEntityChangeBlockEvent((Entity)this, (BlockPos)p_150193_, (BlockState)((BlockState)((Object)blockstate.m_61124_((Property)AbstractCandleBlock.f_151895_, Boolean.valueOf(false))))).isCancelled()) {
                AbstractCandleBlock.m_151899_(null, blockstate, this.f_19853_, p_150193_);
            }
        } else if (CampfireBlock.m_51319_(blockstate) && !CraftEventFactory.callEntityChangeBlockEvent((Entity)this, (BlockPos)p_150193_, (BlockState)((BlockState)((Object)blockstate.m_61124_((Property)CampfireBlock.f_51227_, Boolean.valueOf(false))))).isCancelled()) {
            this.f_19853_.m_5898_(null, 1009, p_150193_, 0);
            CampfireBlock.m_152749_(this.m_37282_(), this.f_19853_, p_150193_, blockstate);
            this.f_19853_.m_46597_(p_150193_, (BlockState)((Object)blockstate.m_61124_((Property)CampfireBlock.f_51227_, Boolean.valueOf(false))));
        }
    }
}

