/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;

public class CraftingContainer
implements Container,
StackedContentsCompatible {
    private final NonNullList<ItemStack> f_39320_;
    private final int f_39321_;
    private final int f_39322_;
    private final AbstractContainerMenu f_39323_;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private Recipe currentRecipe;
    public Container resultInventory;
    public Player owner;
    private int maxStack = 64;

    @Override
    public List<ItemStack> getContents() {
        return this.f_39320_;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add((HumanEntity)who);
    }

    public InventoryType getInvType() {
        return this.f_39320_.size() == 4 ? InventoryType.CRAFTING : InventoryType.WORKBENCH;
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public InventoryHolder getOwner() {
        return this.owner == null ? null : this.owner.getBukkitEntity();
    }

    public void setOwner(Player owner) {
        this.owner = owner;
    }

    @Override
    public int m_6893_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
        this.resultInventory.setMaxStackSize(size);
    }

    @Override
    public Location getLocation() {
        return this.f_39323_ instanceof CraftingMenu ? ((CraftingMenu)this.f_39323_).f_39350_.getLocation() : this.owner.getBukkitEntity().getLocation();
    }

    @Override
    public Recipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    @Override
    public void setCurrentRecipe(Recipe currentRecipe) {
        this.currentRecipe = currentRecipe;
    }

    public CraftingContainer(AbstractContainerMenu container, int i, int j, Player player) {
        this(container, i, j);
        this.owner = player;
    }

    public CraftingContainer(AbstractContainerMenu p_39325_, int p_39326_, int p_39327_) {
        this.f_39320_ = NonNullList.m_122780_((int)(p_39326_ * p_39327_), (Object)((Object)ItemStack.f_41583_));
        this.f_39323_ = p_39325_;
        this.f_39321_ = p_39326_;
        this.f_39322_ = p_39327_;
    }

    @Override
    public int m_6643_() {
        return this.f_39320_.size();
    }

    @Override
    public boolean m_7983_() {
        for (ItemStack itemstack : this.f_39320_) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack m_8020_(int p_39332_) {
        return p_39332_ >= this.m_6643_() ? ItemStack.f_41583_ : (ItemStack)((Object)this.f_39320_.get(p_39332_));
    }

    @Override
    public ItemStack m_8016_(int p_39344_) {
        return ContainerHelper.m_18966_(this.f_39320_, (int)p_39344_);
    }

    @Override
    public ItemStack m_7407_(int p_39334_, int p_39335_) {
        ItemStack itemstack = ContainerHelper.m_18969_(this.f_39320_, (int)p_39334_, (int)p_39335_);
        if (!itemstack.m_41619_()) {
            this.f_39323_.m_6199_(this);
        }
        return itemstack;
    }

    @Override
    public void m_6836_(int p_39337_, ItemStack p_39338_) {
        this.f_39320_.set(p_39337_, (Object)p_39338_);
        this.f_39323_.m_6199_(this);
    }

    @Override
    public void m_6596_() {
    }

    @Override
    public boolean m_6542_(Player p_39340_) {
        return true;
    }

    public void m_6211_() {
        this.f_39320_.clear();
    }

    public int m_39346_() {
        return this.f_39322_;
    }

    public int m_39347_() {
        return this.f_39321_;
    }

    public void m_5809_(StackedContents p_39342_) {
        for (ItemStack itemstack : this.f_39320_) {
            p_39342_.m_36466_(itemstack);
        }
    }
}

