/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_19_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_19_R1.event.CraftEventFactory;
import org.bukkit.entity.Hanging;
import org.bukkit.event.Event;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.inventory.EquipmentSlot;

public class LeadItem
extends Item {
    public static AtomicReference<InteractionHand> interactionHandAtomicReference = new AtomicReference<InteractionHand>(InteractionHand.MAIN_HAND);

    public LeadItem(Item.Properties p_42828_) {
        super(p_42828_);
    }

    @Override
    public InteractionResult m_6225_(UseOnContext p_42834_) {
        BlockPos blockpos;
        Level level = p_42834_.m_43725_();
        BlockState blockstate = level.m_8055_(blockpos = p_42834_.m_8083_());
        if (blockstate.m_204336_(BlockTags.f_13039_)) {
            Player player = p_42834_.m_43723_();
            if (!level.f_46443_ && player != null) {
                interactionHandAtomicReference.set(p_42834_.m_43724_());
                LeadItem.m_42829_(player, level, blockpos);
            }
            level.m_220407_(GameEvent.f_157791_, blockpos, GameEvent.Context.m_223717_((Entity)player));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult m_42829_(Player p_42830_, Level p_42831_, BlockPos p_42832_) {
        LeashFenceKnotEntity leashfenceknotentity = null;
        boolean flag = false;
        double d0 = 7.0;
        int i = p_42832_.m_123341_();
        int j = p_42832_.m_123342_();
        int k = p_42832_.m_123343_();
        for (Mob mob : p_42831_.m_45976_(Mob.class, new AABB((double)i - 7.0, (double)j - 7.0, (double)k - 7.0, (double)i + 7.0, (double)j + 7.0, (double)k + 7.0))) {
            if (mob.m_21524_() != p_42830_) continue;
            InteractionHand enumhand = interactionHandAtomicReference.getAndSet(InteractionHand.MAIN_HAND);
            if (leashfenceknotentity == null) {
                leashfenceknotentity = LeashFenceKnotEntity.m_31844_((Level)p_42831_, (BlockPos)p_42832_);
                EquipmentSlot hand = CraftEquipmentSlot.getHand((InteractionHand)enumhand);
                HangingPlaceEvent event = new HangingPlaceEvent((Hanging)leashfenceknotentity.getBukkitEntity(), p_42830_ != null ? (org.bukkit.entity.Player)p_42830_.getBukkitEntity() : null, p_42831_.getWorld().getBlockAt(i, j, k), BlockFace.SELF, hand);
                p_42831_.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    leashfenceknotentity.m_146870_();
                    return InteractionResult.PASS;
                }
                leashfenceknotentity.m_7084_();
            }
            if (CraftEventFactory.callPlayerLeashEntityEvent((Mob)mob, (Entity)leashfenceknotentity, (Player)p_42830_, (InteractionHand)enumhand).isCancelled()) continue;
            mob.m_21463_((Entity)leashfenceknotentity, true);
            flag = true;
        }
        return flag ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public static InteractionResult bindPlayerMobs(Player p_42830_, Level p_42831_, BlockPos p_42832_, InteractionHand enumhand) {
        interactionHandAtomicReference.set(enumhand);
        return LeadItem.bindPlayerMobs(p_42830_, p_42831_, p_42832_, InteractionHand.MAIN_HAND);
    }
}

