/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

public class RecipeManager
extends SimpleJsonResourceReloadListener {
    private static final Gson f_44005_ = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger f_44006_ = LogUtils.getLogger();
    public Map<RecipeType<?>, Map<ResourceLocation, Recipe<?>>> f_44007_ = ImmutableMap.of();
    private Map<ResourceLocation, Recipe<?>> f_199900_ = ImmutableMap.of();
    private boolean f_44008_;
    private final ICondition.IContext context;
    public Map<RecipeType<?>, Object2ObjectLinkedOpenHashMap<ResourceLocation, Recipe<?>>> recipesCB = ImmutableMap.of();

    @Deprecated
    public RecipeManager() {
        this(ICondition.IContext.EMPTY);
    }

    public RecipeManager(ICondition.IContext context) {
        super(f_44005_, "recipes");
        this.context = context;
    }

    protected void m_5787_(Map<ResourceLocation, JsonElement> p_44037_, ResourceManager p_44038_, ProfilerFiller p_44039_) {
        this.f_44008_ = false;
        HashMap map1 = Maps.newHashMap();
        Iterator iterator = Registry.f_122864_.iterator();
        while (iterator.hasNext()) {
            RecipeType recipeType = (RecipeType)iterator.next();
            map1.put(recipeType, new Object2ObjectLinkedOpenHashMap());
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, JsonElement> entry : p_44037_.entrySet()) {
            ResourceLocation resourcelocation = entry.getKey();
            if (resourcelocation.m_135815_().startsWith("_")) continue;
            try {
                if (entry.getValue().isJsonObject() && !CraftingHelper.processConditions((JsonObject)entry.getValue().getAsJsonObject(), (String)"conditions", (ICondition.IContext)this.context)) {
                    f_44006_.debug("Skipping loading recipe {} as it's conditions were not met", (Object)resourcelocation);
                    continue;
                }
                Recipe<?> recipe = RecipeManager.fromJson(resourcelocation, GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)"top element"), this.context);
                if (recipe == null) {
                    f_44006_.info("Skipping loading recipe {} as it's serializer returned null", (Object)resourcelocation);
                    continue;
                }
                map1.computeIfAbsent(recipe.m_6671_(), recipes -> new Object2ObjectLinkedOpenHashMap()).putAndMoveToFirst((Object)resourcelocation, recipe);
                builder.put((Object)resourcelocation, recipe);
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                f_44006_.error("Parsing error loading recipe {}", (Object)resourcelocation, (Object)jsonparseexception);
            }
        }
        this.f_44007_ = map1;
        this.recipesCB = map1;
        this.f_199900_ = builder.build();
        f_44006_.info("Loaded {} recipes", (Object)map1.size());
    }

    public boolean m_151269_() {
        return this.f_44008_;
    }

    public <C extends Container, T extends Recipe<C>> Optional<T> m_44015_(RecipeType<T> p_44016_, C p_44017_, Level p_44018_) {
        Optional<Recipe> optional = this.m_44054_(p_44016_).values().stream().filter(recipe -> recipe.m_5818_(p_44017_, p_44018_)).findFirst();
        p_44017_.setCurrentRecipe(optional.orElse(null));
        return optional;
    }

    public <C extends Container, T extends Recipe<C>> Optional<Pair<ResourceLocation, T>> m_220248_(RecipeType<T> p_220249_, C p_220250_, Level p_220251_, @Nullable ResourceLocation p_220252_) {
        Recipe t;
        Map<ResourceLocation, T> map = this.m_44054_(p_220249_);
        if (p_220252_ != null && (t = (Recipe)map.get(p_220252_)) != null && t.m_5818_(p_220250_, p_220251_)) {
            return Optional.of(Pair.of((Object)p_220252_, (Object)t));
        }
        return map.entrySet().stream().filter(p_220245_ -> ((Recipe)p_220245_.getValue()).m_5818_(p_220250_, p_220251_)).findFirst().map(p_220256_ -> Pair.of((Object)((ResourceLocation)p_220256_.getKey()), (Object)((Recipe)p_220256_.getValue())));
    }

    public <C extends Container, T extends Recipe<C>> List<T> m_44013_(RecipeType<T> p_44014_) {
        return List.copyOf(this.m_44054_(p_44014_).values());
    }

    public <C extends Container, T extends Recipe<C>> List<T> m_44056_(RecipeType<T> p_44057_, C p_44058_, Level p_44059_) {
        return this.m_44054_(p_44057_).values().stream().filter(p_220241_ -> p_220241_.m_5818_(p_44058_, p_44059_)).sorted(Comparator.comparing(p_220247_ -> p_220247_.m_8043_().m_41778_())).collect(Collectors.toList());
    }

    private <C extends Container, T extends Recipe<C>> Map<ResourceLocation, T> m_44054_(RecipeType<T> p_44055_) {
        return this.f_44007_.getOrDefault(p_44055_, Collections.emptyMap());
    }

    public <C extends Container, T extends Recipe<C>> NonNullList<ItemStack> m_44069_(RecipeType<T> p_44070_, C p_44071_, Level p_44072_) {
        Optional<T> optional = this.m_44015_(p_44070_, p_44071_, p_44072_);
        if (optional.isPresent()) {
            return ((Recipe)optional.get()).m_7457_(p_44071_);
        }
        NonNullList nonnulllist = NonNullList.m_122780_((int)p_44071_.m_6643_(), (Object)((Object)ItemStack.f_41583_));
        for (int i = 0; i < nonnulllist.size(); ++i) {
            nonnulllist.set(i, (Object)p_44071_.m_8020_(i));
        }
        return nonnulllist;
    }

    public Optional<? extends Recipe<?>> m_44043_(ResourceLocation p_44044_) {
        return Optional.ofNullable(this.f_199900_.get(p_44044_));
    }

    public Collection<Recipe<?>> m_44051_() {
        return this.f_44007_.values().stream().flatMap(p_220270_ -> p_220270_.values().stream()).collect(Collectors.toSet());
    }

    public Stream<ResourceLocation> m_44073_() {
        return this.f_44007_.values().stream().flatMap(p_220258_ -> p_220258_.keySet().stream());
    }

    @Deprecated
    public static Recipe<?> m_44045_(ResourceLocation p_44046_, JsonObject p_44047_) {
        return RecipeManager.fromJson(p_44046_, p_44047_, ICondition.IContext.EMPTY);
    }

    public static Recipe<?> fromJson(ResourceLocation p_44046_, JsonObject p_44047_, ICondition.IContext context) {
        String s = GsonHelper.m_13906_((JsonObject)p_44047_, (String)"type");
        return Registry.f_122865_.m_6612_(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Invalid or unsupported recipe type '" + s + "'")).fromJson(p_44046_, p_44047_, context);
    }

    public void m_44024_(Iterable<Recipe<?>> p_44025_) {
        this.f_44008_ = false;
        HashMap map = Maps.newHashMap();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        p_44025_.forEach(p_220262_ -> {
            Map map1 = map.computeIfAbsent(p_220262_.m_6671_(), p_220272_ -> Maps.newHashMap());
            ResourceLocation resourcelocation = p_220262_.m_6423_();
            Recipe recipe = map1.put(resourcelocation, p_220262_);
            builder.put((Object)resourcelocation, p_220262_);
            if (recipe != null) {
                throw new IllegalStateException("Duplicate recipe ignored with ID " + resourcelocation);
            }
        });
        this.f_44007_ = ImmutableMap.copyOf((Map)map);
        this.f_199900_ = builder.build();
    }

    public static <C extends Container, T extends Recipe<C>> CachedCheck<C, T> m_220267_(final RecipeType<T> p_220268_) {
        return new CachedCheck<C, T>(){
            @Nullable
            private ResourceLocation f_220274_;

            @Override
            public Optional<T> m_213657_(C p_220278_, Level p_220279_) {
                RecipeManager recipemanager = p_220279_.m_7465_();
                Optional optional = recipemanager.m_220248_(p_220268_, p_220278_, p_220279_, this.f_220274_);
                if (optional.isPresent()) {
                    Pair pair = optional.get();
                    this.f_220274_ = (ResourceLocation)pair.getFirst();
                    return Optional.of((Recipe)pair.getSecond());
                }
                return Optional.empty();
            }
        };
    }

    public void addRecipe(Recipe<?> irecipe) {
        Object2ObjectLinkedOpenHashMap map0;
        Map<ResourceLocation, Recipe<?>> map = this.f_44007_.get(irecipe.m_6671_());
        if (!(map instanceof Object2ObjectLinkedOpenHashMap)) {
            Object2ObjectLinkedOpenHashMap hashMap = new Object2ObjectLinkedOpenHashMap();
            hashMap.putAll(map);
            if (this.f_44007_ instanceof ImmutableMap) {
                this.f_44007_ = new HashMap(this.f_44007_);
            }
            this.f_44007_.put(irecipe.m_6671_(), (Map<ResourceLocation, Recipe<?>>)hashMap);
            map0 = hashMap;
        } else {
            map0 = (Object2ObjectLinkedOpenHashMap)map;
        }
        Object2ObjectLinkedOpenHashMap<ResourceLocation, Recipe<?>> craftbukkit = this.recipesCB.get(irecipe.m_6671_());
        if (this.f_199900_.containsKey(irecipe.m_6423_()) || map0.containsKey((Object)irecipe.m_6423_()) || craftbukkit.containsKey((Object)irecipe.m_6423_())) {
            throw new IllegalStateException("Duplicate recipe ignored with ID " + irecipe.m_6423_());
        }
        if (this.f_199900_ instanceof ImmutableMap) {
            this.f_199900_ = new HashMap(this.f_199900_);
        }
        map0.putAndMoveToFirst((Object)irecipe.m_6423_(), irecipe);
        craftbukkit.putAndMoveToFirst((Object)irecipe.m_6423_(), irecipe);
        this.f_199900_.put(irecipe.m_6423_(), irecipe);
    }

    public void clearRecipes() {
        this.f_44007_ = Maps.newHashMap();
        for (RecipeType recipeType : ForgeRegistries.RECIPE_TYPES) {
            this.f_44007_.put(recipeType, (Map<ResourceLocation, Recipe<?>>)ImmutableMap.of());
        }
        this.recipesCB = Maps.newHashMap();
        Iterator iterator = Registry.f_122864_.iterator();
        while (iterator.hasNext()) {
            RecipeType recipeType;
            recipeType = (RecipeType)iterator.next();
            this.recipesCB.put(recipeType, new Object2ObjectLinkedOpenHashMap());
        }
        this.f_199900_ = new HashMap();
    }

    public boolean removeRecipe(ResourceLocation mcKey) {
        for (Map<ResourceLocation, Recipe<?>> map : this.f_44007_.values()) {
            map.remove(mcKey);
        }
        for (Object2ObjectLinkedOpenHashMap object2ObjectLinkedOpenHashMap : this.recipesCB.values()) {
            object2ObjectLinkedOpenHashMap.remove((Object)mcKey);
        }
        return this.f_199900_.remove(mcKey) != null;
    }

    public static interface CachedCheck<C extends Container, T extends Recipe<C>> {
        public Optional<T> m_213657_(C var1, Level var2);
    }
}

