/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public class FlatLevelSource
extends ChunkGenerator {
    public static final Codec<FlatLevelSource> f_64164_ = RecordCodecBuilder.create(p_204551_ -> FlatLevelSource.m_208005_(p_204551_).and((App)FlatLevelGeneratorSettings.f_70347_.fieldOf("settings").forGetter(FlatLevelSource::m_64191_)).apply((Applicative)p_204551_, p_204551_.stable(FlatLevelSource::new)));
    private final FlatLevelGeneratorSettings f_64165_;

    public FlatLevelSource(Registry<StructureSet> p_209099_, FlatLevelGeneratorSettings p_209100_) {
        super(p_209099_, p_209100_.m_209810_(), (BiomeSource)new FixedBiomeSource(p_209100_.m_204921_()), Util.m_143827_(arg_0 -> ((FlatLevelGeneratorSettings)p_209100_).m_226294_(arg_0)));
        this.f_64165_ = p_209100_;
    }

    public FlatLevelSource(Registry<StructureSet> iregistry, FlatLevelGeneratorSettings generatorsettingsflat, BiomeSource worldchunkmanager) {
        super(iregistry, generatorsettingsflat.m_209810_(), worldchunkmanager, Util.m_143827_(arg_0 -> ((FlatLevelGeneratorSettings)generatorsettingsflat).m_226294_(arg_0)));
        this.f_64165_ = generatorsettingsflat;
    }

    @Override
    protected Codec<? extends ChunkGenerator> m_6909_() {
        return f_64164_;
    }

    public FlatLevelGeneratorSettings m_64191_() {
        return this.f_64165_;
    }

    @Override
    public void m_214194_(WorldGenRegion p_224174_, StructureManager p_224175_, RandomState p_224176_, ChunkAccess p_224177_) {
    }

    @Override
    public int m_142051_(LevelHeightAccessor p_158279_) {
        return p_158279_.m_141937_() + Math.min(p_158279_.m_141928_(), this.f_64165_.m_161917_().size());
    }

    @Override
    public CompletableFuture<ChunkAccess> m_213974_(Executor p_224183_, Blender p_224184_, RandomState p_224185_, StructureManager p_224186_, ChunkAccess p_224187_) {
        List list = this.f_64165_.m_161917_();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        Heightmap heightmap = p_224187_.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap heightmap1 = p_224187_.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        for (int i = 0; i < Math.min(p_224187_.m_141928_(), list.size()); ++i) {
            BlockState blockstate = (BlockState)((Object)list.get(i));
            if (blockstate == null) continue;
            int j = p_224187_.m_141937_() + i;
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    p_224187_.m_6978_((BlockPos)blockpos$mutableblockpos.m_122178_(k, j, l), blockstate, false);
                    heightmap.m_64249_(k, j, l, blockstate);
                    heightmap1.m_64249_(k, j, l, blockstate);
                }
            }
        }
        return CompletableFuture.completedFuture(p_224187_);
    }

    @Override
    public int m_214096_(int p_224160_, int p_224161_, Heightmap.Types p_224162_, LevelHeightAccessor p_224163_, RandomState p_224164_) {
        List list = this.f_64165_.m_161917_();
        for (int i = Math.min(list.size(), p_224163_.m_151558_()) - 1; i >= 0; --i) {
            BlockState blockstate = (BlockState)((Object)list.get(i));
            if (blockstate == null || !p_224162_.m_64299_().test(blockstate)) continue;
            return p_224163_.m_141937_() + i + 1;
        }
        return p_224163_.m_141937_();
    }

    @Override
    public NoiseColumn m_214184_(int p_224155_, int p_224156_, LevelHeightAccessor p_224157_, RandomState p_224158_) {
        return new NoiseColumn(p_224157_.m_141937_(), (BlockState[])this.f_64165_.m_161917_().stream().limit(p_224157_.m_141928_()).map(p_204549_ -> p_204549_ == null ? Blocks.f_50016_.m_49966_() : p_204549_).toArray(BlockState[]::new));
    }

    @Override
    public void m_213600_(List<String> p_224179_, RandomState p_224180_, BlockPos p_224181_) {
    }

    @Override
    public void m_213679_(WorldGenRegion p_224166_, long p_224167_, RandomState p_224168_, BiomeManager p_224169_, StructureManager p_224170_, ChunkAccess p_224171_, GenerationStep.Carving p_224172_) {
    }

    @Override
    public void m_6929_(WorldGenRegion p_188545_) {
    }

    @Override
    public int m_142062_() {
        return 0;
    }

    @Override
    public int m_6331_() {
        return 384;
    }

    @Override
    public int m_6337_() {
        return -63;
    }
}

