/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.apache.commons.lang3.mutable.MutableObject;

public class NoiseBasedChunkGenerator
extends ChunkGenerator {
    public static final Codec<NoiseBasedChunkGenerator> f_64314_ = RecordCodecBuilder.create(p_224323_ -> NoiseBasedChunkGenerator.m_208005_(p_224323_).and(p_224323_.group((App)RegistryOps.m_206832_(Registry.f_194568_).forGetter(p_188716_ -> p_188716_.f_188604_), (App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(p_188711_ -> p_188711_.f_62137_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(p_224278_ -> p_224278_.f_64318_))).apply((Applicative)p_224323_, p_224323_.stable(NoiseBasedChunkGenerator::new)));
    private static final BlockState f_64321_ = Blocks.f_50016_.m_49966_();
    protected final BlockState f_64316_;
    public final Registry<NormalNoise.NoiseParameters> f_188604_;
    public final Holder<NoiseGeneratorSettings> f_64318_;
    private final Aquifer.FluidPicker f_188607_;

    public NoiseBasedChunkGenerator(Registry<StructureSet> p_224206_, Registry<NormalNoise.NoiseParameters> p_224207_, BiomeSource p_224208_, Holder<NoiseGeneratorSettings> p_224209_) {
        super(p_224206_, Optional.empty(), p_224208_);
        this.f_188604_ = p_224207_;
        this.f_64318_ = p_224209_;
        NoiseGeneratorSettings noisegeneratorsettings = this.f_64318_.m_203334_();
        this.f_64316_ = noisegeneratorsettings.f_64440_();
        Aquifer.FluidStatus aquifer$fluidstatus = new Aquifer.FluidStatus(-54, Blocks.f_49991_.m_49966_());
        int i = noisegeneratorsettings.f_64444_();
        Aquifer.FluidStatus aquifer$fluidstatus1 = new Aquifer.FluidStatus(i, noisegeneratorsettings.f_64441_());
        Aquifer.FluidStatus aquifer$fluidstatus2 = new Aquifer.FluidStatus(DimensionType.f_156653_ * 2, Blocks.f_50016_.m_49966_());
        this.f_188607_ = (p_224274_, p_224275_, p_224276_) -> p_224275_ < Math.min(-54, i) ? aquifer$fluidstatus : aquifer$fluidstatus1;
    }

    @Override
    public CompletableFuture<ChunkAccess> m_213908_(Registry<Biome> p_224297_, Executor p_224298_, RandomState p_224299_, Blender p_224300_, StructureManager p_224301_, ChunkAccess p_224302_) {
        return CompletableFuture.supplyAsync(Util.m_183946_("init_biomes", () -> {
            this.m_224291_(p_224300_, p_224299_, p_224301_, p_224302_);
            return p_224302_;
        }), Util.m_183991_());
    }

    private void m_224291_(Blender p_224292_, RandomState p_224293_, StructureManager p_224294_, ChunkAccess p_224295_) {
        NoiseChunk noisechunk = p_224295_.m_223012_(p_224340_ -> this.m_224256_((ChunkAccess)p_224340_, p_224294_, p_224292_, p_224293_));
        BiomeResolver biomeresolver = BelowZeroRetrogen.m_204531_((BiomeResolver)p_224292_.m_183383_((BiomeResolver)this.f_62137_), (ChunkAccess)p_224295_);
        p_224295_.m_183442_(biomeresolver, noisechunk.m_224359_(p_224293_.m_224578_(), this.f_64318_.m_203334_().f_224370_()));
    }

    private NoiseChunk m_224256_(ChunkAccess p_224257_, StructureManager p_224258_, Blender p_224259_, RandomState p_224260_) {
        return NoiseChunk.m_224352_((ChunkAccess)p_224257_, (RandomState)p_224260_, (DensityFunctions.BeardifierOrMarker)Beardifier.m_223937_(p_224258_, p_224257_.m_7697_()), (NoiseGeneratorSettings)this.f_64318_.m_203334_(), (Aquifer.FluidPicker)this.f_188607_, (Blender)p_224259_);
    }

    @Override
    protected Codec<? extends ChunkGenerator> m_6909_() {
        return f_64314_;
    }

    public Holder<NoiseGeneratorSettings> m_224341_() {
        return this.f_64318_;
    }

    public boolean m_224221_(ResourceKey<NoiseGeneratorSettings> p_224222_) {
        return this.f_64318_.m_203565_(p_224222_);
    }

    @Override
    public int m_214096_(int p_224216_, int p_224217_, Heightmap.Types p_224218_, LevelHeightAccessor p_224219_, RandomState p_224220_) {
        return this.m_224239_(p_224219_, p_224220_, p_224216_, p_224217_, (MutableObject<NoiseColumn>)((MutableObject)null), p_224218_.m_64299_()).orElse(p_224219_.m_141937_());
    }

    @Override
    public NoiseColumn m_214184_(int p_224211_, int p_224212_, LevelHeightAccessor p_224213_, RandomState p_224214_) {
        MutableObject mutableobject = new MutableObject();
        this.m_224239_(p_224213_, p_224214_, p_224211_, p_224212_, (MutableObject<NoiseColumn>)mutableobject, null);
        return (NoiseColumn)mutableobject.getValue();
    }

    @Override
    public void m_213600_(List<String> p_224304_, RandomState p_224305_, BlockPos p_224306_) {
        DecimalFormat decimalformat = new DecimalFormat("0.000");
        NoiseRouter noiserouter = p_224305_.m_224578_();
        DensityFunction.SinglePointContext densityfunction$singlepointcontext = new DensityFunction.SinglePointContext(p_224306_.m_123341_(), p_224306_.m_123342_(), p_224306_.m_123343_());
        double d0 = noiserouter.f_209389_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext);
        p_224304_.add("NoiseRouter T: " + decimalformat.format(noiserouter.f_209384_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " V: " + decimalformat.format(noiserouter.f_224392_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " C: " + decimalformat.format(noiserouter.f_209386_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " E: " + decimalformat.format(noiserouter.f_209387_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " D: " + decimalformat.format(noiserouter.f_209388_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " W: " + decimalformat.format(d0) + " PV: " + decimalformat.format(NoiseRouterData.m_224435_((float)((float)d0))) + " AS: " + decimalformat.format(noiserouter.f_209390_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " N: " + decimalformat.format(noiserouter.f_209391_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)));
    }

    protected OptionalInt m_224239_(LevelHeightAccessor p_224240_, RandomState p_224241_, int p_224242_, int p_224243_, @Nullable MutableObject<NoiseColumn> p_224244_, @Nullable Predicate<BlockState> p_224245_) {
        BlockState[] ablockstate;
        NoiseSettings noisesettings = this.f_64318_.m_203334_().f_64439_().m_224530_(p_224240_);
        int i = noisesettings.m_189212_();
        int j = noisesettings.f_158688_();
        int k = Mth.m_14042_((int)j, (int)i);
        int l = Mth.m_14042_((int)noisesettings.f_64508_(), (int)i);
        if (l <= 0) {
            return OptionalInt.empty();
        }
        if (p_224244_ == null) {
            ablockstate = null;
        } else {
            ablockstate = new BlockState[noisesettings.f_64508_()];
            p_224244_.setValue((Object)new NoiseColumn(j, ablockstate));
        }
        int i1 = noisesettings.m_189213_();
        int j1 = Math.floorDiv(p_224242_, i1);
        int k1 = Math.floorDiv(p_224243_, i1);
        int l1 = Math.floorMod(p_224242_, i1);
        int i2 = Math.floorMod(p_224243_, i1);
        int j2 = j1 * i1;
        int k2 = k1 * i1;
        double d0 = (double)l1 / (double)i1;
        double d1 = (double)i2 / (double)i1;
        NoiseChunk noisechunk = new NoiseChunk(1, p_224241_, j2, k2, noisesettings, (DensityFunctions.BeardifierOrMarker)DensityFunctions.BeardifierMarker.INSTANCE, this.f_64318_.m_203334_(), this.f_188607_, Blender.m_190153_());
        noisechunk.m_188791_();
        noisechunk.m_188749_(0);
        for (int l2 = l - 1; l2 >= 0; --l2) {
            noisechunk.m_188810_(l2, 0);
            for (int i3 = i - 1; i3 >= 0; --i3) {
                BlockState blockstate1;
                int j3 = (k + l2) * i + i3;
                double d2 = (double)i3 / (double)i;
                noisechunk.m_209191_(j3, d2);
                noisechunk.m_209230_(p_224242_, d0);
                noisechunk.m_209241_(p_224243_, d1);
                BlockState blockstate = noisechunk.m_209247_();
                BlockState blockState = blockstate1 = blockstate == null ? this.f_64316_ : blockstate;
                if (ablockstate != null) {
                    int k3 = l2 * i + i3;
                    ablockstate[k3] = blockstate1;
                }
                if (p_224245_ == null || !p_224245_.test(blockstate1)) continue;
                noisechunk.m_209248_();
                return OptionalInt.of(j3 + 1);
            }
        }
        noisechunk.m_209248_();
        return OptionalInt.empty();
    }

    @Override
    public void m_214194_(WorldGenRegion p_224232_, StructureManager p_224233_, RandomState p_224234_, ChunkAccess p_224235_) {
        if (!SharedConstants.m_183707_(p_224235_.m_7697_())) {
            WorldGenerationContext worldgenerationcontext = new WorldGenerationContext((ChunkGenerator)this, (LevelHeightAccessor)p_224232_);
            this.m_224261_(p_224235_, worldgenerationcontext, p_224234_, p_224233_, p_224232_.m_7062_(), p_224232_.m_5962_().m_175515_(Registry.f_122885_), Blender.m_190202_((WorldGenRegion)p_224232_));
        }
    }

    @VisibleForTesting
    public void m_224261_(ChunkAccess p_224262_, WorldGenerationContext p_224263_, RandomState p_224264_, StructureManager p_224265_, BiomeManager p_224266_, Registry<Biome> p_224267_, Blender p_224268_) {
        NoiseChunk noisechunk = p_224262_.m_223012_(p_224321_ -> this.m_224256_((ChunkAccess)p_224321_, p_224265_, p_224268_, p_224264_));
        NoiseGeneratorSettings noisegeneratorsettings = this.f_64318_.m_203334_();
        p_224264_.m_224580_().m_224648_(p_224264_, p_224266_, p_224267_, noisegeneratorsettings.f_209354_(), p_224263_, p_224262_, noisechunk, noisegeneratorsettings.f_188871_());
    }

    @Override
    public void m_213679_(WorldGenRegion p_224224_, long p_224225_, RandomState p_224226_, BiomeManager p_224227_, StructureManager p_224228_, ChunkAccess p_224229_, GenerationStep.Carving p_224230_) {
        BiomeManager biomemanager = p_224227_.m_186687_((p_224281_, p_224282_, p_224283_) -> this.f_62137_.m_203407_(p_224281_, p_224282_, p_224283_, p_224226_.m_224579_()));
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(RandomSupport.m_224599_()));
        int i = 8;
        ChunkPos chunkpos = p_224229_.m_7697_();
        NoiseChunk noisechunk = p_224229_.m_223012_(p_224250_ -> this.m_224256_((ChunkAccess)p_224250_, p_224228_, Blender.m_190202_((WorldGenRegion)p_224224_), p_224226_));
        Aquifer aquifer = noisechunk.m_188817_();
        CarvingContext carvingcontext = new CarvingContext(this, p_224224_.m_5962_(), p_224229_.m_183618_(), noisechunk, p_224226_, this.f_64318_.m_203334_().f_188871_());
        CarvingMask carvingmask = ((ProtoChunk)p_224229_).m_183613_(p_224230_);
        for (int j = -8; j <= 8; ++j) {
            for (int k = -8; k <= 8; ++k) {
                ChunkPos chunkpos1 = new ChunkPos(chunkpos.f_45578_ + j, chunkpos.f_45579_ + k);
                ChunkAccess chunkaccess = p_224224_.m_6325_(chunkpos1.f_45578_, chunkpos1.f_45579_);
                BiomeGenerationSettings biomegenerationsettings = chunkaccess.m_223014_(() -> this.m_223131_(this.f_62137_.m_203407_(QuartPos.m_175400_((int)chunkpos1.m_45604_()), 0, QuartPos.m_175400_((int)chunkpos1.m_45605_()), p_224226_.m_224579_())));
                Iterable<Holder<ConfiguredWorldCarver<?>>> iterable = biomegenerationsettings.m_204187_(p_224230_);
                int l = 0;
                for (Holder<ConfiguredWorldCarver<?>> holder : iterable) {
                    ConfiguredWorldCarver<?> configuredworldcarver = holder.m_203334_();
                    worldgenrandom.m_190068_(p_224225_ + (long)l, chunkpos1.f_45578_, chunkpos1.f_45579_);
                    if (configuredworldcarver.m_224896_((RandomSource)worldgenrandom)) {
                        configuredworldcarver.m_224898_(carvingcontext, p_224229_, arg_0 -> ((BiomeManager)biomemanager).m_204214_(arg_0), (RandomSource)worldgenrandom, aquifer, chunkpos1, carvingmask);
                    }
                    ++l;
                }
            }
        }
    }

    @Override
    public CompletableFuture<ChunkAccess> m_213974_(Executor p_224312_, Blender p_224313_, RandomState p_224314_, StructureManager p_224315_, ChunkAccess p_224316_) {
        NoiseSettings noisesettings = this.f_64318_.m_203334_().f_64439_().m_224530_(p_224316_.m_183618_());
        int i = noisesettings.f_158688_();
        int j = Mth.m_14042_((int)i, (int)noisesettings.m_189212_());
        int k = Mth.m_14042_((int)noisesettings.f_64508_(), (int)noisesettings.m_189212_());
        if (k <= 0) {
            return CompletableFuture.completedFuture(p_224316_);
        }
        int l = p_224316_.m_151564_(k * noisesettings.m_189212_() - 1 + i);
        int i1 = p_224316_.m_151564_(i);
        HashSet set = Sets.newHashSet();
        for (int j1 = l; j1 >= i1; --j1) {
            LevelChunkSection levelchunksection = p_224316_.m_183278_(j1);
            levelchunksection.m_62981_();
            set.add(levelchunksection);
        }
        return CompletableFuture.supplyAsync(Util.m_183946_("wgen_fill_noise", () -> this.m_224284_(p_224313_, p_224315_, p_224314_, p_224316_, j, k)), Util.m_183991_()).whenCompleteAsync((p_224309_, p_224310_) -> {
            for (LevelChunkSection levelchunksection1 : set) {
                levelchunksection1.m_63006_();
            }
        }, p_224312_);
    }

    private ChunkAccess m_224284_(Blender p_224285_, StructureManager p_224286_, RandomState p_224287_, ChunkAccess p_224288_, int p_224289_, int p_224290_) {
        NoiseChunk noisechunk = p_224288_.m_223012_(p_224255_ -> this.m_224256_((ChunkAccess)p_224255_, p_224286_, p_224285_, p_224287_));
        Heightmap heightmap = p_224288_.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap heightmap1 = p_224288_.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        ChunkPos chunkpos = p_224288_.m_7697_();
        int i = chunkpos.m_45604_();
        int j = chunkpos.m_45605_();
        Aquifer aquifer = noisechunk.m_188817_();
        noisechunk.m_188791_();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int k = noisechunk.m_224362_();
        int l = noisechunk.m_224363_();
        int i1 = 16 / k;
        int j1 = 16 / k;
        for (int k1 = 0; k1 < i1; ++k1) {
            noisechunk.m_188749_(k1);
            for (int l1 = 0; l1 < j1; ++l1) {
                LevelChunkSection levelchunksection = p_224288_.m_183278_(p_224288_.m_151559_() - 1);
                for (int i2 = p_224290_ - 1; i2 >= 0; --i2) {
                    noisechunk.m_188810_(i2, l1);
                    for (int j2 = l - 1; j2 >= 0; --j2) {
                        int k2 = (p_224289_ + i2) * l + j2;
                        int l2 = k2 & 0xF;
                        int i3 = p_224288_.m_151564_(k2);
                        if (p_224288_.m_151564_(levelchunksection.m_63017_()) != i3) {
                            levelchunksection = p_224288_.m_183278_(i3);
                        }
                        double d0 = (double)j2 / (double)l;
                        noisechunk.m_209191_(k2, d0);
                        for (int j3 = 0; j3 < k; ++j3) {
                            int k3 = i + k1 * k + j3;
                            int l3 = k3 & 0xF;
                            double d1 = (double)j3 / (double)k;
                            noisechunk.m_209230_(k3, d1);
                            for (int i4 = 0; i4 < k; ++i4) {
                                int j4 = j + l1 * k + i4;
                                int k4 = j4 & 0xF;
                                double d2 = (double)i4 / (double)k;
                                noisechunk.m_209241_(j4, d2);
                                BlockState blockstate = noisechunk.m_209247_();
                                if (blockstate == null) {
                                    blockstate = this.f_64316_;
                                }
                                if ((blockstate = this.m_198231_(noisechunk, k3, k2, j4, blockstate)) == f_64321_ || SharedConstants.m_183707_(p_224288_.m_7697_())) continue;
                                if (blockstate.m_60791_() != 0 && p_224288_ instanceof ProtoChunk) {
                                    blockpos$mutableblockpos.m_122178_(k3, k2, j4);
                                    ((ProtoChunk)p_224288_).m_63277_((BlockPos)blockpos$mutableblockpos);
                                }
                                levelchunksection.m_62991_(l3, l2, k4, blockstate, false);
                                heightmap.m_64249_(l3, k2, k4, blockstate);
                                heightmap1.m_64249_(l3, k2, k4, blockstate);
                                if (!aquifer.m_142203_() || blockstate.m_60819_().m_76178_()) continue;
                                blockpos$mutableblockpos.m_122178_(k3, k2, j4);
                                p_224288_.m_8113_((BlockPos)blockpos$mutableblockpos);
                            }
                        }
                    }
                }
            }
            noisechunk.m_188804_();
        }
        noisechunk.m_209248_();
        return p_224288_;
    }

    private BlockState m_198231_(NoiseChunk p_198232_, int p_198233_, int p_198234_, int p_198235_, BlockState p_198236_) {
        return p_198236_;
    }

    @Override
    public int m_6331_() {
        return this.f_64318_.m_203334_().f_64439_().f_64508_();
    }

    @Override
    public int m_6337_() {
        return this.f_64318_.m_203334_().f_64444_();
    }

    @Override
    public int m_142062_() {
        return this.f_64318_.m_203334_().f_64439_().f_158688_();
    }

    @Override
    public void m_6929_(WorldGenRegion p_64379_) {
        if (!this.f_64318_.m_203334_().f_64445_()) {
            ChunkPos chunkpos = p_64379_.m_143488_();
            Holder holder = p_64379_.m_204166_(chunkpos.m_45615_().m_175288_(p_64379_.m_151558_() - 1));
            WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(RandomSupport.m_224599_()));
            worldgenrandom.m_64690_(p_64379_.m_7328_(), chunkpos.m_45604_(), chunkpos.m_45605_());
            NaturalSpawner.m_220450_((ServerLevelAccessor)((Object)p_64379_), holder, chunkpos, (RandomSource)worldgenrandom);
        }
    }
}

