/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.nbt.visitors.SkipFields;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.DirectoryLock;
import net.minecraft.util.MemoryReserve;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.PlayerDataStorage;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraftforge.common.ForgeHooks;
import org.slf4j.Logger;

public class LevelStorageSource {
    static final Logger f_78191_ = LogUtils.getLogger();
    static final DateTimeFormatter f_78192_ = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('_').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral('-').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral('-').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    private static final ImmutableList<String> f_78193_ = ImmutableList.of((Object)"RandomSeed", (Object)"generatorName", (Object)"generatorOptions", (Object)"generatorVersion", (Object)"legacy_custom_options", (Object)"MapFeatures", (Object)"BonusChest");
    private static final String f_202311_ = "Data";
    final Path f_78194_;
    private final Path f_78195_;
    final DataFixer f_78196_;

    public LevelStorageSource(Path p_78199_, Path p_78200_, DataFixer p_78201_) {
        this.f_78196_ = p_78201_;
        try {
            Files.createDirectories(Files.exists(p_78199_, new LinkOption[0]) ? p_78199_.toRealPath(new LinkOption[0]) : p_78199_, new FileAttribute[0]);
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
        this.f_78194_ = p_78199_;
        this.f_78195_ = p_78200_;
    }

    public static LevelStorageSource m_78242_(Path p_78243_) {
        return new LevelStorageSource(p_78243_, p_78243_.resolve("../backups"), DataFixers.m_14512_());
    }

    private static <T> Pair<WorldGenSettings, Lifecycle> m_78204_(Dynamic<T> p_78205_, DataFixer p_78206_, int p_78207_) {
        Dynamic dynamic = p_78205_.get("WorldGenSettings").orElseEmptyMap();
        for (String s : f_78193_) {
            Optional optional = p_78205_.get(s).result();
            if (!optional.isPresent()) continue;
            dynamic = dynamic.set(s, (Dynamic)optional.get());
        }
        Dynamic dynamic1 = p_78206_.update(References.f_16795_, dynamic, p_78207_, SharedConstants.m_183709_().getWorldVersion());
        DynamicOps dynamicOps = p_78205_.getOps();
        if (dynamicOps instanceof RegistryOps) {
            RegistryOps ops = (RegistryOps)dynamicOps;
            ops.f_206806_.m_203610_().forEach(e -> e.f_206234_().m_203521_());
        }
        DataResult dataresult = WorldGenSettings.f_64600_.parse(dynamic1);
        return Pair.of((Object)dataresult.resultOrPartial(Util.m_137489_("WorldGenSettings: ", arg_0 -> ((Logger)f_78191_).error(arg_0))).orElseGet(() -> {
            RegistryAccess registryaccess = RegistryAccess.m_206154_(dynamic1);
            return WorldPresets.m_226449_((RegistryAccess)registryaccess);
        }), (Object)dataresult.lifecycle());
    }

    private static DataPackConfig m_78202_(Dynamic<?> p_78203_) {
        return DataPackConfig.f_45843_.parse(p_78203_).resultOrPartial(arg_0 -> ((Logger)f_78191_).error(arg_0)).orElse(DataPackConfig.f_45842_);
    }

    public String m_164909_() {
        return "Anvil";
    }

    public LevelCandidates m_230833_() throws LevelStorageException {
        if (!Files.isDirectory(this.f_78194_, new LinkOption[0])) {
            throw new LevelStorageException((Component)Component.m_237115_("selectWorld.load_folder_access"));
        }
        try {
            List<LevelDirectory> list = Files.list(this.f_78194_).filter(p_230839_ -> Files.isDirectory(p_230839_, new LinkOption[0])).map(LevelDirectory::new).filter(p_230835_ -> Files.isRegularFile(p_230835_.m_230858_(), new LinkOption[0]) || Files.isRegularFile(p_230835_.m_230859_(), new LinkOption[0])).toList();
            return new LevelCandidates(list);
        }
        catch (IOException ioexception) {
            throw new LevelStorageException((Component)Component.m_237115_("selectWorld.load_folder_access"));
        }
    }

    public CompletableFuture<List<LevelSummary>> m_230813_(LevelCandidates p_230814_) {
        ArrayList<CompletableFuture<LevelSummary>> list = new ArrayList<CompletableFuture<LevelSummary>>(p_230814_.f_230840_.size());
        for (LevelDirectory levelstoragesource$leveldirectory : p_230814_.f_230840_) {
            list.add(CompletableFuture.supplyAsync(() -> {
                boolean flag;
                try {
                    flag = DirectoryLock.m_13642_((Path)levelstoragesource$leveldirectory.f_230850_());
                }
                catch (Exception exception) {
                    f_78191_.warn("Failed to read {} lock", (Object)levelstoragesource$leveldirectory.f_230850_(), (Object)exception);
                    return null;
                }
                try {
                    LevelSummary levelsummary = this.m_230817_(levelstoragesource$leveldirectory, this.m_230820_(levelstoragesource$leveldirectory, flag));
                    return levelsummary != null ? levelsummary : null;
                }
                catch (OutOfMemoryError outofmemoryerror) {
                    MemoryReserve.m_182328_();
                    System.gc();
                    f_78191_.error(LogUtils.FATAL_MARKER, "Ran out of memory trying to read summary of {}", (Object)levelstoragesource$leveldirectory.m_230853_());
                    throw outofmemoryerror;
                }
                catch (StackOverflowError stackoverflowerror) {
                    f_78191_.error(LogUtils.FATAL_MARKER, "Ran out of stack trying to read summary of {}. Assuming corruption; attempting to restore from from level.dat_old.", (Object)levelstoragesource$leveldirectory.m_230853_());
                    Util.m_212229_(levelstoragesource$leveldirectory.m_230858_(), levelstoragesource$leveldirectory.m_230859_(), levelstoragesource$leveldirectory.m_230856_(LocalDateTime.now()), true);
                    throw stackoverflowerror;
                }
            }, Util.m_183991_()));
        }
        return Util.m_214684_(list).thenApply(p_230832_ -> p_230832_.stream().filter(Objects::nonNull).sorted().toList());
    }

    private int m_78265_() {
        return 19133;
    }

    @Nullable
    <T> T m_230817_(LevelDirectory p_230818_, BiFunction<Path, DataFixer, T> p_230819_) {
        T t;
        if (!Files.exists(p_230818_.f_230850_(), new LinkOption[0])) {
            return null;
        }
        Path path = p_230818_.m_230858_();
        if (Files.exists(path, new LinkOption[0]) && (t = p_230819_.apply(path, this.f_78196_)) != null) {
            return t;
        }
        path = p_230818_.m_230859_();
        return Files.exists(path, new LinkOption[0]) ? (T)p_230819_.apply(path, this.f_78196_) : null;
    }

    @Nullable
    private static DataPackConfig m_230828_(Path p_230829_, DataFixer p_230830_) {
        try {
            Tag tag = LevelStorageSource.m_230836_(p_230829_);
            if (tag instanceof CompoundTag) {
                CompoundTag compoundtag = (CompoundTag)tag;
                CompoundTag compoundtag1 = compoundtag.m_128469_(f_202311_);
                int i = compoundtag1.m_128425_("DataVersion", 99) ? compoundtag1.m_128451_("DataVersion") : -1;
                Dynamic dynamic = p_230830_.update(DataFixTypes.LEVEL.m_14504_(), new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)compoundtag1), i, SharedConstants.m_183709_().getWorldVersion());
                return dynamic.get("DataPacks").result().map(LevelStorageSource::m_78202_).orElse(DataPackConfig.f_45842_);
            }
        }
        catch (Exception exception) {
            f_78191_.error("Exception reading {}", (Object)p_230829_, (Object)exception);
        }
        return null;
    }

    static BiFunction<Path, DataFixer, PrimaryLevelData> m_211737_(DynamicOps<Tag> p_211738_, DataPackConfig p_211739_, Lifecycle p_211740_) {
        return (p_230811_, p_230812_) -> {
            try {
                CompoundTag compoundtag = NbtIo.m_128937_(p_230811_.toFile());
                CompoundTag compoundtag1 = compoundtag.m_128469_(f_202311_);
                CompoundTag compoundtag2 = compoundtag1.m_128425_("Player", 10) ? compoundtag1.m_128469_("Player") : null;
                compoundtag1.m_128473_("Player");
                int i = compoundtag1.m_128425_("DataVersion", 99) ? compoundtag1.m_128451_("DataVersion") : -1;
                Dynamic dynamic = p_230812_.update(DataFixTypes.LEVEL.m_14504_(), new Dynamic(p_211738_, (Object)compoundtag1), i, SharedConstants.m_183709_().getWorldVersion());
                Pair<WorldGenSettings, Lifecycle> pair = LevelStorageSource.m_78204_(dynamic, p_230812_, i);
                LevelVersion levelversion = LevelVersion.m_78390_((Dynamic)dynamic);
                LevelSettings levelsettings = LevelSettings.m_46924_(dynamic, p_211739_);
                Lifecycle lifecycle = ((Lifecycle)pair.getSecond()).add(p_211740_);
                return PrimaryLevelData.m_78530_((Dynamic<Tag>)dynamic, p_230812_, i, compoundtag2, levelsettings, levelversion, (WorldGenSettings)pair.getFirst(), lifecycle);
            }
            catch (Exception exception) {
                f_78191_.error("Exception reading {}", p_230811_, (Object)exception);
                return null;
            }
        };
    }

    BiFunction<Path, DataFixer, LevelSummary> m_230820_(LevelDirectory p_230821_, boolean p_230822_) {
        return (p_230826_, p_230827_) -> {
            try {
                Tag tag = LevelStorageSource.m_230836_(p_230826_);
                if (tag instanceof CompoundTag) {
                    CompoundTag compoundtag = (CompoundTag)tag;
                    CompoundTag compoundtag1 = compoundtag.m_128469_(f_202311_);
                    int i = compoundtag1.m_128425_("DataVersion", 99) ? compoundtag1.m_128451_("DataVersion") : -1;
                    Dynamic dynamic = p_230827_.update(DataFixTypes.LEVEL.m_14504_(), new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)compoundtag1), i, SharedConstants.m_183709_().getWorldVersion());
                    LevelVersion levelversion = LevelVersion.m_78390_((Dynamic)dynamic);
                    int j = levelversion.m_78389_();
                    if (j == 19132 || j == 19133) {
                        boolean flag = j != this.m_78265_();
                        Path path = p_230821_.m_230860_();
                        DataPackConfig datapackconfig = dynamic.get("DataPacks").result().map(LevelStorageSource::m_78202_).orElse(DataPackConfig.f_45842_);
                        LevelSettings levelsettings = LevelSettings.m_46924_(dynamic, datapackconfig);
                        return new LevelSummary(levelsettings, levelversion, p_230821_.m_230853_(), flag, p_230822_, path);
                    }
                } else {
                    f_78191_.warn("Invalid root tag in {}", p_230826_);
                }
                return null;
            }
            catch (Exception exception) {
                f_78191_.error("Exception reading {}", p_230826_, (Object)exception);
                return null;
            }
        };
    }

    @Nullable
    private static Tag m_230836_(Path p_230837_) throws IOException {
        SkipFields skipfields = new SkipFields(new FieldSelector[]{new FieldSelector(f_202311_, CompoundTag.f_128326_, "Player"), new FieldSelector(f_202311_, CompoundTag.f_128326_, "WorldGenSettings")});
        NbtIo.m_202487_(p_230837_.toFile(), (StreamTagVisitor)skipfields);
        return skipfields.m_197713_();
    }

    public boolean m_78240_(String p_78241_) {
        try {
            Path path = this.f_78194_.resolve(p_78241_);
            Files.createDirectory(path, new FileAttribute[0]);
            Files.deleteIfExists(path);
            return true;
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    public boolean m_78255_(String p_78256_) {
        return Files.isDirectory(this.f_78194_.resolve(p_78256_), new LinkOption[0]);
    }

    public Path m_78257_() {
        return this.f_78194_;
    }

    public Path m_78262_() {
        return this.f_78195_;
    }

    public LevelStorageAccess m_78260_(String p_78261_) throws IOException {
        return new LevelStorageAccess(p_78261_);
    }

    public LevelStorageAccess createAccess(String name, ResourceKey<LevelStem> actualDimension) throws IOException {
        return new LevelStorageAccess(name);
    }

    public record LevelCandidates(List<LevelDirectory> f_230840_) implements Iterable<LevelDirectory>
    {
        public boolean m_230843_() {
            return this.f_230840_.isEmpty();
        }

        @Override
        public Iterator<LevelDirectory> iterator() {
            return this.f_230840_.iterator();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{LevelCandidates.class, "levels", "f_230840_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LevelCandidates.class, "levels", "f_230840_"}, this);
        }

        @Override
        public final boolean equals(Object p_230846_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LevelCandidates.class, "levels", "f_230840_"}, this, p_230846_);
        }
    }

    public record LevelDirectory(Path f_230850_) {
        public String m_230853_() {
            return this.f_230850_.getFileName().toString();
        }

        public Path m_230858_() {
            return this.m_230854_(LevelResource.f_78178_);
        }

        public Path m_230859_() {
            return this.m_230854_(LevelResource.f_230800_);
        }

        public Path m_230856_(LocalDateTime p_230857_) {
            return this.f_230850_.resolve(LevelResource.f_78178_.m_78187_() + "_corrupted_" + p_230857_.format(f_78192_));
        }

        public Path m_230860_() {
            return this.m_230854_(LevelResource.f_230801_);
        }

        public Path m_230861_() {
            return this.m_230854_(LevelResource.f_230802_);
        }

        public Path m_230854_(LevelResource p_230855_) {
            return this.f_230850_.resolve(p_230855_.m_78187_());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{LevelDirectory.class, "path", "f_230850_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LevelDirectory.class, "path", "f_230850_"}, this);
        }

        @Override
        public final boolean equals(Object p_230863_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LevelDirectory.class, "path", "f_230850_"}, this, p_230863_);
        }
    }

    public class LevelStorageAccess
    implements AutoCloseable {
        final DirectoryLock f_78270_;
        public final LevelDirectory f_230867_;
        private final String f_78272_;
        private final Map<LevelResource, Path> f_78273_ = Maps.newHashMap();

        public LevelStorageAccess(String p_78276_) throws IOException {
            this.f_78272_ = p_78276_;
            this.f_230867_ = new LevelDirectory(LevelStorageSource.this.f_78194_.resolve(p_78276_));
            this.f_78270_ = DirectoryLock.m_13640_((Path)this.f_230867_.f_230850_());
        }

        public String m_78277_() {
            return this.f_78272_;
        }

        public Path m_78283_(LevelResource p_78284_) {
            return this.f_78273_.computeIfAbsent(p_78284_, this.f_230867_::m_230854_);
        }

        public Path m_197394_(ResourceKey<Level> p_197395_) {
            return DimensionType.m_196975_(p_197395_, this.f_230867_.f_230850_());
        }

        private void m_78313_() {
            if (!this.f_78270_.m_13639_()) {
                throw new IllegalStateException("Lock is no longer valid");
            }
        }

        public PlayerDataStorage m_78301_() {
            this.m_78313_();
            return new PlayerDataStorage(this, LevelStorageSource.this.f_78196_);
        }

        @Nullable
        public LevelSummary m_78308_() {
            this.m_78313_();
            return LevelStorageSource.this.m_230817_(this.f_230867_, LevelStorageSource.this.m_230820_(this.f_230867_, false));
        }

        @Nullable
        public WorldData m_211747_(DynamicOps<Tag> p_211748_, DataPackConfig p_211749_, Lifecycle p_211750_) {
            this.m_78313_();
            return LevelStorageSource.this.m_230817_(this.f_230867_, LevelStorageSource.m_211737_(p_211748_, p_211749_, p_211750_));
        }

        public void readAdditionalLevelSaveData() {
            this.m_78313_();
            LevelStorageSource.this.m_230817_(this.f_230867_, (path, dataFixer) -> {
                try {
                    CompoundTag compoundTag = NbtIo.m_128937_(path.toFile());
                    ForgeHooks.readAdditionalLevelSaveData((CompoundTag)compoundTag, (LevelDirectory)this.f_230867_);
                }
                catch (Exception e) {
                    f_78191_.error("Exception reading {}", path, (Object)e);
                }
                return "";
            });
        }

        @Nullable
        public DataPackConfig m_78309_() {
            this.m_78313_();
            return LevelStorageSource.this.m_230817_(this.f_230867_, LevelStorageSource::m_230828_);
        }

        public void m_78287_(RegistryAccess p_78288_, WorldData p_78289_) {
            this.m_78290_(p_78288_, p_78289_, null);
        }

        public void m_78290_(RegistryAccess p_78291_, WorldData p_78292_, @Nullable CompoundTag p_78293_) {
            File file1 = this.f_230867_.f_230850_().toFile();
            CompoundTag compoundtag = p_78292_.m_6626_(p_78291_, p_78293_);
            CompoundTag compoundtag1 = new CompoundTag();
            compoundtag1.m_128365_(LevelStorageSource.f_202311_, compoundtag);
            ForgeHooks.writeAdditionalLevelSaveData((WorldData)p_78292_, (CompoundTag)compoundtag1);
            try {
                File file2 = File.createTempFile("level", ".dat", file1);
                NbtIo.m_128944_(compoundtag1, file2);
                File file3 = this.f_230867_.m_230859_().toFile();
                File file4 = this.f_230867_.m_230858_().toFile();
                Util.m_137462_(file4, file2, file3);
            }
            catch (Exception exception) {
                f_78191_.error("Failed to save level {}", (Object)file1, (Object)exception);
            }
        }

        public Optional<Path> m_182514_() {
            return !this.f_78270_.m_13639_() ? Optional.empty() : Optional.of(this.f_230867_.m_230860_());
        }

        public Path getWorldDir() {
            return LevelStorageSource.this.f_78194_;
        }

        public void m_78311_() throws IOException {
            this.m_78313_();
            final Path path = this.f_230867_.m_230861_();
            f_78191_.info("Deleting level {}", (Object)this.f_78272_);
            for (int i = 1; i <= 5; ++i) {
                f_78191_.info("Attempt {}...", (Object)i);
                try {
                    Files.walkFileTree(this.f_230867_.f_230850_(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path p_78323_, BasicFileAttributes p_78324_) throws IOException {
                            if (!p_78323_.equals(path)) {
                                f_78191_.debug("Deleting {}", (Object)p_78323_);
                                Files.delete(p_78323_);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path p_78320_, IOException p_78321_) throws IOException {
                            if (p_78321_ != null) {
                                throw p_78321_;
                            }
                            if (p_78320_.equals(LevelStorageAccess.this.f_230867_.f_230850_())) {
                                LevelStorageAccess.this.f_78270_.close();
                                Files.deleteIfExists(path);
                            }
                            Files.delete(p_78320_);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    break;
                }
                catch (IOException ioexception) {
                    if (i >= 5) {
                        throw ioexception;
                    }
                    f_78191_.warn("Failed to delete {}", (Object)this.f_230867_.f_230850_(), (Object)ioexception);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }

        public void m_78297_(String p_78298_) throws IOException {
            this.m_78313_();
            Path path = this.f_230867_.m_230858_();
            if (Files.exists(path, new LinkOption[0])) {
                CompoundTag compoundtag = NbtIo.m_128937_(path.toFile());
                CompoundTag compoundtag1 = compoundtag.m_128469_(LevelStorageSource.f_202311_);
                compoundtag1.m_128359_("LevelName", p_78298_);
                NbtIo.m_128944_(compoundtag, path.toFile());
            }
        }

        public long m_78312_() throws IOException {
            this.m_78313_();
            String s = LocalDateTime.now().format(f_78192_) + "_" + this.f_78272_;
            Path path = LevelStorageSource.this.m_78262_();
            try {
                Files.createDirectories(Files.exists(path, new LinkOption[0]) ? path.toRealPath(new LinkOption[0]) : path, new FileAttribute[0]);
            }
            catch (IOException ioexception) {
                throw new RuntimeException(ioexception);
            }
            Path path1 = path.resolve(FileUtil.m_133730_((Path)path, (String)s, (String)".zip"));
            try (final ZipOutputStream zipoutputstream = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(path1, new OpenOption[0])));){
                final Path path2 = Paths.get(this.f_78272_, new String[0]);
                Files.walkFileTree(this.f_230867_.f_230850_(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path p_78339_, BasicFileAttributes p_78340_) throws IOException {
                        if (p_78339_.endsWith("session.lock")) {
                            return FileVisitResult.CONTINUE;
                        }
                        String s1 = path2.resolve(LevelStorageAccess.this.f_230867_.f_230850_().relativize(p_78339_)).toString().replace('\\', '/');
                        ZipEntry zipentry = new ZipEntry(s1);
                        zipoutputstream.putNextEntry(zipentry);
                        com.google.common.io.Files.asByteSource((File)p_78339_.toFile()).copyTo((OutputStream)zipoutputstream);
                        zipoutputstream.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            return Files.size(path1);
        }

        @Override
        public void close() throws IOException {
            this.f_78270_.close();
        }
    }
}

