/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.dynamicenum;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import sun.misc.Unsafe;

public class MohistDynamEnum {
    private static final MethodHandles.Lookup implLookup;
    public static final Unsafe unsafe;
    private static final List<String> ENUM_CACHE;
    static final Class<?>[] NO_PTYPES;

    private static <T> T makeEnum(Class<T> enumClass, String value, int ordinal, Class<?>[] additionalParameterTypes, Object[] additionalValues) {
        try {
            unsafe.ensureClassInitialized(enumClass);
            Class[] ptypes = new Class[additionalParameterTypes.length + 2];
            ptypes[0] = String.class;
            ptypes[1] = Integer.TYPE;
            System.arraycopy(additionalParameterTypes, 0, ptypes, 2, additionalParameterTypes.length);
            MethodHandle constructor = implLookup.findConstructor(enumClass, MethodType.methodType(Void.TYPE, ptypes));
            Object[] arguments = new Object[additionalValues.length + 2];
            arguments[0] = value;
            arguments[1] = ordinal;
            System.arraycopy(additionalValues, 0, arguments, 2, additionalValues.length);
            return (T)constructor.invokeWithArguments(arguments);
        }
        catch (Throwable e) {
            e.fillInStackTrace();
            return null;
        }
    }

    private static void cleanEnumCache(Class<?> enumClass) {
        ENUM_CACHE.forEach(s -> Arrays.stream(Class.class.getDeclaredFields()).filter(field -> field.getName().equals(s)).forEachOrdered(field -> unsafe.putObjectVolatile(enumClass, unsafe.objectFieldOffset((Field)field), null)));
    }

    private static <T> T addEnum(Class<T> cl, String name, Class<?>[] additionalParameterTypes, Object[] additionalValues) {
        try {
            unsafe.ensureClassInitialized(cl);
            for (Field field : cl.getDeclaredFields()) {
                if (!field.getName().equals("$VALUES") && !field.getName().equals("ENUM$VALUES")) continue;
                Object base = unsafe.staticFieldBase(field);
                long offset = unsafe.staticFieldOffset(field);
                Object[] arr = (Object[])unsafe.getObject(base, offset);
                Object[] newArr = (Object[])Array.newInstance(cl, arr.length + 1);
                System.arraycopy(arr, 0, newArr, 0, arr.length);
                T newInstance = MohistDynamEnum.makeEnum(cl, name, arr.length, additionalParameterTypes, additionalValues);
                newArr[arr.length] = newInstance;
                unsafe.putObject(base, offset, newArr);
                MohistDynamEnum.cleanEnumCache(cl);
                return newInstance;
            }
        }
        catch (Throwable e) {
            e.fillInStackTrace();
            return null;
        }
        return null;
    }

    public static <T> T addEnum(Class<T> cl, String name, List<Class<?>> additionalParameterTypes, List<Object> additionalValues) {
        return MohistDynamEnum.addEnum(cl, name, MohistDynamEnum.listToArray(additionalParameterTypes), additionalValues.toArray());
    }

    public static <T> T addEnum(Class<T> cl, String name) {
        return MohistDynamEnum.addEnum(cl, name, List.of(), List.of());
    }

    private static Class<?>[] listToArray(List<Class<?>> ptypes) {
        return ptypes.toArray(NO_PTYPES);
    }

    static {
        ENUM_CACHE = List.of("enumConstantDirectory", "enumConstants", "enumVars");
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            unsafe = (Unsafe)unsafeField.get(null);
            unsafe.ensureClassInitialized(MethodHandles.Lookup.class);
            Field implLookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            implLookup = (MethodHandles.Lookup)unsafe.getObject(unsafe.staticFieldBase(implLookupField), unsafe.staticFieldOffset(implLookupField));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        NO_PTYPES = new Class[0];
    }
}

