/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.bootstraplauncher;

import cpw.mods.cl.JarModuleFinder;
import cpw.mods.cl.ModuleClassLoader;
import cpw.mods.jarhandling.SecureJar;
import java.io.File;
import java.io.IOException;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;

public class BootstrapLauncher {
    private static final boolean DEBUG = System.getProperties().containsKey("bsl.debug");

    public static void main(String ... args) {
        List<String> legacyClasspath = BootstrapLauncher.loadLegacyClassPath();
        System.setProperty("legacyClassPath", String.join((CharSequence)File.pathSeparator, legacyClasspath));
        String ignoreList = System.getProperty("ignoreList", "asm,securejarhandler");
        String[] ignores = ignoreList.split(",");
        HashSet previousPackages = new HashSet();
        ArrayList jars = new ArrayList();
        HashMap<Path, String> pathLookup = new HashMap<Path, String>();
        Map<String, String> filenameMap = BootstrapLauncher.getMergeFilenameMap();
        LinkedHashMap<String, List> mergeMap = new LinkedHashMap<String, List>();
        ArrayList<String> order = new ArrayList<String>();
        block0: for (String legacy : legacyClasspath) {
            Path path = Paths.get(legacy, new String[0]);
            String filename = path.getFileName().toString();
            for (String filter : ignores) {
                if (!filename.startsWith(filter)) continue;
                if (!DEBUG) continue block0;
                System.out.println("bsl: file '" + legacy + "' ignored because filename starts with '" + filter + "'");
                continue block0;
            }
            if (DEBUG) {
                System.out.println("bsl: encountered path '" + legacy + "'");
            }
            if (Files.notExists(path, new LinkOption[0])) continue;
            SecureJar jar = SecureJar.from((Path[])new Path[]{path});
            if ("".equals(jar.name())) continue;
            String jarname = pathLookup.computeIfAbsent(path, k -> filenameMap.getOrDefault(filename, jar.name()));
            order.add(jarname);
            mergeMap.computeIfAbsent(jarname, k -> new ArrayList()).add(path);
        }
        mergeMap.entrySet().stream().sorted(Comparator.comparingInt(e -> order.indexOf(e.getKey()))).forEach(e -> {
            String name = (String)e.getKey();
            List paths = (List)e.getValue();
            if (paths.size() == 1 && Files.notExists((Path)paths.get(0), new LinkOption[0])) {
                return;
            }
            Path[] pathsArray = (Path[])paths.toArray(Path[]::new);
            SecureJar jar = SecureJar.from((BiPredicate)new PackageTracker(Set.copyOf(previousPackages), pathsArray), (Path[])pathsArray);
            Set packages = jar.getPackages();
            if (DEBUG) {
                System.out.println("bsl: the following paths are merged together in module " + name);
                paths.forEach(path -> System.out.println("bsl:    " + path));
                System.out.println("bsl: list of packages for module " + name);
                packages.forEach(p -> System.out.println("bsl:    " + p));
            }
            previousPackages.addAll(packages);
            jars.add(jar);
        });
        SecureJar[] secureJarsArray = (SecureJar[])jars.toArray(SecureJar[]::new);
        List<String> allTargets = Arrays.stream(secureJarsArray).map(SecureJar::name).toList();
        JarModuleFinder jarModuleFinder = JarModuleFinder.of((SecureJar[])secureJarsArray);
        Configuration bootModuleConfiguration = ModuleLayer.boot().configuration();
        Configuration bootstrapConfiguration = bootModuleConfiguration.resolveAndBind((ModuleFinder)jarModuleFinder, ModuleFinder.ofSystem(), allTargets);
        ModuleClassLoader moduleClassLoader = new ModuleClassLoader("MC-BOOTSTRAP", bootstrapConfiguration, List.of(ModuleLayer.boot()));
        ModuleLayer.Controller layer = ModuleLayer.defineModules(bootstrapConfiguration, List.of(ModuleLayer.boot()), m -> moduleClassLoader);
        Thread.currentThread().setContextClassLoader((ClassLoader)moduleClassLoader);
        ServiceLoader<Consumer> loader = ServiceLoader.load(layer.layer(), Consumer.class);
        loader.stream().findFirst().orElseThrow().get().accept(args);
    }

    private static Map<String, String> getMergeFilenameMap() {
        String mergeModules = System.getProperty("mergeModules");
        if (mergeModules == null) {
            return Map.of();
        }
        HashMap<String, String> filenameMap = new HashMap<String, String>();
        int i = 0;
        for (String merge : mergeModules.split(";")) {
            String[] targets;
            for (String target : targets = merge.split(",")) {
                filenameMap.put(target, String.valueOf(i));
            }
            ++i;
        }
        return filenameMap;
    }

    private static List<String> loadLegacyClassPath() {
        Path legacyCPFileCandidatePath;
        String legacyCpPath = System.getProperty("legacyClassPath.file");
        if (legacyCpPath != null && Files.exists(legacyCPFileCandidatePath = Paths.get(legacyCpPath, new String[0]), new LinkOption[0]) && Files.isRegularFile(legacyCPFileCandidatePath, new LinkOption[0])) {
            try {
                return Files.readAllLines(legacyCPFileCandidatePath);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to load the legacy class path from the specified file: " + legacyCpPath, e);
            }
        }
        String legacyClasspath = System.getProperty("legacyClassPath", System.getProperty("java.class.path"));
        Objects.requireNonNull(legacyClasspath, "Missing legacyClassPath, cannot bootstrap");
        if (legacyClasspath.length() == 0) {
            return List.of();
        }
        return Arrays.asList(legacyClasspath.split(File.pathSeparator));
    }

    private record PackageTracker(Set<String> packages, Path[] paths) implements BiPredicate<String, String>
    {
        @Override
        public boolean test(String path, String basePath) {
            if (this.packages.isEmpty() || path.startsWith("META-INF/")) {
                return true;
            }
            int idx = path.lastIndexOf(47);
            return idx < 0 || idx == path.length() - 1 || !this.packages.contains(path.substring(0, idx).replace('/', '.'));
        }
    }
}

