/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc;

import com.mohistmc.api.ServerAPI;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.thread.NamedThreadFactory;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.spigotmc.SpigotConfig;

public class Metrics {
    public static final ScheduledExecutorService METRICS = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("Metrics"));
    private final String name;
    private final String serverUUID;
    private final List<CustomChart> charts = new ArrayList<CustomChart>();

    public Metrics(String name, String serverUUID) {
        this.name = name;
        this.serverUUID = serverUUID;
        this.startSubmitting();
    }

    private static void sendData(JSONObject data) throws Exception {
        if (data == null) {
            throw new IllegalArgumentException("Data cannot be null!");
        }
        HttpsURLConnection connection = (HttpsURLConnection)new URL("https://bStats.org/submitData/server-implementation").openConnection();
        byte[] compressedData = Metrics.compress(data.toString());
        connection.setRequestMethod("POST");
        connection.addRequestProperty("Accept", "application/json");
        connection.addRequestProperty("Connection", "close");
        connection.addRequestProperty("Content-Encoding", "gzip");
        connection.addRequestProperty("Content-Length", String.valueOf(compressedData.length));
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("User-Agent", "MC-Server/1");
        connection.setDoOutput(true);
        DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());
        outputStream.write(compressedData);
        outputStream.flush();
        outputStream.close();
        connection.getInputStream().close();
    }

    private static byte[] compress(String str) throws IOException {
        if (str == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(outputStream);
        gzip.write(str.getBytes(StandardCharsets.UTF_8));
        gzip.close();
        return outputStream.toByteArray();
    }

    public void addCustomChart(CustomChart chart) {
        if (chart == null) {
            throw new IllegalArgumentException("Chart cannot be null!");
        }
        this.charts.add(chart);
    }

    private void startSubmitting() {
        METRICS.scheduleAtFixedRate(() -> {
            if (MinecraftServer.getServer().hasStopped()) {
                return;
            }
            this.submitData();
        }, 300000L, 1800000L, TimeUnit.MILLISECONDS);
    }

    public JSONObject getPluginData() {
        JSONObject data = new JSONObject();
        data.put((Object)"pluginName", (Object)this.name);
        JSONArray customCharts = new JSONArray();
        for (CustomChart customChart : this.charts) {
            JSONObject chart = customChart.getRequestJsonObject();
            if (chart == null) continue;
            customCharts.add((Object)chart);
        }
        data.put((Object)"customCharts", (Object)customCharts);
        return data;
    }

    private JSONObject getServerData() {
        JSONObject data = new JSONObject();
        data.put((Object)"serverUUID", (Object)this.serverUUID);
        data.put((Object)"osName", (Object)System.getProperty("os.name"));
        data.put((Object)"osArch", (Object)System.getProperty("os.arch"));
        data.put((Object)"osVersion", (Object)System.getProperty("os.version"));
        data.put((Object)"coreCount", (Object)Runtime.getRuntime().availableProcessors());
        return data;
    }

    private void submitData() {
        JSONObject data = this.getServerData();
        JSONArray pluginData = new JSONArray();
        pluginData.add((Object)this.getPluginData());
        data.put((Object)"plugins", (Object)pluginData);
        try {
            Metrics.sendData(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static abstract class CustomChart {
        final String chartId;

        CustomChart(String chartId) {
            if (chartId == null || chartId.isEmpty()) {
                throw new IllegalArgumentException("ChartId cannot be null or empty!");
            }
            this.chartId = chartId;
        }

        private JSONObject getRequestJsonObject() {
            JSONObject chart = new JSONObject();
            chart.put((Object)"chartId", (Object)this.chartId);
            try {
                JSONObject data = this.getChartData();
                if (data == null) {
                    return null;
                }
                chart.put((Object)"data", (Object)data);
            }
            catch (Throwable t) {
                return null;
            }
            return chart;
        }

        protected abstract JSONObject getChartData() throws Exception;
    }

    public static class MohistMetrics {
        public static void startMetrics() {
            MinecraftServer.getServer();
            File configFile = new File(new File((File)MinecraftServer.options.valueOf("plugins"), "bStats"), "config.yml");
            YamlConfiguration config = YamlConfiguration.loadConfiguration(configFile);
            if (!config.isSet("serverUuid")) {
                config.addDefault("enabled", true);
                config.addDefault("serverUuid", UUID.randomUUID().toString());
                config.addDefault("logFailedRequests", false);
                config.options().header("bStats collects some data for plugin authors like how many servers are using their plugins.\nTo honor their work, you should not disable it.\nThis has nearly no effect on the server performance!\nCheck out https://bStats.org/ to learn more :)").copyDefaults(true);
                try {
                    config.save(configFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            String serverUUID = config.getString("serverUuid");
            if (config.getBoolean("enabled", true)) {
                Metrics metrics = new Metrics("Mohist", serverUUID);
                metrics.addCustomChart(new SimplePie("minecraft_version", () -> {
                    String minecraftVersion = Bukkit.getVersion();
                    minecraftVersion = minecraftVersion.substring(minecraftVersion.indexOf("MC: ") + 4, minecraftVersion.length() - 1);
                    return minecraftVersion;
                }));
                metrics.addCustomChart(new SingleLineChart("players", () -> Bukkit.getOnlinePlayers().size()));
                metrics.addCustomChart(new SimplePie("online_mode", () -> Bukkit.getOnlineMode() ? "online" : "offline"));
                metrics.addCustomChart(new SimplePie("mohist_version", () -> "1.19.2"));
                metrics.addCustomChart(new SimplePie("bungeecord", () -> SpigotConfig.bungee ? "true" : "false"));
                metrics.addCustomChart(new DrilldownPie("java_version", () -> {
                    String release;
                    HashMap map = new HashMap();
                    String javaVersion = System.getProperty("java.version");
                    HashMap<String, Integer> entry = new HashMap<String, Integer>();
                    entry.put(javaVersion, 1);
                    String majorVersion = javaVersion.split("\\.")[0];
                    int indexOf = javaVersion.lastIndexOf(46);
                    if (majorVersion.equals("1")) {
                        release = "Java " + javaVersion.substring(0, indexOf);
                    } else {
                        Matcher versionMatcher = Pattern.compile("\\d+").matcher(majorVersion);
                        if (versionMatcher.find()) {
                            majorVersion = versionMatcher.group(0);
                        }
                        release = "Java " + majorVersion;
                    }
                    map.put((CallSite)((Object)release), entry);
                    return map;
                }));
                metrics.addCustomChart(new DrilldownPie("mod_plugin", () -> {
                    String[] mods;
                    HashMap map = new HashMap();
                    HashMap<String, Integer> modslist = new HashMap<String, Integer>();
                    for (String x : mods = ServerAPI.getModList().replace("[", "").replace("]", "").split(", ")) {
                        if (x.equals("minecraft") || x.equals("forge") || x.equals("mohist")) continue;
                        modslist.put(x, 1);
                    }
                    HashMap<String, Integer> pluginlist = new HashMap<String, Integer>();
                    for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
                        if (!plugin.isEnabled()) continue;
                        pluginlist.put(plugin.getDescription().getName(), 1);
                    }
                    map.put("mods", modslist);
                    map.put("plugins", pluginlist);
                    return map;
                }));
            }
        }
    }

    public static class SingleLineChart
    extends CustomChart {
        private final Callable<Integer> callable;

        public SingleLineChart(String chartId, Callable<Integer> callable) {
            super(chartId);
            this.callable = callable;
        }

        @Override
        protected JSONObject getChartData() throws Exception {
            JSONObject data = new JSONObject();
            int value = this.callable.call();
            if (value == 0) {
                return null;
            }
            data.put((Object)"value", (Object)value);
            return data;
        }
    }

    public static class DrilldownPie
    extends CustomChart {
        private final Callable<Map<String, Map<String, Integer>>> callable;

        public DrilldownPie(String chartId, Callable<Map<String, Map<String, Integer>>> callable) {
            super(chartId);
            this.callable = callable;
        }

        @Override
        public JSONObject getChartData() throws Exception {
            JSONObject data = new JSONObject();
            JSONObject values = new JSONObject();
            Map<String, Map<String, Integer>> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean reallyAllSkipped = true;
            for (Map.Entry<String, Map<String, Integer>> entryValues : map.entrySet()) {
                JSONObject value = new JSONObject();
                boolean allSkipped = true;
                for (Map.Entry<String, Integer> valueEntry : map.get(entryValues.getKey()).entrySet()) {
                    value.put((Object)valueEntry.getKey(), (Object)valueEntry.getValue());
                    allSkipped = false;
                }
                if (allSkipped) continue;
                reallyAllSkipped = false;
                values.put((Object)entryValues.getKey(), (Object)value);
            }
            if (reallyAllSkipped) {
                return null;
            }
            data.put((Object)"values", (Object)values);
            return data;
        }
    }

    public static class SimplePie
    extends CustomChart {
        private final Callable<String> callable;

        public SimplePie(String chartId, Callable<String> callable) {
            super(chartId);
            this.callable = callable;
        }

        @Override
        protected JSONObject getChartData() throws Exception {
            JSONObject data = new JSONObject();
            String value = this.callable.call();
            if (value == null || value.isEmpty()) {
                return null;
            }
            data.put((Object)"value", (Object)value);
            return data;
        }
    }
}

