/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.bukkit.remapping;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mohistmc.bukkit.remapping.ClassLoaderAdapter;
import com.mohistmc.bukkit.remapping.ClassLoaderRemapper;
import com.mohistmc.bukkit.remapping.GlobalClassRepo;
import com.mohistmc.bukkit.remapping.InterfaceInvokerGen;
import com.mohistmc.bukkit.remapping.LenientJarRemapper;
import com.mohistmc.bukkit.remapping.PluginTransformer;
import com.mohistmc.bukkit.remapping.RedirectAdapter;
import com.mohistmc.bukkit.remapping.RemapSourceHandler;
import com.mohistmc.bukkit.remapping.Unsafe;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.md_5.specialsource.InheritanceMap;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.JarRemapper;
import net.md_5.specialsource.provider.ClassLoaderProvider;
import net.md_5.specialsource.provider.InheritanceProvider;
import net.md_5.specialsource.provider.JointProvider;

public class Remapper {
    public static final Remapper INSTANCE;
    public static final File DUMP;
    private final JarMapping toNmsMapping;
    private final JarMapping toBukkitMapping;
    public final InheritanceMap inheritanceMap;
    private final List<PluginTransformer> transformerList = new ArrayList<PluginTransformer>();
    private final JarRemapper toBukkitRemapper;
    private final JarRemapper toNmsRemapper;
    private static long pkgOffset;
    private static long clOffset;
    private static long mdOffset;
    private static long fdOffset;
    private static long mapOffset;

    public List<PluginTransformer> getTransformerList() {
        return this.transformerList;
    }

    public Remapper() throws Exception {
        this.toNmsMapping = new JarMapping();
        this.toNmsMapping.packages.put("org/yaml/snakeyaml/", "com/mohistmc/org/yaml/snakeyaml/");
        this.toNmsMapping.packages.put("javax/inject/", "com/mohistmc/javax/inject/");
        this.toNmsMapping.classes.put("io/netty/util/Version", "com/mohistmc/bukkit/pluginfix/ScriptBlockPlus");
        this.toBukkitMapping = new JarMapping();
        this.inheritanceMap = new InheritanceMap();
        this.toNmsMapping.loadMappings(new BufferedReader(new InputStreamReader(Remapper.class.getClassLoader().getResourceAsStream("mappings/spigot2srg.srg"))), null, null, false);
        this.toBukkitMapping.loadMappings(new BufferedReader(new InputStreamReader(Remapper.class.getClassLoader().getResourceAsStream("mappings/spigot2srg.srg"))), null, null, true);
        BiMap inverseClassMap = HashBiMap.create((Map)this.toNmsMapping.classes).inverse();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Remapper.class.getClassLoader().getResourceAsStream("mappings/inheritanceMap.txt")));){
            this.inheritanceMap.load(reader, inverseClassMap);
        }
        JointProvider inheritanceProvider = new JointProvider();
        inheritanceProvider.add((InheritanceProvider)this.inheritanceMap);
        inheritanceProvider.add((InheritanceProvider)new ClassLoaderProvider(ClassLoader.getSystemClassLoader()));
        this.toNmsMapping.setFallbackInheritanceProvider((InheritanceProvider)inheritanceProvider);
        this.toBukkitMapping.setFallbackInheritanceProvider((InheritanceProvider)inheritanceProvider);
        this.transformerList.add(InterfaceInvokerGen.INSTANCE);
        this.transformerList.add(RedirectAdapter.INSTANCE);
        this.transformerList.add(ClassLoaderAdapter.INSTANCE);
        this.toBukkitMapping.setFallbackInheritanceProvider((InheritanceProvider)GlobalClassRepo.inheritanceProvider());
        this.toBukkitRemapper = new LenientJarRemapper(this.toBukkitMapping);
        this.toNmsRemapper = new LenientJarRemapper(this.toNmsMapping);
        RemapSourceHandler.register();
    }

    public static ClassLoaderRemapper createClassLoaderRemapper(ClassLoader classLoader) {
        return new ClassLoaderRemapper(INSTANCE.copyOf(Remapper.INSTANCE.toNmsMapping), INSTANCE.copyOf(Remapper.INSTANCE.toBukkitMapping), classLoader);
    }

    public static JarRemapper getResourceMapper() {
        return Remapper.INSTANCE.toBukkitRemapper;
    }

    public static JarRemapper getNmsMapper() {
        return Remapper.INSTANCE.toNmsRemapper;
    }

    private JarMapping copyOf(JarMapping mapping) {
        JarMapping jarMapping = new JarMapping();
        Unsafe.putObject(jarMapping, pkgOffset, Unsafe.getObject(mapping, pkgOffset));
        Unsafe.putObject(jarMapping, clOffset, Unsafe.getObject(mapping, clOffset));
        Unsafe.putObject(jarMapping, mdOffset, Unsafe.getObject(mapping, mdOffset));
        Unsafe.putObject(jarMapping, fdOffset, Unsafe.getObject(mapping, fdOffset));
        Unsafe.putObject(jarMapping, mapOffset, Unsafe.getObject(mapping, mapOffset));
        return jarMapping;
    }

    static {
        try {
            INSTANCE = new Remapper();
            DUMP = null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            pkgOffset = Unsafe.objectFieldOffset(JarMapping.class.getField("packages"));
            clOffset = Unsafe.objectFieldOffset(JarMapping.class.getField("classes"));
            mdOffset = Unsafe.objectFieldOffset(JarMapping.class.getField("methods"));
            fdOffset = Unsafe.objectFieldOffset(JarMapping.class.getField("fields"));
            mapOffset = Unsafe.objectFieldOffset(JarMapping.class.getDeclaredField("inheritanceMap"));
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

