/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.bukkit.remapping;

import com.google.common.io.ByteStreams;
import com.mohistmc.bukkit.remapping.ClassLoaderRemapper;
import com.mohistmc.bukkit.remapping.Remapper;
import com.mohistmc.bukkit.remapping.RemappingClassLoader;
import io.izzel.tools.product.Product2;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandlerFactory;
import java.security.CodeSource;
import java.util.concurrent.Callable;
import java.util.jar.Manifest;

public class RemappingURLClassLoader
extends URLClassLoader
implements RemappingClassLoader {
    private ClassLoaderRemapper remapper;

    public RemappingURLClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, RemappingClassLoader.asTransforming(parent));
    }

    public RemappingURLClassLoader(URL[] urls) {
        super(urls, RemappingClassLoader.asTransforming(null));
    }

    public RemappingURLClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, RemappingClassLoader.asTransforming(parent), factory);
    }

    public RemappingURLClassLoader(String name, URL[] urls, ClassLoader parent) {
        super(name, urls, RemappingClassLoader.asTransforming(parent));
    }

    public RemappingURLClassLoader(String name, URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(name, urls, RemappingClassLoader.asTransforming(parent), factory);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> result = null;
        String path = name.replace('.', '/').concat(".class");
        URL resource = this.findResource(path);
        if (resource != null) {
            Product2<byte[], CodeSource> classBytes;
            block9: {
                String pkgName;
                Callable<byte[]> byteSource;
                Manifest manifest;
                URLConnection connection;
                try {
                    connection = resource.openConnection();
                    connection.connect();
                    manifest = connection instanceof JarURLConnection && ((JarURLConnection)connection).getManifest() != null ? ((JarURLConnection)connection).getManifest() : null;
                    byteSource = () -> {
                        try (InputStream is = connection.getInputStream();){
                            byte[] byArray = ByteStreams.toByteArray((InputStream)is);
                            return byArray;
                        }
                    };
                }
                catch (IOException e) {
                    throw new ClassNotFoundException(name, e);
                }
                classBytes = this.getRemapper().remapClass(name, byteSource, connection);
                int i = name.lastIndexOf(46);
                if (i != -1 && this.getPackage(pkgName = name.substring(0, i)) == null) {
                    try {
                        if (manifest != null) {
                            this.definePackage(pkgName, manifest, resource);
                        } else {
                            this.definePackage(pkgName, null, null, null, null, null, null, null);
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        if (this.getPackage(pkgName) != null) break block9;
                        throw new IllegalStateException("Cannot find package " + pkgName);
                    }
                }
            }
            result = this.defineClass(name, (byte[])classBytes._1, 0, ((byte[])classBytes._1).length, (CodeSource)classBytes._2);
        }
        if (result == null) {
            throw new ClassNotFoundException(name);
        }
        return result;
    }

    @Override
    public ClassLoaderRemapper getRemapper() {
        if (this.remapper == null) {
            this.remapper = Remapper.createClassLoaderRemapper(this);
        }
        return this.remapper;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

