/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.command;

import com.mohistmc.api.PlayerAPI;
import com.mohistmc.api.ServerAPI;
import com.mohistmc.command.ItemCommand;
import com.mohistmc.configuration.MohistConfig;
import com.mohistmc.configuration.TickConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraftforge.versions.forge.ForgeVersion;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_19_R1.CraftServer;
import org.bukkit.entity.Player;

public class MohistCommand
extends Command {
    private List<String> params = Arrays.asList("mods", "playermods", "printthreadcost", "lang", "item", "reload", "version", "channels", "speed");

    public MohistCommand(String name) {
        super(name);
        this.description = "Mohist related commands";
        this.usageMessage = "/mohist [mods|playermods|printthreadcost|lang|item|reload|version]";
        this.setPermission("mohist.command.mohist");
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1 && (sender.isOp() || this.testPermission(sender))) {
            for (String param : this.params) {
                if (!param.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                list.add(param);
            }
        }
        if (args.length == 2 && args[0].equals("item")) {
            list.add("info");
        }
        return list;
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(ChatColor.RED + "Usage: " + this.usageMessage);
            return false;
        }
        switch (args[0].toLowerCase(Locale.ENGLISH)) {
            case "mods": {
                sender.sendMessage(ChatColor.GREEN + ServerAPI.getModSize() + " " + ServerAPI.getModList());
                break;
            }
            case "playermods": {
                if (args.length == 1) {
                    sender.sendMessage(ChatColor.RED + "Usage: /mohist playermods <playername>");
                    return false;
                }
                Player player = Bukkit.getPlayer(args[1]);
                if (player != null) {
                    sender.sendMessage(ChatColor.GREEN + PlayerAPI.getModSize(player) + " " + PlayerAPI.getModlist(player));
                    break;
                }
                sender.sendMessage(ChatColor.RED + "The player [" + args[1] + "] is not online.");
                break;
            }
            case "item": {
                if (args.length == 1) {
                    sender.sendMessage(ChatColor.RED + "Usage: /mohist item info");
                    return false;
                }
                if ("info".equals(args[1].toLowerCase(Locale.ENGLISH))) {
                    ItemCommand.info(sender);
                    break;
                }
                sender.sendMessage(ChatColor.RED + "Usage: /mohist item info");
                break;
            }
            case "reload": {
                if (MohistConfig.instance != null) {
                    MohistConfig.instance.load();
                }
                TickConfig.ENTITIES.reloadConfig();
                TickConfig.TILES.reloadConfig();
                sender.sendMessage(ChatColor.GREEN + "mohist-config directory reload complete.");
                break;
            }
            case "version": {
                sender.sendMessage("Mohist: 1.19.2");
                sender.sendMessage("Forge: " + ForgeVersion.getVersion());
                String[] cbs = CraftServer.class.getPackage().getImplementationVersion().split("-");
                sender.sendMessage("Bukkit: " + cbs[0]);
                sender.sendMessage("CraftBukkit: " + cbs[1]);
                sender.sendMessage("Spigot: " + cbs[2]);
                break;
            }
            case "channels": {
                sender.sendMessage(ServerAPI.channels.toString());
                break;
            }
            case "speed": {
                if (sender instanceof Player) {
                    Player p = (Player)sender;
                    if (args.length != 2 || !p.isOp()) break;
                    if (this.isFloat(args[1])) {
                        if (p.isFlying()) {
                            float speed = Float.parseFloat(args[1]);
                            if (speed >= 0.0f && speed < 11.0f) {
                                p.setFlySpeed(speed / 10.0f);
                                p.sendMessage("\u98de\u884c\u901f\u5ea6\u5df2\u8bbe\u7f6e\u4e3a \u00a7b" + speed);
                            }
                        } else {
                            float speed = Float.parseFloat(args[1]);
                            if (speed >= 0.0f && speed < 11.0f) {
                                p.setWalkSpeed(speed / 10.0f);
                                p.sendMessage("\u884c\u8d70\u901f\u5ea6\u5df2\u8bbe\u7f6e\u4e3a \u00a7b" + speed);
                            }
                        }
                    }
                    if (!args[0].equalsIgnoreCase("reset")) break;
                    p.setFlySpeed(0.1f);
                    p.setWalkSpeed(0.2f);
                    p.sendMessage("\u884c\u8d70\u548c\u98de\u884c\u901f\u5ea6\u5df2\u6062\u590d\u9ed8\u8ba4.");
                    break;
                }
                sender.sendMessage("\u00a7c\u63a7\u5236\u53f0\u65e0\u6cd5\u8d85\u901f\u884c\u9a76");
                break;
            }
            default: {
                sender.sendMessage(ChatColor.RED + "Usage: " + this.usageMessage);
                return false;
            }
        }
        return true;
    }

    private boolean isFloat(String input) {
        try {
            Float.parseFloat(input);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

