/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting.conditions;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.crafting.CraftingHelper;

public interface ICondition {
    public static final Decoder<Boolean> DECODER = new Decoder<Boolean>(){

        public <T> DataResult<Pair<Boolean, T>> decode(DynamicOps<T> ops, T input) {
            JsonObject obj;
            if (input instanceof JsonObject && (obj = (JsonObject)input).has("forge:conditions")) {
                try {
                    boolean result = CraftingHelper.processConditions(obj, "forge:conditions", IContext.TAGS_INVALID);
                    return DataResult.success((Object)Pair.of((Object)result, input));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return DataResult.success((Object)Pair.of((Object)false, input));
                }
            }
            return DataResult.success((Object)Pair.of((Object)true, input));
        }
    };

    public ResourceLocation getID();

    public boolean test(IContext var1);

    public static interface IContext {
        public static final IContext EMPTY = new IContext(){

            @Override
            public <T> Map<ResourceLocation, Collection<Holder<T>>> getAllTags(ResourceKey<? extends Registry<T>> registry) {
                return Collections.emptyMap();
            }
        };
        public static final IContext TAGS_INVALID = new IContext(){

            @Override
            public <T> Map<ResourceLocation, Collection<Holder<T>>> getAllTags(ResourceKey<? extends Registry<T>> registry) {
                throw new UnsupportedOperationException("Usage of tag-based conditions is not permitted in this context!");
            }
        };

        default public <T> Collection<Holder<T>> getTag(TagKey<T> key) {
            return this.getAllTags(key.f_203867_()).getOrDefault(key.f_203868_(), Set.of());
        }

        public <T> Map<ResourceLocation, Collection<Holder<T>>> getAllTags(ResourceKey<? extends Registry<T>> var1);
    }
}

