/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.resource;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.resource.ResourceCacheManager;
import org.jetbrains.annotations.NotNull;

public class PathPackResources
extends AbstractPackResources {
    private final Path source;
    private final String packName;
    private final ResourceCacheManager cacheManager = new ResourceCacheManager(true, "indexModPackCachesOnThread", (packType, namespace) -> this.resolve(packType.m_10305_(), (String)namespace).toAbsolutePath());

    public PathPackResources(String packName, Path source) {
        super(new File("dummy"));
        this.source = source;
        this.packName = packName;
    }

    public void initForNamespace(String namespace) {
        if (ResourceCacheManager.shouldUseCache()) {
            this.cacheManager.index(namespace);
        }
    }

    public void init(PackType packType) {
        this.getNamespacesFromDisk(packType).forEach(this::initForNamespace);
    }

    public Path getSource() {
        return this.source;
    }

    public String m_8017_() {
        return this.packName;
    }

    protected Path resolve(String ... paths) {
        Path path = this.getSource();
        for (String name : paths) {
            path = path.resolve(name);
        }
        return path;
    }

    protected InputStream m_5541_(String name) throws IOException {
        Path path = this.resolve(name);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("Can't find resource " + name + " at " + this.getSource());
        }
        return Files.newInputStream(path, StandardOpenOption.READ);
    }

    protected boolean m_6105_(String name) {
        Path path = this.resolve(name);
        return Files.exists(path, new LinkOption[0]);
    }

    public Collection<ResourceLocation> m_214146_(PackType type, String resourceNamespace, String pathIn, Predicate<ResourceLocation> filter) {
        try {
            Path root = this.resolve(type.m_10305_(), resourceNamespace).toAbsolutePath();
            Path inputPath = root.getFileSystem().getPath(pathIn, new String[0]);
            if (ResourceCacheManager.shouldUseCache() && this.cacheManager.hasCached(type, resourceNamespace)) {
                return this.cacheManager.getResources(type, resourceNamespace, inputPath, filter);
            }
            return Files.walk(root, new FileVisitOption[0]).map(root::relativize).filter(path -> !path.toString().endsWith(".mcmeta") && path.startsWith(inputPath)).filter(path -> ResourceLocation.m_135841_((String)Joiner.on((char)'/').join((Iterable)path))).map(path -> new ResourceLocation(resourceNamespace, Joiner.on((char)'/').join((Iterable)path))).filter(filter).collect(Collectors.toList());
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public Set<String> m_5698_(PackType type) {
        if (ResourceCacheManager.shouldUseCache()) {
            return this.cacheManager.getNamespaces(type);
        }
        return this.getNamespacesFromDisk(type);
    }

    @NotNull
    private Set<String> getNamespacesFromDisk(PackType type) {
        try {
            Path root = this.resolve(type.m_10305_());
            return Files.walk(root, 1, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(path -> root.relativize((Path)path)).filter(path -> path.getNameCount() > 0).map(p -> p.toString().replaceAll("/$", "")).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        }
        catch (IOException e) {
            if (type == PackType.SERVER_DATA) {
                return this.m_5698_(PackType.CLIENT_RESOURCES);
            }
            return Collections.emptySet();
        }
    }

    public InputStream m_8031_(PackType type, ResourceLocation location) throws IOException {
        if (location.m_135815_().startsWith("lang/")) {
            return super.m_8031_(PackType.CLIENT_RESOURCES, location);
        }
        return super.m_8031_(type, location);
    }

    public boolean m_7211_(PackType type, ResourceLocation location) {
        if (location.m_135815_().startsWith("lang/")) {
            return super.m_7211_(PackType.CLIENT_RESOURCES, location);
        }
        return super.m_7211_(type, location);
    }

    public void close() {
    }

    public String toString() {
        return String.format(Locale.ROOT, "%s: %s", ((Object)((Object)this)).getClass().getName(), this.getSource());
    }
}

