/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.gametest.framework.GameTestServer;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.handshake.ClientIntentionPacket;
import net.minecraft.network.protocol.login.ClientboundLoginDisconnectPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.StructureModifier;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FileUtils;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.gametest.ForgeGameTestHooks;
import net.minecraftforge.network.ConnectionType;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.ServerStatusPing;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.resource.PathPackResources;
import net.minecraftforge.server.LanguageHook;
import net.minecraftforge.server.permission.PermissionAPI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.spigotmc.SpigotConfig;

public class ServerLifecycleHooks {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker SERVERHOOKS = MarkerManager.getMarker((String)"SERVERHOOKS");
    private static final LevelResource SERVERCONFIG = new LevelResource("serverconfig");
    private static volatile CountDownLatch exitLatch = null;
    private static MinecraftServer currentServer;
    private static AtomicBoolean allowLogins;

    private static Path getServerConfigPath(MinecraftServer server) {
        Path serverConfig = server.m_129843_(SERVERCONFIG);
        FileUtils.getOrCreateDirectory((Path)serverConfig, (String)"serverconfig");
        return serverConfig;
    }

    public static boolean handleServerAboutToStart(MinecraftServer server) {
        currentServer = server;
        currentServer.m_129928_().setForgeData(new ServerStatusPing());
        LogicalSidedProvider.setServer(() -> server);
        ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.SERVER, ServerLifecycleHooks.getServerConfigPath(server));
        ServerLifecycleHooks.runModifiers(server);
        return !MinecraftForge.EVENT_BUS.post((Event)new ServerAboutToStartEvent(server));
    }

    public static boolean handleServerStarting(MinecraftServer server) {
        DistExecutor.runWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> {
            LanguageHook.loadLanguagesOnServer(server);
            if (!(server instanceof GameTestServer)) {
                ForgeGameTestHooks.registerGametests();
            }
        });
        PermissionAPI.initializePermissionAPI();
        return !MinecraftForge.EVENT_BUS.post((Event)new ServerStartingEvent(server));
    }

    public static void handleServerStarted(MinecraftServer server) {
        MinecraftForge.EVENT_BUS.post((Event)new ServerStartedEvent(server));
        allowLogins.set(true);
    }

    public static void handleServerStopping(MinecraftServer server) {
        allowLogins.set(false);
        MinecraftForge.EVENT_BUS.post((Event)new ServerStoppingEvent(server));
    }

    public static void expectServerStopped() {
        exitLatch = new CountDownLatch(1);
    }

    public static void handleServerStopped(MinecraftServer server) {
        if (!server.m_6982_()) {
            GameData.revertToFrozen();
        }
        MinecraftForge.EVENT_BUS.post((Event)new ServerStoppedEvent(server));
        currentServer = null;
        LogicalSidedProvider.setServer(null);
        CountDownLatch latch = exitLatch;
        if (latch != null) {
            latch.countDown();
            exitLatch = null;
        }
        ConfigTracker.INSTANCE.unloadConfigs(ModConfig.Type.SERVER, ServerLifecycleHooks.getServerConfigPath(server));
    }

    public static MinecraftServer getCurrentServer() {
        return currentServer;
    }

    public static boolean handleServerLogin(ClientIntentionPacket packet, Connection manager) {
        if (!allowLogins.get()) {
            MutableComponent text = Component.m_237113_((String)"Server is still starting! Please wait before reconnecting.");
            LOGGER.info(SERVERHOOKS, "Disconnecting Player (server is still starting): {}", (Object)text.m_214077_());
            manager.m_129512_((Packet)new ClientboundLoginDisconnectPacket((Component)text));
            manager.m_129507_((Component)text);
            return false;
        }
        if (packet.m_134735_() == ConnectionProtocol.LOGIN) {
            ConnectionType connectionType = ConnectionType.forVersionFlag(packet.getFMLVersion());
            int versionNumber = connectionType.getFMLVersionNumber(packet.getFMLVersion());
            if (connectionType == ConnectionType.MODDED && versionNumber != 3) {
                ServerLifecycleHooks.rejectConnection(manager, connectionType, "This modded server is not impl compatible with your modded client. Please verify your Forge version closely matches the server. Got net version " + versionNumber + " this server is net version 3");
                return false;
            }
            if (!SpigotConfig.bungee && connectionType == ConnectionType.VANILLA && !NetworkRegistry.acceptsVanillaClientConnections()) {
                ServerLifecycleHooks.rejectConnection(manager, connectionType, "This server has mods that require Forge to be installed on the client. Contact your server admin for more details.");
                return false;
            }
        }
        if (packet.m_134735_() == ConnectionProtocol.STATUS) {
            return true;
        }
        NetworkHooks.registerServerLoginChannel(manager, packet);
        return true;
    }

    private static void rejectConnection(Connection manager, ConnectionType type, String message) {
        manager.m_129498_(ConnectionProtocol.LOGIN);
        LOGGER.info(SERVERHOOKS, "Disconnecting {} connection attempt: {}", (Object)type, (Object)message);
        MutableComponent text = Component.m_237113_((String)message);
        manager.m_129512_((Packet)new ClientboundLoginDisconnectPacket((Component)text));
        manager.m_129507_((Component)text);
    }

    public static void handleExit(int retVal) {
        System.exit(retVal);
    }

    public static RepositorySource buildPackFinder(Map<IModFile, ? extends PathPackResources> modResourcePacks) {
        return (packList, factory) -> ServerLifecycleHooks.serverPackFinder(modResourcePacks, packList, factory);
    }

    private static void serverPackFinder(Map<IModFile, ? extends PathPackResources> modResourcePacks, Consumer<Pack> consumer, Pack.PackConstructor factory) {
        for (Map.Entry<IModFile, ? extends PathPackResources> e : modResourcePacks.entrySet()) {
            IModInfo mod = (IModInfo)e.getKey().getModInfos().get(0);
            if (Objects.equals(mod.getModId(), "minecraft")) continue;
            String name = "mod:" + mod.getModId();
            Pack packInfo = Pack.m_10430_((String)name, (boolean)false, e::getValue, (Pack.PackConstructor)factory, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10527_);
            if (packInfo == null) {
                ModLoader.get().addWarning(new ModLoadingWarning(mod, ModLoadingStage.ERROR, "fml.modloading.brokenresources", new Object[]{e.getKey()}));
                continue;
            }
            LOGGER.debug(Logging.CORE, "Generating PackInfo named {} for mod file {}", (Object)name, (Object)e.getKey().getFilePath());
            consumer.accept(packInfo);
        }
    }

    private static void runModifiers(MinecraftServer server) {
        RegistryAccess.Frozen registries = server.m_206579_();
        List<BiomeModifier> biomeModifiers = registries.m_175515_(ForgeRegistries.Keys.BIOME_MODIFIERS).m_203611_().map(Holder::m_203334_).toList();
        List<StructureModifier> structureModifiers = registries.m_175515_(ForgeRegistries.Keys.STRUCTURE_MODIFIERS).m_203611_().map(Holder::m_203334_).toList();
        registries.m_175515_(Registry.f_122885_).m_203611_().forEach(biomeHolder -> ((Biome)biomeHolder.m_203334_()).modifiableBiomeInfo().applyBiomeModifiers((Holder<Biome>)biomeHolder, biomeModifiers));
        registries.m_175515_(Registry.f_235725_).m_203611_().forEach(structureHolder -> ((Structure)structureHolder.m_203334_()).modifiableStructureInfo().applyStructureModifiers((Holder<Structure>)structureHolder, structureModifiers));
    }

    static {
        allowLogins = new AtomicBoolean(false);
    }
}

