/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R1;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.util.Date;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.UserBanList;
import net.minecraft.server.players.UserBanListEntry;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_19_R1.CraftProfileBanEntry;

public class CraftProfileBanList
implements BanList {
    private final UserBanList list;

    public CraftProfileBanList(UserBanList list) {
        this.list = list;
    }

    @Override
    public BanEntry getBanEntry(String target) {
        Validate.notNull((Object)target, (String)"Target cannot be null", (Object[])new Object[0]);
        GameProfile profile = this.getProfile(target);
        if (profile == null) {
            return null;
        }
        UserBanListEntry entry = (UserBanListEntry)this.list.m_11388_((Object)profile);
        if (entry == null) {
            return null;
        }
        return new CraftProfileBanEntry(profile, entry, this.list);
    }

    @Override
    public BanEntry addBan(String target, String reason, Date expires, String source) {
        Validate.notNull((Object)target, (String)"Ban target cannot be null", (Object[])new Object[0]);
        GameProfile profile = this.getProfile(target);
        if (profile == null) {
            return null;
        }
        UserBanListEntry entry = new UserBanListEntry(profile, new Date(), StringUtils.isBlank((CharSequence)source) ? null : source, expires, StringUtils.isBlank((CharSequence)reason) ? null : reason);
        this.list.m_11381_((StoredUserEntry)entry);
        try {
            this.list.m_11398_();
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Failed to save banned-players.json, {0}", ex.getMessage());
        }
        return new CraftProfileBanEntry(profile, entry, this.list);
    }

    @Override
    public Set<BanEntry> getBanEntries() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (StoredUserEntry entry : this.list.m_11395_()) {
            GameProfile profile = (GameProfile)entry.m_11373_();
            builder.add((Object)new CraftProfileBanEntry(profile, (UserBanListEntry)entry, this.list));
        }
        return builder.build();
    }

    @Override
    public boolean isBanned(String target) {
        Validate.notNull((Object)target, (String)"Target cannot be null", (Object[])new Object[0]);
        GameProfile profile = this.getProfile(target);
        if (profile == null) {
            return false;
        }
        return this.list.m_11406_(profile);
    }

    @Override
    public void pardon(String target) {
        Validate.notNull((Object)target, (String)"Target cannot be null", (Object[])new Object[0]);
        GameProfile profile = this.getProfile(target);
        this.list.m_11393_((Object)profile);
    }

    private GameProfile getProfile(String target) {
        UUID uuid = null;
        try {
            uuid = UUID.fromString(target);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return (uuid != null ? MinecraftServer.getServer().m_129927_().m_11002_(uuid) : MinecraftServer.getServer().m_129927_().m_10996_(target)).orElse(null);
    }
}

