/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R1.entity;

import com.google.common.base.Preconditions;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.Validate;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_19_R1.CraftServer;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_19_R1.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class CraftVillager
extends CraftAbstractVillager
implements Villager {
    public CraftVillager(CraftServer server, net.minecraft.world.entity.npc.Villager entity) {
        super(server, (AbstractVillager)entity);
    }

    public net.minecraft.world.entity.npc.Villager getHandle() {
        return (net.minecraft.world.entity.npc.Villager)this.entity;
    }

    @Override
    public String toString() {
        return "CraftVillager";
    }

    @Override
    public EntityType getType() {
        return EntityType.VILLAGER;
    }

    @Override
    public void remove() {
        this.getHandle().m_35524_();
        super.remove();
    }

    @Override
    public Villager.Profession getProfession() {
        return CraftVillager.nmsToBukkitProfession(this.getHandle().m_7141_().m_35571_());
    }

    @Override
    public void setProfession(Villager.Profession profession) {
        Validate.notNull((Object)profession);
        this.getHandle().m_34375_(this.getHandle().m_7141_().m_35565_(CraftVillager.bukkitToNmsProfession(profession)));
    }

    @Override
    public Villager.Type getVillagerType() {
        return Villager.Type.valueOf(Registry.f_122868_.m_7981_((Object)this.getHandle().m_7141_().m_35560_()).m_135815_().toUpperCase(Locale.ROOT));
    }

    @Override
    public void setVillagerType(Villager.Type type) {
        Validate.notNull((Object)type);
        this.getHandle().m_34375_(this.getHandle().m_7141_().m_35567_((VillagerType)Registry.f_122868_.m_7745_(CraftNamespacedKey.toMinecraft(type.getKey()))));
    }

    @Override
    public int getVillagerLevel() {
        return this.getHandle().m_7141_().m_35576_();
    }

    @Override
    public void setVillagerLevel(int level) {
        Preconditions.checkArgument((1 <= level && level <= 5 ? 1 : 0) != 0, (Object)"level must be between [1, 5]");
        this.getHandle().m_34375_(this.getHandle().m_7141_().m_35561_(level));
    }

    @Override
    public int getVillagerExperience() {
        return this.getHandle().m_7809_();
    }

    @Override
    public void setVillagerExperience(int experience) {
        Preconditions.checkArgument((experience >= 0 ? 1 : 0) != 0, (Object)"Experience must be positive");
        this.getHandle().m_35546_(experience);
    }

    @Override
    public boolean sleep(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location needs to be in a world");
        Preconditions.checkArgument((boolean)location.getWorld().equals(this.getWorld()), (Object)"Cannot sleep across worlds");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot sleep during world generation");
        BlockPos position = new BlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        BlockState iblockdata = this.getHandle().f_19853_.m_8055_(position);
        if (!(iblockdata.m_60734_() instanceof BedBlock)) {
            return false;
        }
        this.getHandle().m_5802_(position);
        return true;
    }

    @Override
    public void wakeup() {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Cannot wakeup if not sleeping");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot wakeup during world generation");
        this.getHandle().m_5796_();
    }

    @Override
    public void shakeHead() {
        this.getHandle().m_35518_();
    }

    @Override
    public ZombieVillager zombify() {
        net.minecraft.world.entity.monster.ZombieVillager entityzombievillager = Zombie.zombifyVillager((ServerLevel)this.getHandle().f_19853_.getMinecraftWorld(), (net.minecraft.world.entity.npc.Villager)this.getHandle(), (BlockPos)this.getHandle().m_20183_(), (boolean)this.isSilent(), (CreatureSpawnEvent.SpawnReason)CreatureSpawnEvent.SpawnReason.CUSTOM);
        return entityzombievillager != null ? (ZombieVillager)((Object)entityzombievillager.getBukkitEntity()) : null;
    }

    public static Villager.Profession nmsToBukkitProfession(VillagerProfession nms) {
        return Villager.Profession.valueOf(Registry.f_122869_.m_7981_((Object)nms).m_135815_().toUpperCase(Locale.ROOT));
    }

    public static VillagerProfession bukkitToNmsProfession(Villager.Profession bukkit) {
        return (VillagerProfession)Registry.f_122869_.m_7745_(CraftNamespacedKey.toMinecraft(bukkit.getKey()));
    }
}

