/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R1.inventory;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.world.item.CreativeModeTab;
import org.bukkit.inventory.CreativeCategory;

public final class CraftCreativeCategory {
    private static final Map<CreativeModeTab, CreativeCategory> NMS_TO_BUKKIT = ImmutableMap.builder().put((Object)CreativeModeTab.f_40749_, (Object)CreativeCategory.BUILDING_BLOCKS).put((Object)CreativeModeTab.f_40750_, (Object)CreativeCategory.DECORATIONS).put((Object)CreativeModeTab.f_40751_, (Object)CreativeCategory.REDSTONE).put((Object)CreativeModeTab.f_40752_, (Object)CreativeCategory.TRANSPORTATION).put((Object)CreativeModeTab.f_40753_, (Object)CreativeCategory.MISC).put((Object)CreativeModeTab.f_40755_, (Object)CreativeCategory.FOOD).put((Object)CreativeModeTab.f_40756_, (Object)CreativeCategory.TOOLS).put((Object)CreativeModeTab.f_40757_, (Object)CreativeCategory.COMBAT).put((Object)CreativeModeTab.f_40758_, (Object)CreativeCategory.BREWING).build();

    public static CreativeCategory fromNMS(CreativeModeTab tab) {
        if (tab == null) {
            return null;
        }
        CreativeCategory bukkit = NMS_TO_BUKKIT.get(tab);
        if (bukkit == null) {
            throw new UnsupportedOperationException("Item is not present in any known CreativeModeTab. This is a bug.");
        }
        return bukkit;
    }
}

