/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R1.inventory;

import java.util.Arrays;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import org.bukkit.craftbukkit.v1_19_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_19_R1.inventory.CraftItemStack;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;

public class CraftInventoryCrafting
extends CraftInventory
implements CraftingInventory {
    private final Container resultInventory;

    public CraftInventoryCrafting(Container inventory, Container resultInventory) {
        super(inventory);
        this.resultInventory = resultInventory;
    }

    public Container getResultInventory() {
        return this.resultInventory;
    }

    public Container getMatrixInventory() {
        return this.inventory;
    }

    @Override
    public int getSize() {
        return this.getResultInventory().m_6643_() + this.getMatrixInventory().m_6643_();
    }

    @Override
    public void setContents(ItemStack[] items) {
        if (this.getSize() > items.length) {
            throw new IllegalArgumentException("Invalid inventory size; expected " + this.getSize() + " or less");
        }
        this.setContents(items[0], Arrays.copyOfRange(items, 1, items.length));
    }

    @Override
    public ItemStack[] getContents() {
        ItemStack[] items = new ItemStack[this.getSize()];
        List mcResultItems = this.getResultInventory().getContents();
        int i = 0;
        for (i = 0; i < mcResultItems.size(); ++i) {
            items[i] = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)mcResultItems.get(i));
        }
        List mcItems = this.getMatrixInventory().getContents();
        for (int j = 0; j < mcItems.size(); ++j) {
            items[i + j] = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)mcItems.get(j));
        }
        return items;
    }

    public void setContents(ItemStack result, ItemStack[] contents) {
        this.setResult(result);
        this.setMatrix(contents);
    }

    @Override
    public CraftItemStack getItem(int index) {
        if (index < this.getResultInventory().m_6643_()) {
            net.minecraft.world.item.ItemStack item = this.getResultInventory().m_8020_(index);
            return item.m_41619_() ? null : CraftItemStack.asCraftMirror(item);
        }
        net.minecraft.world.item.ItemStack item = this.getMatrixInventory().m_8020_(index - this.getResultInventory().m_6643_());
        return item.m_41619_() ? null : CraftItemStack.asCraftMirror(item);
    }

    @Override
    public void setItem(int index, ItemStack item) {
        if (index < this.getResultInventory().m_6643_()) {
            this.getResultInventory().m_6836_(index, CraftItemStack.asNMSCopy(item));
        } else {
            this.getMatrixInventory().m_6836_(index - this.getResultInventory().m_6643_(), CraftItemStack.asNMSCopy(item));
        }
    }

    @Override
    public ItemStack[] getMatrix() {
        List matrix = this.getMatrixInventory().getContents();
        return this.asCraftMirror(matrix);
    }

    @Override
    public ItemStack getResult() {
        net.minecraft.world.item.ItemStack item = this.getResultInventory().m_8020_(0);
        if (!item.m_41619_()) {
            return CraftItemStack.asCraftMirror(item);
        }
        return null;
    }

    @Override
    public void setMatrix(ItemStack[] contents) {
        if (this.getMatrixInventory().m_6643_() > contents.length) {
            throw new IllegalArgumentException("Invalid inventory size; expected " + this.getMatrixInventory().m_6643_() + " or less");
        }
        for (int i = 0; i < this.getMatrixInventory().m_6643_(); ++i) {
            if (i < contents.length) {
                this.getMatrixInventory().m_6836_(i, CraftItemStack.asNMSCopy(contents[i]));
                continue;
            }
            this.getMatrixInventory().m_6836_(i, net.minecraft.world.item.ItemStack.f_41583_);
        }
    }

    @Override
    public void setResult(ItemStack item) {
        List contents = this.getResultInventory().getContents();
        contents.set(0, CraftItemStack.asNMSCopy(item));
    }

    @Override
    public org.bukkit.inventory.Recipe getRecipe() {
        Recipe recipe = this.getInventory().getCurrentRecipe();
        return recipe == null ? null : recipe.toBukkitRecipe();
    }
}

