/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R1.inventory;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.apache.commons.lang3.Validate;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_19_R1.block.CraftBanner;
import org.bukkit.craftbukkit.v1_19_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_19_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_19_R1.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_19_R1.inventory.CraftMetaBanner;
import org.bukkit.craftbukkit.v1_19_R1.inventory.CraftMetaItem;
import org.bukkit.inventory.meta.BlockStateMeta;

@DelegateDeserialization(value=CraftMetaItem.SerializableMeta.class)
public class CraftMetaBlockState
extends CraftMetaItem
implements BlockStateMeta {
    private static final Set<Material> SHULKER_BOX_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.SHULKER_BOX, Material.WHITE_SHULKER_BOX, Material.ORANGE_SHULKER_BOX, Material.MAGENTA_SHULKER_BOX, Material.LIGHT_BLUE_SHULKER_BOX, Material.YELLOW_SHULKER_BOX, Material.LIME_SHULKER_BOX, Material.PINK_SHULKER_BOX, Material.GRAY_SHULKER_BOX, Material.LIGHT_GRAY_SHULKER_BOX, Material.CYAN_SHULKER_BOX, Material.PURPLE_SHULKER_BOX, Material.BLUE_SHULKER_BOX, Material.BROWN_SHULKER_BOX, Material.GREEN_SHULKER_BOX, Material.RED_SHULKER_BOX, Material.BLACK_SHULKER_BOX});
    private static final Set<Material> BLOCK_STATE_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.FURNACE, Material.CHEST, Material.TRAPPED_CHEST, Material.JUKEBOX, Material.DISPENSER, Material.DROPPER, Material.ACACIA_SIGN, Material.ACACIA_WALL_SIGN, Material.BIRCH_SIGN, Material.BIRCH_WALL_SIGN, Material.CRIMSON_SIGN, Material.CRIMSON_WALL_SIGN, Material.DARK_OAK_SIGN, Material.DARK_OAK_WALL_SIGN, Material.JUNGLE_SIGN, Material.JUNGLE_WALL_SIGN, Material.MANGROVE_SIGN, Material.MANGROVE_WALL_SIGN, Material.OAK_SIGN, Material.OAK_WALL_SIGN, Material.SPRUCE_SIGN, Material.SPRUCE_WALL_SIGN, Material.WARPED_SIGN, Material.WARPED_WALL_SIGN, Material.SPAWNER, Material.BREWING_STAND, Material.ENCHANTING_TABLE, Material.COMMAND_BLOCK, Material.REPEATING_COMMAND_BLOCK, Material.CHAIN_COMMAND_BLOCK, Material.BEACON, Material.DAYLIGHT_DETECTOR, Material.HOPPER, Material.COMPARATOR, Material.SHIELD, Material.STRUCTURE_BLOCK, Material.ENDER_CHEST, Material.BARREL, Material.BELL, Material.BLAST_FURNACE, Material.CAMPFIRE, Material.SOUL_CAMPFIRE, Material.JIGSAW, Material.LECTERN, Material.SMOKER, Material.BEEHIVE, Material.BEE_NEST, Material.SCULK_CATALYST, Material.SCULK_SHRIEKER, Material.SCULK_SENSOR});
    static final CraftMetaItem.ItemMetaKey BLOCK_ENTITY_TAG;
    final Material material;
    CompoundTag blockEntityTag;

    CraftMetaBlockState(CraftMetaItem meta, Material material) {
        super(meta);
        this.material = material;
        if (!(meta instanceof CraftMetaBlockState) || ((CraftMetaBlockState)meta).material != material) {
            this.blockEntityTag = null;
            return;
        }
        CraftMetaBlockState te = (CraftMetaBlockState)meta;
        this.blockEntityTag = te.blockEntityTag;
    }

    CraftMetaBlockState(CompoundTag tag, Material material) {
        super(tag);
        this.material = material;
        this.blockEntityTag = tag.m_128425_(CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT, 10) ? tag.m_128469_(CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT).m_6426_() : null;
    }

    CraftMetaBlockState(Map<String, Object> map) {
        super(map);
        String matName = CraftMetaItem.SerializableMeta.getString(map, "blockMaterial", true);
        Material m = Material.getMaterial(matName);
        this.material = m != null ? m : Material.AIR;
    }

    @Override
    void applyToItem(CompoundTag tag) {
        super.applyToItem(tag);
        if (this.blockEntityTag != null) {
            tag.m_128365_(CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT, (Tag)this.blockEntityTag);
        }
    }

    @Override
    void deserializeInternal(CompoundTag tag, Object context) {
        super.deserializeInternal(tag, context);
        if (tag.m_128425_(CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT, 10)) {
            this.blockEntityTag = tag.m_128469_(CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT);
        }
    }

    @Override
    void serializeInternal(Map<String, Tag> internalTags) {
        if (this.blockEntityTag != null) {
            internalTags.put(CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT, (Tag)this.blockEntityTag);
        }
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        builder.put((Object)"blockMaterial", (Object)this.material.name());
        return builder;
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.blockEntityTag != null) {
            hash = 61 * hash + this.blockEntityTag.hashCode();
        }
        return original != hash ? CraftMetaBlockState.class.hashCode() ^ hash : hash;
    }

    @Override
    public boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaBlockState) {
            CraftMetaBlockState that = (CraftMetaBlockState)meta;
            return Objects.equal((Object)this.blockEntityTag, (Object)that.blockEntityTag);
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaBlockState || this.blockEntityTag == null);
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.blockEntityTag == null;
    }

    @Override
    boolean applicableTo(Material type) {
        return BLOCK_STATE_MATERIALS.contains(type);
    }

    @Override
    public CraftMetaBlockState clone() {
        CraftMetaBlockState meta = (CraftMetaBlockState)super.clone();
        if (this.blockEntityTag != null) {
            meta.blockEntityTag = this.blockEntityTag.m_6426_();
        }
        return meta;
    }

    @Override
    public boolean hasBlockState() {
        return this.blockEntityTag != null;
    }

    @Override
    public BlockState getBlockState() {
        Material stateMaterial;
        Material material = stateMaterial = this.material != Material.SHIELD ? this.material : CraftMetaBlockState.shieldToBannerHack(this.blockEntityTag);
        if (this.blockEntityTag != null) {
            if (this.material == Material.SHIELD) {
                this.blockEntityTag.m_128359_("id", "minecraft:banner");
            } else if (this.material == Material.BEE_NEST || this.material == Material.BEEHIVE) {
                this.blockEntityTag.m_128359_("id", "minecraft:beehive");
            } else if (SHULKER_BOX_MATERIALS.contains(this.material)) {
                this.blockEntityTag.m_128359_("id", "minecraft:shulker_box");
            }
        }
        return CraftBlockStates.getBlockState(stateMaterial, this.blockEntityTag);
    }

    @Override
    public void setBlockState(BlockState blockState) {
        Material stateMaterial = this.material != Material.SHIELD ? this.material : CraftMetaBlockState.shieldToBannerHack(this.blockEntityTag);
        Class<? extends CraftBlockState> blockStateType = CraftBlockStates.getBlockStateType(stateMaterial);
        Validate.isTrue((blockStateType == blockState.getClass() && blockState instanceof CraftBlockEntityState ? 1 : 0) != 0, (String)("Invalid blockState for " + this.material), (Object[])new Object[0]);
        this.blockEntityTag = ((CraftBlockEntityState)blockState).getSnapshotNBT();
        if (this.material == Material.SHIELD) {
            this.blockEntityTag.m_128405_(CraftMetaBanner.BASE.NBT, (int)((CraftBanner)blockState).getBaseColor().getWoolData());
        }
    }

    private static Material shieldToBannerHack(CompoundTag tag) {
        if (tag == null || !tag.m_128425_(CraftMetaBanner.BASE.NBT, 3)) {
            return Material.WHITE_BANNER;
        }
        switch (tag.m_128451_(CraftMetaBanner.BASE.NBT)) {
            case 0: {
                return Material.WHITE_BANNER;
            }
            case 1: {
                return Material.ORANGE_BANNER;
            }
            case 2: {
                return Material.MAGENTA_BANNER;
            }
            case 3: {
                return Material.LIGHT_BLUE_BANNER;
            }
            case 4: {
                return Material.YELLOW_BANNER;
            }
            case 5: {
                return Material.LIME_BANNER;
            }
            case 6: {
                return Material.PINK_BANNER;
            }
            case 7: {
                return Material.GRAY_BANNER;
            }
            case 8: {
                return Material.LIGHT_GRAY_BANNER;
            }
            case 9: {
                return Material.CYAN_BANNER;
            }
            case 10: {
                return Material.PURPLE_BANNER;
            }
            case 11: {
                return Material.BLUE_BANNER;
            }
            case 12: {
                return Material.BROWN_BANNER;
            }
            case 13: {
                return Material.GREEN_BANNER;
            }
            case 14: {
                return Material.RED_BANNER;
            }
            case 15: {
                return Material.BLACK_BANNER;
            }
        }
        throw new IllegalArgumentException("Unknown banner colour");
    }

    static {
        BLOCK_STATE_MATERIALS.addAll(SHULKER_BOX_MATERIALS);
        BLOCK_ENTITY_TAG = new CraftMetaItem.ItemMetaKey("BlockEntityTag");
    }
}

