/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R1.scoreboard;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R1.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_19_R1.util.WeakCollection;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.ScoreboardManager;

public final class CraftScoreboardManager
implements ScoreboardManager {
    private final CraftScoreboard mainScoreboard;
    private final MinecraftServer server;
    private final Collection<CraftScoreboard> scoreboards = new WeakCollection<CraftScoreboard>();
    private final Map<CraftPlayer, CraftScoreboard> playerBoards = new HashMap<CraftPlayer, CraftScoreboard>();

    public CraftScoreboardManager(MinecraftServer minecraftserver, Scoreboard scoreboardServer) {
        this.mainScoreboard = new CraftScoreboard(scoreboardServer);
        this.server = minecraftserver;
        this.scoreboards.add(this.mainScoreboard);
    }

    @Override
    public CraftScoreboard getMainScoreboard() {
        return this.mainScoreboard;
    }

    @Override
    public CraftScoreboard getNewScoreboard() {
        CraftScoreboard scoreboard = new CraftScoreboard((Scoreboard)new ServerScoreboard(this.server));
        this.scoreboards.add(scoreboard);
        return scoreboard;
    }

    public CraftScoreboard getPlayerBoard(CraftPlayer player) {
        CraftScoreboard board = this.playerBoards.get(player);
        return board == null ? this.getMainScoreboard() : board;
    }

    public void setPlayerBoard(CraftPlayer player, org.bukkit.scoreboard.Scoreboard bukkitScoreboard) throws IllegalArgumentException {
        Validate.isTrue((boolean)(bukkitScoreboard instanceof CraftScoreboard), (String)"Cannot set player scoreboard to an unregistered Scoreboard", (Object[])new Object[0]);
        CraftScoreboard scoreboard = (CraftScoreboard)bukkitScoreboard;
        Scoreboard oldboard = this.getPlayerBoard(player).getHandle();
        Scoreboard newboard = scoreboard.getHandle();
        ServerPlayer entityplayer = player.getHandle();
        if (oldboard == newboard) {
            return;
        }
        if (scoreboard == this.mainScoreboard) {
            this.playerBoards.remove(player);
        } else {
            this.playerBoards.put(player, scoreboard);
        }
        HashSet<Objective> removed = new HashSet<Objective>();
        for (int i = 0; i < 3; ++i) {
            Objective scoreboardobjective = oldboard.m_83416_(i);
            if (scoreboardobjective == null || removed.contains(scoreboardobjective)) continue;
            entityplayer.f_8906_.m_9829_((Packet)new ClientboundSetObjectivePacket(scoreboardobjective, 1));
            removed.add(scoreboardobjective);
        }
        for (PlayerTeam scoreboardteam : oldboard.m_83491_()) {
            entityplayer.f_8906_.m_9829_((Packet)ClientboundSetPlayerTeamPacket.m_179326_((PlayerTeam)scoreboardteam));
        }
        this.server.m_6846_().m_11273_((ServerScoreboard)newboard, player.getHandle());
    }

    public void removePlayer(Player player) {
        this.playerBoards.remove(player);
    }

    public void getScoreboardScores(ObjectiveCriteria criteria, String name, Consumer<Score> consumer) {
        for (CraftScoreboard scoreboard : this.scoreboards) {
            Scoreboard board = scoreboard.board;
            board.m_83427_(criteria, name, score -> consumer.accept((Score)score));
        }
    }
}

