/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R1.structure;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.apache.commons.lang3.Validate;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_19_R1.structure.CraftStructure;
import org.bukkit.craftbukkit.v1_19_R1.util.CraftNamespacedKey;
import org.bukkit.structure.Structure;
import org.bukkit.structure.StructureManager;

public class CraftStructureManager
implements StructureManager {
    private final StructureTemplateManager structureManager;

    public CraftStructureManager(StructureTemplateManager structureManager) {
        this.structureManager = structureManager;
    }

    @Override
    public Map<NamespacedKey, Structure> getStructures() {
        HashMap cachedStructures = new HashMap();
        for (Map.Entry entry : this.structureManager.f_230345_.entrySet()) {
            ((Optional)entry.getValue()).ifPresent(definedStructure -> cachedStructures.put(CraftNamespacedKey.fromMinecraft((ResourceLocation)entry.getKey()), new CraftStructure((StructureTemplate)definedStructure)));
        }
        return Collections.unmodifiableMap(cachedStructures);
    }

    @Override
    public Structure getStructure(NamespacedKey structureKey) {
        Validate.notNull((Object)structureKey, (String)"structureKey cannot be null", (Object[])new Object[0]);
        Optional definedStructure = (Optional)this.structureManager.f_230345_.get(CraftNamespacedKey.toMinecraft(structureKey));
        if (definedStructure == null) {
            return null;
        }
        return definedStructure.map(CraftStructure::new).orElse(null);
    }

    @Override
    public Structure loadStructure(NamespacedKey structureKey, boolean register) {
        ResourceLocation minecraftKey = this.createAndValidateMinecraftStructureKey(structureKey);
        Optional structure = (Optional)this.structureManager.f_230345_.get(minecraftKey);
        structure = structure == null ? Optional.empty() : structure;
        structure = structure.isPresent() ? structure : this.structureManager.m_230431_(minecraftKey);
        Optional optional = structure = structure.isPresent() ? structure : this.structureManager.loadFromResource0(minecraftKey);
        if (register) {
            this.structureManager.f_230345_.put(minecraftKey, structure);
        }
        return structure.map(CraftStructure::new).orElse(null);
    }

    @Override
    public Structure loadStructure(NamespacedKey structureKey) {
        return this.loadStructure(structureKey, true);
    }

    @Override
    public void saveStructure(NamespacedKey structureKey) {
        ResourceLocation minecraftKey = this.createAndValidateMinecraftStructureKey(structureKey);
        this.structureManager.m_230416_(minecraftKey);
    }

    @Override
    public void saveStructure(NamespacedKey structureKey, Structure structure) throws IOException {
        Validate.notNull((Object)structure, (String)"structure cannot be null", (Object[])new Object[0]);
        File structureFile = this.getStructureFile(structureKey);
        Files.createDirectories(structureFile.toPath().getParent(), new FileAttribute[0]);
        this.saveStructure(structureFile, structure);
    }

    @Override
    public Structure registerStructure(NamespacedKey structureKey, Structure structure) {
        Validate.notNull((Object)structure, (String)"structure cannot be null", (Object[])new Object[0]);
        ResourceLocation minecraftKey = this.createAndValidateMinecraftStructureKey(structureKey);
        Optional<StructureTemplate> optionalDefinedStructure = Optional.of(((CraftStructure)structure).getHandle());
        Optional<StructureTemplate> previousStructure = this.structureManager.f_230345_.put(minecraftKey, optionalDefinedStructure);
        return previousStructure == null ? null : (Structure)previousStructure.map(CraftStructure::new).orElse(null);
    }

    @Override
    public Structure unregisterStructure(NamespacedKey structureKey) {
        ResourceLocation minecraftKey = this.createAndValidateMinecraftStructureKey(structureKey);
        Optional previousStructure = (Optional)this.structureManager.f_230345_.remove(minecraftKey);
        return previousStructure == null ? null : (Structure)previousStructure.map(CraftStructure::new).orElse(null);
    }

    @Override
    public void deleteStructure(NamespacedKey structureKey) throws IOException {
        this.deleteStructure(structureKey, true);
    }

    @Override
    public void deleteStructure(NamespacedKey structureKey, boolean unregister) throws IOException {
        ResourceLocation key = CraftNamespacedKey.toMinecraft(structureKey);
        if (unregister) {
            this.structureManager.f_230345_.remove(key);
        }
        Path path = this.structureManager.m_230361_(key, ".nbt");
        Files.deleteIfExists(path);
    }

    @Override
    public File getStructureFile(NamespacedKey structureKey) {
        ResourceLocation minecraftKey = this.createAndValidateMinecraftStructureKey(structureKey);
        return this.structureManager.m_230361_(minecraftKey, ".nbt").toFile();
    }

    @Override
    public Structure loadStructure(File file) throws IOException {
        Validate.notNull((Object)file, (String)"file cannot be null", (Object[])new Object[0]);
        FileInputStream fileinputstream = new FileInputStream(file);
        return this.loadStructure(fileinputstream);
    }

    @Override
    public Structure loadStructure(InputStream inputStream) throws IOException {
        Validate.notNull((Object)inputStream, (String)"inputStream cannot be null", (Object[])new Object[0]);
        return new CraftStructure(this.structureManager.m_230377_(inputStream));
    }

    @Override
    public void saveStructure(File file, Structure structure) throws IOException {
        Validate.notNull((Object)file, (String)"file cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)structure, (String)"structure cannot be null", (Object[])new Object[0]);
        FileOutputStream fileoutputstream = new FileOutputStream(file);
        this.saveStructure(fileoutputstream, structure);
    }

    @Override
    public void saveStructure(OutputStream outputStream, Structure structure) throws IOException {
        Validate.notNull((Object)outputStream, (String)"outputStream cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)structure, (String)"structure cannot be null", (Object[])new Object[0]);
        CompoundTag nbttagcompound = ((CraftStructure)structure).getHandle().m_74618_(new CompoundTag());
        NbtIo.m_128947_((CompoundTag)nbttagcompound, (OutputStream)outputStream);
    }

    @Override
    public Structure createStructure() {
        return new CraftStructure(new StructureTemplate());
    }

    private ResourceLocation createAndValidateMinecraftStructureKey(NamespacedKey structureKey) {
        Validate.notNull((Object)structureKey, (String)"structureKey cannot be null", (Object[])new Object[0]);
        ResourceLocation minecraftkey = CraftNamespacedKey.toMinecraft(structureKey);
        if (minecraftkey.m_135815_().contains("//")) {
            throw new IllegalArgumentException("Resource key for Structures can not contain \"//\"");
        }
        return minecraftkey;
    }

    @Override
    public Structure copy(Structure structure) {
        return new CraftStructure(this.structureManager.m_230404_(((CraftStructure)structure).getHandle().m_74618_(new CompoundTag())));
    }
}

