/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.tags;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagManager;
import org.slf4j.Logger;

public abstract class TagsProvider<T>
implements DataProvider {
    private static final Logger f_126541_ = LogUtils.getLogger();
    protected final PackOutput.PathProvider f_236439_;
    protected final CompletableFuture<HolderLookup.Provider> f_254646_;
    protected final ResourceKey<? extends Registry<T>> f_254716_;
    private final Map<ResourceLocation, TagBuilder> f_126543_ = Maps.newLinkedHashMap();

    protected TagsProvider(PackOutput p_256596_, ResourceKey<? extends Registry<T>> p_255886_, CompletableFuture<HolderLookup.Provider> p_256513_) {
        this.f_236439_ = p_256596_.m_245269_(PackOutput.Target.DATA_PACK, TagManager.m_203918_(p_255886_));
        this.f_254646_ = p_256513_;
        this.f_254716_ = p_255886_;
    }

    @Override
    public final String m_6055_() {
        return "Tags for " + this.f_254716_.m_135782_();
    }

    protected abstract void m_6577_(HolderLookup.Provider var1);

    @Override
    public CompletableFuture<?> m_213708_(CachedOutput p_253684_) {
        return this.f_254646_.thenCompose(p_255494_ -> {
            this.f_126543_.clear();
            this.m_6577_((HolderLookup.Provider)p_255494_);
            HolderLookup.RegistryLookup $$2 = p_255494_.m_255025_(this.f_254716_);
            Predicate<ResourceLocation> $$3 = p_255496_ -> $$2.m_254902_(ResourceKey.m_135785_(this.f_254716_, p_255496_)).isPresent();
            return CompletableFuture.allOf((CompletableFuture[])this.f_126543_.entrySet().stream().map(p_255499_ -> {
                ResourceLocation $$3 = (ResourceLocation)p_255499_.getKey();
                TagBuilder $$4 = (TagBuilder)p_255499_.getValue();
                List<TagEntry> $$5 = $$4.m_215904_();
                List<TagEntry> $$6 = $$5.stream().filter(p_255492_ -> !p_255492_.m_215940_($$3, this.f_126543_::containsKey)).toList();
                if (!$$6.isEmpty()) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Couldn't define tag %s as it is missing following references: %s", $$3, $$6.stream().map(Objects::toString).collect(Collectors.joining(","))));
                }
                JsonElement $$7 = (JsonElement)TagFile.f_215958_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new TagFile($$5, false)).getOrThrow(false, arg_0 -> ((Logger)f_126541_).error(arg_0));
                Path $$8 = this.f_236439_.m_245731_($$3);
                return DataProvider.m_253162_(p_253684_, $$7, $$8);
            }).toArray(CompletableFuture[]::new));
        });
    }

    protected TagAppender<T> m_206424_(TagKey<T> p_206425_) {
        TagBuilder $$1 = this.m_236451_(p_206425_);
        return new TagAppender($$1);
    }

    protected TagBuilder m_236451_(TagKey<T> p_236452_) {
        return this.f_126543_.computeIfAbsent(p_236452_.f_203868_(), p_236442_ -> TagBuilder.m_215899_());
    }

    protected static class TagAppender<T> {
        private final TagBuilder f_126568_;

        protected TagAppender(TagBuilder p_256426_) {
            this.f_126568_ = p_256426_;
        }

        public final TagAppender<T> m_255204_(ResourceKey<T> p_256138_) {
            this.f_126568_.m_215900_(p_256138_.m_135782_());
            return this;
        }

        @SafeVarargs
        public final TagAppender<T> m_211101_(ResourceKey<T> ... p_211102_) {
            for (ResourceKey<T> $$1 : p_211102_) {
                this.f_126568_.m_215900_($$1.m_135782_());
            }
            return this;
        }

        public TagAppender<T> m_176839_(ResourceLocation p_176840_) {
            this.f_126568_.m_215905_(p_176840_);
            return this;
        }

        public TagAppender<T> m_206428_(TagKey<T> p_206429_) {
            this.f_126568_.m_215907_(p_206429_.f_203868_());
            return this;
        }

        public TagAppender<T> m_176841_(ResourceLocation p_176842_) {
            this.f_126568_.m_215909_(p_176842_);
            return this;
        }
    }
}

