/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.OutputStream;
import java.net.Proxy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.CrashReport;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.Bootstrap;
import net.minecraft.server.Eula;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Services;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.level.progress.LoggerChunkProgressListener;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.worldupdate.WorldUpgrader;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import org.slf4j.Logger;

public class Main {
    private static final Logger f_129670_ = LogUtils.getLogger();

    /*
     * WARNING - void declaration
     */
    @DontObfuscate
    public static void main(String[] p_129699_) {
        SharedConstants.m_142977_();
        OptionParser $$1 = new OptionParser();
        OptionSpecBuilder $$2 = $$1.accepts("nogui");
        OptionSpecBuilder $$3 = $$1.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder $$4 = $$1.accepts("demo");
        OptionSpecBuilder $$5 = $$1.accepts("bonusChest");
        OptionSpecBuilder $$6 = $$1.accepts("forceUpgrade");
        OptionSpecBuilder $$7 = $$1.accepts("eraseCache");
        OptionSpecBuilder $$8 = $$1.accepts("safeMode", "Loads level with vanilla datapack only");
        AbstractOptionSpec $$9 = $$1.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec $$10 = $$1.accepts("singleplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec $$11 = $$1.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec $$12 = $$1.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec $$13 = $$1.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec $$14 = $$1.accepts("serverId").withRequiredArg();
        OptionSpecBuilder $$15 = $$1.accepts("jfrProfile");
        NonOptionArgumentSpec $$16 = $$1.nonOptions();
        try {
            void $$33;
            boolean $$28;
            OptionSet $$17 = $$1.parse(p_129699_);
            if ($$17.has((OptionSpec)$$9)) {
                $$1.printHelpOn((OutputStream)System.err);
                return;
            }
            CrashReport.m_127529_();
            if ($$17.has((OptionSpec)$$15)) {
                JvmProfiler.f_185340_.m_183425_(Environment.SERVER);
            }
            Bootstrap.m_135870_();
            Bootstrap.m_135889_();
            Util.m_137584_();
            Path $$18 = Paths.get("server.properties", new String[0]);
            DedicatedServerSettings $$19 = new DedicatedServerSettings($$18);
            $$19.m_139780_();
            Path $$20 = Paths.get("eula.txt", new String[0]);
            Eula $$21 = new Eula($$20);
            if ($$17.has((OptionSpec)$$3)) {
                f_129670_.info("Initialized '{}' and '{}'", (Object)$$18.toAbsolutePath(), (Object)$$20.toAbsolutePath());
                return;
            }
            if (!$$21.m_135944_()) {
                f_129670_.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            File $$22 = new File((String)$$17.valueOf((OptionSpec)$$11));
            Services $$23 = Services.m_214344_(new YggdrasilAuthenticationService(Proxy.NO_PROXY), $$22);
            String $$24 = Optional.ofNullable((String)$$17.valueOf((OptionSpec)$$12)).orElse($$19.m_139777_().f_139741_);
            LevelStorageSource $$25 = LevelStorageSource.m_78242_($$22.toPath());
            LevelStorageSource.LevelStorageAccess $$26 = $$25.m_78260_($$24);
            LevelSummary $$27 = $$26.m_78308_();
            if ($$27 != null) {
                if ($$27.m_193020_()) {
                    f_129670_.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!$$27.m_193021_()) {
                    f_129670_.info("This world was created by an incompatible version.");
                    return;
                }
            }
            if ($$28 = $$17.has((OptionSpec)$$8)) {
                f_129670_.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            PackRepository $$29 = ServerPacksSource.m_245786_($$26.m_78283_(LevelResource.f_78180_));
            try {
                WorldLoader.InitConfig $$30 = Main.m_245383_($$19.m_139777_(), $$26, $$28, $$29);
                WorldStem $$31 = (WorldStem)Util.m_214679_(arg_0 -> Main.m_244800_($$30, $$26, $$17, (OptionSpec)$$4, $$19, (OptionSpec)$$5, arg_0)).get();
            }
            catch (Exception $$32) {
                f_129670_.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)$$32);
                return;
            }
            RegistryAccess.Frozen $$34 = $$33.f_244542_().m_247579_();
            if ($$17.has((OptionSpec)$$6)) {
                Main.m_195488_($$26, DataFixers.m_14512_(), $$17.has((OptionSpec)$$7), () -> true, $$34.m_175515_(Registries.f_256862_));
            }
            WorldData $$35 = $$33.f_206895_();
            $$26.m_78287_($$34, $$35);
            final DedicatedServer $$36 = MinecraftServer.m_129872_(arg_0 -> Main.m_236697_($$26, $$29, (WorldStem)$$33, $$19, $$23, $$17, (OptionSpec)$$10, (OptionSpec)$$13, (OptionSpec)$$4, (OptionSpec)$$14, (OptionSpec)$$2, (OptionSpec)$$16, arg_0));
            Thread $$37 = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    $$36.m_7570_(true);
                }
            };
            $$37.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(f_129670_));
            Runtime.getRuntime().addShutdownHook($$37);
        }
        catch (Exception $$38) {
            f_129670_.error(LogUtils.FATAL_MARKER, "Failed to start the minecraft server", (Throwable)$$38);
        }
    }

    private static WorldLoader.InitConfig m_245383_(DedicatedServerProperties p_248563_, LevelStorageSource.LevelStorageAccess p_251359_, boolean p_249093_, PackRepository p_251069_) {
        WorldDataConfiguration $$8;
        boolean $$7;
        WorldDataConfiguration $$4 = p_251359_.m_247706_();
        if ($$4 != null) {
            boolean $$5 = false;
            WorldDataConfiguration $$6 = $$4;
        } else {
            $$7 = true;
            $$8 = new WorldDataConfiguration(p_248563_.f_243997_, FeatureFlags.f_244332_);
        }
        WorldLoader.PackConfig $$9 = new WorldLoader.PackConfig(p_251069_, $$8, p_249093_, $$7);
        return new WorldLoader.InitConfig($$9, Commands.CommandSelection.DEDICATED, p_248563_.f_139711_);
    }

    private static void m_195488_(LevelStorageSource.LevelStorageAccess p_195489_, DataFixer p_195490_, boolean p_195491_, BooleanSupplier p_195492_, Registry<LevelStem> p_250443_) {
        f_129670_.info("Forcing world upgrade!");
        WorldUpgrader $$5 = new WorldUpgrader(p_195489_, p_195490_, p_250443_, p_195491_);
        Component $$6 = null;
        while (!$$5.m_18829_()) {
            int $$8;
            Component $$7 = $$5.m_18837_();
            if ($$6 != $$7) {
                $$6 = $$7;
                f_129670_.info($$5.m_18837_().getString());
            }
            if (($$8 = $$5.m_18834_()) > 0) {
                int $$9 = $$5.m_18835_() + $$5.m_18836_();
                f_129670_.info("{}% completed ({} / {} chunks)...", new Object[]{Mth.m_14143_((float)$$9 / (float)$$8 * 100.0f), $$9, $$8});
            }
            if (!p_195492_.getAsBoolean()) {
                $$5.m_18820_();
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static /* synthetic */ DedicatedServer m_236697_(LevelStorageSource.LevelStorageAccess p_236698_, PackRepository p_236699_, WorldStem p_236700_, DedicatedServerSettings p_236701_, Services p_236702_, OptionSet p_236703_, OptionSpec p_236704_, OptionSpec p_236705_, OptionSpec p_236706_, OptionSpec p_236707_, OptionSpec p_236708_, OptionSpec p_236709_, Thread p_236710_) {
        boolean $$14;
        DedicatedServer $$13 = new DedicatedServer(p_236710_, p_236698_, p_236699_, p_236700_, p_236701_, DataFixers.m_14512_(), p_236702_, LoggerChunkProgressListener::new);
        $$13.m_236740_(p_236703_.has(p_236704_) ? new GameProfile(null, (String)p_236703_.valueOf(p_236704_)) : null);
        $$13.m_129801_((Integer)p_236703_.valueOf(p_236705_));
        $$13.m_129975_(p_236703_.has(p_236706_));
        $$13.m_129948_((String)p_236703_.valueOf(p_236707_));
        boolean bl = $$14 = !p_236703_.has(p_236708_) && !p_236703_.valuesOf(p_236709_).contains("nogui");
        if ($$14 && !GraphicsEnvironment.isHeadless()) {
            $$13.m_139667_();
        }
        return $$13;
    }

    private static /* synthetic */ CompletableFuture m_244800_(WorldLoader.InitConfig p_248080_, LevelStorageSource.LevelStorageAccess p_248081_, OptionSet p_248082_, OptionSpec p_248083_, DedicatedServerSettings p_248084_, OptionSpec p_248085_, Executor p_248086_) {
        return WorldLoader.m_214362_(p_248080_, p_248079_ -> {
            WorldDimensions $$15;
            WorldOptions $$14;
            LevelSettings $$13;
            Registry<LevelStem> $$6 = p_248079_.f_243759_().m_175515_(Registries.f_256862_);
            RegistryOps<Tag> $$7 = RegistryOps.m_255058_(NbtOps.f_128958_, p_248079_.f_244104_());
            Pair<WorldData, WorldDimensions.Complete> $$8 = p_248081_.m_246049_($$7, p_248079_.f_244127_(), $$6, p_248079_.f_244104_().m_211816_());
            if ($$8 != null) {
                return new WorldLoader.DataLoadOutput<WorldData>((WorldData)$$8.getFirst(), ((WorldDimensions.Complete)$$8.getSecond()).m_245593_());
            }
            if (p_248082_.has(p_248083_)) {
                LevelSettings $$9 = MinecraftServer.f_129743_;
                WorldOptions $$10 = WorldOptions.f_244225_;
                WorldDimensions $$11 = WorldPresets.m_246552_(p_248079_.f_244104_());
            } else {
                DedicatedServerProperties $$12 = p_248084_.m_139777_();
                $$13 = new LevelSettings($$12.f_139741_, $$12.f_139740_, $$12.f_139752_, $$12.f_139739_, false, new GameRules(), p_248079_.f_244127_());
                $$14 = p_248082_.has(p_248085_) ? $$12.f_243824_.m_247325_(true) : $$12.f_243824_;
                $$15 = $$12.m_246483_(p_248079_.f_244104_());
            }
            WorldDimensions.Complete $$16 = $$15.m_245300_($$6);
            Lifecycle $$17 = $$16.m_245945_().add(p_248079_.f_244104_().m_211816_());
            return new WorldLoader.DataLoadOutput<PrimaryLevelData>(new PrimaryLevelData($$13, $$14, $$16.f_244634_(), $$17), $$16.m_245593_());
        }, WorldStem::new, Util.m_183991_(), p_248086_);
    }
}

