/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.Nullable;

public class MutableHashedLinkedMap<K, V>
implements Iterable<Map.Entry<K, V>> {
    private final Hash.Strategy<? super K> strategy;
    private final Map<K, Entry> entries;
    private final MergeFunction<K, V> merge;
    private Entry head = null;
    private Entry last = null;

    public MutableHashedLinkedMap(Hash.Strategy<? super K> strategy) {
        this(strategy, (k, v1, v2) -> v2);
    }

    public MutableHashedLinkedMap(Hash.Strategy<? super K> strategy, MergeFunction<K, V> merge) {
        this.strategy = strategy;
        this.entries = new Object2ObjectOpenCustomHashMap(strategy);
        this.merge = merge;
    }

    @Nullable
    public V put(K key, V value) {
        Entry l;
        Entry old = this.entries.get(key);
        if (old != null) {
            Object ret = old.value;
            old.value = this.merge.apply(key, ret, value);
            return ret;
        }
        Entry self = new Entry(key, value);
        self.previous = l = this.last;
        if (l == null) {
            this.head = self;
        } else {
            l.next = self;
        }
        this.last = self;
        this.entries.put(key, self);
        return null;
    }

    public boolean contains(K key) {
        return this.entries.containsKey(key);
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Nullable
    public V remove(K key) {
        Entry ret = this.entries.remove(key);
        if (ret == null) {
            return null;
        }
        this.remove(ret);
        return ret.getValue();
    }

    @Nullable
    public V get(K key) {
        Entry entry = this.entries.get(key);
        return entry == null ? null : (V)entry.getValue();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new Iterator<Map.Entry<K, V>>(){
            private Entry current;
            {
                this.current = MutableHashedLinkedMap.this.head;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public Map.Entry<K, V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Entry ret = this.current;
                this.current = this.current.next;
                return ret;
            }
        };
    }

    @Nullable
    public V putFirst(K key, V value) {
        if (this.head != null) {
            return this.putBefore(this.head.getKey(), key, value);
        }
        return this.put(key, value);
    }

    @Nullable
    public V putAfter(K after, K key, V value) {
        Entry target = this.entries.get(after);
        if (target == null) {
            return this.put(key, value);
        }
        V ret = null;
        Entry entry = this.entries.get(key);
        if (entry != null) {
            ret = entry.value;
            entry.value = this.merge.apply(key, ret, value);
            this.remove(entry);
        } else {
            entry = new Entry(key, value);
            this.entries.put(key, entry);
        }
        entry.previous = target;
        if (target.next == null) {
            this.last = target;
        } else {
            target.next.previous = entry;
        }
        entry.next = target.next;
        target.next = entry;
        return ret;
    }

    @Nullable
    public V putBefore(K before, K key, V value) {
        Entry target = this.entries.get(before);
        if (target == null) {
            return this.put(key, value);
        }
        V ret = null;
        Entry entry = this.entries.get(key);
        if (entry != null) {
            ret = entry.value;
            entry.value = this.merge.apply(key, ret, value);
            this.remove(entry);
        } else {
            entry = new Entry(key, value);
            this.entries.put(key, entry);
        }
        entry.previous = target.previous;
        if (target.previous == null) {
            this.head = entry;
        } else {
            target.previous.next = entry;
        }
        entry.next = target;
        target.previous = entry;
        return ret;
    }

    private void remove(Entry e) {
        if (this.head == null) {
            this.head = e.next;
        } else if (e.previous != null) {
            e.previous.next = e.next;
            e.previous = null;
        }
        if (this.last == e) {
            this.last = e.previous;
        } else if (e.next != null) {
            e.next.previous = e.previous;
            e.next = null;
        }
    }

    public static interface MergeFunction<Key, Value> {
        public Value apply(Key var1, Value var2, Value var3);
    }

    private class Entry
    implements Map.Entry<K, V> {
        private final K key;
        private V value;
        private Entry previous;
        private Entry next;

        private Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            Object old = this.value;
            this.value = value;
            return old;
        }

        public String toString() {
            return "Entry[" + this.key + ", " + this.value + "]";
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : MutableHashedLinkedMap.this.strategy.hashCode(this.key)) ^ (this.value == null ? 0 : this.value.hashCode());
        }
    }
}

