/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R2;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Date;
import java.util.Set;
import java.util.logging.Level;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.IpBanListEntry;
import net.minecraft.server.players.StoredUserEntry;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_19_R2.CraftIpBanEntry;

public class CraftIpBanList
implements BanList {
    private final IpBanList list;

    public CraftIpBanList(IpBanList list) {
        this.list = list;
    }

    @Override
    public BanEntry getBanEntry(String target) {
        Validate.notNull((Object)target, (String)"Target cannot be null", (Object[])new Object[0]);
        IpBanListEntry entry = (IpBanListEntry)this.list.m_11388_((Object)target);
        if (entry == null) {
            return null;
        }
        return new CraftIpBanEntry(target, entry, this.list);
    }

    @Override
    public BanEntry addBan(String target, String reason, Date expires, String source) {
        Validate.notNull((Object)target, (String)"Ban target cannot be null", (Object[])new Object[0]);
        IpBanListEntry entry = new IpBanListEntry(target, new Date(), StringUtils.isBlank((CharSequence)source) ? null : source, expires, StringUtils.isBlank((CharSequence)reason) ? null : reason);
        this.list.m_11381_((StoredUserEntry)entry);
        try {
            this.list.m_11398_();
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Failed to save banned-ips.json, {0}", ex.getMessage());
        }
        return new CraftIpBanEntry(target, entry, this.list);
    }

    @Override
    public Set<BanEntry> getBanEntries() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String target : this.list.m_5875_()) {
            builder.add((Object)new CraftIpBanEntry(target, (IpBanListEntry)this.list.m_11388_((Object)target), this.list));
        }
        return builder.build();
    }

    @Override
    public boolean isBanned(String target) {
        Validate.notNull((Object)target, (String)"Target cannot be null", (Object[])new Object[0]);
        return this.list.m_11041_((SocketAddress)InetSocketAddress.createUnresolved(target, 0));
    }

    @Override
    public void pardon(String target) {
        Validate.notNull((Object)target, (String)"Target cannot be null", (Object[])new Object[0]);
        this.list.m_11393_((Object)target);
    }
}

