/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R2.block;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.World;
import org.bukkit.block.TileState;
import org.bukkit.craftbukkit.v1_19_R2.block.CraftBlockState;
import org.bukkit.persistence.PersistentDataContainer;

public class CraftBlockEntityState<T extends BlockEntity>
extends CraftBlockState
implements TileState {
    private final T tileEntity;
    private final T snapshot;

    public CraftBlockEntityState(World world, T tileEntity) {
        super(world, tileEntity.m_58899_(), tileEntity.m_58900_());
        this.tileEntity = tileEntity;
        this.snapshot = this.createSnapshot(tileEntity);
        this.load(this.snapshot);
    }

    public void refreshSnapshot() {
        this.load(this.tileEntity);
    }

    private T createSnapshot(T tileEntity) {
        if (tileEntity == null) {
            return null;
        }
        CompoundTag nbtTagCompound = tileEntity.m_187480_();
        BlockEntity snapshot = BlockEntity.m_155241_((BlockPos)this.getPosition(), (BlockState)this.getHandle(), (CompoundTag)nbtTagCompound);
        return (T)snapshot;
    }

    private void copyData(T from, T to) {
        CompoundTag nbtTagCompound = from.m_187480_();
        to.m_142466_(nbtTagCompound);
    }

    protected T getTileEntity() {
        return this.tileEntity;
    }

    protected T getSnapshot() {
        return this.snapshot;
    }

    protected BlockEntity getTileEntityFromWorld() {
        this.requirePlaced();
        return this.getWorldHandle().m_7702_(this.getPosition());
    }

    public CompoundTag getSnapshotNBT() {
        this.applyTo(this.snapshot);
        return this.snapshot.m_187480_();
    }

    protected void load(T tileEntity) {
        if (tileEntity != null && tileEntity != this.snapshot) {
            this.copyData(tileEntity, this.snapshot);
        }
    }

    protected void applyTo(T tileEntity) {
        if (tileEntity != null && tileEntity != this.snapshot) {
            this.copyData(this.snapshot, tileEntity);
        }
    }

    protected boolean isApplicable(BlockEntity tileEntity) {
        return tileEntity != null && this.tileEntity.getClass() == tileEntity.getClass();
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        BlockEntity tile;
        boolean result = super.update(force, applyPhysics);
        if (result && this.isPlaced() && this.isApplicable(tile = this.getTileEntityFromWorld())) {
            this.applyTo(tile);
            tile.m_6596_();
        }
        return result;
    }

    @Override
    public PersistentDataContainer getPersistentDataContainer() {
        return ((BlockEntity)this.getSnapshot()).persistentDataContainer;
    }
}

