/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R2.persistence;

import com.google.common.primitives.Primitives;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.bukkit.craftbukkit.v1_19_R2.persistence.CraftPersistentDataContainer;
import org.bukkit.persistence.PersistentDataContainer;

public final class CraftPersistentDataTypeRegistry {
    private final Function<Class, TagAdapter> CREATE_ADAPTER = this::createAdapter;
    private final Map<Class, TagAdapter> adapters = new HashMap<Class, TagAdapter>();

    private <T> TagAdapter createAdapter(Class<T> type) {
        if (!Primitives.isWrapperType(type)) {
            type = Primitives.wrap(type);
        }
        if (Objects.equals(Byte.class, type)) {
            return this.createAdapter(Byte.class, ByteTag.class, ByteTag::m_128266_, ByteTag::m_7063_);
        }
        if (Objects.equals(Short.class, type)) {
            return this.createAdapter(Short.class, ShortTag.class, ShortTag::m_129258_, ShortTag::m_7053_);
        }
        if (Objects.equals(Integer.class, type)) {
            return this.createAdapter(Integer.class, IntTag.class, IntTag::m_128679_, IntTag::m_7047_);
        }
        if (Objects.equals(Long.class, type)) {
            return this.createAdapter(Long.class, LongTag.class, LongTag::m_128882_, LongTag::m_7046_);
        }
        if (Objects.equals(Float.class, type)) {
            return this.createAdapter(Float.class, FloatTag.class, FloatTag::m_128566_, FloatTag::m_7057_);
        }
        if (Objects.equals(Double.class, type)) {
            return this.createAdapter(Double.class, DoubleTag.class, DoubleTag::m_128500_, DoubleTag::m_7061_);
        }
        if (Objects.equals(String.class, type)) {
            return this.createAdapter(String.class, StringTag.class, StringTag::m_129297_, StringTag::m_7916_);
        }
        if (Objects.equals(byte[].class, type)) {
            return this.createAdapter(byte[].class, ByteArrayTag.class, array -> new ByteArrayTag(Arrays.copyOf(array, ((byte[])array).length)), n -> Arrays.copyOf(n.m_128227_(), n.size()));
        }
        if (Objects.equals(int[].class, type)) {
            return this.createAdapter(int[].class, IntArrayTag.class, array -> new IntArrayTag(Arrays.copyOf(array, ((int[])array).length)), n -> Arrays.copyOf(n.m_128648_(), n.size()));
        }
        if (Objects.equals(long[].class, type)) {
            return this.createAdapter(long[].class, LongArrayTag.class, array -> new LongArrayTag(Arrays.copyOf(array, ((long[])array).length)), n -> Arrays.copyOf(n.m_128851_(), n.size()));
        }
        if (Objects.equals(PersistentDataContainer[].class, type)) {
            return this.createAdapter(PersistentDataContainer[].class, ListTag.class, containerArray -> {
                ListTag list = new ListTag();
                for (int i = 0; i < ((PersistentDataContainer[])containerArray).length; ++i) {
                    list.add((Object)((CraftPersistentDataContainer)containerArray[i]).toTagCompound());
                }
                return list;
            }, tag -> {
                PersistentDataContainer[] containerArray = new CraftPersistentDataContainer[tag.size()];
                for (int i = 0; i < tag.size(); ++i) {
                    CraftPersistentDataContainer container = new CraftPersistentDataContainer(this);
                    CompoundTag compound = tag.m_128728_(i);
                    for (String key : compound.m_128431_()) {
                        container.put(key, compound.m_128423_(key));
                    }
                    containerArray[i] = container;
                }
                return containerArray;
            });
        }
        if (Objects.equals(PersistentDataContainer.class, type)) {
            return this.createAdapter(CraftPersistentDataContainer.class, CompoundTag.class, CraftPersistentDataContainer::toTagCompound, tag -> {
                CraftPersistentDataContainer container = new CraftPersistentDataContainer(this);
                for (String key : tag.m_128431_()) {
                    container.put(key, tag.m_128423_(key));
                }
                return container;
            });
        }
        throw new IllegalArgumentException("Could not find a valid TagAdapter implementation for the requested type " + type.getSimpleName());
    }

    private <T, Z extends Tag> TagAdapter<T, Z> createAdapter(Class<T> primitiveType, Class<Z> nbtBaseType, Function<T, Z> builder, Function<Z, T> extractor) {
        return new TagAdapter<T, Z>(primitiveType, nbtBaseType, builder, extractor);
    }

    public <T> Tag wrap(Class<T> type, T value) {
        return this.adapters.computeIfAbsent(type, this.CREATE_ADAPTER).build(value);
    }

    public <T> boolean isInstanceOf(Class<T> type, Tag base) {
        return this.adapters.computeIfAbsent(type, this.CREATE_ADAPTER).isInstance(base);
    }

    public <T> T extract(Class<T> type, Tag tag) throws ClassCastException, IllegalArgumentException {
        TagAdapter adapter = this.adapters.computeIfAbsent(type, this.CREATE_ADAPTER);
        if (!adapter.isInstance(tag)) {
            throw new IllegalArgumentException(String.format("`The found tag instance cannot store %s as it is a %s", type.getSimpleName(), tag.getClass().getSimpleName()));
        }
        Object foundValue = adapter.extract(tag);
        if (!type.isInstance(foundValue)) {
            throw new IllegalArgumentException(String.format("The found object is of the type %s. Expected type %s", foundValue.getClass().getSimpleName(), type.getSimpleName()));
        }
        return type.cast(foundValue);
    }

    private class TagAdapter<T, Z extends Tag> {
        private final Function<T, Z> builder;
        private final Function<Z, T> extractor;
        private final Class<T> primitiveType;
        private final Class<Z> nbtBaseType;

        public TagAdapter(Class<T> primitiveType, Class<Z> nbtBaseType, Function<T, Z> builder, Function<Z, T> extractor) {
            this.primitiveType = primitiveType;
            this.nbtBaseType = nbtBaseType;
            this.builder = builder;
            this.extractor = extractor;
        }

        T extract(Tag base) {
            if (!this.nbtBaseType.isInstance(base)) {
                throw new IllegalArgumentException(String.format("The provided Tag was of the type %s. Expected type %s", base.getClass().getSimpleName(), this.nbtBaseType.getSimpleName()));
            }
            return this.extractor.apply((Tag)this.nbtBaseType.cast(base));
        }

        Z build(Object value) {
            if (!this.primitiveType.isInstance(value)) {
                throw new IllegalArgumentException(String.format("The provided value was of the type %s. Expected type %s", value.getClass().getSimpleName(), this.primitiveType.getSimpleName()));
            }
            return (Z)((Tag)this.builder.apply(this.primitiveType.cast(value)));
        }

        boolean isInstance(Tag base) {
            return this.nbtBaseType.isInstance(base);
        }
    }
}

